/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j.field;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mime4j.field.AddressListField;
import org.mime4j.field.ContentTransferEncodingField;
import org.mime4j.field.ContentTypeField;
import org.mime4j.field.DateTimeField;
import org.mime4j.field.MailboxField;
import org.mime4j.field.MailboxListField;
import org.mime4j.field.UnstructuredField;

public abstract class Field {
    private static Log log = LogFactory.getLog((Class)(class$org$mime4j$field$Field == null ? (class$org$mime4j$field$Field = Field.class$("org.mime4j.field.Field")) : class$org$mime4j$field$Field));
    public static final String SENDER = "Sender";
    public static final String FROM = "From";
    public static final String TO = "To";
    public static final String CC = "Cc";
    public static final String BCC = "Bcc";
    public static final String REPLY_TO = "Reply-To";
    public static final String RESENT_SENDER = "Resent-Sender";
    public static final String RESENT_FROM = "Resent-From";
    public static final String RESENT_TO = "Resent-To";
    public static final String RESENT_CC = "Resent-Cc";
    public static final String RESENT_BCC = "Resent-Bcc";
    public static final String DATE = "Date";
    public static final String RESENT_DATE = "Resent-Date";
    public static final String SUBJECT = "Subject";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String FIELD_NAME_PATTERN = "^([\\x21-\\x39\\x3b-\\x7e]+)[ \t]*:";
    private static Pattern fieldNamePattern = Pattern.compile("^([\\x21-\\x39\\x3b-\\x7e]+)[ \t]*:");
    private String name;
    private String body;
    private String raw;
    static /* synthetic */ Class class$org$mime4j$field$Field;

    protected Field() {
    }

    public static Field parse(String s) {
        String raw = s;
        Matcher fieldMatcher = fieldNamePattern.matcher(s = s.replaceAll("\r|\n", ""));
        if (!fieldMatcher.find()) {
            throw new IllegalArgumentException("Invalid field in string");
        }
        String name = fieldMatcher.group(1);
        String body = s.substring(fieldMatcher.end());
        if (body.length() > 0 && body.charAt(0) == ' ') {
            body = body.substring(1);
        }
        Field f = null;
        f = name.equalsIgnoreCase(CONTENT_TRANSFER_ENCODING) ? new ContentTransferEncodingField() : (name.equalsIgnoreCase(CONTENT_TYPE) ? new ContentTypeField() : (name.equalsIgnoreCase(DATE) || name.equalsIgnoreCase(RESENT_DATE) ? new DateTimeField() : (name.equalsIgnoreCase(FROM) || name.equalsIgnoreCase(RESENT_FROM) ? new MailboxListField() : (name.equalsIgnoreCase(SENDER) || name.equalsIgnoreCase(RESENT_SENDER) ? new MailboxField() : (name.equalsIgnoreCase(TO) || name.equalsIgnoreCase(CC) || name.equalsIgnoreCase(BCC) || name.equalsIgnoreCase(RESENT_TO) || name.equalsIgnoreCase(RESENT_CC) || name.equalsIgnoreCase(RESENT_BCC) ? new AddressListField() : new UnstructuredField())))));
        f.name = name;
        f.raw = raw;
        f.body = body;
        f.parseBody(body);
        return f;
    }

    protected abstract void parseBody(String var1);

    public String getName() {
        return this.name;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isContentType() {
        return CONTENT_TYPE.equalsIgnoreCase(this.name);
    }

    public boolean isSubject() {
        return SUBJECT.equalsIgnoreCase(this.name);
    }

    public boolean isFrom() {
        return FROM.equalsIgnoreCase(this.name);
    }

    public boolean isTo() {
        return TO.equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.raw;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

