/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j.field.address;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.mime4j.field.address.Address;
import org.mime4j.field.address.Builder;
import org.mime4j.field.address.Mailbox;
import org.mime4j.field.address.MailboxList;
import org.mime4j.field.address.parser.AddressListParser;
import org.mime4j.field.address.parser.ParseException;

public class AddressList {
    private ArrayList addresses;

    public AddressList(ArrayList addresses, boolean dontCopy) {
        this.addresses = addresses != null ? (dontCopy ? addresses : (ArrayList)addresses.clone()) : new ArrayList(0);
    }

    public Iterator iterator() {
        return new Iterator(){
            private int pos = 0;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.pos < AddressList.this.size();
            }

            public Object next() {
                return AddressList.this.get(this.pos++);
            }
        };
    }

    public int size() {
        return this.addresses.size();
    }

    public Address get(int index) {
        if (0 > index || this.size() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return (Address)this.addresses.get(index);
    }

    public MailboxList flatten() {
        boolean groupDetected = false;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) instanceof Mailbox) continue;
            groupDetected = true;
            break;
        }
        if (!groupDetected) {
            return new MailboxList(this.addresses, true);
        }
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.size(); ++i) {
            Address addr = this.get(i);
            addr.addMailboxesTo(results);
        }
        return new MailboxList(results, false);
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            Address addr = this.get(i);
            System.out.println(addr.toString());
        }
    }

    public static AddressList parse(String rawAddressList) throws ParseException {
        AddressListParser parser = new AddressListParser(new StringReader(rawAddressList));
        return Builder.getInstance().buildAddressList(parser.parse());
    }

    public static void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    String line = reader.readLine();
                    if (line.length() == 0 || line.toLowerCase().equals("exit") || line.toLowerCase().equals("quit")) {
                        System.out.println("Goodbye.");
                        return;
                    }
                    AddressList list = AddressList.parse(line);
                    list.print();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.sleep(300L);
                continue;
            }
            break;
        }
    }
}

