/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mime4j.AbstractContentHandler;
import org.mime4j.MimeStreamParser;
import org.mime4j.field.Field;

public class Header {
    private List fields = new LinkedList();
    private HashMap fieldMap = new HashMap();

    public Header() {
    }

    public Header(InputStream is) throws IOException {
        final MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler(new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(String fieldData) {
                Header.this.addField(Field.parse(fieldData));
            }
        });
        parser.parse(is);
    }

    public void addField(Field field) {
        LinkedList<Field> values = (LinkedList<Field>)this.fieldMap.get(field.getName().toLowerCase());
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(field.getName().toLowerCase(), values);
        }
        values.add(field);
        this.fields.add(field);
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(String name) {
        List l = (List)this.fieldMap.get(name.toLowerCase());
        if (l != null && !l.isEmpty()) {
            return (Field)l.get(0);
        }
        return null;
    }

    public List getFields(String name) {
        List l = (List)this.fieldMap.get(name.toLowerCase());
        return Collections.unmodifiableList(l);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            str.append(it.next().toString());
            str.append("\r\n");
        }
        return str.toString();
    }
}

