/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.mime4j.BodyDescriptor;
import org.mime4j.ContentHandler;
import org.mime4j.MimeStreamParser;
import org.mime4j.decoder.Base64InputStream;
import org.mime4j.decoder.QuotedPrintableInputStream;
import org.mime4j.field.Field;
import org.mime4j.field.UnstructuredField;
import org.mime4j.message.AbstractBody;
import org.mime4j.message.Body;
import org.mime4j.message.BodyPart;
import org.mime4j.message.Entity;
import org.mime4j.message.Header;
import org.mime4j.message.Multipart;
import org.mime4j.message.TempFileBinaryBody;
import org.mime4j.message.TempFileTextBody;

public class Message
extends Entity
implements Body {
    static /* synthetic */ Class class$org$mime4j$message$Entity;
    static /* synthetic */ Class class$org$mime4j$message$Message;
    static /* synthetic */ Class class$org$mime4j$message$Header;
    static /* synthetic */ Class class$org$mime4j$message$Multipart;
    static /* synthetic */ Class class$org$mime4j$message$BodyPart;

    public Message() {
    }

    public Message(InputStream is) throws IOException {
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler(new MessageBuilder());
        parser.parse(is);
    }

    public UnstructuredField getSubject() {
        return (UnstructuredField)this.getHeader().getField("Subject");
    }

    public void writeTo(OutputStream out) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MessageBuilder
    implements ContentHandler {
        private Stack stack = new Stack();
        private Message root = null;

        private void expect(Class c) {
            if (!c.isInstance(this.stack.peek())) {
                throw new IllegalStateException("Internal stack error: Expected '" + c.getName() + "' found '" + this.stack.peek().getClass().getName() + "'");
            }
        }

        public void startMessage() {
            if (this.stack.isEmpty()) {
                this.stack.push(Message.this);
            } else {
                this.expect(class$org$mime4j$message$Entity == null ? (class$org$mime4j$message$Entity = Message.class$("org.mime4j.message.Entity")) : class$org$mime4j$message$Entity);
                Message m = new Message();
                ((Entity)this.stack.peek()).setBody(m);
                this.stack.push(m);
            }
        }

        public void endMessage() {
            this.expect(class$org$mime4j$message$Message == null ? (class$org$mime4j$message$Message = Message.class$("org.mime4j.message.Message")) : class$org$mime4j$message$Message);
            this.stack.pop();
        }

        public void startHeader() {
            this.stack.push(new Header());
        }

        public void field(String fieldData) {
            this.expect(class$org$mime4j$message$Header == null ? (class$org$mime4j$message$Header = Message.class$("org.mime4j.message.Header")) : class$org$mime4j$message$Header);
            ((Header)this.stack.peek()).addField(Field.parse(fieldData));
        }

        public void endHeader() {
            this.expect(class$org$mime4j$message$Header == null ? (class$org$mime4j$message$Header = Message.class$("org.mime4j.message.Header")) : class$org$mime4j$message$Header);
            Header h = (Header)this.stack.pop();
            this.expect(class$org$mime4j$message$Entity == null ? (class$org$mime4j$message$Entity = Message.class$("org.mime4j.message.Entity")) : class$org$mime4j$message$Entity);
            ((Entity)this.stack.peek()).setHeader(h);
        }

        public void startMultipart(BodyDescriptor bd) {
            this.expect(class$org$mime4j$message$Entity == null ? (class$org$mime4j$message$Entity = Message.class$("org.mime4j.message.Entity")) : class$org$mime4j$message$Entity);
            Entity e = (Entity)this.stack.peek();
            Multipart multiPart = new Multipart();
            e.setBody(multiPart);
            this.stack.push(multiPart);
        }

        public void body(BodyDescriptor bd, InputStream is) throws IOException {
            this.expect(class$org$mime4j$message$Entity == null ? (class$org$mime4j$message$Entity = Message.class$("org.mime4j.message.Entity")) : class$org$mime4j$message$Entity);
            String enc = bd.getTransferEncoding();
            if ("base64".equals(enc)) {
                is = new Base64InputStream(is);
            } else if ("quoted-printable".equals(enc)) {
                is = new QuotedPrintableInputStream(is);
            }
            AbstractBody body = null;
            body = bd.getMimeType().startsWith("text/") ? new TempFileTextBody(is, bd.getCharset()) : new TempFileBinaryBody(is);
            ((Entity)this.stack.peek()).setBody(body);
        }

        public void endMultipart() {
            this.stack.pop();
        }

        public void startBodyPart() {
            this.expect(class$org$mime4j$message$Multipart == null ? (class$org$mime4j$message$Multipart = Message.class$("org.mime4j.message.Multipart")) : class$org$mime4j$message$Multipart);
            BodyPart bodyPart = new BodyPart();
            ((Multipart)this.stack.peek()).addBodyPart(bodyPart);
            this.stack.push(bodyPart);
        }

        public void endBodyPart() {
            this.expect(class$org$mime4j$message$BodyPart == null ? (class$org$mime4j$message$BodyPart = Message.class$("org.mime4j.message.BodyPart")) : class$org$mime4j$message$BodyPart);
            this.stack.pop();
        }

        public void epilogue(InputStream is) throws IOException {
            int b;
            this.expect(class$org$mime4j$message$Multipart == null ? (class$org$mime4j$message$Multipart = Message.class$("org.mime4j.message.Multipart")) : class$org$mime4j$message$Multipart);
            StringBuffer sb = new StringBuffer();
            while ((b = is.read()) != -1) {
                sb.append((char)b);
            }
            ((Multipart)this.stack.peek()).setEpilogue(sb.toString());
        }

        public void preamble(InputStream is) throws IOException {
            int b;
            this.expect(class$org$mime4j$message$Multipart == null ? (class$org$mime4j$message$Multipart = Message.class$("org.mime4j.message.Multipart")) : class$org$mime4j$message$Multipart);
            StringBuffer sb = new StringBuffer();
            while ((b = is.read()) != -1) {
                sb.append((char)b);
            }
            ((Multipart)this.stack.peek()).setPreamble(sb.toString());
        }

        public void raw(InputStream is) throws IOException {
        }
    }
}

