/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mime4j.message.AbstractBody;
import org.mime4j.message.TextBody;
import org.mime4j.util.CharsetUtil;
import org.mime4j.util.TempFile;
import org.mime4j.util.TempPath;
import org.mime4j.util.TempStorage;

class TempFileTextBody
extends AbstractBody
implements TextBody {
    private static Log log = LogFactory.getLog((Class)(class$org$mime4j$message$TempFileTextBody == null ? (class$org$mime4j$message$TempFileTextBody = TempFileTextBody.class$("org.mime4j.message.TempFileTextBody")) : class$org$mime4j$message$TempFileTextBody));
    private String mimeCharset = null;
    private TempFile tempFile = null;
    static /* synthetic */ Class class$org$mime4j$message$TempFileTextBody;

    public TempFileTextBody(InputStream is) throws IOException {
        this(is, null);
    }

    public TempFileTextBody(InputStream is, String mimeCharset) throws IOException {
        this.mimeCharset = mimeCharset;
        TempPath tempPath = TempStorage.getInstance().getRootTempPath();
        this.tempFile = tempPath.createTempFile("attachment", ".txt");
        OutputStream out = this.tempFile.getOutputStream();
        CopyUtils.copy((InputStream)is, (OutputStream)out);
        out.close();
    }

    public Reader getReader() throws UnsupportedEncodingException, IOException {
        String javaCharset = null;
        if (this.mimeCharset != null) {
            javaCharset = CharsetUtil.toJavaCharset(this.mimeCharset);
        }
        if (javaCharset == null) {
            javaCharset = "ISO8859-1";
            if (log.isWarnEnabled()) {
                if (this.mimeCharset == null) {
                    log.warn((Object)("No MIME charset specified. Using " + javaCharset + " instead."));
                } else {
                    log.warn((Object)("MIME charset '" + this.mimeCharset + "' has no " + "corresponding Java charset. Using " + javaCharset + " instead."));
                }
            }
        }
        return new InputStreamReader(this.tempFile.getInputStream(), javaCharset);
    }

    public void writeTo(OutputStream out) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

