// IBM Confidential
// OCO Source Materials
// BI and PM: Mobile
// (C) Copyright IBM Corp. 2012
// The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.

package com.cognos.mobile.server.validation;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import com.cognos.mobile.vm.VM;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;

/**
 * a class to adapt VerfiySession to interface ICognosValidator;
 * @author wangj
 *
 */
public class VerifySessionAdaptor implements ICognosValidator {
	private static final String VALIDATION_RESOURCE = "com/cognos/mobile/server/validation/mobile_validation_rules.xml"; 
	private static final String VALIDATION_NAMESPACE = "urn:cognos:mobile"; 
	private static final Class CLASS = VerifySessionAdaptor.class;
	private static VerifySession delegate;
	static {
		try {
			ValidatorFactory vf = ValidatorFactory.newInstance();
			vf.put(ValidatorFactory.PROP_BOOL_MANDATORY_RULES, true);
			com.cognos.validator.api.Document doc = vf.createDocument();
			if ( !doc.loadFromNamespace( VALIDATION_NAMESPACE ) )
			{
				ClassLoader cl = MobileValidator.class.getClassLoader();
				InputStream is = cl.getResourceAsStream(VALIDATION_RESOURCE);
				Reader isr = new InputStreamReader(is);
				doc.loadFromXML(isr);
			}
			delegate = vf.createVerifySession(doc);
		} catch (Exception e) {
			VM.log(CLASS, VM.SEVERITY_ERROR, "failed to create verify session.");
		}	
	}
	public VerifySessionAdaptor() {
		super();
	}

	@Override
	public void setProperty(int feature, boolean onoff) throws ValidatorException {
		if (delegate != null) delegate.put(feature, onoff);
	}

	@Override
	public void validate(IParameterUpdater paramUpdater) throws VerifyException, ValidatorException {
		if (delegate != null) delegate.verify(paramUpdater);
	}

}
