/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.mock;

import com.ibm.cognos.jdbc.mock.MockInvocationHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class MockDriver
implements Driver {
    private int driverMajorVersion = 0;
    private int driverMinorVersion = 0;
    private static final String URL_PREFIX = "jdbc:mock:";
    private static final String START_TRACE = "startTrace";
    private static final int INFO_LENGTH = "INFO: ".length();
    public static final String MOCK_URL = "ibmcognos.mockurl";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        String mockURLProperty = properties != null ? properties.getProperty(MOCK_URL) : null;
        String string = url = mockURLProperty != null ? mockURLProperty : url;
        if (this.acceptsURL(url)) {
            String spec = url.substring(URL_PREFIX.length());
            BufferedReader reader = this.openReader(spec);
            HashMap<String, String> info = new HashMap<String, String>();
            while (this.preloadInformation(reader, info)) {
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.driverMajorVersion = Integer.valueOf(info.get("getDriverMajorVersion"));
            }
            catch (Exception e) {
                this.driverMajorVersion = 0;
            }
            try {
                this.driverMinorVersion = Integer.valueOf(info.get("getDriverMinorVersion"));
            }
            catch (Exception e) {
                this.driverMinorVersion = 0;
            }
            MockInvocationHandler handler = new MockInvocationHandler(this.openReader(spec), info);
            Connection connection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), MockInvocationHandler.getInterfaces(Connection.class), (InvocationHandler)handler);
            return connection;
        }
        throw new SQLNonTransientConnectionException("Mock URL must begin with: jdbc:mock:");
    }

    private BufferedReader openReader(String spec) throws SQLException {
        InputStream is;
        URL dataURL;
        try {
            dataURL = new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new SQLNonTransientConnectionException("Invalid resource specificaton: " + spec + " " + e.getMessage());
        }
        try {
            is = dataURL.openConnection().getInputStream();
        }
        catch (IOException e) {
            throw new SQLNonTransientConnectionException(e);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    private boolean preloadInformation(BufferedReader reader, HashMap<String, String> info) {
        try {
            String text = reader.readLine();
            if (text == null || !text.endsWith(START_TRACE)) {
                return false;
            }
            text = reader.readLine();
            if (text == null) {
                return false;
            }
            int equalPos = (text = text.trim()).indexOf(61);
            if (equalPos >= 0) {
                String name = text.substring(INFO_LENGTH, equalPos);
                String value = text.substring(equalPos + 1);
                info.put(name, value);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public int getMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

