/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Locale;

public class ContentServiceException
extends MoserException {
    private static final long serialVersionUID = 7711217917636365931L;
    private final String cmError;
    private final String cmErrorCode;

    public ContentServiceException(JSONObject responseJson, int statusCode) {
        super(MoserError.CONTENT_SERVICE_UNKNOWN);
        this.httpStatus = statusCode;
        if (responseJson != null) {
            String errorMsg;
            JSONArray messages = (JSONArray)responseJson.get((Object)"messages");
            String string = errorMsg = messages != null && !messages.isEmpty() ? (String)messages.get(0) : null;
            if (errorMsg != null && errorMsg.startsWith("CM-")) {
                this.cmError = errorMsg;
                this.cmErrorCode = this.cmError.split(" ")[0];
            } else {
                JSONObject error;
                JSONArray errors = (JSONArray)responseJson.get((Object)"errors");
                JSONObject jSONObject = error = errors != null && !errors.isEmpty() ? (JSONObject)errors.get(0) : null;
                if (error != null && !error.isEmpty()) {
                    this.cmError = (String)error.get((Object)"message");
                    this.cmErrorCode = (String)error.get((Object)"code");
                } else {
                    this.cmError = null;
                    this.cmErrorCode = null;
                }
            }
        } else {
            this.cmError = null;
            this.cmErrorCode = null;
        }
    }

    public String getErrorCode() {
        return this.cmErrorCode != null ? this.cmErrorCode : super.getErrorCode();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.cmError != null ? this.cmError : super.getLocalizedMessage(locale);
    }
}

