/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.http.jetty;

import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.remote.http.WebContainer;
import org.mortbay.http.HttpListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHttpContext;

public class JettyWebContainer
implements WebContainer {
    private final Server server = new Server();

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    protected Server getServer() {
        return this.server;
    }

    @Override
    public void start(JMXServiceURL url, Map environment) throws IOException {
        try {
            this.configure(url, environment);
            this.getServer().start();
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception x) {
            throw new IOException(x.toString());
        }
    }

    private void configure(JMXServiceURL url, Map environment) throws IOException {
        Logger logger = this.getLogger();
        if (environment != null) {
            Object config = environment.get("jmx.remote.x.http.server.configuration");
            if (config instanceof String) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Configuring Jetty with configuration " + config);
                }
                this.getServer().configure((String)config);
                HttpListener[] listeners = this.getServer().getListeners();
                if (listeners != null) {
                    boolean found = false;
                    for (int i = 0; i < listeners.length; ++i) {
                        HttpListener listener = listeners[i];
                        if (listener.getPort() != url.getPort()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new IOException("No listener configured with configuration " + config + " matches JMXServiceURL " + url);
                    }
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Configured Jetty successfully with configuration " + config);
                    }
                    return;
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug("Jetty configuration " + config + " does not have any listener");
                }
            } else if (logger.isEnabledFor(10)) {
                logger.debug("Skipping Jetty configuration " + config + " (must be a String)");
            }
        }
        this.configureListener(url, environment);
    }

    protected void configureListener(JMXServiceURL url, Map environment) throws IOException {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Configuring Jetty with a default listener on port " + url.getPort());
        }
        this.getServer().addListener(":" + url.getPort());
    }

    @Override
    public void stop() throws IOException {
        try {
            this.getServer().stop();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void deploy(String servletClassName, JMXServiceURL url, Map environment) throws IOException {
        try {
            String urlPattern = this.resolveServletMapping(url);
            ServletHttpContext context = (ServletHttpContext)this.getServer().getContext("/");
            context.addServlet(urlPattern, servletClassName);
            if (!context.isStarted()) {
                context.start();
            }
        }
        catch (Exception x) {
            throw new IOException(x.toString());
        }
    }

    @Override
    public void undeploy(String servletName, JMXServiceURL url, Map environment) {
        String urlPattern = this.resolveServletMapping(url);
        ServletHttpContext context = (ServletHttpContext)this.getServer().getContext("/");
        ServletHandler handler = context.getServletHandler();
        handler.getServletMap().remove((Object)urlPattern);
    }

    private String resolveServletMapping(JMXServiceURL url) {
        String path = url.getURLPath();
        String urlPattern = null;
        urlPattern = path.endsWith("/") ? path + "*" : path + "/*";
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        return urlPattern;
    }
}

