/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems;

import com.cognos.ems.EventManagementAsyncService;
import com.cognos.ems.EventManagementCategory;
import com.cognos.ems.EventManagementConfiguration;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jms.provider.metrics.JmsQueueMetrics;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.service.ServiceProperties;
import com.cognos.jsmcommon.service.ServicePropertiesException;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;
import java.util.Iterator;
import java.util.Locale;
import noticecast.services.IRepositoryServices;
import noticecast.services.RepositoryServicesImpl;
import noticecast.services.types.LocalServiceType;
import noticecast.starter.ProcessType;
import noticecast.starter.SingletonServiceProvider;
import org.dom4j.Element;

public class EventManagementServiceHandler
extends BasicHandler
implements Asyncable {
    private PogoEngine engine = null;
    private boolean m_suspended = false;
    private boolean m_serviceFailedToInit = false;
    private boolean m_isSchedulerEnabled = true;

    public EventManagementServiceHandler() {
        super(null);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        ServiceProperties emsServiceProperties = null;
        try {
            emsServiceProperties = new ServiceProperties(this.getConfig());
            String isSchedulerEnabledStr = emsServiceProperties.getProperty("isSchedulerEnabled");
            if (null != isSchedulerEnabledStr) {
                this.m_isSchedulerEnabled = Boolean.getBoolean(isSchedulerEnabledStr);
            }
        }
        catch (ServicePropertiesException e) {
            throw new PogoException("Handler config problem: " + e.getLocalizedMessage());
        }
    }

    public void configure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        CRNProperties cclConfig = CRNProperties.getInstance();
        cclConfig.init(configuration.getICCLConfiguration(), this.getName());
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
        try {
            JMSProperties.getInstance().loadProperties();
            JmsQueueMetrics.configure((String)JMSProperties.getInstance().getProperty(JMSProperties.JOB_QUEUE_NAME));
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
        }
        perf.stop();
    }

    public void dispose() {
    }

    public void initialize() {
        try {
            Handler h = this.engine.getHandlerPool().find("eventManagementService.jsmReporter");
            if (h != null && h instanceof SimpleRequestReportingHandler) {
                SimpleRequestReportingHandler srrh = (SimpleRequestReportingHandler)h;
                srrh.getRequestReporter();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            if (this.isSuspended()) {
                mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
                return;
            }
            BIBusEnvelope biBusEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
            ThreadProperties.setProperty((String)"componentID", (String)"EMS");
            String requestOp = BiBusUtilities.getOperation((BIBusEnvelope)biBusEnv);
            if (requestOp != null) {
                ThreadProperties.setProperty((String)"requestOperation", (String)requestOp);
            }
            AxisServiceHandler handler = AxisServiceHandler.getHandler((IServiceConfiguration)EventManagementConfiguration.getInstance(), (MessageContext)mc);
            handler.prepare();
            handler.execute();
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public void reconfigure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        this.configure(configuration);
        perf.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STARTING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
        if (this.m_serviceFailedToInit) {
            throw new RuntimeException(errMsg);
        }
        try {
            RepositoryServicesImpl.instance().getSchedulerController().startScheduler();
            this.setSuspended(false);
            this.m_serviceFailedToInit = false;
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).startService("EventService", "Success");
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(ex.getLocalizedMessage());
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).startService("EventService", "Failure", errMsg);
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            if (this.m_isSchedulerEnabled) {
                SingletonServiceProvider.getInstance().initServices(ProcessType.CR1_scheduler);
            }
            DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.NC);
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).startService("EventService", "Success");
            this.setSuspended(false);
        }
        catch (Throwable t) {
            String errMsg = I18NUtil.getMessage((I18NCode)EmsI18NCode.SERVICE_START_ERROR, (Object)t.getMessage(), (Locale)SDSLogger.getLocale());
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).startService("EventService", "Failure", errMsg);
            this.m_serviceFailedToInit = true;
            this.flagNotStartable();
        }
        finally {
            perf.stop();
        }
    }

    public void stop() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            this.setSuspended(true);
            if (this.m_isSchedulerEnabled) {
                RepositoryServicesImpl.instance().getSchedulerController().stopScheduler();
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).stopService("EventService", "Success");
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(boolean immediately) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        String errMsg = I18NUtil.getMessage((I18NCode)I18NCode.ERROR_STOPPING_JMS_SERVICE, (Locale)SDSLogger.getLocale());
        if (this.m_serviceFailedToInit) {
            throw new RuntimeException(errMsg);
        }
        try {
            this.setSuspended(true);
            RepositoryServicesImpl.instance().getSchedulerController().stopScheduler();
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).stopService("EventService", "Success");
        }
        finally {
            perf.stop();
        }
    }

    private synchronized void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private synchronized boolean isSuspended() {
        return this.m_suspended;
    }

    public AsyncService getAsyncRequest(MessageContext context) {
        String method;
        Iterator children;
        EventManagementAsyncService asyncService = null;
        BIBusEnvelope biBusEnv = (BIBusEnvelope)context.getProperty("request.envelope");
        Element body = biBusEnv.getBody();
        if (body != null && (children = body.elementIterator()).hasNext() && (method = ((Element)children.next()).getName()) != null && (method.equals("cancel") || method.equals("release") || method.equals("run") || method.equals("runSpecification") || method.equals("wait") || method.equals("firstPage") || method.equals("nextPage") || method.equals("previousPage") || method.equals("lastPage") || method.equals("currentPage"))) {
            asyncService = new EventManagementAsyncService(this, context);
        }
        return asyncService;
    }

    public void allServicesStarted() {
        if (!SingletonServiceProvider.getInstance().hasService(LocalServiceType.SchedulerServiceType)) {
            IRepositoryServices rs = RepositoryServicesImpl.instance();
            rs.getRunTimeManager().loadSchedules();
            rs.getSchedulerController().startScheduler();
            SingletonServiceProvider.getInstance().setService(rs.getSchedulerController(), LocalServiceType.SchedulerServiceType);
        }
    }
}

