/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.api;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.AsynchDetailParameterValues;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSecondaryRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.developer.schemas.bibus._3.EventManagementServiceSpecification;
import com.cognos.developer.schemas.bibus._3.EventManagementService_PortType;
import com.cognos.developer.schemas.bibus._3.EventRecord;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryEventsOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.ScheduleSynchronizationInput;
import com.cognos.developer.schemas.bibus._3.ScheduleSynchronizationOutput;
import com.cognos.developer.schemas.bibus._3.ScheduledEvent;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.ems.EventManagementCategory;
import com.cognos.ems.api.EventServiceException;
import com.cognos.ems.event.FutureEventsContext;
import com.cognos.ems.event.FutureEventsResponse;
import com.cognos.ems.event.FutureEventsUtil;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.ChainedServiceException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.service.ServiceImplBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.TrackingThreadProperties;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.sds.adapter.ScheduleSynchInputAdapter;
import com.cognos.sds.adapter.ScheduleSynchOutputAdapter;
import com.cognos.sds.api.ScheduleService;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.IEventId;
import com.cognos.sds.event.QueryEventAdapter;
import com.cognos.sds.event.SDSEventService;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.CurrentEventSecurityHandler;
import com.cognos.spec.eventRecordState.EventRecordStateUtil;
import com.cognos.spec.eventRecordState.castor.EventRecordState;
import com.cognos.spec.queryEvent.QueryEventSpecUtil;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import org.apache.axis.AxisFault;

public class EventManagementServiceImpl
extends ServiceImplBase
implements EventManagementService_PortType {
    public static final String CANCEL = "cancel";
    public static final String RELEASE = "release";
    public static final String RUN = "run";
    public static final String RUN_SPECIFICATION = "runSpecification";
    public static final String WAIT = "wait";
    public static final String FIRST_PAGE = "firstPage";
    public static final String NEXT_PAGE = "nextPage";
    public static final String PREVIOUS_PAGE = "previousPage";
    public static final String LAST_PAGE = "lastPage";
    public static final String CURRENT_PAGE = "currentPage";

    private BiBusHeader authenticate() throws AxisFault {
        BiBusHeader header = this.extractBiBusHeader();
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        this.authenticate(headers);
        return headers.getBiBusHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AsynchRequest conversation) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply currentPage(AsynchRequest conversation, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (conversation.getSpecification() == null || conversation.getSpecification().length < 1) {
                throw new RemoteException("nextPage: required specification is missing");
            }
            if (conversation.getStateData() == null) {
                throw new RemoteException("nextPage: required stateData is missing");
            }
            int maxObjects = FutureEventsUtil.getPagingOptionMaxObjects(conversation.getOptions());
            EventRecordState eventRecordState = EventRecordStateUtil.getEventRecordState(conversation.getStateData());
            int skipCount = eventRecordState.getEnd();
            AsynchSpecification spec = conversation.getSpecification()[0];
            QueryEventSpecification qes = QueryEventSpecUtil.getQueryEventSpecification(spec);
            FutureEventsContext context = new FutureEventsContext();
            context.setQuerySpecification(qes);
            context.setMaxObjects(maxObjects);
            context.setSkipCount(skipCount);
            reply = this.processEventRecords(spec, conversation.getParameters(), conversation.getOptions(), maxObjects, skipCount, context);
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayEventsFor(String[] eventIDs, String duration) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            header = headers.getBiBusHeader();
            Event[] events = new Event[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    try {
                        if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                            throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
                        }
                        events[i] = new Event(EventStatus.SCHEDULED, EventId.valueOf(eventIDs[i]));
                        events[i].duration = duration;
                        continue;
                    }
                    catch (SDSServiceException ex) {
                        throw new APIException((LocalizableException)ex);
                    }
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().updateStatus(events, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayEventsUntil(String[] eventIDs, Calendar until) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            header = headers.getBiBusHeader();
            Event[] events = new Event[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                        throw new APIException((LocalizableException)new SDSServiceException(I18NCode.EVENT_ID_INVALID));
                    }
                    events[i] = new Event(EventStatus.SCHEDULED, EventId.valueOf(eventIDs[i]));
                    if (!until.getTime().after(events[i].getScheduledStartDate())) {
                        throw new APIException((LocalizableException)new SDSServiceException(I18NCode.EVENT_DELAY_ERROR));
                    }
                    events[i].setRequestedStartDate(until.getTime());
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().updateStatus(events, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply firstPage(AsynchRequest conversation, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (conversation.getSpecification() == null || conversation.getSpecification().length < 1) {
                throw new RemoteException("firstPage: required specification is missing");
            }
            if (conversation.getStateData() == null) {
                throw new RemoteException("firstPage: required stateData is missing");
            }
            int maxObjects = FutureEventsUtil.getPagingOptionMaxObjects(conversation.getOptions());
            int skipCount = 0;
            AsynchSpecification spec = conversation.getSpecification()[0];
            QueryEventSpecification qes = QueryEventSpecUtil.getQueryEventSpecification(spec);
            FutureEventsContext context = new FutureEventsContext();
            context.setQuerySpecification(qes);
            context.setMaxObjects(maxObjects);
            context.setSkipCount(skipCount);
            reply = this.processEventRecords(spec, conversation.getParameters(), conversation.getOptions(), maxObjects, skipCount, context);
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply lastPage(AsynchRequest conversation, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (conversation.getSpecification() == null || conversation.getSpecification().length < 1) {
                throw new RemoteException("lastPage: required specification is missing");
            }
            int maxObjects = FutureEventsUtil.getPagingOptionMaxObjects(conversation.getOptions());
            int skipCount = -1;
            AsynchSpecification spec = conversation.getSpecification()[0];
            QueryEventSpecification qes = QueryEventSpecUtil.getQueryEventSpecification(spec);
            FutureEventsContext context = new FutureEventsContext();
            context.setQuerySpecification(qes);
            context.setMaxObjects(maxObjects);
            context.setSkipCount(skipCount);
            reply = this.processEventRecords(spec, conversation.getParameters(), conversation.getOptions(), maxObjects, skipCount, context);
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply nextPage(AsynchRequest conversation, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        try {
            int previousEnd;
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (conversation.getSpecification() == null || conversation.getSpecification().length < 1) {
                throw new RemoteException("nextPage: required specification is missing");
            }
            if (conversation.getStateData() == null) {
                throw new RemoteException("nextPage: required stateData is missing");
            }
            int maxObjects = FutureEventsUtil.getPagingOptionMaxObjects(conversation.getOptions());
            EventRecordState eventRecordState = EventRecordStateUtil.getEventRecordState(conversation.getStateData());
            int skipCount = previousEnd = eventRecordState.getEnd();
            AsynchSpecification spec = conversation.getSpecification()[0];
            QueryEventSpecification qes = QueryEventSpecUtil.getQueryEventSpecification(spec);
            FutureEventsContext context = new FutureEventsContext();
            context.setQuerySpecification(qes);
            context.setMaxObjects(maxObjects);
            context.setSkipCount(skipCount);
            reply = this.processEventRecords(spec, conversation.getParameters(), conversation.getOptions(), maxObjects, skipCount, context);
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply previousPage(AsynchRequest conversation, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (conversation.getSpecification() == null || conversation.getSpecification().length < 1) {
                throw new RemoteException("previousPage: required specification is missing");
            }
            if (conversation.getStateData() == null) {
                throw new RemoteException("previousPage: required stateData is missing");
            }
            int maxObjects = FutureEventsUtil.getPagingOptionMaxObjects(conversation.getOptions());
            EventRecordState eventRecordState = EventRecordStateUtil.getEventRecordState(conversation.getStateData());
            int skipCount = eventRecordState.getStart() - maxObjects - 1;
            if (skipCount < 0) {
                skipCount = 0;
            }
            AsynchSpecification spec = conversation.getSpecification()[0];
            QueryEventSpecification qes = QueryEventSpecUtil.getQueryEventSpecification(spec);
            FutureEventsContext context = new FutureEventsContext();
            context.setQuerySpecification(qes);
            context.setMaxObjects(maxObjects);
            context.setSkipCount(skipCount);
            reply = this.processEventRecords(spec, conversation.getParameters(), conversation.getOptions(), maxObjects, skipCount, context);
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AsynchRequest conversation) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
        }
        finally {
            perf.stop();
        }
    }

    public AsynchReply run(SearchPathSingleObject searchPath, ParameterValue[] params, Option[] options) throws RemoteException {
        throw new UnsupportedOperationException("EventManagementServiceImpl.run is unsupported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply runSpecification(AsynchSpecification asynchSpec, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        if (!(asynchSpec instanceof EventManagementServiceSpecification)) {
            throw new RemoteException("EventManagementService.runSpecification() expects an EventManagementServiceSpecification! Received a " + asynchSpec.getClass().getName());
        }
        AsynchReply reply = null;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            int maxObjects = FutureEventsUtil.getPagingOptionMaxObjects(options);
            QueryEventSpecification qes = QueryEventSpecUtil.getQueryEventSpecification(asynchSpec);
            int skipCount = 0;
            if (qes.getDisplay() != null) {
                int end;
                int start = qes.getDisplay().getStart();
                if (start > (end = qes.getDisplay().getEnd())) {
                    throw new IllegalStateException("EventManagementService.runSpecification: display.start is greater than display.end");
                }
                if (start < 1) {
                    throw new IllegalStateException("EventManagementService.runSpecification: display.start is less than 1");
                }
                skipCount = start - 1;
                maxObjects = end - skipCount;
            }
            FutureEventsContext context = new FutureEventsContext();
            context.setQuerySpecification(qes);
            context.setMaxObjects(maxObjects);
            context.setSkipCount(skipCount);
            reply = this.processEventRecords(asynchSpec, params, options, maxObjects, skipCount, context);
            this.debugWait("primary.wait.ems");
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    private AsynchReply processEventRecords(AsynchSpecification asynchSpec, ParameterValue[] params, Option[] options, int maxObjects, int skipCount, FutureEventsContext context) throws RemoteException {
        BiBusHeader header = this.extractBiBusHeader();
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        this.authenticate(headers);
        header = headers.getBiBusHeader();
        AsynchRequest request = new AsynchRequest();
        request.setSpecification(new AsynchSpecification[]{asynchSpec});
        request.setParameters(params);
        request.setOptions(options);
        AsynchReply reply = new AsynchReply();
        reply.setPrimaryRequest(request);
        try {
            FutureEventsResponse response = SDSEventService.getInstance().getEventRecords(context, header);
            AsynchDetailEventRecord[] eventRecords = response.getEventRecords();
            AsynchDetailParameterValues paramValues = response.getTotalCounts();
            AsynchDetail[] details = new AsynchDetail[eventRecords.length + 1];
            for (int i = 0; i < eventRecords.length; ++i) {
                details[i] = eventRecords[i];
            }
            details[details.length - 1] = paramValues;
            reply.setDetails(details);
            int windowStart = response.getWindowStart();
            int windowEnd = response.getWindowEnd();
            String eventRecordStateXml = FutureEventsUtil.getEventRecordStateAsXML(windowStart, windowEnd);
            XmlEncodedXML encodedXML = new XmlEncodedXML();
            encodedXML.set_value(eventRecordStateXml);
            reply.getPrimaryRequest().setStateData(encodedXML);
            AsynchSecondaryRequest[] secondaryRequests = null;
            LinkedList<String> secondaryRequestsList = new LinkedList<String>();
            secondaryRequestsList.add(RELEASE);
            if (response.getListSize() > response.getWindowSize()) {
                if (response.getWindowStart() > 1) {
                    secondaryRequestsList.add(FIRST_PAGE);
                    secondaryRequestsList.add(PREVIOUS_PAGE);
                }
                if (response.getWindowEnd() < response.getListSize()) {
                    secondaryRequestsList.add(NEXT_PAGE);
                    secondaryRequestsList.add(LAST_PAGE);
                }
            }
            secondaryRequests = this.getSecondaryRequests(secondaryRequestsList.toArray(new String[secondaryRequestsList.size()]));
            reply.setSecondaryRequests(secondaryRequests);
            reply.setStatus(AsynchReplyStatusEnum.complete);
        }
        catch (Exception e) {
            this.emsThrowAxisFault(e);
        }
        return reply;
    }

    private AsynchSecondaryRequest[] getSecondaryRequests(String[] pages) {
        AsynchSecondaryRequest[] secondaryRequests = new AsynchSecondaryRequest[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            secondaryRequests[i] = new AsynchSecondaryRequest();
            secondaryRequests[i].setName(pages[i]);
        }
        return secondaryRequests;
    }

    public AsynchReply wait(AsynchRequest arg0, ParameterValue[] arg1, Option[] arg2) throws RemoteException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int triggerSubscriptions(SearchPathSingleObject periodicalProducer, SearchPathSingleObject documentVersion) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        int count = 0;
        try {
            if (periodicalProducer == null || documentVersion == null) {
                APIException e = new APIException((LocalizableException)new SDSServiceException(I18NCode.SCHDR_INVALID_TRIGGER));
                this.emsThrowAxisFault((Exception)((Object)e));
                int n = count;
                return n;
            }
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            header = headers.getBiBusHeader();
            ScheduleService service = ScheduleService.getInstance();
            try {
                count = service.triggerSubscriptions(header, periodicalProducer.get_value(), documentVersion.get_value());
            }
            catch (APIException ex) {
                this.emsThrowAxisFault((Exception)((Object)ex));
            }
        }
        finally {
            perf.stop();
        }
        return count;
    }

    public void updateEvents(EventRecord[] events) throws RemoteException {
        block14: {
            ArrayList<Object> faults = new ArrayList<Object>();
            BiBusHeader header = this.extractBiBusHeader();
            Date now = new Date();
            try {
                if (!this.checkCanUseSchedulingPriority()) break block14;
                ArrayList<EventRecord> currentEvents = new ArrayList<EventRecord>();
                ArrayList<Event> futureEvents = new ArrayList<Event>();
                Event sdsEvent = null;
                for (int i = 0; i < events.length; ++i) {
                    sdsEvent = new Event(EventStatus.valueOf((String)events[i].getStatus()), EventId.valueOf(events[i].getEventID()));
                    if (sdsEvent.getEventId().getRunDate() != null && sdsEvent.getEventId().getRunDate().after(now)) {
                        sdsEvent.setPriority(new Integer(events[i].getPriority()));
                        futureEvents.add(sdsEvent);
                        continue;
                    }
                    currentEvents.add(events[i]);
                }
                if (futureEvents.size() > 0) {
                    Event[] sdsFutureEvents = futureEvents.toArray(new Event[futureEvents.size()]);
                    SDSEventService service = SDSEventService.getInstance();
                    try {
                        service.updateEvents(sdsFutureEvents, header);
                    }
                    catch (APIException e) {
                        faults.add((Object)e);
                    }
                }
                CurrentEventSecurityHandler handler = new CurrentEventSecurityHandler();
                boolean objectPermissionsRequired = handler.isObjectPermissionsRequired();
                for (int i = 0; i < currentEvents.size(); ++i) {
                    EventRecord eventRecord = (EventRecord)currentEvents.get(i);
                    TaskStateRecord task = TaskPersistLayer.getTaskStateFromEventId((String)eventRecord.getEventID());
                    if (task == null) continue;
                    TaskStatus sts = task.status;
                    short count = task.executing;
                    TaskStatus actualStatus = TaskStateRecord.getActualStatus((TaskStatus)sts, (int)count);
                    if (actualStatus.equals((Object)TaskStatus.PENDING) || actualStatus.equals((Object)TaskStatus.READY) || actualStatus.equals((Object)TaskStatus.PAUSED)) {
                        TaskRecord taskRecord;
                        if (objectPermissionsRequired && (taskRecord = TaskPersistLayer.getTaskFromEventId((String)eventRecord.getEventID())) != null) {
                            try {
                                String searchPath = "storeID('" + taskRecord.getTaskStoreId() + "')";
                                handler.validateObjectPermissions(header, searchPath);
                            }
                            catch (ProcessHandlerException phe) {
                                faults.add((Object)phe);
                                continue;
                            }
                        }
                        MonitorService ms = MonitorService.instance();
                        ms.updateEvents(eventRecord);
                        continue;
                    }
                    faults.add((Object)new EventServiceException(EmsI18NCode.CANNOT_CHANGE_PRIORITY));
                }
                if (faults.size() > 0) {
                    ChainedServiceException cse = new ChainedServiceException(faults);
                    this.emsThrowAxisFault((Exception)cse);
                }
            }
            catch (ProcessHandlerException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
            catch (TaskPersistLayerException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addSchedules(SearchPathSingleObject objectPath, Schedule[] schedules, AddOptions options) throws RemoteException {
        String[] scheduleIds;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        this.isTrustedRequest();
        try {
            if (schedules == null || schedules.length <= 0) {
                throw new RemoteException("No schedule passed to addSchedule method");
            }
            Schedule[] returnedSchedules = null;
            if (options == null) {
                returnedSchedules = this.doCreateSchedules(schedules);
            } else {
                UpdateActionEnum updateAction = options.getUpdateAction();
                if (updateAction == null) {
                    returnedSchedules = this.doCreateSchedules(schedules);
                } else if (updateAction.equals((Object)UpdateActionEnum.replace)) {
                    returnedSchedules = this.doCreateSchedules(schedules);
                } else if (updateAction.equals((Object)UpdateActionEnum.update)) {
                    returnedSchedules = this.doUpdateSchedules(schedules);
                } else {
                    if (updateAction.equals((Object)UpdateActionEnum.fail)) {
                        throw new RemoteException("AddSchedule request is to fail!!");
                    }
                    throw new RemoteException("AddSchedule: unknown option: " + updateAction.getValue());
                }
            }
            scheduleIds = new String[returnedSchedules.length];
            for (int i = 0; i < returnedSchedules.length; ++i) {
                scheduleIds[i] = returnedSchedules[i].getTaskID().getValue();
            }
        }
        finally {
            perf.stop();
        }
        return scheduleIds;
    }

    public void cancelEvent(String eventID) throws RemoteException {
        this.cancelEvents(new String[]{eventID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEvents(String[] eventIDs) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            BiBusHeader header = this.authenticate();
            IEventId[] eventIds = new EventId[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                        throw new APIException((LocalizableException)new SDSServiceException(I18NCode.EVENT_ID_INVALID));
                    }
                    eventIds[i] = EventId.valueOf(eventIDs[i]);
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().cancelEvents(eventIds, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public void deleteSchedules(String[] taskIDs) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            this.isTrustedRequest();
            this.doDeleteSchedules(taskIDs);
        }
        finally {
            perf.stop();
        }
    }

    public ScheduledEvent[] getScheduledEvents(int eventLimit) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public void holdEvent(String eventID) throws RemoteException {
        this.holdEvents(new String[]{eventID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void holdEvents(String[] eventIDs) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.authenticate();
            Event[] events = new Event[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    try {
                        if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                            throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
                        }
                        events[i] = new Event(EventStatus.SUSPENDED, EventId.valueOf(eventIDs[i]));
                        events[i].setRequestedStartDate(null);
                        continue;
                    }
                    catch (SDSServiceException ex) {
                        throw new APIException((LocalizableException)ex);
                    }
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().updateStatus(events, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventRecord[] queryEvents(QueryEventsOptions options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        EventRecord[] events = new EventRecord[]{};
        try {
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            header = headers.getBiBusHeader();
            try {
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                events = SDSEventService.getInstance().queryEvents(new QueryEventAdapter(options), header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return events;
    }

    public void releaseEvent(String eventID) throws RemoteException {
        this.releaseEvents(new String[]{eventID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEvents(String[] eventIDs) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.authenticate();
            IEventId[] eventIds = new EventId[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                        throw new APIException((LocalizableException)new SDSServiceException(I18NCode.EVENT_ID_INVALID));
                    }
                    eventIds[i] = EventId.valueOf(eventIDs[i]);
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().releaseEvents(eventIds, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runAt(Calendar startTime, SearchPathSingleObject objectPath, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        String eventId = (String)this.getServiceContext().getProperty("runAt");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            header = headers.getBiBusHeader();
            try {
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                eventId = this.runLater(header, startTime, objectPath);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return eventId;
    }

    public void validateSchedule(Schedule schedule) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        perf.stop();
    }

    private boolean checkCanUseSchedulingPriority() throws ProcessHandlerException {
        boolean found = false;
        try {
            BiBusHeader biBusHeader = this.extractBiBusHeader();
            found = AuthenticatorFactory.getInstance().hasCapability(biBusHeader, UserCapabilityEnum.canUseSchedulingPriority);
            if (!found) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Current user does not have canUseScheduling capability.");
                throw new ProcessHandlerException(EmsI18NCode.SEC_NO_PRIVILEGES);
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Unable to retrieve the capabilities for the current user.");
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
            throw new ProcessHandlerException(I18NCode.IO_CM_COMMS_ERROR);
        }
        return found;
    }

    private String runLater(BiBusHeader biBusHeader, Calendar cal, SearchPathSingleObject objectPath) throws APIException {
        String eventID = null;
        Credential credential = null;
        try {
            ContentManagerServiceClientPort cm = null;
            Account account = null;
            BaseClass object = null;
            JobBiBusHeaders headers = new JobBiBusHeaders(biBusHeader);
            try {
                cm = Client.instance().getContentManagerServiceClient(headers);
                QueryRequest accountRequest = new QueryRequest();
                accountRequest.setSearch("~");
                accountRequest.setProperties(new PropEnum[]{PropEnum.storeID});
                accountRequest.setOptions(null);
                accountRequest.setSortBy(null);
                QueryRequest objectRequest = new QueryRequest();
                objectRequest.setSearch(objectPath.get_value());
                objectRequest.setProperties(new PropEnum[]{PropEnum.storeID, PropEnum.objectClass, PropEnum.owner});
                objectRequest.setOptions(null);
                objectRequest.setSortBy(null);
                QueryReply[] replyArray = cm.queryMultiple(new QueryRequest[]{accountRequest, objectRequest});
                if (replyArray != null && replyArray.length == 2) {
                    BaseClass[] accountArray = replyArray[0].getQueryResult();
                    BaseClass[] objectArray = replyArray[1].getQueryResult();
                    if (accountArray.length > 0 && accountArray[0] instanceof Account) {
                        account = (Account)accountArray[0];
                    }
                    if (objectArray.length > 0) {
                        object = objectArray[0];
                    }
                }
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Service Exception retrieving cached binding port.");
                throw new ProcessHandlerException(EmsI18NCode.IO_CM_COMMS_ERROR);
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("SDKClient Exception retrieving current session information for the user.");
                throw new ProcessHandlerException(EmsI18NCode.IO_CM_COMMS_ERROR, (LocalizableException)e);
            }
            finally {
                if (cm != null) {
                    cm.close();
                }
            }
            boolean hasCapability = false;
            try {
                hasCapability = this.checkCapabilities(headers);
            }
            catch (SDSServiceException ex) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Service Exception retrieving capabilities for the user.");
                throw new ProcessHandlerException(EmsI18NCode.INVALID_CAPABILITIES, (LocalizableException)ex);
            }
            if (!hasCapability) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Current user does not have canUseScheduling capability.");
                throw new ProcessHandlerException(EmsI18NCode.SEC_NO_PRIVILEGES);
            }
            if (account == null) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Unable to retrieve account information for the current user.");
                throw new ProcessHandlerException(EmsI18NCode.SCHDR_CREATE_ERROR);
            }
            if (object == null) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Unable to retrieve information on object to run, for the current user.");
                throw new ProcessHandlerException(EmsI18NCode.SCHDR_CREATE_ERROR);
            }
            try {
                if (this.isAuthenticateWhenSchedule() && !AuthenticatorFactory.getInstance().hasPermission(biBusHeader, objectPath, "execute")) {
                    throw new ProcessHandlerException(EmsI18NCode.SEC_NO_PRIVILEGES);
                }
                credential = AuthenticatorFactory.getInstance().getCredential(biBusHeader);
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(e.getMessage() + "");
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, EmsI18NCode.OTH_CM_ERROR);
                throw new ProcessHandlerException(EmsI18NCode.OTH_CM_ERROR, (LocalizableException)e);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("This user has not got execute permission for this runnable.");
                throw new ProcessHandlerException(EmsI18NCode.SCHDR_CREATE_ERROR);
            }
            try {
                if (credential == null) {
                    AuthenticatorFactory.getInstance().generateTC(biBusHeader);
                    credential = AuthenticatorFactory.getInstance().getCredential(biBusHeader);
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("There was no credential.  We attempted to generate one but this failed with the message: " + e.getMessage());
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SEC_NO_CREDENTIAL_CM);
                throw new ProcessHandlerException(I18NCode.SEC_NO_CREDENTIAL_CM, (LocalizableException)e);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("There was no credential.  We attempted to generate one but this failed");
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SEC_NO_CREDENTIAL_CM);
                throw new ProcessHandlerException(I18NCode.SEC_NO_CREDENTIAL_CM);
            }
            if (credential == null || credential.getSearchPath() == null) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, EmsI18NCode.SCHDR_CREATE_ERROR);
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.SEC_NO_CREDENTIAL_CM);
                throw new ProcessHandlerException(I18NCode.SEC_NO_CREDENTIAL_CM);
            }
            ScheduleService service = ScheduleService.getInstance();
            IEventId id = service.addTransientSchedule(cal.getTime(), credential, account, object);
            if (id != null) {
                eventID = id.toXMLString();
            }
        }
        catch (ProcessHandlerException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.AUDIT).log(SDSLevel.WARN, (LocalizableException)e);
            throw new APIException((LocalizableException)e);
        }
        return eventID;
    }

    public void scheduleEvent(String eventID) throws RemoteException {
        this.scheduleEvents(new String[]{eventID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEvents(String[] eventIDs) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.authenticate();
            IEventId[] eventIds = new EventId[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                        throw new APIException((LocalizableException)new SDSServiceException(I18NCode.EVENT_ID_INVALID));
                    }
                    eventIds[i] = EventId.valueOf(eventIDs[i]);
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().scheduleEvents(eventIds, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduleSynchronizationOutput[] synchronizeSchedules(ScheduleSynchronizationInput[] scheduleData) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        ScheduleSynchronizationOutput[] outputs = new ScheduleSynchronizationOutput[]{};
        try {
            this.isTrustedRequest();
            ScheduleService service = ScheduleService.getInstance();
            try {
                ScheduleSynchOutputAdapter[] outputAdapters = service.synchronizeSchedules(ScheduleSynchInputAdapter.convertToAdapters(scheduleData));
                outputs = new ScheduleSynchronizationOutput[outputAdapters.length];
                for (int i = 0; i < outputAdapters.length; ++i) {
                    outputs[i] = outputAdapters[i].getOutput();
                }
            }
            catch (Exception ex) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Exception class: " + ex.getClass().getName());
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)ex);
                for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Exception class (cause): " + cause.getClass().getName());
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug(cause);
                }
                if (!SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).isLoggingAt(SDSLevel.DEBUG)) {
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("Exception class: " + ex.getClass().getName());
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug((Throwable)ex);
                    for (Throwable cause1 = ex.getCause(); cause1 != null; cause1 = cause1.getCause()) {
                        SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug("Exception class (cause1): " + cause1.getClass().getName());
                        SDSLogger.getLogger((SDSCategory)EventManagementCategory.TRACE).debug(cause1);
                    }
                }
                throw new RemoteException("ScheduleService Error: " + ex.getMessage());
            }
        }
        finally {
            perf.stop();
        }
        return outputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int triggerWithOptions(String triggerName, Option[] opts) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        int count = 0;
        try {
            if (triggerName == null || triggerName.length() <= 0) {
                APIException e = new APIException((LocalizableException)new SDSServiceException(I18NCode.SCHDR_INVALID_TRIGGER));
                this.emsThrowAxisFault((Exception)((Object)e));
                int n = count;
                return n;
            }
            BiBusHeader header = this.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            header = headers.getBiBusHeader();
            if (triggerName.equalsIgnoreCase("EVENT_CONSISTENCY_CHECK")) {
                int n = 0;
                return n;
            }
            perf.setLogData("trigger name = " + triggerName);
            ScheduleService service = ScheduleService.getInstance();
            try {
                count = service.trigger(header, triggerName, opts);
            }
            catch (APIException ex) {
                this.emsThrowAxisFault((Exception)((Object)ex));
            }
        }
        finally {
            perf.stop();
        }
        return count;
    }

    public int trigger(String triggerName) throws RemoteException {
        return this.triggerWithOptions(triggerName, null);
    }

    public void updateSchedules(Schedule[] schedules) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            this.isTrustedRequest();
            this.doUpdateSchedules(schedules);
        }
        finally {
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEventUpdate(String[] eventIDs, EventStatus status) throws AxisFault {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)EventManagementCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        try {
            BiBusHeader header = this.authenticate();
            Event[] events = new Event[eventIDs.length];
            try {
                for (int i = 0; i < eventIDs.length; ++i) {
                    try {
                        if (eventIDs[i] == null || eventIDs[i].length() != 45) {
                            throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
                        }
                        events[i] = new Event(status, EventId.valueOf(eventIDs[i]));
                        continue;
                    }
                    catch (SDSServiceException ex) {
                        throw new APIException((LocalizableException)ex);
                    }
                }
                TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
                SDSEventService.getInstance().updateStatus(events, header);
            }
            catch (APIException e) {
                this.emsThrowAxisFault((Exception)((Object)e));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    private Schedule[] doCreateSchedules(Schedule[] schedules) throws RemoteException {
        Schedule[] returnedSchedules = new Schedule[]{};
        ScheduleService service = ScheduleService.getInstance();
        try {
            returnedSchedules = service.addSchedules(schedules);
        }
        catch (APIException ex) {
            this.emsThrowAxisFault((Exception)((Object)ex));
        }
        return returnedSchedules;
    }

    private BigInteger doDeleteSchedules(String[] schedules) throws RemoteException {
        Schedule[] returnedSchedules = new Schedule[]{};
        ScheduleService service = ScheduleService.getInstance();
        try {
            returnedSchedules = service.deleteSchedules(schedules);
        }
        catch (APIException ex) {
            this.emsThrowAxisFault((Exception)((Object)ex));
        }
        return BigInteger.valueOf(returnedSchedules.length);
    }

    private Schedule[] doUpdateSchedules(Schedule[] schedules) throws RemoteException {
        Schedule[] returnedSchedules = new Schedule[]{};
        ScheduleService service = ScheduleService.getInstance();
        try {
            returnedSchedules = service.updateSchedules(schedules);
        }
        catch (APIException ex) {
            this.emsThrowAxisFault((Exception)((Object)ex));
        }
        return returnedSchedules;
    }

    private boolean isAuthenticateWhenSchedule() {
        try {
            String strBoolean = CRNProperties.getInstance().getProperty("authenticate.when.scheduled");
            return null != strBoolean && strBoolean.equalsIgnoreCase("true");
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.FATAL, I18NCode.MSG_FAILED_TO_READ_PROPERTIES);
            return false;
        }
    }

    private void emsThrowAxisFault(Exception e) throws AxisFault {
        if (e instanceof AxisFault) {
            throw (AxisFault)e;
        }
        if (e instanceof APIException) {
            super.throwAxisFault((APIException)((Object)e));
        } else if (e instanceof LocalizableException) {
            super.throwAxisFault(new APIException((LocalizableException)e));
        } else {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            EventServiceException ese = new EventServiceException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, errorParams, e);
            super.throwAxisFault(new APIException((LocalizableException)ese));
        }
    }

    private boolean checkCapabilities(JobBiBusHeaders headers) throws SDSServiceException {
        boolean found = false;
        UserCapabilityEnum[] ucea = headers.getUserCapabilities();
        if (ucea.length > 0) {
            for (int i = 0; !found && i < ucea.length; ++i) {
                found = ucea[i].equals((Object)UserCapabilityEnum.canUseScheduling);
            }
        }
        return found;
    }
}

