/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.ems.event.EvntRcdComparator;
import com.cognos.ems.event.FutureEventsContext;
import com.cognos.ems.event.FutureEventsHandlerBase;
import com.cognos.ems.event.FutureEventsResponse;
import com.cognos.ems.event.FutureEventsSchedulableQuery;
import com.cognos.ems.event.FutureEventsUtil;
import com.cognos.ems.event.SummaryResponse;
import com.cognos.ems.event.query.SchedulerQueueQuery;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.ems.util.EMSUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectCopyUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.IEventId;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.spec.queryEvent.castor.Summary;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import noticecast.datatier.helperoptions.HelperOption;
import noticecast.datatier.helperoptions.HelperOptionImpl;
import noticecast.logictier.NCObjectType;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.core.IQueueEntry;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.core.SchedulerQueueException;
import noticecast.scheduling.nc.ITaskSchedule;
import noticecast.scheduling.nc.NCSchedulable;
import noticecast.services.RepositoryServicesImpl;

public class FutureEventsHandler
extends FutureEventsHandlerBase {
    @Override
    public void invokeImpl(ProcessContext context) throws ProcessHandlerException {
        Date start;
        FutureEventsContext eventsContext = context.getFutureEventsContext();
        this.validateSpecification(this.m_spec);
        Date startDate = this.m_spec.getFilters().getStartTime();
        Date endDate = this.m_spec.getFilters().getEndTime();
        PriorityEnum priority = this.m_spec.getFilters().getPriority();
        if (priority == null) {
            priority = PriorityEnum.ANY;
        }
        String tenantID = this.m_spec.getFilters().getTenantID();
        int maxReturn = eventsContext.getMaxObjects();
        int skipCount = eventsContext.getSkipCount();
        String[] statuses = FutureEventsUtil.getStatuses(this.m_spec);
        int suspendedCount = FutureEventsUtil.getSuspendedCount();
        Date now = new Date();
        Date minStart = start = startDate.after(now) ? startDate : now;
        Date maxEnd = endDate;
        SummaryResponse summaryResponse = null;
        Summary summary = this.m_spec.getSummary();
        if (summary != null) {
            if (summary.getStartTime().before(now)) {
                summary.setStartTime(now);
            }
            if (summary.getEndTime().before(summary.getStartTime())) {
                summary.setEndTime(summary.getStartTime());
            }
            summaryResponse = new SummaryResponse(summary);
            if (summary.getStartTime().before(minStart)) {
                minStart = summary.getStartTime();
            }
            if (summary.getEndTime().before(maxEnd)) {
                maxEnd = summary.getEndTime();
            }
        } else {
            summaryResponse = new SummaryResponse(start, endDate);
        }
        if (endDate.before(now)) {
            FutureEventsResponse response = this.createEmptyResponse(summaryResponse, skipCount, maxReturn, suspendedCount);
            eventsContext.setFutureEventsResponse(response);
            return;
        }
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "BEGIN");
        try {
            Collection schedulables;
            try {
                schedulables = this.getSchedulables(minStart, maxEnd);
            }
            catch (SchedulerQueueException e) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (LocalizableException)e);
                throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new Object[]{e.getMessage()}, e);
            }
            if (!this.hasCanUseMonitorActivityToolCapability) {
                EMSUtil emsUtil = new EMSUtil();
                emsUtil.filterOnCaller(this.m_header, schedulables);
            }
            if (schedulables.size() > 0) {
                Map runable_map = this.getRunableMap(schedulables.iterator());
                this.filterOnScopeSearchPath(runable_map);
                this.filterOnParentOwner(runable_map);
                ISchedulable[] schedulableArray = new NCSchedulable[runable_map.size()];
                runable_map.keySet().toArray(schedulableArray);
                FutureEventsResponse schedulableQueryResponse = FutureEventsSchedulableQuery.doQuery(schedulableArray, summaryResponse, start, endDate, maxReturn, skipCount, statuses, priority, tenantID);
                schedulableQueryResponse.setSuspendedCount(suspendedCount);
                Event[] events = schedulableQueryResponse.getRunDates();
                events = this.filterOnScopeEventID(events);
                AsynchDetailEventRecord[] eventRecords = new AsynchDetailEventRecord[events.length];
                IEventId[] eventIds = new IEventId[events.length];
                Map scheduledByMap = this.getScheduledByAccountsMap((NCSchedulable[])schedulableArray);
                for (int i = 0; i < events.length; ++i) {
                    Account account;
                    Date requestRunDate = events[i].getRunDate();
                    Date scheduledStartDate = events[i].getScheduledStartDate();
                    NCSchedulable ncSchedulable = (NCSchedulable)events[i].getSchedulable();
                    eventIds[i] = new EventId(ncSchedulable.getTaskSchedule().getTaskId(), scheduledStartDate);
                    BaseClass runnable = (BaseClass)runable_map.get(ncSchedulable);
                    BaseClass runnableCopy = (BaseClass)ObjectCopyUtil.deepCopy((Object)runnable);
                    eventRecords[i] = new AsynchDetailEventRecord();
                    eventRecords[i].setEventID(eventIds[i].toXMLString());
                    Calendar cal1 = TimeUtils.dateToUTCJavaCalendar((Date)requestRunDate);
                    eventRecords[i].setRequestedStartTime(cal1);
                    Calendar cal2 = TimeUtils.dateToUTCJavaCalendar((Date)scheduledStartDate);
                    eventRecords[i].setScheduledStartTime(cal2);
                    eventRecords[i].setRunnable(new BaseClass[]{runnableCopy});
                    eventRecords[i].setStatus(events[i].getStatus().statusName());
                    if (events[i].getPriority() != null) {
                        eventRecords[i].setPriority(events[i].getPriority().intValue());
                    }
                    if (events[i].getTenantID() != null) {
                        eventRecords[i].setTenantID(events[i].getTenantID());
                    }
                    if ((account = (Account)scheduledByMap.get(ncSchedulable)) == null) continue;
                    eventRecords[i].setUser(new BaseClass[]{account});
                }
                EvntRcdComparator mcomp = new EvntRcdComparator(this.m_spec.getSort().getOrder(), this.m_spec.getSort().getSortItem());
                Arrays.sort(eventRecords, mcomp);
                for (int i = 0; i < eventRecords.length; ++i) {
                    NonNegativeIntegerProp nonNegativeIntegerProp = new NonNegativeIntegerProp();
                    nonNegativeIntegerProp.setValue(new BigInteger(new Integer(i + 1).toString()));
                    eventRecords[i].getRunnable()[0].setPosition(nonNegativeIntegerProp);
                }
                AsynchDetailEventRecord[] requiredRunDates = this.makePages(eventRecords, skipCount, maxReturn);
                schedulableQueryResponse.setEventRecords(requiredRunDates);
                eventsContext.setFutureEventsResponse(schedulableQueryResponse);
            } else {
                FutureEventsResponse response = this.createEmptyResponse(summaryResponse, skipCount, maxReturn, suspendedCount);
                eventsContext.setFutureEventsResponse(response);
            }
        }
        catch (Exception e) {
            if (e instanceof LocalizableException) {
                LocalizableException le = (LocalizableException)e;
                throw new ProcessHandlerException(le.getI18NCode(), le.getParams());
            }
            throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new String[]{e.getLocalizedMessage()});
        }
        finally {
            perf.stop();
        }
    }

    private Map getScheduledByAccountsMap(NCSchedulable[] schedulableArray) throws ProcessHandlerException {
        Object[] errorParams;
        int[] backPointers = new int[schedulableArray.length];
        ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>();
        QueryReply[] replies = null;
        HashMap<NCSchedulable, BaseClass> SchedulableAccountsMap = new HashMap<NCSchedulable, BaseClass>();
        for (int i = 0; i < schedulableArray.length; ++i) {
            NCSchedulable ncSchedulable = schedulableArray[i];
            String ownerStoreId = ncSchedulable.getTaskSchedule().getOwnerStoreID();
            if (ownerStoreId == null) continue;
            backPointers[requests.size()] = i;
            QueryRequest request = new QueryRequest();
            request.setSearch("storeID(\"" + ownerStoreId + "\")");
            request.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.userName});
            request.setOptions(null);
            request.setSortBy(null);
            requests.add(request);
        }
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.m_header));
            if (requests.size() > 0) {
                replies = contentManager.queryMultiple(requests.toArray(new QueryRequest[requests.size()]));
            }
        }
        catch (SDKClientException e) {
            errorParams = new String[]{e.getLocalizedMessage()};
            throw new ProcessHandlerException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, errorParams, (LocalizableException)e);
        }
        catch (EMFSecurityException e) {
            errorParams = new String[]{e.getLocalizedMessage()};
            throw new ProcessHandlerException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, errorParams);
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        if (replies != null) {
            int isz = replies.length;
            for (int i = 0; i < isz; ++i) {
                BaseClass[] result;
                int backPtr = backPointers[i];
                if (replies[i] == null || (result = replies[i].getQueryResult()) == null || result.length != 1) continue;
                NCSchedulable schedulable = schedulableArray[backPtr];
                SchedulableAccountsMap.put(schedulable, result[0]);
            }
        }
        return SchedulableAccountsMap;
    }

    private Collection getSchedulables(Date start, Date end) throws SchedulerQueueException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        SchedulerQueueQuery schedulerQueueQuery = new SchedulerQueueQuery(this.m_spec, this.userIdentity);
        Iterator contentsIter = schedulerQueueQuery.getScheduleQueueEntries().iterator();
        HashMap<ISchedulableId, IQueueEntry> schedulableIdEntryMap = new HashMap<ISchedulableId, IQueueEntry>();
        while (contentsIter.hasNext()) {
            IQueueEntry entry = (IQueueEntry)contentsIter.next();
            schedulableIdEntryMap.put(entry.getSchedulableId(), entry);
        }
        ISchedulableId[] ids = new ISchedulableId[schedulableIdEntryMap.keySet().size()];
        schedulableIdEntryMap.keySet().toArray(ids);
        Collection schedulables = this.getSchedulablesFromPersistManager(ids);
        Iterator schedulablesIter = schedulables.iterator();
        while (schedulablesIter.hasNext()) {
            NCSchedulable schedulable = (NCSchedulable)schedulablesIter.next();
            IQueueEntry entry = (IQueueEntry)schedulableIdEntryMap.get(schedulable.getId());
            if (!entry.getDate().before(start)) continue;
            Event runDate = schedulable.getNextExecuteInclusive(start);
            if (runDate != null) {
                Date nextExecute = runDate.getRunDate();
                if (nextExecute != null && !nextExecute.after(end)) continue;
                schedulablesIter.remove();
                continue;
            }
            schedulablesIter.remove();
        }
        perf.stop();
        return schedulables;
    }

    private Collection getSchedulablesFromPersistManager(ISchedulableId[] ids) {
        LinkedList<NCSchedulable> schedulables = new LinkedList<NCSchedulable>();
        HelperOption helperOption = HelperOptionImpl.getHelperOptionForIds(NCObjectType.TASK_SCHEDULE, ids);
        if (helperOption != null) {
            IPersistManager persistManager = RepositoryServicesImpl.instance().getPersistManager();
            try {
                Iterator schedulableIter = persistManager.getObjectList(NCObjectType.TASK_SCHEDULE, null, helperOption);
                while (schedulableIter.hasNext()) {
                    ITaskSchedule taskSchedule = (ITaskSchedule)schedulableIter.next();
                    NCSchedulable schedulable = new NCSchedulable(taskSchedule);
                    schedulables.add(schedulable);
                }
            }
            catch (PersistManagerException persistManagerException) {
                // empty catch block
            }
        }
        return schedulables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getRunableMap(Iterator schedule_itr) throws ProcessHandlerException {
        HashMap<NCSchedulable, Object> runable_map = new HashMap<NCSchedulable, Object>();
        ArrayList<NCObjectId> task_id_array = new ArrayList<NCObjectId>();
        ArrayList schedulable_array = new ArrayList();
        if (schedule_itr == null) {
            return runable_map;
        }
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        try {
            while (schedule_itr.hasNext()) {
                Object next = schedule_itr.next();
                if (!(next instanceof NCSchedulable)) continue;
                NCObjectId task_id = ((NCSchedulable)next).getTaskSchedule().getTaskId();
                task_id_array.add(task_id);
                schedulable_array.add(next);
            }
            NCObjectId[] task_ids = task_id_array.toArray(new NCObjectId[0]);
            NCSchedulable[] schedulables = schedulable_array.toArray(new NCSchedulable[0]);
            BaseClass[] parents = this.getTaskParents(task_ids);
            Locale locale = null;
            for (int i = 0; i < parents.length; ++i) {
                if (parents[i] != null) {
                    runable_map.put(schedulables[i], parents[i]);
                    continue;
                }
                if (!this.hasCanUseMonitorActivityToolCapability || this.mustCheckPermissions) continue;
                Nil runnable = new Nil();
                if (locale == null) {
                    locale = new JobBiBusHeaders(this.m_header).getProductLocale();
                }
                String unknown = I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, null, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
                TokenProp nameProp = new TokenProp();
                nameProp.setValue(unknown);
                runnable.setDefaultName(nameProp);
                runable_map.put(schedulables[i], runnable);
            }
        }
        finally {
            perf.stop();
        }
        return runable_map;
    }
}

