/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event;

import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.ems.event.FutureEventsContext;
import com.cognos.ems.event.FutureEventsResponse;
import com.cognos.ems.event.FutureEventsUtil;
import com.cognos.ems.event.SummaryResponse;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.security.UserIdentity;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.core.persist.PublishedGuidException;
import com.cognos.sds.core.persist.PublishedGuidPersist;
import com.cognos.sds.event.Event;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.FutureEventSecurityHandler;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import com.cognos.spec.queryEvent.castor.SearchPaths;
import com.cognos.spec.queryEvent.castor.Summary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import noticecast.logictier.NCObjectType;
import noticecast.services.soap.cm.CMRunnablePathResolver;
import noticecast.services.soap.cm.CMSearchPathGenerator;

public abstract class FutureEventsHandlerBase
implements ProcessHandler {
    private static final int MILLISECONDS_IN_TWENTY_FIVE_HOURS = 90000000;
    private static final int MILLISECONDS_IN_THIRTY_DAYS = -1702967296;
    BiBusHeader m_header;
    QueryEventSpecification m_spec;
    boolean hasCanUseMonitorActivityToolCapability = false;
    boolean mustCheckPermissions = false;
    UserIdentity userIdentity;

    public void setSpecification(QueryEventSpecification spec) {
        this.m_spec = spec;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        FutureEventsContext eventsContext = context.getFutureEventsContext();
        IAuthenticator authenticator = AuthenticatorFactory.getInstance();
        this.m_header = context.getBiBusHeader();
        this.m_spec = eventsContext.getQuerySpecification();
        try {
            this.userIdentity = authenticator.getUserIdentity(this.m_header);
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
        }
        try {
            this.hasCanUseMonitorActivityToolCapability = authenticator.hasCapability(this.m_header, UserCapabilityEnum.canUseMonitorActivityTool);
        }
        catch (Exception e) {
            // empty catch block
        }
        FutureEventSecurityHandler fesh = new FutureEventSecurityHandler();
        this.mustCheckPermissions = fesh.isObjectPermissionsRequired();
        this.invokeImpl(context);
    }

    public abstract void invokeImpl(ProcessContext var1) throws ProcessHandlerException;

    protected int resolveSkip(int skip, int count, int eventsCount) {
        if (skip < 0) {
            int mod;
            skip = eventsCount > 0 && count > 0 ? ((mod = eventsCount % count) == 0 ? eventsCount - count : eventsCount - mod) : 0;
        }
        return skip;
    }

    protected AsynchDetailEventRecord[] makePages(AsynchDetailEventRecord[] eventRecords, int skipCount, int maxReturn) {
        AsynchDetailEventRecord[] requiredRunDates = new AsynchDetailEventRecord[]{};
        if (skipCount < 0) {
            int mod;
            int allRunDatesCount = eventRecords.length;
            skipCount = allRunDatesCount > 0 && maxReturn > 0 ? ((mod = allRunDatesCount % maxReturn) == 0 ? allRunDatesCount - maxReturn : allRunDatesCount - mod) : 0;
        }
        if (eventRecords.length == 0 || skipCount >= eventRecords.length) {
            requiredRunDates = new AsynchDetailEventRecord[]{};
        } else {
            int arrayStart = skipCount;
            int arrayEnd = maxReturn + skipCount;
            if (arrayEnd >= eventRecords.length) {
                arrayEnd = eventRecords.length;
            }
            requiredRunDates = new AsynchDetailEventRecord[arrayEnd - arrayStart];
            System.arraycopy(eventRecords, arrayStart, requiredRunDates, 0, arrayEnd - arrayStart);
        }
        return requiredRunDates;
    }

    protected FutureEventsResponse createEmptyResponse(SummaryResponse summaryResponse, int skipCount, int maxReturn, int suspendedCount) {
        FutureEventsResponse response = new FutureEventsResponse(skipCount + 1, skipCount + maxReturn);
        response.setSummaryResponse(summaryResponse);
        response.setListSize(0);
        response.setSuspendedCount(suspendedCount);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseClass[] getTaskParents(NCObjectId[] task_ids) throws ProcessHandlerException {
        int i;
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        String[] paths = new String[task_ids.length];
        for (i = 0; i < task_ids.length; ++i) {
            try {
                paths[i] = PublishedGuidPersist.getInstance().getGuid(task_ids[i], NCObjectType.NOTIFICATION_AGENT);
                continue;
            }
            catch (PublishedGuidException publishedGuidException) {
                // empty catch block
            }
        }
        for (i = 0; i < paths.length; ++i) {
            paths[i] = paths[i] != null ? CMSearchPathGenerator.getScheduleParent(paths[i]) : CMRunnablePathResolver.getRunnablePath(task_ids[i]);
        }
        BaseClass[] responses = new BaseClass[task_ids.length];
        try {
            QueryReply[] cm_responses = this.getRunnablesFromCM(paths);
            for (int i2 = 0; i2 < task_ids.length; ++i2) {
                BaseClass[] response = cm_responses[i2].getQueryResult();
                if (response == null || response.length < 1) continue;
                responses[i2] = response[0];
            }
        }
        finally {
            perf.stop();
        }
        return responses;
    }

    protected QueryReply[] getRunnablesFromCM(String[] searchPaths) throws ProcessHandlerException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "ENTER");
        QueryRequest[] requests = new QueryRequest[searchPaths.length];
        QueryReply[] ret_value = null;
        QueryOptions qo = new QueryOptions();
        qo.setPermission("read");
        String sPermissionFlag = "[permission('read')]";
        for (int i = 0; i < searchPaths.length; ++i) {
            requests[i] = new QueryRequest();
            if (searchPaths[i] == null) {
                searchPaths[i] = "~/report[@name='data']";
            }
            requests[i].setSearch(searchPaths[i] + sPermissionFlag);
            requests[i].setProperties(FutureEventsUtil.getRunnableRefProps(this.m_spec));
        }
        ContentManagerServiceClientPort cm = null;
        try {
            cm = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.m_header));
            ret_value = cm.queryMultiple(requests);
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_UNABLE_CONNECT_CM);
            throw new ProcessHandlerException(I18NCode.MSG_UNABLE_CONNECT_CM);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)e);
            ProcessHandlerException phe = new ProcessHandlerException(I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e.getMessage()}, (LocalizableException)e);
            throw phe;
        }
        finally {
            if (cm != null) {
                cm.close();
            }
            perf.stop();
        }
        return ret_value;
    }

    protected boolean filterOnParentOwner(Map runnablesMap) {
        if (this.m_spec.getFilters() == null || this.m_spec.getFilters().getOwner() == null || this.m_spec.getFilters().getOwner().equalsIgnoreCase("any user")) {
            return false;
        }
        int mapOriginalSize = runnablesMap.size();
        String ownedBy = this.m_spec.getFilters().getOwner();
        LinkedList toRemove = new LinkedList();
        for (Object key : runnablesMap.keySet()) {
            String parentOwnerStoreIDString;
            BaseClass parentOwner;
            BaseClass parent = (BaseClass)runnablesMap.get(key);
            if (parent == null || parent.getOwner() == null) continue;
            BaseClass[] parentOwners = parent.getOwner().getValue();
            if (parentOwners != null && parentOwners.length > 0 && (parentOwner = parentOwners[0]).getStoreID() != null && !ownedBy.equals(parentOwnerStoreIDString = parentOwner.getStoreID().getValue().get_value())) {
                toRemove.add(key);
            }
            parent.setOwner(null);
        }
        Iterator removeIter = toRemove.iterator();
        while (removeIter.hasNext()) {
            runnablesMap.remove(removeIter.next());
        }
        return mapOriginalSize != runnablesMap.size();
    }

    protected boolean filterOnScopeSearchPath(Map<?, BaseClass> runnablesMap) {
        if (this.m_spec.getScope() == null || this.m_spec.getScope().getSearchPaths() == null) {
            return false;
        }
        int mapOriginalSize = runnablesMap.size();
        SearchPaths scopeSearchPaths = this.m_spec.getScope().getSearchPaths();
        LinkedList toRemove = new LinkedList();
        for (Object key : runnablesMap.keySet()) {
            String scopeSearchPath;
            BaseClass parent = runnablesMap.get(key);
            if (parent == null || parent.getSearchPath() == null) continue;
            String searchPath = parent.getSearchPath().getValue();
            int searchPathCount = scopeSearchPaths.getSearchPathCount();
            for (int j = 0; j < searchPathCount && !searchPath.startsWith(scopeSearchPath = scopeSearchPaths.getSearchPath(j)); ++j) {
                toRemove.add(key);
            }
        }
        Iterator removeIter = toRemove.iterator();
        while (removeIter.hasNext()) {
            runnablesMap.remove(removeIter.next());
        }
        return mapOriginalSize != runnablesMap.size();
    }

    protected Event[] filterOnScopeEventID(Event[] events) {
        if (events == null || this.m_spec.getScope() == null || this.m_spec.getScope().getEventID() == null) {
            return events;
        }
        String scopeEventID = this.m_spec.getScope().getEventID();
        ArrayList<Event> filteredEventList = new ArrayList<Event>();
        for (Event event : events) {
            if (event == null || event.getEventId() == null || event.getEventId().toString() == null || !event.getEventId().toString().equalsIgnoreCase(scopeEventID)) continue;
            filteredEventList.add(event);
        }
        return filteredEventList.toArray(new Event[filteredEventList.size()]);
    }

    protected void validateSpecification(QueryEventSpecification spec) throws ProcessHandlerException {
        if (spec.getFilters() == null || spec.getFilters().getStartTime() == null || spec.getFilters().getEndTime() == null) {
            throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new Object[]{"StartDate and EndDate filters are required!"});
        }
        Summary summary = spec.getSummary();
        if (summary != null) {
            if (summary.getStartTime() == null || summary.getEndTime() == null) {
                throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new Object[]{"Summary StartDate and EndDate are required!"});
            }
            if (summary.getStartTime().after(summary.getEndTime())) {
                throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new Object[]{"Summary StartDate after EndDate!"});
            }
            SummaryResponse.GroupBy groupBy = SummaryResponse.GroupBy.valueOf(summary.getGroupBy());
            if (groupBy != null && groupBy.equals((Object)SummaryResponse.GroupBy.hour)) {
                long startLong = summary.getStartTime().getTime();
                long endLong = summary.getEndTime().getTime();
                if (90000000L <= endLong - startLong) {
                    throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new Object[]{"Summary (GROUP BY HOUR) StartDate to EndDate range > 25 hours!"});
                }
            }
        }
    }
}

