/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event;

import com.cognos.ems.event.DateRange;
import com.cognos.ems.event.FutureEventsSchedulableQuery;
import com.cognos.ems.event.SummaryResponse;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.sds.event.Event;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import java.util.Date;
import java.util.TreeSet;
import noticecast.scheduling.core.ISchedulable;

public class FutureEventsQueryUtil {
    private ISchedulable[] m_schedulables;
    private Date m_start;
    private Date m_end;
    private SummaryResponse m_summary;
    private String[] m_statuses;
    private PriorityEnum m_priority;
    private String m_tenantID;
    private int m_hardMaxActivities;
    private int m_softMaxActivities;

    public FutureEventsQueryUtil(ISchedulable[] schedulables, SummaryResponse summary, Date start, Date end, String[] statuses, PriorityEnum priority, String tenantID) {
        this.m_schedulables = schedulables;
        this.m_summary = summary;
        this.m_start = start;
        this.m_end = end;
        this.m_statuses = statuses;
        this.m_priority = priority;
        this.m_tenantID = tenantID;
        this.m_hardMaxActivities = Integer.MAX_VALUE;
        this.m_softMaxActivities = Integer.MAX_VALUE;
    }

    public FutureEventsSchedulableQuery.EventsWrapper getEvents() {
        DateRange summaryRange = new DateRange(this.m_summary.getStartDate(), this.m_summary.getEndDate());
        DateRange detailRange = new DateRange(this.m_start, this.m_end);
        try {
            int newValue;
            String strMaxActivities = CRNProperties.getInstance().getProperty("max.activities.hard");
            if (strMaxActivities != null && (newValue = Integer.valueOf(strMaxActivities).intValue()) >= 0) {
                this.m_hardMaxActivities = newValue;
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("m_hardMaxActivities[" + this.m_hardMaxActivities + "]");
            }
            if ((strMaxActivities = CRNProperties.getInstance().getProperty("max.activities")) != null && (newValue = Integer.valueOf(strMaxActivities).intValue()) >= 0) {
                this.m_softMaxActivities = newValue;
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("m_softMaxActivities[" + this.m_softMaxActivities + "]");
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.WARN, (Throwable)e);
        }
        if (this.isIdentical(summaryRange, detailRange)) {
            return this.processSummaryAndDetail(detailRange);
        }
        if (this.isDisjoint(summaryRange, detailRange)) {
            this.processSummary(summaryRange);
            return this.processDetail(detailRange);
        }
        return this.processSummaryAndDetail(summaryRange, detailRange);
    }

    private FutureEventsSchedulableQuery.EventsWrapper processSummaryAndDetail(DateRange summaryRange, DateRange detailRange) {
        Date minStart = summaryRange.getStart().before(detailRange.getStart()) ? summaryRange.getStart() : detailRange.getStart();
        Date maxEnd = summaryRange.getEnd().after(detailRange.getEnd()) ? summaryRange.getEnd() : detailRange.getEnd();
        FutureEventsSchedulableQuery.EventsWrapper wrapper = new FutureEventsSchedulableQuery.EventsWrapper();
        int priorityVal = this.m_priority.getType();
        TreeSet<Event> schedulableRunDateSet = new TreeSet<Event>(new Event.RequestDateComparator());
        int hardCounter = 0;
        int softCounter = 0;
        for (int i = 0; i < this.m_schedulables.length; ++i) {
            Event srd = this.m_schedulables[i].getNextExecuteInclusive(minStart);
            boolean isInSummaryRange = false;
            boolean isInDetailRange = false;
            if (srd != null) {
                isInSummaryRange = summaryRange.isInRange(srd.getRunDate());
                isInDetailRange = detailRange.isInRange(srd.getRunDate());
            }
            while (!this.isMaximumActivities(hardCounter, softCounter, "processSummaryAndDetail") && srd != null && (srd.getRunDate().before(maxEnd) || srd.getRunDate().equals(maxEnd))) {
                ++hardCounter;
                ++softCounter;
                EventStatus theStatus = srd.getStatus();
                boolean isIncreased = false;
                if ((this.m_priority.equals(PriorityEnum.ANY) || priorityVal == srd.getPriority()) && (this.m_tenantID == null || this.m_tenantID.equals(srd.getTenantID()))) {
                    if (isInDetailRange && FutureEventsSchedulableQuery.checkStatusInList(theStatus, this.m_statuses)) {
                        schedulableRunDateSet.add(srd);
                        isIncreased = true;
                    }
                    if (isInSummaryRange) {
                        this.m_summary.incrementCount(srd.getRunDate(), theStatus);
                        isIncreased = true;
                    }
                    if (!isIncreased) {
                        --softCounter;
                    }
                }
                if ((srd = this.m_schedulables[i].getNextExecute(srd.getRunDate())) == null) continue;
                isInSummaryRange = summaryRange.isInRange(srd.getRunDate());
                isInDetailRange = detailRange.isInRange(srd.getRunDate());
            }
        }
        Event[] schedulableRunDateArrayFull = new Event[schedulableRunDateSet.size()];
        schedulableRunDateSet.toArray(schedulableRunDateArrayFull);
        wrapper.setScheduleRunDates(schedulableRunDateArrayFull);
        for (int i = 0; i < schedulableRunDateArrayFull.length; ++i) {
            schedulableRunDateArrayFull[i].setPosition(i + 1);
        }
        return wrapper;
    }

    private FutureEventsSchedulableQuery.EventsWrapper processSummaryAndDetail(DateRange range) {
        Date start = range.getStart();
        Date end = range.getEnd();
        FutureEventsSchedulableQuery.EventsWrapper wrapper = new FutureEventsSchedulableQuery.EventsWrapper();
        int priorityVal = this.m_priority.getType();
        TreeSet<Event> srdSet = new TreeSet<Event>(new Event.RequestDateComparator());
        int hardCounter = 0;
        int softCounter = 0;
        for (int i = 0; i < this.m_schedulables.length; ++i) {
            Event srd = this.m_schedulables[i].getNextExecuteInclusive(start);
            while (!this.isMaximumActivities(hardCounter, softCounter, "processSummaryAndDetail_single") && srd != null && (srd.getRunDate().before(end) || srd.getRunDate().equals(end))) {
                ++hardCounter;
                ++softCounter;
                EventStatus theStatus = srd.getStatus();
                if ((this.m_priority.equals(PriorityEnum.ANY) || priorityVal == srd.getPriority()) && (this.m_tenantID == null || this.m_tenantID.equals(srd.getTenantID()))) {
                    if (FutureEventsSchedulableQuery.checkStatusInList(theStatus, this.m_statuses)) {
                        srdSet.add(srd);
                    } else {
                        --softCounter;
                    }
                    this.m_summary.incrementCount(srd.getRunDate(), theStatus);
                }
                srd = this.m_schedulables[i].getNextExecute(srd.getRunDate());
            }
        }
        Event[] srdArrayFull = new Event[srdSet.size()];
        srdSet.toArray(srdArrayFull);
        wrapper.setScheduleRunDates(srdArrayFull);
        for (int i = 0; i < srdArrayFull.length; ++i) {
            srdArrayFull[i].setPosition(i + 1);
        }
        return wrapper;
    }

    private void processSummary(DateRange summaryRange) {
        Date start = summaryRange.getStart();
        Date end = summaryRange.getEnd();
        int priorityVal = this.m_priority.getType();
        int hardCounter = 0;
        int softCounter = 0;
        for (int i = 0; i < this.m_schedulables.length; ++i) {
            Event srd = this.m_schedulables[i].getNextExecuteInclusive(start);
            while (!this.isMaximumActivities(hardCounter, softCounter, "processSummary") && srd != null && (srd.getRunDate().before(end) || srd.getRunDate().equals(end))) {
                ++hardCounter;
                ++softCounter;
                EventStatus theStatus = srd.getStatus();
                if (this.m_priority.equals(PriorityEnum.ANY) || priorityVal == srd.getPriority()) {
                    if (this.m_tenantID == null || this.m_tenantID.equals(srd.getTenantID())) {
                        this.m_summary.incrementCount(srd.getRunDate(), theStatus);
                    } else {
                        --softCounter;
                    }
                }
                srd = this.m_schedulables[i].getNextExecute(srd.getRunDate());
            }
        }
    }

    private FutureEventsSchedulableQuery.EventsWrapper processDetail(DateRange detailRange) {
        Date start = detailRange.getStart();
        Date end = detailRange.getEnd();
        FutureEventsSchedulableQuery.EventsWrapper wrapper = new FutureEventsSchedulableQuery.EventsWrapper();
        int priorityVal = this.m_priority.getType();
        TreeSet<Event> srdSet = new TreeSet<Event>(new Event.RequestDateComparator());
        int hardCounter = 0;
        int softCounter = 0;
        for (int i = 0; i < this.m_schedulables.length; ++i) {
            Event srd = this.m_schedulables[i].getNextExecuteInclusive(start);
            ++hardCounter;
            ++softCounter;
            while (!this.isMaximumActivities(hardCounter, softCounter, "processDetail") && srd != null && (srd.getRunDate().before(end) || srd.getRunDate().equals(end))) {
                EventStatus theStatus = srd.getStatus();
                if ((this.m_priority.equals(PriorityEnum.ANY) || priorityVal == srd.getPriority()) && (this.m_tenantID == null || this.m_tenantID.equals(srd.getTenantID()))) {
                    if (FutureEventsSchedulableQuery.checkStatusInList(theStatus, this.m_statuses)) {
                        srdSet.add(srd);
                    } else {
                        --softCounter;
                    }
                }
                srd = this.m_schedulables[i].getNextExecute(srd.getRunDate());
            }
        }
        Event[] srdArrayFull = new Event[srdSet.size()];
        srdSet.toArray(srdArrayFull);
        wrapper.setScheduleRunDates(srdArrayFull);
        for (int i = 0; i < srdArrayFull.length; ++i) {
            srdArrayFull[i].setPosition(i + 1);
        }
        return wrapper;
    }

    private boolean isDisjoint(DateRange range1, DateRange range2) {
        return range1.getEnd().before(range2.getStart());
    }

    private boolean isIdentical(DateRange range1, DateRange range2) {
        return range1.equals(range2);
    }

    private boolean isMaximumActivities(int hardCounter, int softCounter, String funcName) {
        boolean result = false;
        if (this.m_hardMaxActivities <= hardCounter || this.m_softMaxActivities <= softCounter) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("[" + funcName + "] The number of activities reached the limit. Hard_Limit[" + this.m_hardMaxActivities + "] Soft_Limit[" + this.m_softMaxActivities + "].  hardCounter[" + hardCounter + "] softCounter[" + softCounter + "]");
            result = true;
        }
        return result;
    }
}

