/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event;

import com.cognos.ems.event.FutureEventsQueryUtil;
import com.cognos.ems.event.FutureEventsResponse;
import com.cognos.ems.event.SummaryResponse;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import noticecast.scheduling.core.ISchedulable;
import noticecast.scheduling.core.ISchedulableId;
import noticecast.scheduling.core.Scheduler;
import noticecast.scheduling.schedules.DailySchedule;
import noticecast.scheduling.schedules.ISchedule;
import noticecast.scheduling.schedules.ScheduleType;

public class FutureEventsSchedulableQuery {
    public static int MAX_COUNT = Integer.MAX_VALUE;

    public static FutureEventsResponse doQuery(ISchedulable[] schedulables, SummaryResponse summary, Date start, Date end, int count, int skip, String[] statuses, PriorityEnum priority, String tenantID) throws LocalizableException {
        long diff;
        FutureEventsResponse response = null;
        if (!Scheduler.getInstance().isSchedulerThreadActive()) {
            response = new FutureEventsResponse(skip, skip + count);
            response.setRunDates(new Event[0]);
            return response;
        }
        if (count == 0) {
            count = MAX_COUNT;
        }
        if ((diff = (long)end.compareTo(start)) < 0L) {
            end = start;
        } else {
            Date maximumEnd = new Date(start.getTime() + 2592000000L);
            if (maximumEnd.compareTo(end) < 0) {
                throw new LocalizableException(EmsI18NCode.QUERY_EVENTS_MAX_DATE_RANGE_ERROR, new String[]{"30"}){};
            }
        }
        response = FutureEventsSchedulableQuery.getAscending(schedulables, summary, start, end, count, skip, statuses, priority, tenantID);
        return response;
    }

    private static FutureEventsResponse getAscending(ISchedulable[] schedulables, SummaryResponse summary, Date start, Date end, int count, int skip, String[] statuses, PriorityEnum priority, String tenantID) {
        FutureEventsQueryUtil util = new FutureEventsQueryUtil(schedulables, summary, start, end, statuses, priority, tenantID);
        EventsWrapper wrapper = util.getEvents();
        Event[] allRunDates = wrapper.getScheduleRunDates();
        if (skip < 0) {
            int mod;
            int allRunDatesCount = allRunDates.length;
            skip = allRunDatesCount > 0 && count > 0 ? ((mod = allRunDatesCount % count) == 0 ? allRunDatesCount - count : allRunDatesCount - mod) : 0;
        }
        FutureEventsResponse response = new FutureEventsResponse(skip + 1, skip + count);
        response.setSummaryResponse(summary);
        response.setListSize(allRunDates.length);
        response.setRunDates(allRunDates);
        return response;
    }

    public static boolean checkStatusInList(EventStatus status, String[] statuses) {
        if (statuses == null) {
            return true;
        }
        String aStatus = status.statusName();
        for (int i = 0; i < statuses.length; ++i) {
            if (aStatus.compareToIgnoreCase(statuses[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private static Event[] getFullRunDateArray(ISchedulable[] schedulables, Date start, Date end, String[] statuses) {
        TreeSet<Event> schedulableRunDateSet = new TreeSet<Event>(new Event.RequestDateComparator());
        for (int i = 0; i < schedulables.length; ++i) {
            Event event = schedulables[i].getNextExecuteInclusive(start);
            while (event != null && (event.getRunDate().before(end) || event.getRunDate().equals(end))) {
                EventStatus theStatus = event.getStatus();
                if (FutureEventsSchedulableQuery.checkStatusInList(theStatus, statuses)) {
                    schedulableRunDateSet.add(event);
                }
                event = schedulables[i].getNextExecute(event.getRunDate());
            }
        }
        Event[] schedulableRunDateArrayFull = new Event[schedulableRunDateSet.size()];
        schedulableRunDateSet.toArray(schedulableRunDateArrayFull);
        return schedulableRunDateArrayFull;
    }

    private static EventsWrapper getFutureEvents(ISchedulable[] schedulables, Date start, Date end, String[] statuses, PriorityEnum priority) {
        int priorityVal = priority.getType();
        EventsWrapper wrapper = new EventsWrapper();
        TreeSet<Event> schedulableRunDateSet = new TreeSet<Event>(new Event.RequestDateComparator());
        for (int i = 0; i < schedulables.length; ++i) {
            Event srd = schedulables[i].getNextExecuteInclusive(start);
            while (srd != null && (srd.getRunDate().before(end) || srd.getRunDate().equals(end))) {
                EventStatus theStatus = srd.getStatus();
                if (priority.equals(PriorityEnum.ANY) || priorityVal == srd.getPriority()) {
                    if (FutureEventsSchedulableQuery.checkStatusInList(theStatus, statuses)) {
                        schedulableRunDateSet.add(srd);
                    }
                    wrapper.incrementStatusCount(theStatus);
                }
                srd = schedulables[i].getNextExecute(srd.getRunDate());
            }
        }
        Event[] schedulableRunDateArrayFull = new Event[schedulableRunDateSet.size()];
        schedulableRunDateSet.toArray(schedulableRunDateArrayFull);
        wrapper.setScheduleRunDates(schedulableRunDateArrayFull);
        for (int i = 0; i < schedulableRunDateArrayFull.length; ++i) {
            schedulableRunDateArrayFull[i].setPosition(i + 1);
        }
        return wrapper;
    }

    public static void main(String[] args) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss a zzz");
        formatter.setTimeZone(TimeZone.getDefault());
        ISchedule schedule1 = FutureEventsSchedulableQuery.getDailySchedule(formatter, "2002.05.01 at 11:00:00 AM GMT", "2002.05.04 at 11:00:00 AM GMT", false, 1);
        ISchedule schedule2 = FutureEventsSchedulableQuery.getDailySchedule(formatter, "2002.05.07 at 11:00:00 AM GMT", "2002.05.09 at 11:00:00 AM GMT", false, 1);
        Date start = null;
        Date end = null;
        try {
            start = formatter.parse("2002.05.01 at 11:00:00 AM GMT");
            end = formatter.parse("2002.05.09 at 11:00:00 AM GMT");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TestSchedulable sched1 = new TestSchedulable(schedule1, EventStatus.SCHEDULED);
        TestSchedulable sched2 = new TestSchedulable(schedule2, EventStatus.CANCELLED);
        ISchedulable[] schedulables = new ISchedulable[]{sched1, sched2};
        Object[][] data = new Object[][]{{schedulables, start, end, new Integer(0), new Integer(0), Boolean.TRUE}, {schedulables, start, end, new Integer(-1), new Integer(0), Boolean.TRUE}, {schedulables, start, end, new Integer(4), new Integer(0), Boolean.TRUE}, {schedulables, start, end, new Integer(0), new Integer(4), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-2), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-6), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-7), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-8), Boolean.TRUE}, {schedulables, start, end, new Integer(3), new Integer(-30), Boolean.TRUE}, {schedulables, start, end, new Integer(0), new Integer(0), Boolean.FALSE}, {schedulables, start, end, new Integer(-1), new Integer(0), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(0), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(3), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(6), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(7), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(8), Boolean.FALSE}, {schedulables, start, end, new Integer(0), new Integer(-3), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-5), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-7), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-8), Boolean.FALSE}, {schedulables, start, end, new Integer(3), new Integer(-30), Boolean.FALSE}};
        FutureEventsSchedulableQuery queryObject = new FutureEventsSchedulableQuery();
        String[] statuses = new String[]{"scheduled", "cancelled"};
        for (int i = 0; i < data.length; ++i) {
            System.out.println("Test[" + i + "]");
            System.out.print("Count:" + data[i][3].toString());
            System.out.print("  Skip:" + data[i][4].toString());
            System.out.print((Boolean)data[i][5] != false ? "  Ascending:" : "  Descending");
            System.out.println();
        }
    }

    private static ISchedule getDailySchedule(DateFormat formatter, String startDateString, String endDateString, boolean repeatForever, int interval) {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = formatter.parse(startDateString);
            endDate = formatter.parse(endDateString);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        DailySchedule schedule = new DailySchedule(ScheduleType.DAILY_SCHEDULE, startDate, endDate, false, 1, com.cognos.i18n.TimeZone.getDefault());
        return schedule;
    }

    private static class TestSchedulable
    implements ISchedulable {
        private EventStatus m_status;
        private ISchedule m_schedule;

        public TestSchedulable(ISchedule schedule, EventStatus x) {
            this.m_schedule = schedule;
            this.m_status = x;
        }

        @Override
        public Date getNextExecution() {
            return null;
        }

        @Override
        public Event getNextExecute(Date date) {
            Date resultDate = this.m_schedule.getNextExecute(date);
            Event srd = null;
            if (resultDate != null) {
                srd = new Event(EventStatus.SCHEDULED, EventId.valueOf("1234"));
                srd.setRequestedStartDate(resultDate);
                srd.setPriority(new Integer(3));
                srd.setSchedulable(this);
            }
            return srd;
        }

        @Override
        public Event getNextExecuteInclusive(Date date) {
            Date resultDate = this.m_schedule.getNextExecuteInclusive(date);
            Event srd = null;
            if (resultDate != null) {
                srd = new Event(EventStatus.SCHEDULED, EventId.valueOf("1234"));
                srd.setRequestedStartDate(resultDate);
                srd.setPriority(new Integer(3));
                srd.setSchedulable(this);
            }
            return srd;
        }

        @Override
        public void runTask() {
        }

        @Override
        public ISchedulableId getId() {
            return null;
        }
    }

    public static class EventsWrapper {
        private Event[] m_scheduleRunDates;
        private int m_scheduledCount;
        private int m_cancelledCount;

        void setScheduleRunDates(Event[] scheduleRunDates) {
            this.m_scheduleRunDates = scheduleRunDates;
        }

        Event[] getScheduleRunDates() {
            return this.m_scheduleRunDates;
        }

        void incrementStatusCount(EventStatus status) {
            if (status.isEqualTo(EventStatus.SCHEDULED)) {
                ++this.m_scheduledCount;
            } else if (status.isEqualTo(EventStatus.CANCELLED)) {
                ++this.m_cancelledCount;
            }
        }

        int getcancelledCount() {
            return this.m_cancelledCount;
        }

        int getScheduleCount() {
            return this.m_scheduledCount;
        }
    }
}

