/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event;

import com.cognos.developer.schemas.bibus._3.AsynchDetailParameterValues;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.i18n.Calendar;
import com.cognos.i18n.TimeZone;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.spec.queryEvent.castor.Summary;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class SummaryResponse {
    private static final TimeZone UTC_TZ = TimeZone.getTimeZone((String)"UTC");
    private static final String SCHEDULED = "scheduled";
    private static final String CANCELLED = "cancelled";
    private static final String SUSPENDED = "suspended";
    private Date m_start;
    private Date m_end;
    private SortedMap<Date, IntervalCount> m_scheduled;
    private SortedMap<Date, IntervalCount> m_cancelled;
    private int m_scheduledCount;
    private int m_cancelledCount;
    private int m_suspendedCount;
    private GroupBy m_groupBy;
    private boolean m_ignoreSuspended;

    public SummaryResponse() {
    }

    public SummaryResponse(Date start, Date end) {
        this.m_start = start;
        this.m_end = end;
        this.m_groupBy = GroupBy.none;
        this.m_ignoreSuspended = true;
        this.init();
    }

    public SummaryResponse(Summary summary) {
        this.m_start = summary.getStartTime();
        this.m_end = summary.getEndTime();
        this.m_groupBy = GroupBy.valueOf(summary.getGroupBy());
        this.m_ignoreSuspended = false;
        this.init();
    }

    private void init() {
        if (this.m_groupBy == null) {
            this.m_groupBy = GroupBy.none;
        }
        this.m_scheduled = new TreeMap<Date, IntervalCount>();
        this.m_cancelled = new TreeMap<Date, IntervalCount>();
    }

    public Date getEndDate() {
        return this.m_end;
    }

    public Date getStartDate() {
        return this.m_start;
    }

    public int getScheduledCount() {
        return this.m_scheduledCount;
    }

    public void setScheduledCount(int scheduledCount) {
        this.m_scheduledCount = scheduledCount;
    }

    public int getCancelledCount() {
        return this.m_cancelledCount;
    }

    public void setCancelledCount(int cancelledCount) {
        this.m_cancelledCount = cancelledCount;
    }

    public int getSuspendedCount() {
        return this.m_suspendedCount;
    }

    public void setSuspendedCount(int suspendedCount) {
        this.m_suspendedCount = suspendedCount;
    }

    public AsynchDetailParameterValues getSummary() {
        AsynchDetailParameterValues values = null;
        values = this.m_groupBy.equals((Object)GroupBy.none) ? this.buildSummary() : this.buildIntervalSummary();
        return values;
    }

    private AsynchDetailParameterValues buildSummary() {
        String scheduledCount = Integer.toString(this.m_scheduledCount);
        String cancelledCount = Integer.toString(this.m_cancelledCount);
        ParameterValue paramValue1 = ObjectModelUtil.makeParameterValue((String)SCHEDULED, (String)scheduledCount);
        ParameterValue paramValue2 = ObjectModelUtil.makeParameterValue((String)CANCELLED, (String)cancelledCount);
        AsynchDetailParameterValues values = new AsynchDetailParameterValues();
        if (this.m_ignoreSuspended) {
            values.setParameters(new ParameterValue[]{paramValue1, paramValue2});
        } else {
            String suspendedCount = Integer.toString(this.m_suspendedCount);
            ParameterValue paramValue3 = ObjectModelUtil.makeParameterValue((String)SUSPENDED, (String)suspendedCount);
            values.setParameters(new ParameterValue[]{paramValue1, paramValue2, paramValue3});
        }
        return values;
    }

    private AsynchDetailParameterValues buildIntervalSummary() {
        ParameterValue[] paramValues = new ParameterValue[]{this.createSummaryParameter(SCHEDULED, this.m_scheduled), this.createSummaryParameter(CANCELLED, this.m_cancelled), new ParameterValue()};
        paramValues[2].setName(SUSPENDED);
        SimpleParmValueItem suspendCountItem = new SimpleParmValueItem();
        suspendCountItem.setDisplay(Integer.toString(this.m_suspendedCount));
        suspendCountItem.setUse(Integer.toString(this.m_suspendedCount));
        paramValues[2].setValue(new ParmValueItem[]{suspendCountItem});
        AsynchDetailParameterValues values = new AsynchDetailParameterValues();
        values.setParameters(paramValues);
        return values;
    }

    private ParameterValue createSummaryParameter(String name, SortedMap<Date, IntervalCount> items) {
        if (items.size() == 0) {
            return ObjectModelUtil.makeParameterValue((String)name, (String)Integer.toString(0));
        }
        ParameterValue paramValue = new ParameterValue();
        paramValue.setName(name);
        ParmValueItem[] parmValItems = new ParmValueItem[items.size()];
        int index = 0;
        Iterator<Date> keysIter = items.keySet().iterator();
        Iterator<IntervalCount> valuesIter = items.values().iterator();
        while (valuesIter.hasNext()) {
            Date intervalDate = keysIter.next();
            IntervalCount summaryInterval = valuesIter.next();
            SimpleParmValueItem item = new SimpleParmValueItem();
            item.setDisplay(Integer.toString(summaryInterval.m_count));
            item.setUse(TimeUtils.dateToUTCString((Date)intervalDate));
            parmValItems[index] = item;
            ++index;
        }
        paramValue.setValue(parmValItems);
        return paramValue;
    }

    void incrementCount(Date runDate, EventStatus status) {
        if (this.m_groupBy.equals((Object)GroupBy.none)) {
            if (status.equals((Object)EventStatus.SCHEDULED)) {
                ++this.m_scheduledCount;
            } else if (status.equals((Object)EventStatus.CANCELLED)) {
                ++this.m_cancelledCount;
            }
        } else {
            this.incrementIntervalCount(runDate, status);
        }
    }

    private void incrementIntervalCount(Date runDate, EventStatus status) {
        IntervalCount summaryInterval = null;
        Date intervalDate = this.getIntervalDate(runDate);
        if (status.equals((Object)EventStatus.SCHEDULED)) {
            ++this.m_scheduledCount;
            summaryInterval = (IntervalCount)this.m_scheduled.get(intervalDate);
            if (summaryInterval == null) {
                this.m_scheduled.put(intervalDate, new IntervalCount());
            } else {
                ++summaryInterval.m_count;
            }
        }
        if (status.equals((Object)EventStatus.CANCELLED)) {
            ++this.m_cancelledCount;
            summaryInterval = (IntervalCount)this.m_cancelled.get(intervalDate);
            if (summaryInterval == null) {
                this.m_cancelled.put(intervalDate, new IntervalCount());
            } else {
                ++summaryInterval.m_count;
            }
        }
    }

    private Date getIntervalDate(Date date) {
        Date intervalDate;
        block3: {
            block2: {
                intervalDate = this.m_start;
                if (!this.m_groupBy.equals((Object)GroupBy.hour)) break block2;
                Calendar cal = Calendar.getInstance((TimeZone)UTC_TZ);
                cal.setTime(this.m_start);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Date temp = intervalDate = cal.getTime();
                while (!temp.after(date)) {
                    intervalDate = temp;
                    cal.add(11, 1);
                    temp = cal.getTime();
                }
                break block3;
            }
            if (!this.m_groupBy.equals((Object)GroupBy.day)) break block3;
            Calendar cal = Calendar.getInstance((TimeZone)UTC_TZ);
            cal.setTime(this.m_start);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date temp = intervalDate = cal.getTime();
            while (!temp.after(date)) {
                intervalDate = temp;
                cal.add(5, 1);
                temp = cal.getTime();
            }
        }
        return intervalDate;
    }

    private class IntervalCount {
        public int m_count = 1;

        private IntervalCount() {
        }
    }

    public static enum GroupBy {
        hour,
        day,
        none;

    }
}

