/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.ems.event.FutureEventsContext;
import com.cognos.ems.event.FutureEventsHandlerBase;
import com.cognos.ems.event.FutureEventsResponse;
import com.cognos.ems.event.FutureEventsUtil;
import com.cognos.ems.event.SummaryResponse;
import com.cognos.ems.event.query.SuspendedScheduleQuery;
import com.cognos.ems.i18n.EmsI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectCopyUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.sds.event.Event;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.spec.queryEvent.castor.Summary;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SuspendedFutureEventsHandler
extends FutureEventsHandlerBase {
    @Override
    public void invokeImpl(ProcessContext context) throws ProcessHandlerException {
        Date start;
        FutureEventsContext eventsContext = context.getFutureEventsContext();
        this.validateSpecification(this.m_spec);
        Date startDate = this.m_spec.getFilters().getStartTime();
        Date endDate = this.m_spec.getFilters().getEndTime();
        PriorityEnum priority = this.m_spec.getFilters().getPriority();
        if (priority == null) {
            priority = PriorityEnum.ANY;
        }
        int maxReturn = eventsContext.getMaxObjects();
        int skipCount = eventsContext.getSkipCount();
        int suspendedCount = FutureEventsUtil.getSuspendedCount();
        Date now = new Date();
        Date minStart = start = startDate.after(now) ? startDate : now;
        Date maxEnd = endDate;
        SummaryResponse summaryResponse = null;
        Summary summary = this.m_spec.getSummary();
        if (summary != null) {
            summaryResponse = new SummaryResponse(summary);
            if (summary.getStartTime().before(minStart)) {
                minStart = summary.getStartTime();
            }
            if (summary.getEndTime().before(maxEnd)) {
                maxEnd = summary.getEndTime();
            }
        } else {
            summaryResponse = new SummaryResponse(start, endDate);
        }
        if (endDate.before(now)) {
            FutureEventsResponse response = this.createEmptyResponse(summaryResponse, skipCount, maxReturn, suspendedCount);
            eventsContext.setFutureEventsResponse(response);
            return;
        }
        PerfLog perf = SDSLogger.getLogger((SDSCategory)JSMCommonCategory.PERF).start(this.getClass(), SDSLevel.DEBUG, "BEGIN");
        try {
            SuspendedScheduleQuery query = new SuspendedScheduleQuery(this.m_spec);
            List<Event> events = query.getEvents();
            Event[] eventsArray = new Event[events.size()];
            eventsArray = this.filterOnScopeEventID(events.toArray(eventsArray));
            events = new ArrayList<Event>(Arrays.asList(eventsArray));
            if (events.size() > 0) {
                Map<NCObjectId, BaseClass> runnableMap = this.getRunnableMap(events);
                if (this.filterOnParentOwner(runnableMap) || this.filterOnScopeSearchPath(runnableMap)) {
                    Iterator<Event> eventsIter = events.iterator();
                    while (eventsIter.hasNext()) {
                        Event event = eventsIter.next();
                        if (runnableMap.containsKey(event.getEventId().getTaskId())) continue;
                        eventsIter.remove();
                    }
                }
                Set<NCObjectId> ids = runnableMap.keySet();
                Iterator<Event> eventsIter = events.iterator();
                while (eventsIter.hasNext()) {
                    Event event = eventsIter.next();
                    if (ids.contains(event.getEventId().getTaskId())) continue;
                    eventsIter.remove();
                }
                AsynchDetailEventRecord[] eventRecords = new AsynchDetailEventRecord[events.size()];
                Map<Event, BaseClass> scheduledByMap = this.getScheduledByAccountsMap(events);
                for (int i = 0; i < events.size(); ++i) {
                    Event event = events.get(i);
                    event.setPosition(i + 1);
                    Date requestRunDate = event.getRunDate();
                    Date scheduledStartDate = event.getScheduledStartDate();
                    NCObjectId taskId = event.getEventId().getTaskId();
                    BaseClass runnable = runnableMap.get(taskId);
                    BaseClass runnableCopy = (BaseClass)ObjectCopyUtil.deepCopy((Object)runnable);
                    eventRecords[i] = new AsynchDetailEventRecord();
                    eventRecords[i].setEventID(event.getEventId().toXMLString());
                    Calendar cal = TimeUtils.dateToUTCJavaCalendar((Date)scheduledStartDate);
                    eventRecords[i].setScheduledStartTime(cal);
                    eventRecords[i].setRunnable(new BaseClass[]{runnableCopy});
                    eventRecords[i].setStatus(event.getStatus().statusName());
                    if (event.getPriority() != null) {
                        eventRecords[i].setPriority(event.getPriority().intValue());
                    }
                    if (event.getTenantID() != null) {
                        eventRecords[i].setTenantID(event.getTenantID());
                    }
                    NonNegativeIntegerProp nonNegativeIntegerProp = new NonNegativeIntegerProp();
                    nonNegativeIntegerProp.setValue(new BigInteger(new Integer(event.getPosition()).toString()));
                    runnableCopy.setPosition(nonNegativeIntegerProp);
                    Account account = (Account)scheduledByMap.get(event);
                    if (account == null) continue;
                    eventRecords[i].setUser(new BaseClass[]{account});
                }
                AsynchDetailEventRecord[] requiredRunDates = this.makePages(eventRecords, skipCount, maxReturn);
                int skip = this.resolveSkip(skipCount, maxReturn, events.size());
                FutureEventsResponse schedulableQueryResponse = new FutureEventsResponse(skip, skip + maxReturn);
                schedulableQueryResponse.setSummaryResponse(summaryResponse);
                schedulableQueryResponse.setListSize(eventRecords.length);
                schedulableQueryResponse.setSuspendedCount(suspendedCount);
                schedulableQueryResponse.setEventRecords(requiredRunDates);
                eventsContext.setFutureEventsResponse(schedulableQueryResponse);
            } else {
                FutureEventsResponse response = this.createEmptyResponse(summaryResponse, skipCount, maxReturn, suspendedCount);
                eventsContext.setFutureEventsResponse(response);
            }
        }
        catch (Exception e) {
            if (e instanceof LocalizableException) {
                LocalizableException le = (LocalizableException)e;
                throw new ProcessHandlerException(le.getI18NCode(), le.getParams());
            }
            throw new ProcessHandlerException(EmsI18NCode.MSG_EMS_GENERAL_ERROR, new String[]{e.getLocalizedMessage()});
        }
        finally {
            perf.stop();
        }
    }

    protected Map<Event, BaseClass> getScheduledByAccountsMap(List<Event> events) throws ProcessHandlerException {
        Object[] errorParams;
        int[] backPointers = new int[events.size()];
        ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>();
        QueryReply[] replies = null;
        HashMap<Event, BaseClass> accountsMap = new HashMap<Event, BaseClass>();
        for (int i = 0; i < events.size(); ++i) {
            Event event = events.get(i);
            String ownerStoreId = event.getScheduledBy();
            if (ownerStoreId == null) continue;
            backPointers[requests.size()] = i;
            QueryRequest request = new QueryRequest();
            request.setSearch("storeID(\"" + ownerStoreId + "\")");
            request.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.userName});
            request.setOptions(null);
            request.setSortBy(null);
            requests.add(request);
        }
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(this.m_header));
            if (requests.size() > 0) {
                replies = contentManager.queryMultiple(requests.toArray(new QueryRequest[requests.size()]));
            }
        }
        catch (SDKClientException e) {
            errorParams = new String[]{e.getLocalizedMessage()};
            throw new ProcessHandlerException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, errorParams, (LocalizableException)e);
        }
        catch (EMFSecurityException e) {
            errorParams = new String[]{e.getLocalizedMessage()};
            throw new ProcessHandlerException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, errorParams);
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        if (replies != null) {
            int isz = replies.length;
            for (int i = 0; i < isz; ++i) {
                BaseClass[] result;
                int backPtr = backPointers[i];
                if (replies[i] == null || (result = replies[i].getQueryResult()) == null || result.length != 1) continue;
                Event event = events.get(backPtr);
                accountsMap.put(event, result[0]);
            }
        }
        return accountsMap;
    }

    protected Map<NCObjectId, BaseClass> getRunnableMap(List<Event> events) throws ProcessHandlerException {
        HashMap<NCObjectId, BaseClass> runnableMap = new HashMap<NCObjectId, BaseClass>();
        HashSet<NCObjectId> ids = new HashSet<NCObjectId>();
        for (Event event : events) {
            ids.add(event.getEventId().getTaskId());
        }
        NCObjectId[] idsArray = ids.toArray(new NCObjectId[0]);
        BaseClass[] parents = this.getTaskParents(idsArray);
        Locale locale = null;
        for (int i = 0; i < parents.length; ++i) {
            if (parents[i] != null) {
                runnableMap.put(idsArray[i], parents[i]);
                continue;
            }
            if (!this.hasCanUseMonitorActivityToolCapability || this.mustCheckPermissions) continue;
            Nil runnable = new Nil();
            if (locale == null) {
                locale = new JobBiBusHeaders(this.m_header).getProductLocale();
            }
            String unknown = I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, null, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
            TokenProp nameProp = new TokenProp();
            nameProp.setValue(unknown);
            runnable.setDefaultName(nameProp);
            runnableMap.put(idsArray[i], (BaseClass)runnable);
        }
        return runnableMap;
    }
}

