/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event.query;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.jsmcommon.security.UserIdentity;
import com.cognos.sds.util.SQL.SQLJoin;
import com.cognos.sds.util.SQL.SQLOrQueryFilter;
import com.cognos.sds.util.SQL.SQLQueryBuilder;
import com.cognos.sds.util.SQL.SQLQueryOperatorFilter;
import com.cognos.sds.util.SQL.SQLTableItem;
import com.cognos.spec.queryEvent.castor.Filters;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import com.cognos.spec.queryEvent.castor.types.ScheduleTypeEnum;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import noticecast.scheduling.core.persistqueue.PersistableSchedulerQueueEntry;
import noticecast.scheduling.nc.NCSchedulableId;

public class SchedulerQueueQuery {
    private QueryEventSpecification m_spec;
    private SQLQueryBuilder builder = null;

    public SchedulerQueueQuery(QueryEventSpecification spec, UserIdentity userIdentity) {
        boolean filterByPriority;
        this.m_spec = spec;
        Filters filters = this.m_spec.getFilters();
        boolean bl = filterByPriority = filters != null && filters.getPriority() != null && filters.getPriority().getType() != PriorityEnum.VALUE_3.getType();
        if (filterByPriority) {
            this.builder = new SQLQueryBuilder(new String[]{NC_TASK.TABLE_NAME, NC_TASKSCHEDULE.TABLE_NAME, R_TASKSCHEDULE_SCHEDULE.TABLE_NAME, NC_SCHEDULE.TABLE_NAME, NC_SCHEDULE_QUEUE.TABLE_NAME, NC_SCHEDULED_EVENT_OVERRIDE.TABLE_NAME});
            this.builder.setDistinct(true);
        }
        if (this.builder == null) {
            this.builder = new SQLQueryBuilder(new String[]{NC_TASK.TABLE_NAME, NC_TASKSCHEDULE.TABLE_NAME, R_TASKSCHEDULE_SCHEDULE.TABLE_NAME, NC_SCHEDULE.TABLE_NAME, NC_SCHEDULE_QUEUE.TABLE_NAME});
        }
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_SCHEDULE_QUEUE.SCHEDULE_ID), new SQLTableItem(NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID)));
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID), new SQLTableItem(R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID)));
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID), new SQLTableItem(NC_SCHEDULE.PK_SCHEDULE_ID)));
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASKSCHEDULE.FK_TASK_ID), new SQLTableItem(NC_TASK.PK_TASK_ID)));
        if (filterByPriority) {
            this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID), new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.FK_TASKSCHEDULE_ID)));
        }
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULE_QUEUE.SCHEDULE_ID));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULE_QUEUE.RUN_DATE));
        if (filters != null && filters.getEndTime() != null) {
            PriorityEnum priorityRangeEnum;
            String scheduleTrigger;
            ScheduleTypeEnum scheduleType;
            String scheduledBy;
            if (userIdentity.doTenantFiltering()) {
                this.addTenantIDFilter(this.builder, userIdentity.getTenantIDsForFiltering());
            }
            Date endDate = filters.getEndTime();
            this.addEndDateFilter(this.builder, endDate);
            String objectClass = filters.getObjectClass();
            if (objectClass != null && !objectClass.equalsIgnoreCase("any")) {
                this.addObjectClassFilter(this.builder, objectClass);
            }
            if ((scheduledBy = filters.getUser()) != null && !scheduledBy.equalsIgnoreCase("any user")) {
                this.addScheduledByFilter(this.builder, scheduledBy);
            }
            if ((scheduleType = filters.getScheduleType()) != null && !scheduleType.toString().equalsIgnoreCase("any")) {
                this.addScheduleTypeFilter(this.builder, scheduleType);
            }
            if ((scheduleTrigger = filters.getScheduleTrigger()) != null) {
                this.addScheduleTriggerFilter(this.builder, scheduleTrigger);
            }
            if ((priorityRangeEnum = filters.getPriority()) != null) {
                this.addPriorityFilter(this.builder, priorityRangeEnum);
            }
        } else {
            throw new IllegalStateException("SchedulerQueueQuery: No end date specified!");
        }
    }

    public String getSQL() {
        return this.builder.getSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getScheduleQueueEntries() {
        void var1_5;
        void var1_3;
        block6: {
            Object var1_1 = null;
            JDBCConnection connection = null;
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
                HashMap<String, Object> params = new HashMap<String, Object>();
                ArrayList<String> orderedParamKeys = new ArrayList<String>();
                String sql = this.builder.getSQL(params);
                String paramSql = SQLQueryBuilder.buildSQLAndCollectParams(sql, params, orderedParamKeys);
                statement = connection.prepareStatement(paramSql, 1004, 1007);
                SQLQueryBuilder.fillPreparedStatementParameters(params, orderedParamKeys, statement);
                rs = statement.executeQuery();
                List list = this.readEntries(rs);
                if (connection == null) break block6;
            }
            catch (SQLException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
                break block6;
            }
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            break block6;
            finally {
                if (connection != null) {
                    SqlResourceCloser.closeResources(rs, statement);
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
            }
        }
        if (var1_3 != null) return var1_5;
        ArrayList arrayList = new ArrayList();
        return var1_5;
    }

    private void addObjectClassFilter(SQLQueryBuilder builder, String objectClass) {
        if (objectClass.equalsIgnoreCase("any")) {
            return;
        }
        builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK.OBJECT_CLASS), objectClass, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addTenantIDFilter(SQLQueryBuilder builder, String[] tenantIDs) {
        SQLOrQueryFilter filter = new SQLOrQueryFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.TENANT_ID), "", SQLQueryOperatorFilter.FilterOperator.EQUALS), new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.TENANT_ID), SQLQueryOperatorFilter.FilterOperator.IS_NULL));
        if (tenantIDs != null) {
            for (String tenantID : tenantIDs) {
                if (tenantID == null || tenantID.length() <= 0) continue;
                filter = new SQLOrQueryFilter(filter, new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.TENANT_ID), tenantID, SQLQueryOperatorFilter.FilterOperator.EQUALS));
            }
        }
        builder.addFilter(filter);
    }

    private void addEndDateFilter(SQLQueryBuilder builder, Date endDate) {
        builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULE_QUEUE.RUN_DATE), new Long(endDate.getTime()), SQLQueryOperatorFilter.FilterOperator.LESS_THAN_OR_EQUAL));
    }

    private void addOwnedByFilter(SQLQueryBuilder builder, String ownedBy) {
        if (ownedBy.equalsIgnoreCase("any")) {
            return;
        }
        builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK.OWNED_BY), ownedBy, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduledByFilter(SQLQueryBuilder builder, String scheduledBy) {
        if (scheduledBy.equalsIgnoreCase("any")) {
            return;
        }
        builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.SCHEDULED_BY), scheduledBy, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduleTypeFilter(SQLQueryBuilder builder, ScheduleTypeEnum scheduleType) {
        builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULE.SCHEDULE_TYPE), scheduleType.toString(), SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduleTriggerFilter(SQLQueryBuilder builder, String scheduleTrigger) {
        builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULE.TRIGGER_ID), scheduleTrigger, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addPriorityFilter(SQLQueryBuilder builder, PriorityEnum priorityRangeEnum) {
        if (priorityRangeEnum == null || priorityRangeEnum.equals(PriorityEnum.ANY)) {
            return;
        }
        try {
            SQLQueryOperatorFilter filter1 = new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.PRIORITY), new Integer(priorityRangeEnum.toString()), SQLQueryOperatorFilter.FilterOperator.EQUALS);
            if (this.isAnySchdEventOvrridden()) {
                SQLQueryOperatorFilter filter2 = new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_PRIORITY), new Integer(priorityRangeEnum.toString()), SQLQueryOperatorFilter.FilterOperator.EQUALS);
                SQLOrQueryFilter orFilter = new SQLOrQueryFilter(filter1, filter2);
                builder.addOrFilter(orFilter);
            } else {
                builder.addFilter(filter1);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAnySchdEventOvrridden() {
        ResultSet rs;
        Statement statement;
        JDBCConnection connection;
        boolean result;
        block7: {
            result = true;
            String sql = "Select count(*) from " + NC_SCHEDULED_EVENT_OVERRIDE.TABLE_NAME;
            connection = null;
            statement = null;
            rs = null;
            try {
                int count;
                connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                if (!rs.next() || (count = rs.getInt(1)) >= 1) break block7;
                result = false;
            }
            catch (SQLException e) {
                try {
                    SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
                }
                catch (Throwable throwable) {
                    SqlResourceCloser.closeResources(rs, statement);
                    if (connection != null) {
                        SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                    }
                    throw throwable;
                }
                SqlResourceCloser.closeResources(rs, (Statement)statement);
                if (connection != null) {
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
        if (connection != null) {
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
        }
        return result;
    }

    private List readEntries(ResultSet result_set) throws SQLException {
        ArrayList<PersistableSchedulerQueueEntry> entriesList = new ArrayList<PersistableSchedulerQueueEntry>();
        while (result_set.next()) {
            NCObjectId ncObjectId = NCObjectIdUtil.instance().createObjectId(result_set, 1);
            NCSchedulableId id = new NCSchedulableId(ncObjectId);
            long dateLong = result_set.getLong(2);
            Date date = new Date(dateLong);
            entriesList.add(new PersistableSchedulerQueueEntry(id, date));
        }
        return entriesList;
    }

    public static class NC_SCHEDULED_EVENT_OVERRIDE {
        public static String TABLE_NAME = "NC_SCHEDULED_EVENT_OVERRIDE";
        public static String FK_TASKSCHEDULE_ID = TABLE_NAME + ".FK_TASKSCHEDULE_ID";
        public static String EVENT_DATE = TABLE_NAME + ".EVENT_DATE";
        public static String EVENT_PRIORITY = TABLE_NAME + ".EVENT_PRIORITY";
    }

    public static class R_TASKSCHEDULE_SCHEDULE {
        public static String TABLE_NAME = "R_TASKSCHEDULE_SCHEDULE";
        public static String FK_TASKSCHEDULE_ID = TABLE_NAME + ".FK_TASKSCHEDULE_ID";
        public static String FK_SCHEDULE_ID = TABLE_NAME + ".FK_SCHEDULE_ID";
    }

    public static class NC_SCHEDULE_QUEUE {
        public static String TABLE_NAME = "NC_SCHEDULE_QUEUE";
        public static String SCHEDULE_ID = TABLE_NAME + ".SCHEDULE_ID";
        public static String RUN_DATE = TABLE_NAME + ".RUN_DATE";
    }

    public static class NC_SCHEDULE {
        public static String TABLE_NAME = "NC_SCHEDULE";
        public static String PK_SCHEDULE_ID = "NC_SCHEDULE.PK_SCHEDULE_ID";
        public static String SCHEDULE_TYPE = "NC_SCHEDULE.SCHEDULE_TYPE";
        public static String TRIGGER_ID = "NC_SCHEDULE.TRIGGER_ID";
    }

    public static class NC_TASKSCHEDULE {
        public static String TABLE_NAME = "NC_TASKSCHEDULE";
        public static String PK_TASKSCHEDULE_ID = TABLE_NAME + ".PK_TASKSCHEDULE_ID";
        public static String FK_TASK_ID = TABLE_NAME + ".FK_TASK_ID";
        public static String PK_TASK_ID = TABLE_NAME + ".PK_TASK_ID";
        public static String PRIORITY = TABLE_NAME + ".PRIORITY";
        public static String SCHEDULED_BY = TABLE_NAME + ".SCHEDULED_BY";
        public static String TENANT_ID = TABLE_NAME + ".TENANT_ID";
    }

    public static class NC_TASK {
        public static String TABLE_NAME = "NC_TASK";
        public static String PK_TASK_ID = TABLE_NAME + ".PK_TASK_ID";
        public static String OBJECT_CLASS = TABLE_NAME + ".OBJECT_CLASS";
        public static String OWNED_BY = TABLE_NAME + ".OWNED_BY";
    }
}

