/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.event.query;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.objectid.NCObjectIdUtil;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.persist.EventStatusPersister;
import com.cognos.sds.util.SQL.SQLJoin;
import com.cognos.sds.util.SQL.SQLOrQueryFilter;
import com.cognos.sds.util.SQL.SQLQueryBuilder;
import com.cognos.sds.util.SQL.SQLQueryOperatorFilter;
import com.cognos.sds.util.SQL.SQLSort;
import com.cognos.sds.util.SQL.SQLTableItem;
import com.cognos.spec.queryEvent.castor.Filters;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import com.cognos.spec.queryEvent.castor.Sort;
import com.cognos.spec.queryEvent.castor.types.OrderEnum;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import com.cognos.spec.queryEvent.castor.types.ScheduleTypeEnum;
import com.cognos.spec.queryEvent.castor.types.SortEnum;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SuspendedScheduleQuery {
    public static String PK_TASK_ID = "PK_TASK_ID";
    public static String SCHEDULED_BY = "SCHEDULED_BY";
    public static String FK_TASKSCHEDULE_ID = "FK_TASKSCHEDULE_ID";
    public static String EVENT_DATE = "EVENT_DATE";
    public static String EVENT_PRIORITY = "EVENT_PRIORITY";
    public static String EVENT_STATUS = "EVENT_STATUS";
    public static String DELAY_UNTIL = "DELAY_UNTIL";
    public static String SCHEDULE_ID = "FK_SCHEDULE_ID";
    public static String CANCELLED_BY = "CANCELLED_BY";
    public static String TENANTID = "TENANT_ID";
    private QueryEventSpecification m_spec;
    private SQLQueryBuilder builder;

    public SuspendedScheduleQuery(QueryEventSpecification spec) {
        this.m_spec = spec;
        Filters filters = this.m_spec.getFilters();
        this.builder = new SQLQueryBuilder(new String[]{NC_TASK.TABLE_NAME, NC_TASKSCHEDULE.TABLE_NAME, R_TASKSCHEDULE_SCHEDULE.TABLE_NAME, NC_SCHEDULE.TABLE_NAME, NC_SCHEDULED_EVENT_OVERRIDE.TABLE_NAME});
        this.builder.setDistinct(true);
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID), new SQLTableItem(R_TASKSCHEDULE_SCHEDULE.FK_TASKSCHEDULE_ID)));
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(R_TASKSCHEDULE_SCHEDULE.FK_SCHEDULE_ID), new SQLTableItem(NC_SCHEDULE.PK_SCHEDULE_ID)));
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASKSCHEDULE.FK_TASK_ID), new SQLTableItem(NC_TASK.PK_TASK_ID)));
        this.builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASKSCHEDULE.PK_TASKSCHEDULE_ID), new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.FK_TASKSCHEDULE_ID)));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.FK_TASKSCHEDULE_ID));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_DATE));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.DELAY_UNTIL));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_PRIORITY));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_STATUS));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.CANCELLED_BY));
        this.builder.addSelectedItem(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.SCHEDULE_ID));
        this.builder.addSelectedItem(new SQLTableItem(NC_TASK.PK_TASK_ID));
        this.builder.addSelectedItem(new SQLTableItem(NC_TASKSCHEDULE.SCHEDULED_BY));
        this.builder.addSelectedItem(new SQLTableItem(NC_TASKSCHEDULE.TENANTID));
        this.setSort();
        this.setSuspendedStatusFilter();
        if (filters != null) {
            PriorityEnum priorityRangeEnum;
            String scheduleTrigger;
            ScheduleTypeEnum scheduleType;
            String scheduledBy;
            String objectClass = filters.getObjectClass();
            if (objectClass != null && !objectClass.equalsIgnoreCase("any")) {
                this.addObjectClassFilter(objectClass);
            }
            if ((scheduledBy = filters.getUser()) != null && !scheduledBy.equalsIgnoreCase("any user")) {
                this.addScheduledByFilter(scheduledBy);
            }
            if ((scheduleType = filters.getScheduleType()) != null && !scheduleType.toString().equalsIgnoreCase("any")) {
                this.addScheduleTypeFilter(scheduleType);
            }
            if ((scheduleTrigger = filters.getScheduleTrigger()) != null) {
                this.addScheduleTriggerFilter(scheduleTrigger);
            }
            if ((priorityRangeEnum = filters.getPriority()) != null) {
                this.addPriorityFilter(priorityRangeEnum);
            }
        } else {
            throw new IllegalStateException("SchedulerQueueQuery: No end date specified!");
        }
    }

    public String getSQL() {
        return this.builder.getSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Event> getEvents() {
        void var1_5;
        void var1_3;
        block6: {
            Object var1_1 = null;
            JDBCConnection connection = null;
            PreparedStatement statement = null;
            ResultSet rs = null;
            try {
                connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
                HashMap<String, Object> params = new HashMap<String, Object>();
                ArrayList<String> orderedParamKeys = new ArrayList<String>();
                String sql = this.builder.getSQL(params);
                String paramSql = SQLQueryBuilder.buildSQLAndCollectParams(sql, params, orderedParamKeys);
                statement = connection.prepareStatement(paramSql, 1004, 1007);
                SQLQueryBuilder.fillPreparedStatementParameters(params, orderedParamKeys, statement);
                rs = statement.executeQuery();
                List<Event> list = this.readEntries(rs);
                if (connection == null) break block6;
            }
            catch (SQLException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
                break block6;
            }
            SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            break block6;
            finally {
                if (connection != null) {
                    SqlResourceCloser.closeResources(rs, statement);
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
            }
        }
        if (var1_3 != null) return var1_5;
        ArrayList arrayList = new ArrayList();
        return var1_5;
    }

    private void addObjectClassFilter(String objectClass) {
        if (objectClass.equalsIgnoreCase("any")) {
            return;
        }
        this.builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK.OBJECT_CLASS), objectClass, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addOwnedByFilter(String ownedBy) {
        if (ownedBy.equalsIgnoreCase("any")) {
            return;
        }
        this.builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK.OWNED_BY), ownedBy, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void setSuspendedStatusFilter() {
        int statusAsInt = new EventStatusPersister(EventStatus.SUSPENDED).getInteger();
        this.builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_STATUS), statusAsInt, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduledByFilter(String scheduledBy) {
        if (scheduledBy.equalsIgnoreCase("any")) {
            return;
        }
        this.builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.SCHEDULED_BY), scheduledBy, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduleTypeFilter(ScheduleTypeEnum scheduleType) {
        this.builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULE.SCHEDULE_TYPE), scheduleType.toString(), SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduleTriggerFilter(String scheduleTrigger) {
        this.builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULE.TRIGGER_ID), scheduleTrigger, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addPriorityFilter(PriorityEnum priorityRangeEnum) {
        if (priorityRangeEnum == null || priorityRangeEnum.equals(PriorityEnum.ANY)) {
            return;
        }
        try {
            SQLQueryOperatorFilter filter1 = new SQLQueryOperatorFilter(new SQLTableItem(NC_TASKSCHEDULE.PRIORITY), new Integer(priorityRangeEnum.toString()), SQLQueryOperatorFilter.FilterOperator.EQUALS);
            SQLQueryOperatorFilter filter2 = new SQLQueryOperatorFilter(new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_PRIORITY), new Integer(priorityRangeEnum.toString()), SQLQueryOperatorFilter.FilterOperator.EQUALS);
            SQLOrQueryFilter orFilter = new SQLOrQueryFilter(filter1, filter2);
            this.builder.addOrFilter(orFilter);
        }
        catch (Exception e) {
            return;
        }
    }

    private void setSort() {
        SQLTableItem sortItem = new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_DATE);
        SQLSort.SortDirection sortDirection = SQLSort.SortDirection.ASCENDING;
        Sort sort = this.m_spec.getSort();
        if (sort != null) {
            if (sort.getSortItem() != null) {
                if (sort.getSortItem().equals(SortEnum.PRIORITY)) {
                    sortItem = new SQLTableItem(NC_SCHEDULED_EVENT_OVERRIDE.EVENT_PRIORITY);
                } else if (sort.getSortItem().equals(SortEnum.SCHEDULETYPE)) {
                    sortItem = new SQLTableItem(NC_SCHEDULE.SCHEDULE_TYPE);
                }
            }
            if (sort.getOrder() != null && sort.getOrder().equals(OrderEnum.DESCENDING)) {
                sortDirection = SQLSort.SortDirection.DESCENDING;
            }
        }
        this.builder.addSort(new SQLSort(sortItem, sortDirection));
    }

    private List<Event> readEntries(ResultSet rs) throws SQLException {
        ArrayList<Event> events = null;
        while (rs.next()) {
            if (events == null) {
                events = new ArrayList<Event>();
            }
            NCObjectId taskId = NCObjectIdUtil.instance().createObjectId(rs, PK_TASK_ID);
            Date date = new Date(rs.getLong(EVENT_DATE));
            EventStatus status = null;
            int eventStatusInt = rs.getInt(EVENT_STATUS);
            if (!rs.wasNull()) {
                EventStatusPersister persister = new EventStatusPersister();
                persister.valueOf(eventStatusInt);
                status = persister.getEventStatus();
            }
            Integer priority = null;
            int priorityInt = rs.getInt(EVENT_PRIORITY);
            if (!rs.wasNull()) {
                priority = new Integer(priorityInt);
            }
            String user = rs.getString(CANCELLED_BY);
            Date requestedDate = null;
            long delayUntilLong = rs.getLong(DELAY_UNTIL);
            if (!rs.wasNull()) {
                requestedDate = new Date(delayUntilLong);
            }
            EventId id = new EventId(taskId, date);
            Event event = new Event(status, id);
            event.setCancelUser(user);
            if (requestedDate != null) {
                event.setRequestedStartDate(requestedDate);
            } else if (status.equals((Object)EventStatus.SUSPENDED)) {
                event.setRequestedStartDate(null);
            }
            event.setPriority(priority);
            String tenantID = rs.getString(TENANTID);
            if (!rs.wasNull()) {
                event.setTenantID(tenantID);
            }
            String scheduledBy = rs.getString(SCHEDULED_BY);
            event.setScheduledBy(scheduledBy);
            event.setIsOverride(true);
            events.add(event);
        }
        return events;
    }

    public static class NC_SCHEDULED_EVENT_OVERRIDE {
        public static String TABLE_NAME = "NC_SCHEDULED_EVENT_OVERRIDE";
        public static String FK_TASKSCHEDULE_ID = TABLE_NAME + ".FK_TASKSCHEDULE_ID";
        public static String EVENT_DATE = TABLE_NAME + ".EVENT_DATE";
        public static String EVENT_PRIORITY = TABLE_NAME + ".EVENT_PRIORITY";
        public static String EVENT_STATUS = TABLE_NAME + ".EVENT_STATUS";
        public static String DELAY_UNTIL = TABLE_NAME + ".DELAY_UNTIL";
        public static String SCHEDULE_ID = TABLE_NAME + ".FK_SCHEDULE_ID";
        public static String CANCELLED_BY = TABLE_NAME + ".CANCELLED_BY";
    }

    public static class R_TASKSCHEDULE_SCHEDULE {
        public static String TABLE_NAME = "R_TASKSCHEDULE_SCHEDULE";
        public static String FK_TASKSCHEDULE_ID = TABLE_NAME + ".FK_TASKSCHEDULE_ID";
        public static String FK_SCHEDULE_ID = TABLE_NAME + ".FK_SCHEDULE_ID";
    }

    public static class NC_SCHEDULE {
        public static String TABLE_NAME = "NC_SCHEDULE";
        public static String PK_SCHEDULE_ID = "NC_SCHEDULE.PK_SCHEDULE_ID";
        public static String SCHEDULE_TYPE = "NC_SCHEDULE.SCHEDULE_TYPE";
        public static String TRIGGER_ID = "NC_SCHEDULE.TRIGGER_ID";
    }

    public static class NC_TASKSCHEDULE {
        public static String TABLE_NAME = "NC_TASKSCHEDULE";
        public static String PK_TASKSCHEDULE_ID = TABLE_NAME + ".PK_TASKSCHEDULE_ID";
        public static String FK_TASK_ID = TABLE_NAME + ".FK_TASK_ID";
        public static String PK_TASK_ID = TABLE_NAME + ".PK_TASK_ID";
        public static String PRIORITY = TABLE_NAME + ".PRIORITY";
        public static String SCHEDULED_BY = TABLE_NAME + ".SCHEDULED_BY";
        public static String TENANTID = TABLE_NAME + ".TENANT_ID";
    }

    public static class NC_TASK {
        public static String TABLE_NAME = "NC_TASK";
        public static String PK_TASK_ID = TABLE_NAME + ".PK_TASK_ID";
        public static String OBJECT_CLASS = TABLE_NAME + ".OBJECT_CLASS";
        public static String OWNED_BY = TABLE_NAME + ".OWNED_BY";
    }
}

