/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.handlers;

import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.sds.adapter.ScheduleSynchInputAdapter;
import com.cognos.sds.adapter.ScheduleSynchOutputAdapter;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class UpgradeSchedulesHandler
implements ProcessHandler {
    private static final String SELECT_CM_SCHEDULABLE_AGENTS = "SELECT R_NEWSITEMS_NCOBJECTS.NID FROM NC_TASK, R_NEWSITEMS_NCOBJECTS WHERE NC_TASK.PK_TASK_ID=R_NEWSITEMS_NCOBJECTS.FK_NCID AND R_NEWSITEMS_NCOBJECTS.TYPE=908 AND (NC_TASK.OBJECT_CLASS IS NULL OR NC_TASK.OWNED_BY IS NULL) ORDER BY R_NEWSITEMS_NCOBJECTS.NID";
    private static UpgradeSchedulesHandler instance = new UpgradeSchedulesHandler();
    private static boolean doProcess = true;

    protected UpgradeSchedulesHandler() {
    }

    public static UpgradeSchedulesHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        if (!doProcess) {
            return;
        }
        doProcess = false;
        List schedulesToUpdate = this.getSchedulesToUpgrade(context);
        if (schedulesToUpdate != null && !schedulesToUpdate.isEmpty()) {
            ScheduleSynchOutputAdapter[] outputAdapters = context.getScheduleSynchOutputAdapters();
            if (outputAdapters == null) {
                outputAdapters = new ScheduleSynchOutputAdapter[]{};
            }
            ScheduleSynchOutputAdapter[] newOutputAdapters = new ScheduleSynchOutputAdapter[outputAdapters.length + schedulesToUpdate.size()];
            System.arraycopy(outputAdapters, 0, newOutputAdapters, 0, outputAdapters.length);
            int scheduleToUpdateIndex = 0;
            for (int i = outputAdapters.length; i < newOutputAdapters.length; ++i) {
                ScheduleSynchOutputAdapter adapter;
                String taskId = (String)schedulesToUpdate.get(scheduleToUpdateIndex++);
                newOutputAdapters[i] = adapter = ScheduleSynchOutputAdapter.createAdapter(taskId, "update");
            }
            context.setScheduleSynchOutputAdapter(newOutputAdapters);
        }
    }

    private List getSchedulesToUpgrade(ProcessContext context) {
        ScheduleSynchOutputAdapter[] outputAdapters;
        List schedulesToUpdate = this.getSchedulesToUpgradeGuids();
        if (schedulesToUpdate.isEmpty()) {
            return schedulesToUpdate;
        }
        TreeSet<String> inputGuidSet = new TreeSet<String>();
        ScheduleSynchInputAdapter[] inputAdapters = context.getScheduleSynchInputAdapters();
        if (inputAdapters != null && inputAdapters.length > 0) {
            for (int i = 0; i < inputAdapters.length; ++i) {
                inputGuidSet.add(inputAdapters[i].getTaskId());
            }
        }
        if ((outputAdapters = context.getScheduleSynchOutputAdapters()) != null && outputAdapters.length > 0) {
            for (int i = 0; i < outputAdapters.length; ++i) {
                inputGuidSet.remove(outputAdapters[i].getTaskId());
            }
        }
        Iterator iter = schedulesToUpdate.iterator();
        ArrayList<String> schedulesNotInCm = new ArrayList<String>();
        while (iter.hasNext()) {
            String guid = (String)iter.next();
            if (inputGuidSet.contains(guid)) continue;
            schedulesNotInCm.add(guid);
        }
        if (schedulesNotInCm.size() > 0) {
            schedulesToUpdate.retainAll(schedulesNotInCm);
            for (String guid : schedulesNotInCm) {
                this.logUpgradeError(guid);
            }
        }
        return schedulesToUpdate;
    }

    protected void logUpgradeError(String guid) {
        SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("UpgradeSchedulesHandler: Schedule with guid [" + guid + "] is not in CM - unable to upgrade");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getSchedulesToUpgradeGuids() {
        JDBCConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        LinkedList<String> guidsList = new LinkedList<String>();
        try {
            connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery(SELECT_CM_SCHEDULABLE_AGENTS);
            while (rs.next()) {
                String guid = rs.getString(1);
                guidsList.add(guid);
            }
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, statement);
                if (connection != null) {
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
                throw throwable;
            }
            SqlResourceCloser.closeResources(rs, (Statement)statement);
            if (connection != null) {
                SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
        if (connection != null) {
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
        }
        return guidsList;
    }
}

