/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.handlers;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.sds.core.persist.ObjectPersist;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandler;
import com.cognos.sds.handler.ProcessHandlerException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.base.INCBaseObject;
import noticecast.logictier.message.IMessageLine;
import noticecast.logictier.message.IMessageStruct;
import noticecast.persist.INCObjectUpdate;

public class UpgradeTransientSchedulesHandler
implements ProcessHandler {
    private static final String SELECT_TRANSIENT_SCHEDULABLE_AGENTS = "SELECT NC_TASK.PK_TASK_ID, NC_TASK.MODCOUNT, R_NEWSITEMS_NCOBJECTS.NID FROM NC_TASK, R_NEWSITEMS_NCOBJECTS WHERE NC_TASK.PK_TASK_ID=R_NEWSITEMS_NCOBJECTS.FK_NCID AND R_NEWSITEMS_NCOBJECTS.TYPE=911 AND (NC_TASK.OBJECT_CLASS IS NULL OR NC_TASK.OWNED_BY IS NULL) ORDER BY R_NEWSITEMS_NCOBJECTS.NID";
    private static UpgradeTransientSchedulesHandler instance = new UpgradeTransientSchedulesHandler();
    private static boolean doProcess = true;
    private String UPDATE_TASK_SQL = "UPDATE NC_TASK SET OBJECT_CLASS = ?, OWNED_BY = ?, MODCOUNT = MODCOUNT +  1 WHERE PK_TASK_ID = ? AND MODCOUNT = ?";

    private UpgradeTransientSchedulesHandler() {
    }

    public static UpgradeTransientSchedulesHandler getInstance() {
        return instance;
    }

    @Override
    public void invoke(ProcessContext context) throws ProcessHandlerException {
        if (!doProcess) {
            return;
        }
        doProcess = false;
        List infoList = this.getSchedulesToUpgradeInfo();
        for (UpgradeScheduleInfoHolder info : infoList) {
            INCObjectUpdate objUp = ObjectPersist.getInstance().getNCObjectUpdate(NCObjectType.TASK, info.getNcObjectId());
            String searchPath = this.getSearchPath(objUp);
            if (searchPath != null) {
                StringProp stringProp = new StringProp();
                stringProp.setValue(searchPath);
                Nil parent = new Nil();
                parent.setSearchPath(stringProp);
                info.setParent((BaseClass)parent);
                continue;
            }
            SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("UpgradeTransientSchedulesHandler: SearchPath resolved to null for NCObjectId:" + info.getNcObjectId().toString() + " runAt schedule will not be updated");
        }
        this.getParentInfoFromCM(infoList);
        this.updateTransientSchedulesDb(context, infoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSchedulesToUpgradeInfo() {
        JDBCConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        LinkedList<UpgradeScheduleInfoHolder> infoList = new LinkedList<UpgradeScheduleInfoHolder>();
        try {
            connection = NCConnection.instance().getConnectionFactory().createReadOnlyConnection();
            statement = connection.createStatement();
            rs = statement.executeQuery(SELECT_TRANSIENT_SCHEDULABLE_AGENTS);
            while (rs.next()) {
                UpgradeScheduleInfoHolder info = new UpgradeScheduleInfoHolder();
                info.setNcObjectId(NCObjectId.valueOf((ResultSet)rs, (int)1));
                info.setModcount(rs.getInt(2));
                info.setGuid(rs.getString(3));
                infoList.add(info);
            }
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(rs, statement);
                if (connection != null) {
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
                throw throwable;
            }
            SqlResourceCloser.closeResources(rs, (Statement)statement);
            if (connection != null) {
                SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            }
        }
        SqlResourceCloser.closeResources((ResultSet)rs, (Statement)statement);
        if (connection != null) {
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
        }
        return infoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getParentInfoFromCM(List transientInfoUpdates) {
        ContentManagerServiceClientPort cmPort = null;
        BaseClass parent = null;
        for (UpgradeScheduleInfoHolder info : transientInfoUpdates) {
            if (info.getParent() == null) continue;
            String parentSearchPath = info.getParent().getSearchPath().getValue();
            try {
                BaseClass[] parentArray;
                BiBusHeader newHeader = new BiBusHeader();
                newHeader.setTracking(new Tracking());
                cmPort = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(newHeader));
                cmPort.signNextRequest("JSM", false);
                QueryRequest scheduleParentRequest = new QueryRequest();
                scheduleParentRequest.setSearch(parentSearchPath);
                scheduleParentRequest.setProperties(new PropEnum[]{PropEnum.owner, PropEnum.objectClass});
                scheduleParentRequest.setOptions(null);
                scheduleParentRequest.setSortBy(null);
                QueryReply[] replyArray = cmPort.queryMultiple(new QueryRequest[]{scheduleParentRequest});
                if (replyArray == null || replyArray.length != 1 || (parentArray = replyArray[0].getQueryResult()).length <= 0) continue;
                parent = parentArray[0];
                info.setParent(parent);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("Service Exception retrieving cached binding port.");
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug("SDKClient Exception retrieving schedule information for the user.");
            }
            finally {
                cmPort.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransientSchedulesDb(ProcessContext context, List transientInfoUpdates) {
        JDBCConnection connection = null;
        boolean isNewConnection = true;
        try {
            connection = context.getConnection();
        }
        catch (ProcessHandlerException processHandlerException) {
            // empty catch block
        }
        isNewConnection = connection == null;
        PreparedStatement psTask = null;
        try {
            if (isNewConnection) {
                connection = NCConnection.instance().getConnectionFactory().createConnection();
            }
            psTask = connection.prepareStatement(this.UPDATE_TASK_SQL);
            for (UpgradeScheduleInfoHolder info : transientInfoUpdates) {
                psTask.setString(1, info.getParentObjectClass());
                psTask.setString(2, info.getParentOwnerStoreId());
                NCObjectId.setIntoStatement((NCObjectId)info.getNcObjectId(), (int)3, (PreparedStatement)psTask);
                psTask.setInt(4, info.getModcount());
                psTask.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).debug((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlResourceCloser.closeResources(null, psTask);
                if (isNewConnection && connection != null) {
                    SqlResourceCloser.releaseConnection((JDBCConnection)connection);
                }
                throw throwable;
            }
            SqlResourceCloser.closeResources(null, (Statement)psTask);
            if (isNewConnection && connection != null) {
                SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            }
        }
        SqlResourceCloser.closeResources(null, (Statement)psTask);
        if (isNewConnection && connection != null) {
            SqlResourceCloser.releaseConnection((JDBCConnection)connection);
        }
    }

    String getSearchPath(INCObjectUpdate objUp) {
        Iterator messagesIter;
        String searchPath = null;
        INCBaseObject baseObject = objUp.getObject();
        if (baseObject instanceof ITask && (messagesIter = ((ITask)baseObject).getMessages()).hasNext()) {
            IMessageStruct messageStruct = (IMessageStruct)messagesIter.next();
            Vector mLines = messageStruct.getMessageLines();
            StringBuffer cmdStringBuffer = new StringBuffer();
            Enumeration mLinesIter = mLines.elements();
            while (mLinesIter.hasMoreElements()) {
                IMessageLine mLine = (IMessageLine)mLinesIter.nextElement();
                cmdStringBuffer.append(mLine.toString());
            }
            String cmdString = cmdStringBuffer.toString();
            searchPath = this.extractSearchPath(cmdString);
        }
        return searchPath;
    }

    String extractSearchPath(String cmdString) {
        String tmpSearchPath;
        int startIndex;
        int endIndex;
        String searchPath = null;
        if (cmdString != null && cmdString.length() > 0 && (endIndex = cmdString.indexOf("</objectPath>")) > 0 && (startIndex = (tmpSearchPath = cmdString.substring(0, endIndex)).lastIndexOf(">")) > 0) {
            searchPath = tmpSearchPath.substring(startIndex + 1, tmpSearchPath.length());
        }
        return searchPath;
    }

    private class UpgradeScheduleInfoHolder {
        private String m_guid;
        private NCObjectId m_ncObjectId;
        private Schedule m_schedule;
        private BaseClass m_parent;
        private int m_modcount;

        private UpgradeScheduleInfoHolder() {
        }

        public String getGuid() {
            return this.m_guid;
        }

        public void setGuid(String guid) {
            this.m_guid = guid;
        }

        public NCObjectId getNcObjectId() {
            return this.m_ncObjectId;
        }

        public void setNcObjectId(NCObjectId objectId) {
            this.m_ncObjectId = objectId;
        }

        public BaseClass getParent() {
            return this.m_parent;
        }

        public void setParent(BaseClass parent) {
            this.m_parent = parent;
        }

        public Schedule getSchedule() {
            return this.m_schedule;
        }

        public void setSchedule(Schedule schedule) {
            this.m_schedule = schedule;
        }

        public int getModcount() {
            return this.m_modcount;
        }

        public void setModcount(int modcount) {
            this.m_modcount = modcount;
        }

        public String getParentObjectClass() {
            if (this.m_parent != null && this.m_parent.getObjectClass() != null) {
                return this.m_parent.getObjectClass().getValue().getValue();
            }
            return null;
        }

        public String getParentOwnerStoreId() {
            BaseClass[] ownerArray;
            if (this.m_parent != null && this.m_parent.getOwner() != null && (ownerArray = this.m_parent.getOwner().getValue()) != null && ownerArray.length > 0) {
                return ownerArray[0].getStoreID().getValue().get_value();
            }
            return null;
        }

        public String getScheduleOwnerStoreId() {
            BaseClass[] ownerArray;
            if (this.m_schedule != null && this.m_schedule.getOwner() != null && (ownerArray = this.m_schedule.getOwner().getValue()) != null && ownerArray.length > 0) {
                return ownerArray[0].getStoreID().getValue().get_value();
            }
            return null;
        }
    }
}

