/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ems.util;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.ems.EventManagementCategory;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.objectid.NCObjectId;
import com.cognos.jsmcommon.util.AuditPropUtil;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.sds.handler.ProcessContext;
import com.cognos.sds.handler.ProcessHandlerException;
import com.cognos.sds.security.UserAccountSecurityHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import noticecast.logictier.NCObjectType;
import noticecast.logictier.agent.ITask;
import noticecast.logictier.message.IMessageStruct;
import noticecast.persist.IPersistManager;
import noticecast.persist.PersistManagerException;
import noticecast.scheduling.nc.NCSchedulable;
import noticecast.services.RepositoryServicesImpl;

public class EMSUtil {
    public void filterOnCaller(BiBusHeader m_header, Collection schedulables) throws ProcessHandlerException {
        Account account = this.getCallerAccount(m_header);
        String accountPath = account.getSearchPath().getValue();
        Iterator iter = schedulables.iterator();
        while (iter.hasNext()) {
            NCSchedulable schedulable = (NCSchedulable)iter.next();
            NCObjectId taskId = schedulable.getTaskSchedule().getTaskId();
            IPersistManager pm = RepositoryServicesImpl.instance().getPersistManager();
            String credential = null;
            try {
                ITask task = (ITask)pm.findNCObjectConsumerCopyByOid(taskId, NCObjectType.AGENT);
                Iterator msgIter = task.getMessages();
                if (msgIter.hasNext()) {
                    IMessageStruct msg = (IMessageStruct)msgIter.next();
                    credential = msg.getCredential();
                }
            }
            catch (PersistManagerException ex) {
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)ex);
                AuditProperties ap = AuditPropUtil.doProps(this.getClass(), (String)"Warning");
                SDSLogger.getLogger((SDSCategory)EventManagementCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.MSG_FAILED_TO_RETRIEVE_A_TASK_OBJECT_FROM_RE, (Object[])new String[]{taskId.toString()}, (Map)ap);
            }
            if (credential != null && credential.startsWith(accountPath)) continue;
            iter.remove();
        }
    }

    private Account getCallerAccount(BiBusHeader m_header) throws ProcessHandlerException {
        ProcessContext runningContext = new ProcessContext();
        runningContext.setBiBusHeader(m_header);
        UserAccountSecurityHandler handler = new UserAccountSecurityHandler();
        handler.invoke(runningContext);
        return runningContext.getUserAccount();
    }
}

