/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.service.AsyncServiceImpl;
import com.cognos.jsmcommon.soap.util.XMLHelper;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.MonitorServiceHandler;
import com.cognos.monitor.api.Monitorable;
import com.cognos.monitor.paging.MonitorServicePager;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.MessageContext;
import org.dom4j.Element;

public class MonitorAsyncService
extends AsyncServiceImpl {
    public MonitorAsyncService(MonitorServiceHandler handler, MessageContext context) {
        super((BasicHandler)handler, MonitorCategory.TRACE, context);
    }

    protected int getDefaultPrimaryThreshold() {
        return this.calculateThreshold(7, "primary.wait.ms");
    }

    protected int getDefaultSecondaryThreshold() {
        return this.calculateThreshold(120, "secondary.wait.ms");
    }

    public void stillWorkingImpl(MessageContext mc, AsyncContext ac) {
        super.stillWorkingImpl(mc, ac);
        this.addID(mc, ac);
    }

    public void workingImpl(MessageContext mc, AsyncContext ac) {
        super.workingImpl(mc, ac);
        this.addID(mc, ac);
    }

    public void abandonImpl(AsyncContext ac) {
        Object context;
        if (ac != null && (context = ac.getContextObj()) != null && context instanceof MonitorServicePager) {
            MonitorServicePager pager = (MonitorServicePager)context;
            pager.release();
        }
    }

    private void addID(MessageContext mc, AsyncContext ac) {
        Object obj = ac.getContextObj();
        String id = null;
        if (obj != null) {
            if (obj instanceof TaskRunContext) {
                id = ((TaskRunContext)obj).getEventId().toXMLString();
            } else if (obj instanceof Monitorable) {
                id = ((Monitorable)obj).getId().toXMLString();
            }
        }
        if (id == null) {
            return;
        }
        BIBusEnvelope response = (BIBusEnvelope)mc.getProperty(mc.getResponseName() + ".envelope");
        Element bodyElem = response.getBody();
        Element resultElement = (Element)bodyElem.selectSingleNode("//" + RESULT.getName());
        if (resultElement == null) {
            String msg = "MonitorsyncService - result element is null, cannot set response id";
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(msg);
            return;
        }
        this.addAsyncDetailsEventID(resultElement, id);
    }

    private void addAsyncDetailsEventID(Element resultElement, String id) {
        Element detailsElement = resultElement.element("//" + DETAILS);
        if (detailsElement != null) {
            String msg = "MonitorsyncService - response details element unexpectedly set!";
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(msg);
            return;
        }
        detailsElement = resultElement.addElement(DETAILS.getName());
        detailsElement.addAttribute(XMLHelper.XSI_TYPE, BIBusEnvelope.SOAP_ENC_ARRAY);
        detailsElement.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, ASYNC_DETAIL.getQualifiedName() + "[1]");
        Element idItem = detailsElement.addElement("item");
        idItem.addAttribute(XMLHelper.XSI_TYPE, ASYNC_DETAIL_EVENT_ID.getQualifiedName());
        Element eventIdElement = idItem.addElement("eventID");
        eventIdElement.addAttribute(XMLHelper.XSI_TYPE, BIBusEnvelope.XSD_STRING);
        eventIdElement.setText(id);
    }
}

