/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.Credential;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.MonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.MonitorServiceSpecification;
import com.cognos.developer.schemas.bibus._3.MonitorService_PortType;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.jsmcommon.api.APIException;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.serverinst.SDSInstanceManager;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.AttachmentException;
import com.cognos.jsmcommon.soap.client.AttachmentFactory;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.service.ServiceImplBase;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.CommonHistoryHelper;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.RunOptionsInformation;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.TrackingThreadProperties;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.IMonitorService;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.api.Monitorable;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.impl.MonitorableSpecification;
import com.cognos.monitor.impl.state.HistoryRecord;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.paging.IPager;
import com.cognos.monitor.paging.MonitorServicePager;
import com.cognos.monitor.paging.PagingException;
import com.cognos.monitor.tse.ITSE;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.WriteFinalHistoryService;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.EventIdUtil;
import com.cognos.sds.event.IEventId;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public class MonitorServiceBinding
extends ServiceImplBase
implements MonitorService_PortType {
    private IMonitorService m_service = MonitorService.instance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply background(AsynchRequest request) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        BiBusHeader header = this.extractBiBusHeader(true);
        TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
        JobBiBusHeaders headers = new JobBiBusHeaders();
        headers.setBiBusHeader(header, false);
        AsynchReply reply = new AsynchReply();
        try {
            Attachment[] attachments = this.getAttachments();
            IEventId id = this.getTSE().delegate(headers, attachments, request);
            EventIdUtil.addEventIDToReply(reply, id);
            reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        }
        catch (AttachmentException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Error retrieving the attachments on a backgrounded request.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            MonitorServiceException mse = new MonitorServiceException(I18NCode.MON_BACKGROUND_ERROR, e);
            this.throwAxisFault(new APIException((LocalizableException)((Object)mse)));
        }
        catch (TSEException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Error in TSE when backgrounding the request sent to the Monitor Service.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
            MonitorServiceException mse = new MonitorServiceException(I18NCode.MON_BACKGROUND_ERROR, e);
            this.throwAxisFault(new APIException((LocalizableException)((Object)mse)));
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Error when backgrounding the request sent to the Monitor Service.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(new APIException(e));
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AsynchRequest conversation) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            UserAccountUtil uau = new UserAccountUtil(headers);
            String userName = uau.getUserName();
            Object ctxObj = this.getContextObject();
            if (ctxObj != null && ctxObj instanceof TaskRunContext) {
                TaskRunContext context = (TaskRunContext)ctxObj;
                if (context.getTaskRecord() != null && context.getTaskRecord().getRunSpec() != null) {
                    context.getTaskRecord().getRunSpec().cancelledBy = userName;
                }
                TSE.getInstance().cancel((TaskRunContext)ctxObj);
            }
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Exception when cancelling task: " + e.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEvent(String eventID) throws RemoteException {
        BiBusHeader header = this.extractBiBusHeader();
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        this.authenticate(headers);
        UserAccountUtil uau = new UserAccountUtil(headers);
        String userName = uau.getUserName();
        try {
            if (eventID == null) {
                throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
            }
            if (eventID.startsWith("LOCAL:")) {
                eventID = eventID.substring(6);
                EventsResult result = new EventsResult();
                this.getServiceInstance().cancelLocalEvent(eventID, userName, result);
            } else {
                if (eventID.length() != 45) {
                    throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
                }
                Event event = new Event(EventStatus.CANCELLED, EventId.valueOf(eventID));
                this.getServiceInstance().cancelEvents(new Event[]{event}, userName);
            }
        }
        catch (SDSServiceException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Exception when cancelling task: " + ex.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            this.throwAxisFault(new APIException((LocalizableException)((Object)ex)));
        }
        finally {
            ThreadProperties.clear();
        }
    }

    public void resetService() throws RemoteException {
        BiBusHeader header = this.extractBiBusHeader();
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        this.authenticate(headers);
        try {
            if (!AuthenticatorFactory.getInstance().hasCapability(header, UserCapabilityEnum.canUseMonitorActivityTool)) {
                return;
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Exception when reseting service: " + e.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
        MonitorService.instance().stop(true);
        WriteFinalHistoryService.getInstance().testReset(true);
        SDSInstanceManager.getInstance().testStop();
        MonitorService.instance().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release(AsynchRequest conversation) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        if (conversation == null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_INVALID_REQUEST);
            this.throwAxisFault(new APIException((LocalizableException)((Object)new MonitorServiceException(MonitorI18NCode.MSG_MS_INVALID_REQUEST))));
        }
        BiBusHeader biBusHeader = this.extractBiBusHeader();
        TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)biBusHeader);
        JobBiBusHeaders headers = new JobBiBusHeaders(biBusHeader);
        this.authenticate(headers);
        SearchPathSingleObject spsoBaseClass = conversation.getObjectPath();
        AsynchSpecification[] specifications = conversation.getSpecification();
        try {
            if (specifications != null && specifications.length == 1 && specifications[0] instanceof MonitorServiceSpecification) {
                this.releaseContext();
                return;
            }
            if (spsoBaseClass == null) return;
            ServiceAPI service = null;
            ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(headers);
            cmPort.setLogCategory(MonitorCategory.RUNTIME);
            try {
                BaseClass baseClass = ObjectModelUtil.getBaseClass((ContentManagerServiceClientPort)cmPort, (SearchPathSingleObject)spsoBaseClass, (PropEnum[])ObjectModelUtil.PERMISSSION_PROPS);
                service = Client.instance().getServiceAPI(headers, baseClass);
                service.release(conversation);
                return;
            }
            catch (LocalizableException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
                this.throwAxisFault(new APIException(e));
                return;
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
                throw AxisFault.makeFault((Exception)((Object)e));
                catch (Throwable e2) {
                    String message = this.getThrowableMessage(e2);
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e2);
                    throw new AxisFault(message);
                }
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
                if (service != null) {
                    service.close();
                }
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply run(SearchPathSingleObject searchPath, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        BiBusHeader header = this.extractBiBusHeader();
        TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
        AsynchReply reply = null;
        RunOptionsInformation roi = new RunOptionsInformation(options);
        try {
            Message currentMessage = MessageContext.getCurrentContext().getRequestMessage();
            Attachment[] attachments = AttachmentFactory.getAttachments((Message)currentMessage);
            CAM cam = header.getCAM();
            if (cam != null && cam.getAction() != null && cam.getAction().equals("logonAs")) {
                this.isTrustedRequest();
            }
            header.setCAF(null);
            header.setDispatcherTransportVars(null);
            String parent = roi.getParentHistoryEventID();
            BiBusRunSpec runSpec = new BiBusRunSpec(header);
            runSpec.searchPath = searchPath.get_value();
            runSpec.options = options;
            runSpec.priority = (byte)roi.getPriority();
            runSpec.parameters = params;
            runSpec.attachments = attachments;
            try {
                runSpec.tenantID = AuthenticatorFactory.getInstance().getTenantID(header);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
                this.throwFault((Exception)((Object)e));
            }
            try {
                TSE.getInstance().authenticateHeader((BiBusSpec)runSpec, roi.getParentHistoryEventID() == null);
            }
            catch (EMFSecurityException e) {
                this.writeFailedHistory((Exception)((Object)e), searchPath, parent, header);
            }
            catch (RemoteException e) {
                this.writeFailedHistory(e, searchPath, parent, header);
            }
            catch (LocalizableException e) {
                this.writeFailedHistory((Exception)((Object)e), searchPath, parent, header);
            }
            reply = roi.getRestartHistoryPath() == null || "".equals(roi.getRestartHistoryPath().trim()) ? this.doRun(runSpec, roi) : this.doRestart(roi, header);
            perf.setLogData(EventIdUtil.getEventIDFromReply(reply).toXMLString());
            this.debugWait("primary.wait.ms");
        }
        catch (RemoteException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
            this.throwFault(e);
        }
        catch (TaskPersistLayerException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            this.writeFailedHistory((Exception)((Object)e), searchPath, roi.getParentHistoryEventID(), header);
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(e);
        }
        catch (TSEException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
            this.writeFailedHistory(e, searchPath, roi.getParentHistoryEventID(), header);
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    private AsynchReply doRun(BiBusRunSpec runSpec, RunOptionsInformation roi) throws TSEException, TaskPersistLayerException, LocalizableException {
        String parent = roi.getParentHistoryEventID();
        AsynchReply reply = null;
        SequenceSpec[] spec = new SequenceSpec[]{new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)runSpec)};
        TaskID parentID = parent != null && TaskID.isTSEID((String)parent) ? TaskID.fromEventId((String)parent) : null;
        TaskPersistLayer.TaskRecords records = TaskPersistLayer.getInstance().addTasks(parentID, spec, roi.isBackground());
        TaskRecord task = records.taskRecord;
        TaskStateRecord state = records.taskStateRecord;
        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("created task Record for " + runSpec.searchPath + " with priority: " + runSpec.priority + " with request time " + new Date(task.getTimeStamp()).toString());
        TaskRunContext context = TaskRunContextFactory.createTaskRunContext(task, state);
        if (roi.isBackground()) {
            reply = new AsynchReply();
            reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
            TSE.getInstance().setTaskAsReady(context);
        } else {
            this.setContextObject(context);
            reply = (AsynchReply)TSE.getInstance().runTaskImmediate(context);
        }
        EventIdUtil.addEventIDToReply(reply, TSE.getInstance().getEventId(task.getTaskId()));
        return reply;
    }

    private TaskRecord getRestartRecord(String restartPath, BiBusHeader userHeader) throws Exception {
        TaskRecord restarter = null;
        String eventId = ObjectModelUtil.findEventIdFromHistoryPath((String)restartPath);
        if (eventId != null) {
            restarter = TaskPersistLayer.getTaskFromEventId((String)eventId);
        }
        if (restarter == null) {
            History restartHistory = CommonHistoryHelper.getHistoryFromCM((String)restartPath, (BiBusHeader)userHeader);
            String string = eventId = restartHistory.getEventID() == null ? null : restartHistory.getEventID().getValue();
            if (eventId != null) {
                restarter = TaskPersistLayer.getTaskFromEventId((String)eventId);
            }
        }
        if (restarter == null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED_NO_RECORD);
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED_NO_HISTORY, new Object[]{restartPath});
        }
        return restarter;
    }

    private TaskID[] getRestartSkipIds(String[] restartSkips, BiBusHeader userHeader) throws Exception {
        TaskID[] skippies = new TaskID[restartSkips.length];
        for (int i = 0; i < restartSkips.length; ++i) {
            String eventId = ObjectModelUtil.findEventIdFromHistoryPath((String)restartSkips[i]);
            if (eventId == null) {
                History restartHistory = CommonHistoryHelper.getHistoryFromCM((String)restartSkips[i], (BiBusHeader)userHeader);
                String string = eventId = restartHistory.getEventID() == null ? null : restartHistory.getEventID().getValue();
            }
            if (eventId == null) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED_NO_HISTORY);
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED_NO_HISTORY, new Object[]{eventId});
            }
            skippies[i] = TaskID.fromEventId((String)eventId);
        }
        return skippies;
    }

    private AsynchReply doRestart(RunOptionsInformation roi, BiBusHeader userHeader) throws TSEException, TaskPersistLayerException, LocalizableException, AxisFault {
        AsynchReply reply = null;
        TaskRecord restarter = null;
        TaskID[] skippies = null;
        try {
            restarter = this.getRestartRecord(roi.getRestartHistoryPath(), userHeader);
            skippies = this.getRestartSkipIds(roi.getSkipHistoryPaths(), userHeader);
        }
        catch (Exception e) {
            TSE.logException(e);
            TSE.throwException(e);
        }
        TaskStateRecord record = TaskStateRecord.findRecord((TaskID)restarter.getTaskId());
        if (!record.status.canRestart(true)) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED_BAD_STATUS);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("The TSE record found " + restarter.toString() + " has a status that cannot restart");
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED_BAD_STATUS, new Object[]{roi.getRestartHistoryPath()});
        }
        this.checkRestartPermission(userHeader, restarter, roi);
        boolean usePassport = !this.checkCredential(userHeader, restarter, roi);
        TaskID newEventId = TaskID.create();
        TSE.getInstance().restartTask(record, skippies, newEventId, (BiBusHeader)(usePassport ? userHeader : null));
        reply = new AsynchReply();
        reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
        EventIdUtil.addEventIDToReply(reply, EventId.valueOf(newEventId.toEventId()));
        return reply;
    }

    private void checkRestartPermission(BiBusHeader userHeader, TaskRecord restarter, RunOptionsInformation roi) throws TSEException, MonitorServiceException, SDKClientException {
        boolean hasPermission;
        SearchPathSingleObject runnablePath = ObjectModelUtil.getSearchPathFromGuid((String)restarter.getTaskStoreId());
        boolean isOwner = false;
        try {
            isOwner = AuthenticatorFactory.getInstance().isOwner(userHeader, runnablePath, true);
        }
        catch (EMFSecurityException e) {
            TSE.logException(e);
            TSE.throwException((Exception)((Object)e));
        }
        boolean bl = hasPermission = isOwner || this.hasRestartPermission(runnablePath, userHeader);
        if (!hasPermission) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_RESTART_TASK_PERMISSION);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("The current user does not have permission to restart " + roi.getRestartHistoryPath());
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_PERMISSION, new Object[]{roi.getRestartHistoryPath()});
        }
    }

    private boolean checkCredential(BiBusHeader userHeader, TaskRecord restarter, RunOptionsInformation roi) throws MonitorServiceException {
        BiBusHeader header = new BiBusHeader();
        Tracking tracking = new Tracking();
        header.setTracking(tracking);
        ContentManagerServiceClientPort conMan = Client.instance().getContentManagerServiceClient(new JobBiBusHeaders(header));
        try {
            conMan.signNextRequest("JSM", false);
            BaseClass[] credential = conMan.query(new SearchPathMultipleObject(restarter.getAccountPath() + "/credential"), new PropEnum[]{PropEnum.searchPath, PropEnum.userName}, new Sort[0], new QueryOptions());
            if (credential != null && credential.length > 0 && credential[0] instanceof Credential) {
                boolean bl = true;
                return bl;
            }
            conMan.signNextRequest("JSM", false);
            BaseClass[] account = conMan.query(new SearchPathMultipleObject(restarter.getAccountPath()), new PropEnum[]{PropEnum.userName, PropEnum.defaultName, PropEnum.searchPath, PropEnum.email, PropEnum.givenName, PropEnum.surname, PropEnum.parent, PropEnum.storeID}, new Sort[0], new QueryOptions());
            if (account.length == 0) {
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_MISSING_CREDENTIAL, new Object[]{roi.getRestartHistoryPath(), restarter.getAccountPath()});
            }
            UserAccountUtil userAccount = new UserAccountUtil(new JobBiBusHeaders(userHeader));
            UserAccountUtil restarterAccount = new UserAccountUtil((Account)account[0]);
            if (userAccount.equals(restarterAccount)) {
                boolean bl = false;
                return bl;
            }
            try {
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_MISSING_CREDENTIAL, new Object[]{roi.getRestartHistoryPath(), restarterAccount.getUserName()});
            }
            catch (SDKClientException se) {
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_PERMISSION, new Object[]{roi.getRestartHistoryPath()});
            }
            catch (EMFSecurityException ce) {
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_RESTART_TASK_PERMISSION, new Object[]{roi.getRestartHistoryPath()});
            }
        }
        finally {
            if (conMan != null) {
                conMan.close();
            }
        }
    }

    private boolean hasRestartPermission(SearchPathSingleObject spso, BiBusHeader userHeader) {
        boolean hasPermission = false;
        try {
            if (spso != null && spso.get_value() != null) {
                hasPermission = AuthenticatorFactory.getInstance().hasPermissions(userHeader, spso, new String[]{"read"}, true);
                hasPermission = hasPermission && AuthenticatorFactory.getInstance().hasCapability(userHeader, UserCapabilityEnum.canUseMonitorActivityTool);
            }
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_RESTART_TASK_FAILED, (Object[])new String[]{t.getMessage()});
        }
        return hasPermission;
    }

    private void throwFault(Exception e) throws AxisFault {
        if (e instanceof LocalizableException) {
            this.throwAxisFault((LocalizableException)((Object)e));
        } else if (e instanceof APIException) {
            this.throwAxisFault((APIException)((Object)e));
        } else {
            if (e instanceof AxisFault) {
                throw (AxisFault)e;
            }
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private void writeFailedHistory(Exception e, SearchPathSingleObject searchPath, String parentId, BiBusHeader header) throws AxisFault {
        BiBusHeader newHeader = new BiBusHeader();
        newHeader.setTracking(header.getTracking());
        newHeader.setHdrSession(header.getHdrSession());
        newHeader.setRouting(header.getRouting());
        newHeader.setUserPreferenceVars(header.getUserPreferenceVars());
        IEventId id = EventIdUtil.createEventId();
        HistoryRecord history = new HistoryRecord(searchPath, parentId, new JobBiBusHeaders(newHeader));
        history.setUseTrusted(true);
        ThreadProperties.setProperty((String)"asynchDetailEventID", (String)id.toXMLString());
        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{e.getMessage()});
        try {
            history.create(id, EventStatus.FAILED);
            history.update(EventStatus.FAILED);
            history.addErrorDetail(I18NCode.GEN_3RD_PARTY_FAULT, new String[]{e.getMessage()});
        }
        catch (RecordableException e1) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[RecordableException] Error when updating the history after failed log on:" + e1.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, MonitorI18NCode.MSG_MS_GENERAL_ERROR, (Object[])new String[]{e1.getMessage()});
        }
        this.logFailedRunToIPF(searchPath, e);
        this.throwFault(e);
    }

    public AsynchReply runSpecification(AsynchSpecification specification, ParameterValue[] params, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        BiBusHeader header = this.extractBiBusHeader();
        TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
        JobBiBusHeaders jobHdr = new JobBiBusHeaders(header);
        boolean faulted = false;
        AsynchReply reply = null;
        boolean doLogon = false;
        CAM cam = header.getCAM();
        try {
            if (cam != null && cam.getAction() != null && cam.getAction().equals("logonAs")) {
                this.isTrustedRequest();
                this.getAuthenticator().logon(jobHdr);
                doLogon = true;
            } else {
                this.authenticate(jobHdr);
            }
            if (specification instanceof MonitorServiceSpecification) {
                AsynchRequest asyncRequest = new AsynchRequest();
                asyncRequest.setSpecification(new AsynchSpecification[]{specification});
                asyncRequest.setOptions(options);
                asyncRequest.setParameters(params);
                IPager pagerController = this.getPager(jobHdr);
                this.setContextObject(pagerController);
                pagerController.runSpecification(asyncRequest);
                reply = pagerController.currentPage(asyncRequest);
                this.m_service.getMonitorContextMap().updateContext(this.getServiceContext().getAsyncContext(), reply);
                this.debugWait("primary.wait.ms");
            } else {
                RunOptionsInformation roi = new RunOptionsInformation(options);
                if (roi.getParentHistoryEventID() == null) {
                    this.getAuthenticator().clonePassport(jobHdr);
                }
                Attachment[] attachments = this.getAttachments();
                Monitorable monitorable = this.getMonitorableSpec(specification, params, options, attachments, jobHdr);
                monitorable.setDoLogOff(doLogon);
                this.setContextObject(monitorable);
                reply = this.getServiceInstance().add(monitorable);
                this.debugWait("primary.wait.ms");
            }
        }
        catch (AttachmentException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Error reading that attachments from the message.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            this.throwAxisFault(new APIException((LocalizableException)((Object)e)));
        }
        catch (LocalizableException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(new APIException(e));
        }
        catch (EMFSecurityException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)e);
            throw AxisFault.makeFault((Exception)((Object)e));
        }
        catch (Throwable e) {
            faulted = true;
            String message = this.getThrowableMessage(e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug(message);
            if (e instanceof AxisFault) {
                throw (AxisFault)e;
            }
            throw new AxisFault(message);
        }
        finally {
            if (faulted) {
                this.releaseContext();
            }
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    protected void releaseContext() {
        Object ctxObj = this.getContextObject();
        if (ctxObj != null && ctxObj instanceof IPager) {
            ((IPager)ctxObj).release();
        }
        this.m_service.getMonitorContextMap().removeContext(this.getServiceContext().getAsyncContext());
    }

    public AsynchReply wait(AsynchRequest conversation, ParameterValue[] parameterValues, Option[] options) throws RemoteException {
        String errorMessage = "A 'wait' request was recieved out of context. (The monitorService uses the async toolkit, and expects a wait request to be associated with a current conversation)";
        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(errorMessage);
        throw new AxisFault(errorMessage);
    }

    private String getThrowableMessage(Throwable ex) {
        String message = ex.getMessage();
        if (message == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ex.printStackTrace(ps);
            ps.flush();
            String trace = baos.toString();
            message = ex.getClass().getName() + trace;
        }
        return message;
    }

    private void logFailedRunToIPF(SearchPathSingleObject searchPath, Exception ex) {
        String path = searchPath != null ? searchPath.get_value() : "null";
        ContentManagerServiceClientPort port = null;
        try {
            JobBiBusHeaders header = new JobBiBusHeaders(new BiBusHeader());
            port = Client.instance().getContentManagerServiceClient(header);
            port.setLogCategory(MonitorCategory.RUNTIME);
            port.signNextRequest("JSM");
            QueryRequest request = new QueryRequest();
            request.setSearch(path);
            request.setProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.objectClass});
            BaseClass result = port.query(request);
            path = result.getSearchPath() != null ? result.getSearchPath().getValue() : path;
            String type = result.getObjectClass() != null ? result.getObjectClass().getValue().getValue() : "baseClass";
            String first = type.substring(0, 1);
            String rest = type.substring(1, type.length());
            first = first.toUpperCase();
            type = first + rest;
            AuditProperties auditProps = new AuditProperties("Run", path, type, "Failure");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{ex.getMessage()}, (Map)auditProps);
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("[SDKClientException] Error retrieving task information before writing failed IPF audit log. " + e.getMessage());
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("[EMFSecurityException] Error retrieving task information before writing failed IPF audit log. " + e.getMessage());
        }
    }

    public AsynchReply currentPage(AsynchRequest request, ParameterValue[] parameters, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        boolean faulted = false;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            this.m_service.getMonitorContextMap().removeContext(this.getServiceContext().getAsyncContext());
            Object ctxObj = this.getContextObject();
            if (ctxObj == null) {
                ctxObj = this.rebuildContextObject(headers, request);
            }
            reply = ((IPager)ctxObj).currentPage(request);
            this.m_service.getMonitorContextMap().updateContext(this.getServiceContext().getAsyncContext(), reply);
            this.debugWait("primary.wait.ms");
        }
        catch (LocalizableException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(e);
        }
        catch (Throwable e) {
            faulted = true;
            String message = this.getThrowableMessage(e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug(message);
            throw new AxisFault(message);
        }
        finally {
            if (faulted) {
                this.releaseContext();
            }
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    public AsynchReply firstPage(AsynchRequest request, ParameterValue[] parameters, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        boolean faulted = false;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            this.m_service.getMonitorContextMap().removeContext(this.getServiceContext().getAsyncContext());
            Object ctxObj = this.getContextObject();
            if (ctxObj == null) {
                ctxObj = this.rebuildContextObject(headers, request);
            }
            reply = ((IPager)ctxObj).firstPage(request);
            this.m_service.getMonitorContextMap().updateContext(this.getServiceContext().getAsyncContext(), reply);
            this.debugWait("primary.wait.ms");
        }
        catch (LocalizableException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(e);
        }
        catch (Throwable e) {
            faulted = true;
            String message = this.getThrowableMessage(e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug(message);
            throw new AxisFault(message);
        }
        finally {
            if (faulted) {
                this.releaseContext();
            }
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    public AsynchReply lastPage(AsynchRequest request, ParameterValue[] parameters, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        boolean faulted = false;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            this.m_service.getMonitorContextMap().removeContext(this.getServiceContext().getAsyncContext());
            Object ctxObj = this.getContextObject();
            if (ctxObj == null) {
                ctxObj = this.rebuildContextObject(headers, request);
            }
            reply = ((IPager)ctxObj).lastPage(request);
            this.m_service.getMonitorContextMap().updateContext(this.getServiceContext().getAsyncContext(), reply);
            this.debugWait("primary.wait.ms");
        }
        catch (LocalizableException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(e);
        }
        catch (Throwable e) {
            faulted = true;
            String message = this.getThrowableMessage(e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug(message);
            throw new AxisFault(message);
        }
        finally {
            if (faulted) {
                this.releaseContext();
            }
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    public AsynchReply nextPage(AsynchRequest request, ParameterValue[] parameters, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        boolean faulted = false;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            this.m_service.getMonitorContextMap().removeContext(this.getServiceContext().getAsyncContext());
            Object ctxObj = this.getContextObject();
            if (ctxObj == null) {
                ctxObj = this.rebuildContextObject(headers, request);
            }
            reply = ((IPager)ctxObj).nextPage(request);
            this.m_service.getMonitorContextMap().updateContext(this.getServiceContext().getAsyncContext(), reply);
            this.debugWait("primary.wait.ms");
        }
        catch (LocalizableException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(e);
        }
        catch (Throwable e) {
            faulted = true;
            String message = this.getThrowableMessage(e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug(message);
            throw new AxisFault(message);
        }
        finally {
            if (faulted) {
                this.releaseContext();
            }
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    public AsynchReply previousPage(AsynchRequest request, ParameterValue[] parameters, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        AsynchReply reply = null;
        boolean faulted = false;
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            this.m_service.getMonitorContextMap().removeContext(this.getServiceContext().getAsyncContext());
            Object ctxObj = this.getContextObject();
            if (ctxObj == null) {
                ctxObj = this.rebuildContextObject(headers, request);
            }
            reply = ((IPager)ctxObj).previousPage(request);
            this.m_service.getMonitorContextMap().updateContext(this.getServiceContext().getAsyncContext(), reply);
            this.debugWait("primary.wait.ms");
        }
        catch (LocalizableException e) {
            faulted = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            this.throwAxisFault(e);
        }
        catch (Throwable e) {
            faulted = true;
            String message = this.getThrowableMessage(e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, e);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug(message);
            throw new AxisFault(message);
        }
        finally {
            if (faulted) {
                this.releaseContext();
            }
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsynchReply add(String eventID, BaseClass[] classes, ParameterValue[] pv, Option[] options) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER", eventID);
        AsynchReply reply = null;
        BiBusHeader header = this.extractBiBusHeader();
        TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
        JobBiBusHeaders headers = new JobBiBusHeaders(header);
        this.authenticate(headers);
        try {
            IMonitorService service = this.getServiceInstance();
            reply = service.addDetail(eventID, classes, options, headers);
        }
        catch (MonitorServiceException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            this.throwAxisFault(new APIException((LocalizableException)((Object)ex)));
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(MonitorServiceEventID id, String status) throws RemoteException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.ERROR, "ENTER");
        try {
            BiBusHeader header = this.extractBiBusHeader();
            TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)header);
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            try {
                this.isTrustedRequest();
            }
            catch (AxisFault af) {
                this.authenticate(headers);
            }
            try {
                IMonitorService service = this.getServiceInstance();
                service.notify(id, status, headers);
            }
            catch (MonitorServiceException ex) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
                this.throwAxisFault(new APIException((LocalizableException)((Object)ex)));
            }
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public String getProperty(String name) throws RemoteException {
        String value = null;
        try {
            BiBusHeader header = BiBusUtilities.extractBiBusHeader();
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            this.authenticate(headers);
            if (!AuthenticatorFactory.getInstance().hasCapability(header, UserCapabilityEnum.canUsePortalAdministrationTool)) {
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_INVALID_REQUEST);
            }
            value = CRNProperties.getInstance().getProperty(name);
        }
        catch (LocalizableException e) {
            throw AxisFault.makeFault((Exception)((Object)e));
        }
        catch (EMFSecurityException e) {
            throw AxisFault.makeFault((Exception)((Object)e));
        }
        return value;
    }

    private Object rebuildContextObject(JobBiBusHeaders headers, AsynchRequest request) throws PagingException {
        IPager pagerController = this.getPager(headers);
        this.setContextObject(pagerController);
        pagerController.runSpecification(request);
        return pagerController;
    }

    protected IMonitorService getServiceInstance() {
        return this.m_service;
    }

    protected ITSE getTSE() {
        return TSE.getInstance();
    }

    protected IPager getPager(JobBiBusHeaders headers) {
        return new MonitorServicePager(headers);
    }

    protected Monitorable getMonitorableSpec(AsynchSpecification specification, ParameterValue[] parameters, Option[] options, Attachment[] attachments, JobBiBusHeaders header) throws RemoteException, SDSServiceException {
        return new MonitorableSpecification(specification, parameters, options, attachments, header);
    }
}

