/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor;

import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.service.ServiceProperties;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.monitor.MonitorAsyncService;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.MonitorConfiguration;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.tse.api.CreateTSERequestHandler;
import com.cognos.monitor.tse.api.RetrieveTSERequestHandler;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class MonitorServiceHandler
extends BasicHandler
implements Asyncable {
    protected static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(MonitorService.class.getName());
    private static final String MONITOR_OPTION_BOOLEAN_XPATH = "//*[local-name()='run']/*[local-name()='options']/*[contains(@type,'monitorOptionBoolean')]";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String BACKGROUND = "background";
    private static final String NOASYNC = "noasync";
    private static final String TRUE = "true";
    private static final String CANCEL_EVENT = "cancelEvent";
    private static final String RESET_SERVICE = "resetService";
    private static final String GET_PROPERTY = "getProperty";
    private static final String NOTIFY = "notify";
    private static final String CREATE_TSE_REQUEST = "createTSERequest";
    private static final String RESPONSE_NAME = "response";
    public static final Namespace NS_TSE = Namespace.get((String)"tse", (String)"http://www.ibm.com/xmlns/prod/cognos/internal/tse");
    public static final QName CREATE_TSE_QNAME = new QName("createTSERequest", NS_TSE);
    public static final QName TSE_FAULT = new QName("TSEFault", NS_TSE);
    public static final QName TSE_MESSAGE = new QName("message", NS_TSE);
    public static final QName TSE_TRACE = new QName("trace", NS_TSE);
    public static final QName RETRIEVE_TSE_QNAME = new QName("retrieveTSERequest", NS_TSE);
    private PogoEngine engine = null;
    private boolean m_suspended = false;
    private boolean m_isHistoryEnabled = true;

    public MonitorServiceHandler() {
        super(null);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        ServiceProperties monitorServiceProperties = null;
        try {
            monitorServiceProperties = new ServiceProperties(this.getConfig());
            String isHistoryEnabledStr = monitorServiceProperties.getProperty("isHistoryEnabled");
            if (null != isHistoryEnabledStr) {
                this.m_isHistoryEnabled = Boolean.getBoolean(isHistoryEnabledStr);
            }
        }
        catch (Exception x) {
            logger.error("Jaxen/XPath problem", (Throwable)x);
            throw new PogoException("Handler config problem");
        }
        MonitorService.createInstance(this.m_isHistoryEnabled).compose_impl();
        CRNProperties.serviceNames.setServiceName(CRNProperties.ServiceNames.ServiceKey.MONITOR, this.getName());
    }

    private boolean doAsync(BIBusEnvelope biBusEnv) {
        String method;
        Iterator children;
        boolean async = true;
        Element body = biBusEnv.getBody();
        List l = body.selectNodes(MONITOR_OPTION_BOOLEAN_XPATH);
        if (l != null) {
            for (Element mob : l) {
                Element nameElement = mob.element(NAME);
                Element valueElement = mob.element(VALUE);
                if (nameElement == null || valueElement == null) continue;
                String name = nameElement.getText();
                String value = valueElement.getText();
                if (name == null || value == null) continue;
                if (name.equals(BACKGROUND) && value.equals(TRUE)) {
                    async = false;
                }
                if (!name.equals(NOASYNC) || !value.equals(TRUE)) continue;
                async = false;
            }
        }
        if ((children = body.elementIterator()).hasNext() && (method = ((Element)children.next()).getName()) != null && (method.equals(CANCEL_EVENT) || method.equals(RESET_SERVICE) || method.equals(GET_PROPERTY) || method.equals(NOTIFY) || method.equals(CREATE_TSE_REQUEST))) {
            async = false;
        }
        return async;
    }

    public AsyncService getAsyncRequest(MessageContext context) {
        BIBusEnvelope biBusEnv = (BIBusEnvelope)context.getProperty("request.envelope");
        if (!this.doAsync(biBusEnv) || this.isSuspended()) {
            return null;
        }
        return new MonitorAsyncService(this, context);
    }

    public void configure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        CRNProperties cclConfig = CRNProperties.getInstance();
        cclConfig.init(configuration.getICCLConfiguration(), this.getName());
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
        MonitorService.createInstance(this.m_isHistoryEnabled).configure(configuration);
        perf.stop();
    }

    public void dispose() {
    }

    public void initialize() {
        try {
            Handler h = this.engine.getHandlerPool().find("monitorService.asvReporter");
            if (h != null && h instanceof SimpleRequestReportingHandler) {
                SimpleRequestReportingHandler srrh = (SimpleRequestReportingHandler)h;
                srrh.getRequestReporter();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MonitorService.instance().initialize(null);
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        Element operationElement;
        if (this.isSuspended()) {
            mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
            return;
        }
        BIBusEnvelope request_envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element body = request_envelope.getBody();
        if (body != null && (operationElement = (Element)body.selectSingleNode("./*")) != null) {
            if (operationElement.getQName().equals((Object)CREATE_TSE_QNAME)) {
                CreateTSERequestHandler requestHandler = new CreateTSERequestHandler(mc);
                try {
                    Element responseElement = requestHandler.process();
                    BIBusEnvelope response = this.buildBiBusResponse(request_envelope, responseElement);
                    this.buildResponse(mc, response);
                }
                catch (Throwable e) {
                    this.generateFaultResponse(mc, e);
                }
            } else if (operationElement.getQName().equals((Object)RETRIEVE_TSE_QNAME)) {
                RetrieveTSERequestHandler requestHandler = new RetrieveTSERequestHandler(mc);
                try {
                    Element responseElement = requestHandler.process();
                    BIBusEnvelope response = this.buildBiBusResponse(request_envelope, responseElement);
                    this.buildResponse(mc, response);
                }
                catch (Exception e) {
                    throw new PogoException("unexpected exception", e);
                }
            } else {
                this.handleRPCMessage(mc);
            }
        }
    }

    private void buildResponse(MessageContext mc, BIBusEnvelope response) throws Exception {
        if (response == null) {
            throw new IllegalStateException("null response");
        }
        this.fillMCSoapResponse(mc, response);
    }

    protected BIBusEnvelope buildBiBusResponse(BIBusEnvelope requestEnvelope, Element responseElement) {
        Element ffVars;
        Element responseHeader = requestEnvelope.getHeader().createCopy();
        Element envVars = responseHeader.element(BIBusEnvelope.BUS_ENVIRONMENT_VARS);
        if (envVars != null) {
            envVars.detach();
        }
        if ((ffVars = responseHeader.element(BIBusEnvelope.BUS_FORM_FIELD_VARS)) != null) {
            ffVars.detach();
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope(responseHeader);
        responseEnvelope.getBody().add(responseElement);
        return responseEnvelope;
    }

    private void generateFaultResponse(MessageContext mc, Throwable e) {
        BIBusEnvelope request = (BIBusEnvelope)mc.getProperty("request.envelope");
        String sessionID = request != null ? request.getPassportID() : null;
        String requestID = request != null ? request.getTrackingRequestContext() : null;
        BIBusEnvelope faultResponse = this.generateFault(e, mc);
        this.fillMCSoapResponse(mc, faultResponse);
    }

    private BIBusEnvelope generateFault(Throwable e, MessageContext mc) {
        Locale locale = (Locale)mc.getProperty("locale");
        if (locale == null) {
            locale = new Locale("en");
        }
        BIBusEnvelope responseEnvelope = this.buildResponseEnvelopeStub(mc);
        Element faultElement = responseEnvelope.createFaultElement("Fault", "Fault");
        Element detail = responseEnvelope.getFaultDetail();
        this.generateDetails(e, detail, locale);
        return responseEnvelope;
    }

    public void generateDetails(Throwable e, Element detailsElement, Locale locale) {
        Element tseFault = detailsElement.addElement(TSE_FAULT);
        Element tseMessage = tseFault.addElement(TSE_MESSAGE);
        String messageText = e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage();
        tseMessage.setText(messageText);
        String trace = this.getTrace(e);
        if (trace != null) {
            Element traceElement = tseFault.addElement(TSE_TRACE);
            traceElement.setText(trace);
        }
    }

    public String getTrace(Throwable e) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pWriter = new PrintWriter(sWriter);
        Throwable t = e;
        do {
            t.printStackTrace(pWriter);
        } while ((t = t.getCause()) != null);
        return sWriter.toString();
    }

    private BIBusEnvelope buildResponseEnvelopeStub(MessageContext mc) {
        BIBusEnvelope responseEnvelope;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (requestEnvelope == null) {
            responseEnvelope = new BIBusEnvelope();
        } else {
            Element headerElement = requestEnvelope.getHeader();
            headerElement.detach();
            responseEnvelope = new BIBusEnvelope(headerElement);
        }
        Element camProtect = requestEnvelope.getCAMProtect();
        if (camProtect != null) {
            camProtect.detach();
        }
        return responseEnvelope;
    }

    private void fillMCSoapResponse(MessageContext mc, BIBusEnvelope responseEnvelope) {
        Element bigFault = responseEnvelope.getBody().element("Fault");
        Element littleFault = responseEnvelope.getBody().element("fault");
        mc.setResponseName(RESPONSE_NAME);
        mc.setProperty("response.envelope", (Object)responseEnvelope);
        if (bigFault != null || littleFault != null) {
            mc.setProperty("response.status_code", (Object)"500");
            mc.setProperty("response.status_msg", (Object)"Internal Server error");
        } else {
            mc.setProperty("response.status_code", (Object)"200");
            mc.setProperty("response.status_msg", (Object)"OK");
        }
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml");
        mc.setProperty("response.headers", (Object)headers);
        mc.setProperty("response.boundary", null);
        mc.setProperty("response.attachments", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRPCMessage(MessageContext mc) throws PogoException {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            AxisServiceHandler handler = AxisServiceHandler.getHandler((IServiceConfiguration)MonitorConfiguration.getInstance(), (MessageContext)mc);
            BIBusEnvelope biBusEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
            handler.setAsAsync(this.doAsync(biBusEnv));
            ThreadProperties.setProperty((String)"componentID", (String)"MS");
            String requestOp = BiBusUtilities.getOperation((BIBusEnvelope)biBusEnv);
            if (requestOp != null) {
                ThreadProperties.setProperty((String)"requestOperation", (String)requestOp);
            }
            handler.prepare();
            handler.execute();
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public void reconfigure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        this.configure(configuration);
        perf.stop();
    }

    public void resume() {
    }

    public void start() {
        PerfLog perf = null;
        try {
            perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
            this.setSuspended(false);
            MonitorService.instance().start();
            DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.NC);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).startService("MonitorService", "Success");
        }
        finally {
            if (perf != null) {
                perf.stop();
            }
        }
    }

    public void stop() {
        PerfLog perf = null;
        try {
            perf = SDSLogger.getLogger((SDSCategory)MonitorCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
            this.setSuspended(true);
            MonitorService.instance().stop(true);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).stopService("MonitorService", "Success");
        }
        finally {
            if (perf != null) {
                perf.stop();
            }
        }
    }

    public void suspend(boolean immediately) {
    }

    private synchronized void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private synchronized boolean isSuspended() {
        return this.m_suspended;
    }

    public void allServicesStarted() {
        MonitorService.instance().allServicesStarted();
    }
}

