/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.bursting;

import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRequestArguments;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.monitor.tse.historyHelp.HistoryAndDetails;
import com.cognos.monitor.tse.historyHelp.HistoryIterator;
import com.cognos.monitor.tse.historyHelp.HistoryListHelper;

public class BurstDistribution {
    public static final String PROPAGATE_ERRORS_TO_PARENT_TASK = "http://developer.cognos.com/ceba/constants/burstOptionEnum#propagateErrorsToParentTask";
    public static final String DISCARD_CHILD_HISTORY_DETAILS = "http://developer.cognos.com/ceba/constants/burstOptionEnum#discardChildHistoryDetails";
    private static final Option[] NO_OPTIONS = new Option[0];

    public boolean canDiscardChildHistoryDetails(BaseHistoryDetail[] historyDetails) {
        for (BaseHistoryDetail detail : historyDetails) {
            if (!this.canDiscardChildHistoryDetails(detail)) continue;
            return true;
        }
        return false;
    }

    private boolean canDiscardChildHistoryDetails(BaseHistoryDetail detail) {
        if (detail instanceof HistoryDetailRequestArguments) {
            for (Option option : this.getOptions((HistoryDetailRequestArguments)detail)) {
                if (!OptionUtils.isTrue((Option)option, (String)DISCARD_CHILD_HISTORY_DETAILS)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOptionToPropagateErrorsToParent(Option[] options) {
        if (options != null) {
            for (Option option : options) {
                if (!OptionUtils.isTrue((Option)option, (String)PROPAGATE_ERRORS_TO_PARENT_TASK)) continue;
                return true;
            }
        }
        return false;
    }

    public void propagateChildTaskErrorsToRootHistory(HistoryListHelper rootHistoryList, HistoryListHelper childHistoryList) {
        if (rootHistoryList != null && childHistoryList != null) {
            HistoryIterator it = childHistoryList.iterator();
            while (it.hasNext()) {
                this.propagateErrorsIfNeeded(it.next(), rootHistoryList, RootHandling.INCLUDE);
            }
        }
    }

    public void propagateChildTaskErrorsToNonRootParents(HistoryListHelper historyList) {
        if (historyList != null) {
            HistoryIterator it = historyList.iterator();
            while (it.hasNext()) {
                this.propagateErrorsIfNeeded(it.next(), historyList, RootHandling.SKIP);
            }
        }
    }

    private void propagateErrorsIfNeeded(HistoryAndDetails taskHistory, HistoryListHelper historyList, RootHandling rootHandling) {
        if (this.hasOptionToPropagateErrorsToParent(taskHistory)) {
            this.propagateErrorsToParent(taskHistory, historyList, rootHandling);
        }
    }

    private boolean hasOptionToPropagateErrorsToParent(HistoryAndDetails taskHistory) {
        Option[] options = this.getOptions(taskHistory);
        return this.hasOptionToPropagateErrorsToParent(options);
    }

    private void propagateErrorsToParent(HistoryAndDetails childHistory, HistoryListHelper historyList, RootHandling rootHandling) {
        HistoryAndDetails parentHistory = this.findParentHistory(childHistory, historyList, rootHandling);
        if (parentHistory != null) {
            for (BaseHistoryDetail detail : childHistory.getHistoryDetails()) {
                if (!(detail instanceof HistoryDetail)) continue;
                parentHistory.AddDetail(detail);
            }
        }
    }

    private HistoryAndDetails findParentHistory(HistoryAndDetails childHistory, HistoryListHelper historyList, RootHandling rootHandling) {
        String parentRunContext = this.getParentRunContext(childHistory);
        return parentRunContext != null ? this.findHistory(parentRunContext, historyList, rootHandling) : null;
    }

    private String getParentRunContext(HistoryAndDetails taskHistory) {
        for (Option option : this.getOptions(taskHistory)) {
            AsynchOptionStringArray aosa;
            if (!(option instanceof AsynchOptionStringArray) || !this.hasMultipleRunContexts(aosa = (AsynchOptionStringArray)option)) continue;
            return this.getFirstRunContext(aosa);
        }
        return null;
    }

    private boolean hasMultipleRunContexts(AsynchOptionStringArray aosa) {
        return aosa.getName() == AsynchOptionEnum.runContext && aosa.getValue().length > 1;
    }

    private String getFirstRunContext(AsynchOptionStringArray aosa) {
        return aosa.getValue()[0];
    }

    private Option[] getOptions(HistoryAndDetails taskHistory) {
        for (BaseHistoryDetail detail : taskHistory.getHistoryDetails()) {
            if (!(detail instanceof HistoryDetailRequestArguments)) continue;
            return this.getOptions((HistoryDetailRequestArguments)detail);
        }
        return NO_OPTIONS;
    }

    private Option[] getOptions(HistoryDetailRequestArguments requestArgs) {
        OptionArrayProp options = requestArgs.getOptions();
        return options != null ? options.getValue() : NO_OPTIONS;
    }

    private HistoryAndDetails findHistory(String parentRunContext, HistoryListHelper historyList, RootHandling rootHandling) {
        HistoryIterator it = historyList.iterator();
        if (rootHandling == RootHandling.SKIP) {
            it.next();
        }
        while (it.hasNext()) {
            HistoryAndDetails taskHistory = it.next();
            if (!parentRunContext.equals(this.getRunContext(taskHistory))) continue;
            return taskHistory;
        }
        return null;
    }

    private String getRunContext(HistoryAndDetails taskHistory) {
        for (Option option : this.getOptions(taskHistory)) {
            AsynchOptionStringArray aosa;
            if (!(option instanceof AsynchOptionStringArray) || !this.hasAnyRunContext(aosa = (AsynchOptionStringArray)option)) continue;
            return this.getLastRunContext(aosa);
        }
        return null;
    }

    private boolean hasAnyRunContext(AsynchOptionStringArray aosa) {
        return aosa.getName() == AsynchOptionEnum.runContext && aosa.getValue().length > 0;
    }

    private String getLastRunContext(AsynchOptionStringArray aosa) {
        String[] values = aosa.getValue();
        return values[values.length - 1];
    }

    private static enum RootHandling {
        SKIP,
        INCLUDE;

    }
}

