/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.capacity;

import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.Monitorable;
import com.cognos.monitor.capacity.Task;
import com.cognos.monitor.impl.MonitorableObject;
import com.cognos.monitor.tse.BiBusContext;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.TSE;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.IEventId;
import java.rmi.RemoteException;

public class MonitorableTask
implements Task {
    private Monitorable m_monitorable;
    BiBusContext m_runContext;

    public MonitorableTask(BiBusRunContext task) {
        System.out.println("Capacity: MonitorableTask()");
        SearchPathSingleObject sp = new SearchPathSingleObject();
        this.m_runContext = task;
        BiBusRunSpec spec = task.getBiBusRunSpec();
        sp.set_value(spec.searchPath);
        try {
            this.m_monitorable = new MonitorableObject(null, sp, spec.parameters, spec.options, null, null, false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cancel() throws LocalizableException {
        return this.m_monitorable.unconditionalCancel(this.m_monitorable.getId(), null);
    }

    @Override
    public boolean cancel(Object obj, String userName) throws LocalizableException {
        return this.m_monitorable.cancel((Event)obj, userName);
    }

    @Override
    public IEventId getId() throws LocalizableException {
        return this.m_monitorable.getId();
    }

    @Override
    public Object getTask() throws LocalizableException {
        return this.m_monitorable;
    }

    @Override
    public boolean release(Object obj, String userName) throws LocalizableException {
        return this.m_monitorable.release((Event)obj, userName);
    }

    @Override
    public Object run() {
        try {
            return this.m_monitorable.run();
        }
        catch (Throwable e) {
            String taskName = this.m_monitorable != null ? this.m_monitorable.toString() : "null";
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Failed to run task [" + taskName + "].  Error is: " + e.getLocalizedMessage()});
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug(e);
            TSE.trace(this.m_monitorable.getId() + "Failed to run task [" + taskName + "].  Error is: " + e.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public boolean suspend(Object obj, String userName) throws LocalizableException {
        return this.m_monitorable.suspend((Event)obj, userName);
    }

    @Override
    public void useSessionAffinity(boolean useSessionAffinity) throws LocalizableException {
    }
}

