/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.capacity;

import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.nminusone.TargetServiceInfo;
import com.cognos.jsmcommon.nminusone.TargetServiceInfoFactory;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.capacity.ITaskFactory;
import com.cognos.monitor.capacity.ResourceCapacityWorker;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.pogo.capacity.ServiceCapacity;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.capacity.ServiceCapacityMediator;
import com.cognos.pogo.capacity.ServiceCapacityObserver;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.IEventId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResourceCapacityManager
implements ServiceCapacityObserver {
    private Map m_resourceCapacityWorkers = Collections.synchronizedMap(new HashMap());
    private ITaskFactory m_taskFactory;
    private boolean started = false;
    private static final int DEFAULT_SESSION_AFFINITY_CAPACITY = 2;

    public ResourceCapacityManager(ITaskFactory taskFactory) {
        this.m_taskFactory = taskFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTask(IEventId id) throws LocalizableException {
        Object task = null;
        Map map = this.m_resourceCapacityWorkers;
        synchronized (map) {
            Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
            while (iter.hasNext() && task == null) {
                task = ((ResourceCapacityWorker)iter.next()).getTask(id);
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        if (!this.started) {
            Map map = this.m_resourceCapacityWorkers;
            synchronized (map) {
                Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
                while (iter.hasNext()) {
                    ((ResourceCapacityWorker)iter.next()).start();
                }
            }
            ServiceCapacityMediator mediator = ServiceCapacityMediator.getInstance();
            mediator.addObserver((ServiceCapacityObserver)this);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean immediately) {
        if (this.started) {
            ServiceCapacityMediator mediator = ServiceCapacityMediator.getInstance();
            mediator.removeObserver((ServiceCapacityObserver)this);
            Map map = this.m_resourceCapacityWorkers;
            synchronized (map) {
                Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
                while (iter.hasNext()) {
                    ((ResourceCapacityWorker)iter.next()).stop(immediately);
                }
            }
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws LocalizableException {
        Map map = this.m_resourceCapacityWorkers;
        synchronized (map) {
            Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
            while (iter.hasNext()) {
                ((ResourceCapacityWorker)iter.next()).cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Event event, String userName) throws LocalizableException {
        boolean cancelled = false;
        Map map = this.m_resourceCapacityWorkers;
        synchronized (map) {
            Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
            while (iter.hasNext() && !cancelled) {
                cancelled = ((ResourceCapacityWorker)iter.next()).cancel(event, userName);
            }
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Event event, String userName) throws LocalizableException {
        boolean released = false;
        Map map = this.m_resourceCapacityWorkers;
        synchronized (map) {
            Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
            while (iter.hasNext() && !released) {
                released = ((ResourceCapacityWorker)iter.next()).release(event, userName);
            }
        }
        return released;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspend(Event event, String userName) throws LocalizableException {
        boolean suspended = false;
        Map map = this.m_resourceCapacityWorkers;
        synchronized (map) {
            Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
            while (iter.hasNext() && !suspended) {
                suspended = ((ResourceCapacityWorker)iter.next()).suspend(event, userName);
            }
        }
        return suspended;
    }

    public void update(ServiceCapacity serviceCapacity) {
        if (null == serviceCapacity.serviceName) {
            this.debug("ResourceCapacityManager.update received blank serviceName update, probably a service is incorrectly configured.");
            throw new RuntimeException((Throwable)((Object)new MonitorServiceException(MonitorI18NCode.MSG_MS_BAD_SERVICE_NAME)));
        }
        this.update(serviceCapacity, false);
    }

    private void debug(String msg) {
        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Object)this, msg);
    }

    public synchronized void update(ServiceCapacity serviceCapacity, boolean useSessionAffinity) {
        String serviceName = serviceCapacity.serviceName;
        String serverGroup = serviceCapacity.serverGroup;
        String key = serviceName + serverGroup;
        ResourceCapacityWorker resourceCapacityWorker = (ResourceCapacityWorker)this.m_resourceCapacityWorkers.get(key);
        if (resourceCapacityWorker == null) {
            resourceCapacityWorker = new ResourceCapacityWorker(serviceName, serverGroup, this.m_taskFactory, useSessionAffinity);
            this.m_resourceCapacityWorkers.put(key, resourceCapacityWorker);
            if (this.started) {
                resourceCapacityWorker.start();
            }
        }
        resourceCapacityWorker.update(serviceCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() {
        block11: {
            try {
                String enableSessionAffinity = CRNProperties.getInstance().getProperty("enable.session.affinity");
                if (enableSessionAffinity == null || enableSessionAffinity.equalsIgnoreCase("true")) {
                    TargetServiceInfo[] tsi;
                    List defaultSessionAffinityServices = Client.instance().getSessionAffinityServices();
                    String targetServiceInfo = CRNProperties.getInstance().getProperty("session.affinity.services");
                    this.debug("ResourceCapacityManager User setting session.affinity.services=" + targetServiceInfo);
                    if (targetServiceInfo == null) {
                        targetServiceInfo = "serviceName=powerPlayService,numThreads=10;serviceName=dataIntegrationService,numThreads=10";
                        this.debug("ResourceCapacityManager TargetService not set so using default override for powerplay service and dataIntegrationService as session.affinity.services=" + targetServiceInfo);
                    }
                    if (targetServiceInfo != null && (tsi = TargetServiceInfoFactory.getTargetServiceInfo((String)targetServiceInfo)) != null && tsi.length > 0) {
                        for (int i = 0; i < tsi.length; ++i) {
                            String serviceName = tsi[i].getServiceName();
                            String serverGroup = tsi[i].getServerGroup();
                            int numThreads = tsi[i].getNumThreads();
                            ServiceCapacityConfiguration capacity = new ServiceCapacityConfiguration(serviceName, serverGroup, numThreads);
                            this.update((ServiceCapacity)capacity, true);
                            defaultSessionAffinityServices.remove(serviceName);
                        }
                    }
                    for (String serviceName : defaultSessionAffinityServices) {
                        ServiceCapacityConfiguration capacity = new ServiceCapacityConfiguration(serviceName, "", 2);
                        this.update((ServiceCapacity)capacity, true);
                    }
                    break block11;
                }
                Map map = this.m_resourceCapacityWorkers;
                synchronized (map) {
                    Iterator iter = this.m_resourceCapacityWorkers.values().iterator();
                    while (iter.hasNext()) {
                        ResourceCapacityWorker worker = (ResourceCapacityWorker)iter.next();
                        if (!worker.isSessionAffinity()) continue;
                        worker.stop(false);
                        iter.remove();
                    }
                }
            }
            catch (PropertiesException propertiesException) {
                // empty catch block
            }
        }
    }

    Map getResourceCapacityWorkers() {
        return this.m_resourceCapacityWorkers;
    }
}

