/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.capacity;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.ThreadFactoryImpl;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.capacity.ITaskFactory;
import com.cognos.monitor.capacity.Task;
import com.cognos.monitor.capacity.TaskSource;
import com.cognos.pogo.capacity.ServiceCapacity;
import com.cognos.pogo.capacity.ServiceCapacityChange;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.IEventId;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ResourceCapacityWorker {
    private static String m_traceString;
    private static String ALL;
    private static String EMPTY_STRING;
    private static String UNDEFINED;
    private int m_configuredCapacity = 0;
    private int m_interactiveCount = 0;
    private String m_serviceName;
    private String m_serverGroup;
    private TaskSource m_taskSource = null;
    private ITaskFactory m_taskRunnableFactory = null;
    private WorkRetrieverThread m_taskRetrieverThread;
    private List m_runningTasks = Collections.synchronizedList(new ArrayList());
    private boolean m_useSessionAffinity = false;
    private static final ExecutorService m_threadPool;

    public ResourceCapacityWorker(String serviceName, String serverGroup, ITaskFactory taskFactory) {
        this(serviceName, serverGroup, taskFactory, false);
    }

    public ResourceCapacityWorker(String serviceName, String serverGroup, ITaskFactory taskFactory, boolean useSessionAffinity) {
        this.m_serviceName = serviceName;
        this.m_serverGroup = serverGroup;
        this.m_taskSource = taskFactory.getTaskSource();
        this.m_taskRunnableFactory = taskFactory;
        this.m_useSessionAffinity = useSessionAffinity;
        m_traceString = System.getProperty("com.cognos.monitor.capacity.trace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTask(IEventId id) throws LocalizableException {
        Object taskObj = null;
        this.m_taskRetrieverThread.pauseTaskRetrieval();
        try {
            List<Object> snapShotRunningTasks = Arrays.asList(this.m_runningTasks.toArray());
            Iterator<Object> iter = snapShotRunningTasks.iterator();
            while (iter.hasNext() && taskObj == null) {
                TaskRunner taskRunner = (TaskRunner)iter.next();
                if (!taskRunner.getEventId().equals(id)) continue;
                taskObj = taskRunner.getTask();
            }
        }
        finally {
            this.m_taskRetrieverThread.resumeTaskRetrieval();
        }
        return taskObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Event event, String userName) throws LocalizableException {
        if (this.m_taskRetrieverThread == null) {
            return false;
        }
        boolean released = false;
        this.m_taskRetrieverThread.pauseTaskRetrieval();
        try {
            List<Object> snapShotRunningTasks = Arrays.asList(this.m_runningTasks.toArray());
            Iterator<Object> iter = snapShotRunningTasks.iterator();
            while (iter.hasNext() && !released) {
                released = ((TaskRunner)iter.next()).release(event, userName);
            }
        }
        finally {
            this.m_taskRetrieverThread.resumeTaskRetrieval();
        }
        return released;
    }

    public void start() {
        if (this.doTrace()) {
            System.out.println("Starting worker for: " + this.getServiceName());
        }
        this.m_taskRetrieverThread = new WorkRetrieverThread(this);
        this.m_taskRetrieverThread.start();
    }

    public void stop(boolean immediately) {
        if (this.doTrace()) {
            System.out.println("Stopping worker for: " + this.getServiceName());
        }
        if (this.m_taskRetrieverThread == null) {
            return;
        }
        try {
            this.m_taskRetrieverThread.end();
            this.m_taskRetrieverThread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_taskRetrieverThread = null;
        }
        if (immediately) {
            m_threadPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspend(Event event, String userName) throws LocalizableException {
        if (this.m_taskRetrieverThread == null) {
            return false;
        }
        boolean suspended = false;
        this.m_taskRetrieverThread.pauseTaskRetrieval();
        try {
            List<Object> snapShotRunningTasks = Arrays.asList(this.m_runningTasks.toArray());
            Iterator<Object> iter = snapShotRunningTasks.iterator();
            while (iter.hasNext() && !suspended) {
                suspended = ((TaskRunner)iter.next()).suspend(event, userName);
            }
        }
        finally {
            this.m_taskRetrieverThread.resumeTaskRetrieval();
        }
        return suspended;
    }

    public void cancel() throws LocalizableException {
        if (this.m_taskRetrieverThread == null) {
            return;
        }
        this.m_taskRetrieverThread.pauseTaskRetrieval();
        try {
            List<Object> snapShotRunningTasks = Arrays.asList(this.m_runningTasks.toArray());
            Iterator<Object> iter = snapShotRunningTasks.iterator();
            while (iter.hasNext()) {
                ((TaskRunner)iter.next()).cancel();
            }
        }
        finally {
            this.m_taskRetrieverThread.resumeTaskRetrieval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Event event, String userName) throws LocalizableException {
        if (this.m_taskRetrieverThread == null) {
            return false;
        }
        boolean cancelled = false;
        this.m_taskRetrieverThread.pauseTaskRetrieval();
        try {
            List<Object> snapShotRunningTasks = Arrays.asList(this.m_runningTasks.toArray());
            Iterator<Object> iter = snapShotRunningTasks.iterator();
            while (iter.hasNext() && !cancelled) {
                cancelled = ((TaskRunner)iter.next()).cancel(event, userName);
            }
        }
        finally {
            this.m_taskRetrieverThread.resumeTaskRetrieval();
        }
        return cancelled;
    }

    private synchronized boolean hasCapacity() {
        int currentUsage = this.m_runningTasks.size() + this.m_interactiveCount;
        return currentUsage < this.m_configuredCapacity;
    }

    public synchronized int getCapacity() {
        int capacity = this.m_configuredCapacity - (this.m_runningTasks.size() + this.m_interactiveCount);
        return capacity;
    }

    private void execute(Object work) {
        Task task = this.m_taskRunnableFactory.getTaskRunnable(work);
        TaskRunner taskRunner = new TaskRunner(this, task);
        this.m_runningTasks.add(taskRunner);
        m_threadPool.execute(taskRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeComplete(TaskRunner taskRunner) {
        this.m_runningTasks.remove(taskRunner);
        ResourceCapacityWorker resourceCapacityWorker = this;
        synchronized (resourceCapacityWorker) {
            this.notify();
        }
    }

    public synchronized void update(ServiceCapacity serviceCapacity) {
        String serviceName = serviceCapacity.serviceName;
        String serverGroup = serviceCapacity.serverGroup;
        if (!serviceName.equals(this.m_serviceName)) {
            this.debug("ResourceCapacityManager.update received wrong serviceName update");
            return;
        }
        if (serverGroup != null && !serverGroup.equals(this.m_serverGroup)) {
            this.debug("ResourceCapacityManager.update received wrong serverGroup update");
            return;
        }
        String serviceCapacityType = "Service Capacity Type Unknown ";
        String capacityStr = "Unknown";
        if (serviceCapacity instanceof ServiceCapacityConfiguration) {
            int oldCapacity = this.m_configuredCapacity;
            this.m_configuredCapacity = ((ServiceCapacityConfiguration)serviceCapacity).capacity;
            serviceCapacityType = "ServiceCapacityConfiguration";
            capacityStr = "capacity: " + this.m_configuredCapacity;
            if (oldCapacity > 0 && this.m_configuredCapacity == 0 && this.m_taskRetrieverThread != null) {
                this.m_taskRetrieverThread.interrupt();
            }
        } else if (serviceCapacity instanceof ServiceCapacityChange) {
            int capacityChange = ((ServiceCapacityChange)serviceCapacity).capacityChange;
            this.m_interactiveCount -= capacityChange;
            serviceCapacityType = "ServiceCapacityChange";
            capacityStr = "capacityChange: " + capacityChange;
        }
        if (this.doTrace()) {
            SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy 'at' HH:mm:ss z");
            String dateStr = df.format(new Date());
            String serverGroupDebugStr = serverGroup == null || serverGroup.equals(EMPTY_STRING) ? UNDEFINED : serverGroup;
            System.out.println(serviceCapacityType + " [" + dateStr + "] " + "\n\tname: " + serviceName + ", serverGroup: " + serverGroupDebugStr + ", " + capacityStr + "\n\tConfigured runs: " + this.m_configuredCapacity + " InteractiveRuns: " + this.m_interactiveCount + " MS runs: " + this.m_runningTasks.size());
        }
        this.notify();
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getServerGroup() {
        return this.m_serverGroup;
    }

    private void debug(String msg) {
        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Object)this, msg);
    }

    private boolean doTrace() {
        boolean doTrace = false;
        if (m_traceString != null && (m_traceString.equals(ALL) || m_traceString.equals(this.m_serviceName))) {
            doTrace = true;
        }
        return doTrace;
    }

    public boolean isSessionAffinity() {
        return this.m_useSessionAffinity;
    }

    static {
        ALL = "all";
        EMPTY_STRING = "";
        UNDEFINED = "undefined";
        m_threadPool = Executors.newCachedThreadPool((ThreadFactory)new ThreadFactoryImpl("TaskRunner:"));
    }

    public class TaskRunner
    implements Runnable {
        private ResourceCapacityWorker m_rcmForTaskRunner;
        private Task m_task;

        public TaskRunner(ResourceCapacityWorker rcm, Task task) {
            this.m_rcmForTaskRunner = rcm;
            this.m_task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"TaskRunner.run");
            try {
                ResourceCapacityWorker.this.debug("TaskRunner on thread: " + Thread.currentThread().getName());
                ThreadProperties.setProperty((String)"componentID", (String)"MS");
                ThreadProperties.setProperty((String)"requestOperation", (String)"Run Task");
                this.m_task.useSessionAffinity(ResourceCapacityWorker.this.m_useSessionAffinity);
                this.m_task.run();
            }
            catch (Throwable e) {
                String taskName = this.m_task != null ? this.m_task.toString() : "null";
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Failed to run task [" + taskName + "].  Error is: " + e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug(e);
            }
            finally {
                this.m_rcmForTaskRunner.executeComplete(this);
                zipiTimer.stopAndClear();
            }
        }

        public boolean cancel() throws LocalizableException {
            return this.m_task.cancel();
        }

        public boolean cancel(Object obj, String userName) throws LocalizableException {
            return this.m_task.cancel(obj, userName);
        }

        public IEventId getEventId() throws LocalizableException {
            return this.m_task.getId();
        }

        public Object getTask() throws LocalizableException {
            return this.m_task.getTask();
        }

        public boolean release(Object obj, String userName) throws LocalizableException {
            return this.m_task.release(obj, userName);
        }

        public boolean suspend(Object obj, String userName) throws LocalizableException {
            return this.m_task.suspend(obj, userName);
        }
    }

    private class WorkRetrieverThread
    extends Thread {
        private ResourceCapacityWorker m_rcm;
        private volatile int pausedCount;
        private volatile boolean m_end;
        private volatile boolean paused;
        private Object pauseObject;
        private Thread pausingThread;

        public WorkRetrieverThread(ResourceCapacityWorker rcm) {
            super("WorkRetrieverThread [" + rcm.getServiceName() + " " + rcm.getServerGroup() + "]");
            this.pauseObject = new Object();
            this.setDaemon(true);
            this.m_rcm = rcm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (!this.m_end) {
                ZipiTimer zipiTimer;
                block28: {
                    zipiTimer = ZipiBridge.startTimer((String)"WorkRetrieverThread.Run");
                    Object object = this.pauseObject;
                    // MONITORENTER : object
                    if (this.paused) {
                        if (this.pausingThread != null) {
                            this.pausingThread.interrupt();
                        }
                        WorkRetrieverThread.interrupted();
                        try {
                            this.pauseObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    // MONITOREXIT : object
                    if (!this.m_end && !this.paused) break block28;
                    zipiTimer.stopAndClear();
                    continue;
                }
                try {
                    block30: {
                        Object task;
                        block29: {
                            task = null;
                            if (ResourceCapacityWorker.this.hasCapacity()) {
                                task = ResourceCapacityWorker.this.m_taskSource.getTask(ResourceCapacityWorker.this.m_serviceName, ResourceCapacityWorker.this.m_serverGroup);
                            }
                            if (!this.m_end && !this.paused) break block29;
                            zipiTimer.stopAndClear();
                            continue;
                        }
                        if (task != null) {
                            ResourceCapacityWorker.this.execute(task);
                            ResourceCapacityWorker.this.m_taskSource.releaseTask(task);
                            continue;
                        }
                        Object object = this.pauseObject;
                        // MONITORENTER : object
                        if (!this.paused) break block30;
                        // MONITOREXIT : object
                        zipiTimer.stopAndClear();
                        continue;
                    }
                    try {
                        // MONITOREXIT : object
                        ZipiTimer zipiTimer6 = ZipiBridge.startTimer((String)"WorkRetrieverThread.capacityReachedWait");
                        try {
                            ResourceCapacityWorker resourceCapacityWorker = this.m_rcm;
                            // MONITORENTER : resourceCapacityWorker
                            this.m_rcm.wait();
                            // MONITOREXIT : resourceCapacityWorker
                        }
                        finally {
                            zipiTimer6.stop();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (Throwable t) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"ResourceCapacityWorker error [" + ResourceCapacityWorker.this.m_serviceName + "].  Error is: " + t.getLocalizedMessage()});
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    zipiTimer.stopAndClear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseTaskRetrieval() {
            Object object = this.pauseObject;
            synchronized (object) {
                ++this.pausedCount;
                if (this.paused) {
                    return;
                }
                this.paused = true;
                this.pausingThread = Thread.currentThread();
                this.interrupt();
                try {
                    this.pauseObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.pausingThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeTaskRetrieval() {
            Object object = this.pauseObject;
            synchronized (object) {
                --this.pausedCount;
                if (this.pausedCount <= 0) {
                    this.paused = false;
                    this.pauseObject.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            this.m_end = true;
            Object object = this.pauseObject;
            synchronized (object) {
                this.pauseObject.notifyAll();
            }
            object = this;
            synchronized (object) {
                this.interrupt();
            }
        }
    }
}

