/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventID;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.MonitorOptionBoolean;
import com.cognos.developer.schemas.bibus._3.MonitorOptionEnum;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.AsyncConversationStatusListener;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.RunOptionsInformation;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.TrackingThreadProperties;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.api.Monitorable;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.state.IRecordable;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.TSEException;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventTransition;
import com.cognos.sds.event.IEventId;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Locale;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public abstract class BaseMonitorable
implements Monitorable {
    private ParameterValue[] m_parameters;
    private Option[] m_options;
    protected JobBiBusHeaders m_header;
    private boolean m_suspended = false;
    private RunOptionsInformation m_optionInfo = null;
    private Attachment[] m_attachments;
    private EventStatus m_currentStatus = EventStatus.SDS_NEW;
    private AsyncConversation m_conversation = null;
    private boolean m_logOffRequired = false;
    private IEventId m_id;
    boolean isBackground = false;
    private String m_firstErrorString = null;

    public BaseMonitorable(IEventId id, ParameterValue[] parameters, Option[] options, Attachment[] attachments, JobBiBusHeaders header) throws RemoteException {
        BiBusHeader headerCopy;
        this.m_id = id;
        String guid = "";
        if (id != null) {
            guid = id.getGuid();
        }
        if ((headerCopy = BiBusUtilities.getDeepCopy((BiBusHeader)header.getBiBusHeader())).getTracking() != null) {
            headerCopy.getTracking().setConversationContext(null);
        }
        this.m_header = new JobBiBusHeaders(headerCopy);
        this.m_header.setCamCredential(header.getCamCredential());
        this.setOptions(options);
        this.setParameters(parameters);
        this.setAttachments(attachments);
        this.m_conversation = new AsyncConversation(guid);
        this.m_conversation.addStatusListener((AsyncConversationStatusListener)this);
        this.removeConversationContext(this.m_header.getBiBusHeader());
        this.setThreadProperties();
    }

    protected void removeConversationContext(BiBusHeader header) {
        Tracking tracking = header.getTracking();
        if (tracking != null) {
            tracking.setConversationContext(null);
            header.setTracking(tracking);
        }
    }

    @Override
    public void reauthenticate() throws LocalizableException, EMFSecurityException {
        EMFSecurityException camSecurityException = null;
        try {
            AuthenticatorFactory.getInstance().authenticate(this.m_header);
        }
        catch (EMFSecurityException e) {
            camSecurityException = e;
        }
        if (camSecurityException != null) {
            try {
                AuthenticatorFactory.getInstance().logon(this.m_header);
                this.setBiBusHeader(this.m_header.getBiBusHeader());
            }
            catch (Exception e) {
                throw camSecurityException;
            }
        }
    }

    void addAttachments(ServiceAPI service) {
        Message currentMessage = MessageContext.getCurrentContext().getRequestMessage();
        Iterator attachmentsIter = currentMessage.getAttachments();
        while (attachmentsIter.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)attachmentsIter.next();
            try {
                DataHandler dh = attachmentPart.getDataHandler();
                service.addAttachment((Object)dh);
            }
            catch (SOAPException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("SOAPException when getting the DataHandler for the attachment.");
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug((Throwable)e);
            }
        }
    }

    @Override
    public IEventId getId() {
        return this.m_id;
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        return this.m_header.getBiBusHeader();
    }

    public synchronized void setBiBusHeader(BiBusHeader h) {
        this.m_header.setBiBusHeader(h);
    }

    @Override
    public synchronized Option[] getOptions() {
        return this.m_options;
    }

    synchronized void addOption(Option option) throws RemoteException {
        if (this.m_options != null) {
            int numOptions = this.m_options.length;
            Option[] newOptions = new Option[numOptions + 1];
            System.arraycopy(this.m_options, 0, newOptions, 0, numOptions);
            newOptions[numOptions] = option;
            this.setOptions(newOptions);
        } else {
            this.setOptions(new Option[]{option});
        }
    }

    synchronized void setOptions(Option[] options) throws RemoteException {
        this.m_options = options;
        this.m_optionInfo = new RunOptionsInformation(this.m_options);
        this.isBackground = this.m_optionInfo.isBackground();
    }

    public Attachment[] getAttachments() {
        return this.m_attachments;
    }

    public void setAttachments(Attachment[] attachments) {
        this.m_attachments = attachments == null ? new Attachment[]{} : attachments;
    }

    public void setParameters(ParameterValue[] params) {
        this.m_parameters = params;
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.m_parameters;
    }

    @Override
    public synchronized EventStatus getStatus() {
        return this.m_currentStatus;
    }

    @Override
    public synchronized void setStatus(EventStatus status) throws MonitorServiceException {
        this.m_currentStatus = status;
    }

    private String generateLogMessage(String msg, String methodName) {
        String mName = "";
        if (methodName != null) {
            mName = methodName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(" TASK:LOG:START: OBJECT=BaseMonitorable : METHOD=");
        sb.append(mName);
        sb.append(" : EVENTID=");
        if (this.getId() != null) {
            sb.append(this.getId().getGuid());
        }
        sb.append(" : MSG=");
        sb.append(msg);
        sb.append(" : TASK:LOG:END");
        return sb.toString();
    }

    @Override
    public synchronized boolean cancel(Event event, String userName) throws MonitorServiceException {
        boolean cancelled = event.getEventId().equalTo(this.getId());
        this.getRTLogger().debug(this.generateLogMessage("Method cancel(Event event, String userName) called with eventId=" + event.getEventId().getGuid(), "cancel(Event event, String userName)"));
        if (cancelled) {
            EventTransition.validate(this.m_currentStatus, event.getStatus());
            cancelled = this.unconditionalCancel(event.getEventId(), userName);
        }
        return cancelled;
    }

    public synchronized void cancel() {
        this.getRTLogger().debug(this.generateLogMessage("Before calling m_conversation.cancel() method.", "cancel()"));
        this.m_conversation.cancel();
        this.getRTLogger().debug(this.generateLogMessage("After calling m_conversation.cancel() method.", "cancel()"));
    }

    @Override
    public boolean unconditionalCancel(IEventId id, String userName) {
        this.getRTLogger().debug(this.generateLogMessage("Before calling cancel() method.", "unconditionalCancel(IEventId id, String userName)"));
        this.cancel();
        this.getRTLogger().debug(this.generateLogMessage("After calling cancel() method.", "unconditionalCancel(IEventId id, String userName)"));
        return true;
    }

    @Override
    public void suspend(String userName) throws MonitorServiceException {
        this.getRTLogger().debug(this.generateLogMessage("Method suspend() Called.", "suspend(String userName)"));
        this.m_suspended = true;
        this.updateRecord(MonitorI18NCode.MSG_MS_SUSPENDED_BY_USER_Y, new Object[]{userName}, EventStatus.SUSPENDED, SeverityEnum.info);
    }

    @Override
    public boolean suspend(Event event, String userName) throws MonitorServiceException {
        this.getRTLogger().debug(this.generateLogMessage("Method suspend(Event event, String userName) called with eventId=" + event.getEventId().getGuid(), "suspend(Event event, String userName)"));
        boolean suspended = event.getEventId().equalTo(this.getId());
        if (suspended) {
            EventTransition.validate(this.m_currentStatus, event.getStatus());
            this.suspend(userName);
        }
        return suspended;
    }

    @Override
    public void release(String userName) throws MonitorServiceException {
        this.getRTLogger().debug(this.generateLogMessage("Method release() called.", "release(String userName)"));
        this.updateRecord(MonitorI18NCode.MSG_MS_RELEASED_BY_USER_Y, new Object[]{userName}, EventStatus.PENDING, SeverityEnum.info);
    }

    @Override
    public boolean release(Event event, String userName) throws MonitorServiceException {
        boolean released = event.getEventId().equalTo(this.getId());
        this.getRTLogger().debug(this.generateLogMessage("Method release(Event event, String userName) called with eventId=" + event.getEventId().getGuid(), "release(Event event, String userName)"));
        if (released) {
            EventTransition.validate(this.m_currentStatus, event.getStatus());
            this.release(userName);
        }
        return released;
    }

    @Override
    public AsynchReply addAsynchDetailEventID(AsynchReply reply) {
        AsynchDetailEventID dei = new AsynchDetailEventID();
        dei.setEventID(this.getId().toXMLString());
        AsynchDetail[] existingDetails = reply.getDetails();
        if (existingDetails == null) {
            reply.setDetails(new AsynchDetail[]{dei});
        } else {
            AsynchDetail[] details = new AsynchDetail[existingDetails.length + 1];
            System.arraycopy(existingDetails, 0, details, 0, existingDetails.length);
            details[existingDetails.length] = dei;
            reply.setDetails(details);
        }
        return reply;
    }

    @Override
    public synchronized boolean isBackground() {
        return this.isBackground;
    }

    @Override
    public void setBackground(boolean v) {
        this.isBackground = v;
    }

    public boolean isSuspended() {
        return this.m_suspended;
    }

    @Override
    public void stripBackgroundOption() {
        Option[] oldOptions = this.getOptions();
        int numOptions = 0;
        if (oldOptions != null) {
            numOptions = oldOptions.length;
        }
        if (numOptions == 0) {
            return;
        }
        Option[] newOptions = new Option[numOptions];
        int j = 0;
        int numOptionsRemoved = 0;
        for (int i = 0; i < numOptions; ++i) {
            if (oldOptions[i] instanceof MonitorOptionBoolean) {
                MonitorOptionBoolean bool = (MonitorOptionBoolean)oldOptions[i];
                if (!bool.getName().equals((Object)MonitorOptionEnum.background)) {
                    newOptions[j] = oldOptions[i];
                    ++j;
                    continue;
                }
                ++numOptionsRemoved;
                continue;
            }
            newOptions[j] = oldOptions[i];
            ++j;
        }
        try {
            int numOptionsLeft = numOptions - numOptionsRemoved;
            if (numOptionsLeft <= 0) {
                this.setOptions(null);
            } else {
                Option[] newerOptions = new Option[numOptionsLeft];
                System.arraycopy(newOptions, 0, newerOptions, 0, numOptionsLeft);
                this.setOptions(newerOptions);
            }
        }
        catch (RemoteException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("Remote Exception whilst setting the new Options [" + e.getMessage() + "].");
        }
    }

    @Override
    public String getParentRelatedId() {
        return this.m_optionInfo.getParentHistoryEventID();
    }

    synchronized int getRunContextOptionIndex() {
        return this.m_optionInfo.getRunContextOptionIndex();
    }

    public synchronized boolean isCancelled() {
        return this.m_conversation.isCancelled();
    }

    ContentManagerServiceClientPort getCmPort() throws RemoteException {
        ContentManagerServiceClientPort port = Client.instance().getContentManagerServiceClient(this.m_header);
        port.setLogCategory(MonitorCategory.RUNTIME);
        return port;
    }

    protected abstract IRecordable getStateRecorder();

    protected abstract void runPostConversationCommands(AsynchReply var1) throws TSEException;

    @Override
    public void createRecord() throws RecordableException {
        this.getStateRecorder().update(EventStatus.PENDING);
    }

    @Override
    public void updateRecord(I18NCode detail, Object[] params, EventStatus status, SeverityEnum sevEnum) throws MonitorServiceException {
        this.setErrorString(detail, params);
        this.setStatus(status);
        this.getStateRecorder().update(detail, params, status, sevEnum);
    }

    @Override
    public void updateRecord(EventStatus status) throws MonitorServiceException {
        this.setStatus(status);
        this.getStateRecorder().update(status);
    }

    private void setErrorString(I18NCode detail, Object[] params) {
        if (this.m_firstErrorString == null && detail != null) {
            Locale locale = this.m_header.getProductLocale();
            this.m_firstErrorString = I18NUtil.getMessage((I18NCode)detail, (Object[])params, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
        }
    }

    public String getFirstError() {
        return this.m_firstErrorString;
    }

    protected AsynchReply doConversation(ServiceAPI service, AsynchReply reply) throws LocalizableException {
        this.getRTLogger().debug(this.generateLogMessage("Calling method m_conversation.doConversationWithRelease(service, reply) of AsyncConversation object.", "doConversation()"));
        return this.m_conversation.doConversationWithRelease(service, reply);
    }

    SDSLogger getRTLogger() {
        return SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME);
    }

    public void updateConversationStatus(AsynchReply reply, AsynchReplyStatusEnum replyStatusEnum) throws LocalizableException {
        EventStatus newStatus = EventStatusUtil.getEventStatus((AsynchReplyStatusEnum)replyStatusEnum);
        if (this.m_conversation.isCancelled()) {
            if (EventStatus.EXECUTING.isEqualTo(newStatus)) {
                this.updateRecord(EventStatus.TERMINATED);
            } else if (EventStatus.PENDING.isEqualTo(newStatus)) {
                this.updateRecord(EventStatus.PURGED);
            } else {
                this.setStatus(newStatus);
            }
        } else if (newStatus.isEqualTo(EventStatus.SUCCEEDED)) {
            try {
                TaskStateRecord tsr = TaskPersistLayer.getTaskStateFromEventId((String)this.getId().toXMLString());
                if (tsr == null || !tsr.status.isWaiting() && !this.getStatus().isEqualTo(EventStatus.SUCCEEDED)) {
                    this.runPostConversationCommands(reply);
                    this.updateRecord(newStatus);
                }
            }
            catch (TaskPersistLayerException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("TaskPersistLayerException getting task state [" + e.getMessage() + "].");
            }
            catch (TSEException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug("TSEException running post conversation commands [" + e.getMessage() + "].");
            }
        } else {
            try {
                TaskStateRecord tsr = TaskPersistLayer.getTaskStateFromEventId((String)this.getId().toXMLString());
                if (tsr == null || !tsr.status.isWaiting()) {
                    this.setStatus(newStatus);
                }
            }
            catch (TaskPersistLayerException e) {
                this.setStatus(newStatus);
            }
        }
    }

    public void onConversationCancel() {
    }

    @Override
    public void setDoLogOff(boolean doLogoff) {
        this.m_logOffRequired = doLogoff;
    }

    protected boolean logOffWhenDone() {
        return this.m_logOffRequired;
    }

    String getThrowableMessage(Throwable ex) {
        String message = ex.getMessage();
        if (message == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ex.printStackTrace(ps);
            ps.flush();
            String trace = baos.toString();
            message = ex.getClass().getName() + trace;
        }
        return message;
    }

    public int hashCode() {
        return this.getId().toXMLString().hashCode();
    }

    @Override
    public void setThreadProperties() {
        TrackingThreadProperties.setThreadTrackingProperties((BiBusHeader)this.m_header.getBiBusHeader());
        ThreadProperties.setObject((String)"step_id_key", (Object)this.getId().toXMLString());
        String parentID = this.m_optionInfo.getParentHistoryEventID();
        parentID = parentID != null ? parentID : "";
        ThreadProperties.setObject((String)"hop_id_key", (Object)parentID);
    }

    @Override
    public void addEventIDToRunContextOption(Option[] options) throws RemoteException {
        int runContextOptionIndex = this.getRunContextOptionIndex();
        String historyID = this.getId().toXMLString();
        if (runContextOptionIndex != -1) {
            AsynchOptionStringArray asynchOption = (AsynchOptionStringArray)options[runContextOptionIndex];
            String[] contextEventIDs = asynchOption.getValue();
            String[] updatedContextEventIDs = new String[contextEventIDs.length + 1];
            System.arraycopy(contextEventIDs, 0, updatedContextEventIDs, 0, contextEventIDs.length);
            updatedContextEventIDs[contextEventIDs.length] = historyID;
            asynchOption.setValue(updatedContextEventIDs);
        } else {
            AsynchOptionStringArray runContextAsynchOption = new AsynchOptionStringArray();
            runContextAsynchOption.setName(AsynchOptionEnum.runContext);
            runContextAsynchOption.setValue(new String[]{historyID});
            this.addOption((Option)runContextAsynchOption);
        }
    }
}

