/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.IMonitorService;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.impl.MonitorService;
import com.cognos.monitor.paging.MonitorQueueQuery;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;

public class InactiveTaskCleanUp
implements Runnable {
    Thread runThread;
    IMonitorService monitorSvc;
    boolean stopped = true;

    public InactiveTaskCleanUp(IMonitorService monitor) {
        this.monitorSvc = monitor;
    }

    public synchronized void start() {
        if (this.stopped) {
            this.stopped = false;
            this.runThread = new Thread((Runnable)this, "InactiveTaskCleanup");
            this.runThread.setDaemon(true);
            this.runThread.start();
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("InactiveTaskCleanup stopped.");
            this.runThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("InactiveTaskCleanup Started.");
        while (!this.isStopped()) {
            try {
                int newValue;
                String checkIntervalValue;
                String cleanupEnabledValue;
                int newValue2;
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("InactiveTaskCleanup Checking....");
                int duration = 300;
                boolean cleanupEnabled = false;
                int checkInterval = 30000;
                Thread.sleep(checkInterval);
                String durationValue = CRNProperties.getInstance().getProperty("inactive.task.cleanup.duration");
                if (durationValue != null && (newValue2 = Integer.valueOf(durationValue).intValue()) > 0) {
                    duration = newValue2;
                }
                if ((cleanupEnabledValue = CRNProperties.getInstance().getProperty("inactive.task.cleanup.enabled")) != null && cleanupEnabledValue.trim().toUpperCase().equals("TRUE")) {
                    cleanupEnabled = true;
                }
                if ((checkIntervalValue = CRNProperties.getInstance().getProperty("inactive.task.cleanup.check.interval")) != null && (newValue = Integer.valueOf(checkIntervalValue).intValue()) > 0) {
                    checkInterval = newValue * 1000;
                }
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("cleanUpEnabled[" + cleanupEnabled + "] duration[" + duration + "] checkInterval[" + checkInterval / 1000 + "]");
                if (!cleanupEnabled) continue;
                MonitorQueueQuery m_query = new MonitorQueueQuery(null);
                m_query.setInactiveTaskCleanupFlag(true);
                m_query.executeQuery(null);
                int numRows = m_query.numRows();
                ResultSet rs = m_query.getResultSet();
                long currentTime = System.currentTimeMillis();
                ArrayList<Event> eventArray = new ArrayList<Event>();
                while (rs.next()) {
                    int status = rs.getInt("STATUS");
                    String taskId = rs.getString("TASK_ID");
                    long taskStarted = rs.getLong("DATE_ENTERED");
                    String storeId = rs.getString("STOREID");
                    Date date = new Date(taskStarted);
                    if (!this.isInactiveStatus(status) || !this.isTaskInActiveOverDuration(taskStarted, duration)) continue;
                    Event event = new Event(EventStatus.CANCELLED, EventId.valueOf(taskId));
                    eventArray.add(event);
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Found inactive task - StoreId[" + storeId + "] status[" + status + "], Task ID[" + taskId + "] date_enter[" + taskStarted + "] timestamp[" + date.toString() + "]");
                }
                m_query.close();
                MonitorService service = MonitorService.instance();
                EventsResult result = null;
                try {
                    if (eventArray.size() <= 0) continue;
                    Event[] events = new Event[eventArray.size()];
                    events = eventArray.toArray(events);
                    result = service.cancelEvents(events, "");
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[" + eventArray.size() + "] inactive task(s) were cleaned up.");
                }
                catch (MonitorServiceException e) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
                }
            }
            catch (Exception e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
            }
        }
        this.stop();
    }

    private boolean isInactiveStatus(int status) {
        boolean result = false;
        if (status == TaskStatus.INACTIVE.hashCode()) {
            result = true;
        }
        return result;
    }

    private boolean isTaskInActiveOverDuration(long taskStarted, int duration) {
        boolean result = false;
        long currentTime = System.currentTimeMillis();
        if (taskStarted + (long)(duration * 1000) < currentTime) {
            result = true;
        }
        return result;
    }

    private synchronized boolean isStopped() {
        return this.stopped;
    }
}

