/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.jsmcommon.jms.client.JMSConnection;
import com.cognos.jsmcommon.jms.resource.JMSProperties;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.IMonitorService;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.ibm.cognos.jsmcommon.jms.JMSException;
import com.ibm.cognos.jsmcommon.jms.Message;
import com.ibm.cognos.jsmcommon.jms.ObjectMessage;
import com.ibm.cognos.jsmcommon.jms.Queue;
import com.ibm.cognos.jsmcommon.jms.QueueReceiver;
import com.ibm.cognos.jsmcommon.jms.QueueSession;

public class JmsQueueConsumer
implements Runnable {
    Queue queue;
    Thread runThread;
    QueueReceiver receiver;
    QueueSession session;
    IMonitorService monitorSvc;
    JMSConnection connection = null;
    boolean stopped = true;

    public JmsQueueConsumer(IMonitorService monitor) {
        this.monitorSvc = monitor;
    }

    public synchronized void start() {
        if (this.stopped) {
            this.stopped = false;
            this.runThread = new Thread((Runnable)this, "JsmQueueConsumer");
            this.runThread.setDaemon(true);
            this.runThread.start();
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.stopReceiver();
            this.runThread.interrupt();
        }
    }

    private synchronized void createReceiver() {
        if (this.session == null) {
            try {
                if (this.connection == null) {
                    this.connection = new JMSConnection();
                }
                this.session = this.connection.getConnection().createQueueSession(false, 2);
                String name = JMSProperties.getInstance().getProperty(JMSProperties.JOB_QUEUE_NAME);
                this.queue = this.session.createQueue(name);
                this.receiver = this.session.createReceiver(this.queue);
                this.connection.getConnection().start();
            }
            catch (Exception e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
                this.session = null;
                this.receiver = null;
            }
        }
    }

    private synchronized void stopReceiver() {
        try {
            if (this.receiver != null) {
                this.receiver.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.getConnection().stop();
            }
        }
        catch (JMSException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
        }
        this.session = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        this.createReceiver();
        if (this.receiver == null) {
            this.stopped = true;
        }
        while (!this.isStopped()) {
            Message msg;
            block23: {
                msg = null;
                msg = this.receiver.receive();
                if (msg != null) break block23;
                if (msg == null) break;
                try {
                    if (msg.getJMSReplyTo() != null) {
                        // empty if block
                    }
                    msg.acknowledge();
                }
                catch (JMSException e) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
                }
                break;
            }
            ObjectMessage om = (ObjectMessage)msg;
            this.runTask(om.getObject());
            if (msg == null) continue;
            try {
                if (msg.getJMSReplyTo() != null) {
                    // empty if block
                }
                msg.acknowledge();
            }
            catch (JMSException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
            }
            continue;
            catch (Exception e) {
                try {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
                    if (msg == null) continue;
                }
                catch (Throwable throwable) {
                    if (msg != null) {
                        try {
                            if (msg.getJMSReplyTo() != null) {
                                // empty if block
                            }
                            msg.acknowledge();
                        }
                        catch (JMSException e2) {
                            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e2.getLocalizedMessage()});
                            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (msg.getJMSReplyTo() != null) {
                        // empty if block
                    }
                    msg.acknowledge();
                }
                catch (JMSException e3) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e3.getLocalizedMessage()});
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e3);
                }
            }
        }
        this.stop();
        JmsQueueConsumer jmsQueueConsumer = this;
        synchronized (jmsQueueConsumer) {
            this.receiver = null;
        }
    }

    private void runTask(Object data) {
        try {
            TaskID taskID = (TaskID)data;
            TaskRunContext context = TaskRunContextFactory.createTaskRunContext(taskID);
            if (context != null) {
                if (context.getTaskRecord().getRunSpec().isCancelledRun) {
                    TSE.getInstance().cancel(context);
                } else {
                    TSE.getInstance().setTaskAsReady(context);
                }
            }
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
        }
    }

    private synchronized boolean isStopped() {
        return this.stopped;
    }
}

