/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.paging.IPager;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.impl.AsyncContextImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class MonitorContextMap {
    static final SDSLogger logger = SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT);
    private HashMap inProgressMap = new HashMap();
    private long checkIntervalDefault_ms = 60000L;
    private int abandonLimitDefault = 1800;
    private long checkInterval_ms = this.checkIntervalDefault_ms;
    private int abandonLimit = this.abandonLimitDefault;
    private Timer expiryTimer = null;
    private String threadName = "pagerExpireyThread";

    public MonitorContextMap() {
        logger.debug("Created with threadName=" + this.threadName + ", checkIntervalms=" + this.checkInterval_ms + ", abandonLimit=" + this.abandonLimit);
    }

    public synchronized void configure() {
        try {
            this.abandonLimit = this.abandonLimitDefault;
            String abandonLimitString = CRNProperties.getInstance().getProperty("ms.paging.abandon.limit");
            if (abandonLimitString != null) {
                this.abandonLimit = Integer.parseInt(abandonLimitString);
            }
        }
        catch (NumberFormatException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("Error configuring monitorContextMap abandon limit : " + e);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).debug("Error configuring monitorContextMap check interval: " + (Object)((Object)e));
        }
    }

    synchronized void start() {
        if (this.expiryTimer == null) {
            this.expiryTimer = new Timer(true);
            this.expiryTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName(MonitorContextMap.this.threadName);
                }
            }, 0L);
            this.expiryTimer.schedule((TimerTask)new MonitorPagerExpiryTask(), this.checkInterval_ms, this.checkInterval_ms);
        }
    }

    synchronized void stop() {
        if (this.expiryTimer != null) {
            this.expiryTimer.cancel();
            this.expiryTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncContext removeContext(AsyncContext context) {
        AsyncContext ret_value = null;
        if (context != null) {
            HashMap hashMap = this.inProgressMap;
            synchronized (hashMap) {
                if (this.inProgressMap.containsKey(context.getConversationID())) {
                    logger.debug("Removing contextID from map" + context.getConversationID());
                    ContextMapItem value = (ContextMapItem)this.inProgressMap.remove(context.getConversationID());
                    ret_value = value.getAsyncContext();
                }
            }
        }
        return ret_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContext(AsyncContext asContext, AsynchReply reply) {
        if (reply.getStatus().equals((Object)AsynchReplyStatusEnum.complete)) {
            ContextMapItem item = new ContextMapItem(asContext);
            HashMap hashMap = this.inProgressMap;
            synchronized (hashMap) {
                logger.debug("Adding contextID into map" + asContext.getConversationID());
                this.inProgressMap.put(asContext.getConversationID(), item);
            }
        }
    }

    class ContextMapItem {
        private AsyncContext asyncContext;
        private long usedTime;

        public ContextMapItem(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
            this.usedTime = System.currentTimeMillis();
        }

        public AsyncContext getAsyncContext() {
            return this.asyncContext;
        }

        public void setAsyncContext(AsyncContextImpl asyncContext) {
            this.asyncContext = asyncContext;
        }

        public boolean hasReachedAbandonLimit(long abandonLimit) {
            boolean result = false;
            if (System.currentTimeMillis() - this.usedTime > abandonLimit * 1000L) {
                result = true;
            }
            return result;
        }
    }

    class MonitorPagerExpiryTask
    extends TimerTask {
        ArrayList expiredContexts = new ArrayList();

        MonitorPagerExpiryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.expiredContexts.clear();
            HashMap hashMap = MonitorContextMap.this.inProgressMap;
            synchronized (hashMap) {
                Iterator it = MonitorContextMap.this.inProgressMap.entrySet().iterator();
                while (it.hasNext()) {
                    ContextMapItem context;
                    Map.Entry me = it.next();
                    ContextMapItem contextMapItem = context = (ContextMapItem)me.getValue();
                    synchronized (contextMapItem) {
                        if (context.hasReachedAbandonLimit(MonitorContextMap.this.abandonLimit)) {
                            logger.debug("detected abandoned async conversation: " + context);
                            this.expiredContexts.add(context);
                            it.remove();
                        }
                    }
                }
            }
            for (int i = 0; i < this.expiredContexts.size(); ++i) {
                ContextMapItem item = (ContextMapItem)this.expiredContexts.get(i);
                AsyncContext asyncContext = item.getAsyncContext();
                logger.debug("Removing contextID from map due to expirey" + asyncContext.getConversationID());
                Object contextObject = asyncContext.getContextObj();
                if (contextObject instanceof IPager) {
                    ((IPager)contextObject).release();
                }
                asyncContext.setContextObj(null);
            }
            this.expiredContexts.clear();
        }
    }
}

