/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EventRecord;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRequestArguments;
import com.cognos.developer.schemas.bibus._3.MonitorAddOptionBoolean;
import com.cognos.developer.schemas.bibus._3.MonitorAddOptionEnum;
import com.cognos.developer.schemas.bibus._3.MonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusInfo;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueMetrics;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.CommonHistoryHelper;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.IMonitorService;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.api.Monitorable;
import com.cognos.monitor.capacity.MonitorableTaskFactory;
import com.cognos.monitor.capacity.ResourceCapacityManager;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.EventResultType;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.impl.InactiveTaskCleanUp;
import com.cognos.monitor.impl.JmsQueueConsumer;
import com.cognos.monitor.impl.MonitorContextMap;
import com.cognos.monitor.queue.JobQueueReceiver;
import com.cognos.monitor.tse.HistoryConsistencyThread;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.monitor.tse.TaskRunContextFactory;
import com.cognos.monitor.tse.TaskStateConsistencyCheckThread;
import com.cognos.monitor.tse.WriteFinalHistoryService;
import com.cognos.monitor.tse.bclean.BulkFinishedTaskCleanerThread;
import com.cognos.monitor.tse.commands.TaskPriorityChangedCmd;
import com.cognos.monitor.tse.commands.TaskRunNotifyInactiveCmd;
import com.cognos.pogo.capacity.ServiceCapacity;
import com.cognos.pogo.capacity.ServiceCapacityConfiguration;
import com.cognos.pogo.monitoring.RequestReporter;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import com.cognos.sds.event.EventTransition;
import com.cognos.sds.event.persist.EventIdStatusTable;
import com.cognos.sds.event.persist.EventIdStatusTableException;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import noticecast.services.soap.cm.CMSearchPathGenerator;
import org.apache.axis.AxisFault;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MonitorService
implements IMonitorService {
    protected static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(MonitorService.class.getName());
    private boolean m_isEnabled;
    private static boolean m_isHistoryEnabled = true;
    JmsQueueConsumer jmsQueue;
    JobQueueReceiver jobReceiver = new JobQueueReceiver(this);
    InactiveTaskCleanUp taskCleanUp;
    ResourceCapacityManager m_resourceCapacityManager;
    MonitorContextMap m_pager_contexts;
    private static ThreadLocal m_initHolder = new ThreadLocal();
    private static MonitorService m_instance;
    private WriteFinalHistoryService writeFinalHistoryService = null;
    private boolean m_allServicesStarted = false;

    private MonitorService() {
        this.jmsQueue = new JmsQueueConsumer(this);
        this.taskCleanUp = new InactiveTaskCleanUp(this);
        this.m_resourceCapacityManager = new ResourceCapacityManager(new MonitorableTaskFactory(this));
        ServiceCapacityConfiguration config = new ServiceCapacityConfiguration("taskLoadFailed", "", 5);
        this.m_resourceCapacityManager.update((ServiceCapacity)config);
        this.m_pager_contexts = new MonitorContextMap();
        this.writeFinalHistoryService = WriteFinalHistoryService.getInstance();
    }

    public static MonitorService createInstance(boolean isHistoryEnabled) {
        m_isHistoryEnabled = isHistoryEnabled;
        return MonitorService.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MonitorService instance() {
        if (m_initHolder.get() != null) return m_instance;
        Class<MonitorService> clazz = MonitorService.class;
        synchronized (MonitorService.class) {
            if (m_instance == null) {
                m_instance = new MonitorService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            m_initHolder.set(Boolean.TRUE);
            return m_instance;
        }
    }

    @Override
    public void adjustEnabledProcessorCount(int hour) {
    }

    @Override
    public JobQueueReceiver getJobQueueReceiver() {
        return this.jobReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchReply add(Monitorable monitorable) throws SDSServiceException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"MonitorService.add");
        try {
            if (!this.isEnabled()) {
                this.trace("Cannot add monitorables to a stopped Monitor Service.");
                throw new MonitorServiceException(I18NCode.JS_ADD_JOB_QUEUE_ERROR);
            }
            AsynchReply asynchReply = this.runImmediately(monitorable);
            return asynchReply;
        }
        finally {
            zipiTimer.stop();
        }
    }

    @Override
    public AsynchReply addDetail(String eventID, BaseClass[] classes, Option[] options, JobBiBusHeaders headers) throws MonitorServiceException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"MonitorService.addDetail");
        try {
            AsynchReply reply = new AsynchReply();
            try {
                reply.setStatus(AsynchReplyStatusEnum.working);
                Integer[] indexesUsed = null;
                Option dependentStepOption = null;
                if (eventID == null || !TaskID.isTSEID((String)eventID)) {
                    throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
                }
                ArrayList detailsList = new ArrayList();
                for (int i = 0; i < classes.length; ++i) {
                    this.addDetail(detailsList, classes[i]);
                }
                if (detailsList.size() < 1) {
                    throw new SDSServiceException(MonitorI18NCode.MSG_MS_NO_HISTORY_DETAILS);
                }
                BaseHistoryDetail[] details = detailsList.toArray(new BaseHistoryDetail[detailsList.size()]);
                TaskStateRecord record = new TaskStateRecord();
                TaskID taskID = TaskID.fromEventId((String)eventID);
                if (!record.find(taskID) && (taskID = TaskPersistLayer.resolveRestartId((TaskID)taskID)) == null) {
                    throw new SDSServiceException(I18NCode.EVENT_ID_INVALID);
                }
                dependentStepOption = OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)MonitorAddOptionEnum.dependentStep);
                indexesUsed = dependentStepOption != null && dependentStepOption instanceof MonitorAddOptionBoolean && ((MonitorAddOptionBoolean)dependentStepOption).isValue() ? TaskPersistLayer.getInstance().addInactiveTaskDetails(taskID, details) : TaskPersistLayer.getInstance().addTaskDetails(taskID, details);
                reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
                if (dependentStepOption != null && indexesUsed != null) {
                    AsynchDetailMonitorServiceEventID[] msEventID = new AsynchDetailMonitorServiceEventID[indexesUsed.length];
                    for (int i = 0; i < indexesUsed.length; ++i) {
                        MonitorServiceEventID id = new MonitorServiceEventID();
                        id.setEventID(eventID);
                        id.setStepID(indexesUsed[i].intValue());
                        msEventID[i] = new AsynchDetailMonitorServiceEventID();
                        msEventID[i].setEventID(id);
                    }
                    AsynchDetail[] existingDetails = reply.getDetails();
                    if (existingDetails == null) {
                        reply.setDetails((AsynchDetail[])msEventID);
                    } else {
                        AsynchDetail[] newDetails = new AsynchDetail[existingDetails.length + msEventID.length];
                        System.arraycopy(existingDetails, 0, newDetails, 0, existingDetails.length);
                        System.arraycopy(msEventID, 0, newDetails, existingDetails.length, msEventID.length);
                        reply.setDetails(newDetails);
                    }
                }
                AsynchReply asynchReply = reply;
                return asynchReply;
            }
            catch (LocalizableException ex) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Exception when adding history details for task with ID [" + eventID + "]");
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, ex);
                throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR_WRAPPER, ex);
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    private void addDetail(List details, BaseClass base) throws MonitorServiceException {
        if (base instanceof HistoryDetailRequestArguments) {
            ParameterValueArrayProp params;
            HistoryDetailRequestArguments hdra = (HistoryDetailRequestArguments)base;
            OptionArrayProp ops = hdra.getOptions();
            if (ops != null) {
                Option[] opArray = ops.getValue();
                for (int i = 0; opArray != null && i < opArray.length; ++i) {
                    if (opArray[i] != null) continue;
                    throw new MonitorServiceException(MonitorI18NCode.MSG_MS_INVALID_REQUEST);
                }
            }
            if ((params = hdra.getParameters()) != null) {
                ParameterValue[] paramsArray = params.getValue();
                for (int i = 0; paramsArray != null && i < paramsArray.length; ++i) {
                    if (paramsArray[i] != null) continue;
                    throw new MonitorServiceException(MonitorI18NCode.MSG_MS_INVALID_REQUEST);
                }
            }
            details.add(base);
        } else if (base instanceof BaseHistoryDetail) {
            details.add(base);
        }
    }

    private AsynchReply runImmediately(Monitorable monitorable) throws MonitorServiceException {
        this.updateSdsInstance(monitorable);
        AsynchReply reply = null;
        try {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Task [" + monitorable.toString() + "] called to run.  Initialising execution."});
            reply = monitorable.run();
        }
        catch (MonitorServiceException ex) {
            monitorable.updateRecord(MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{ex.getLocalizedMessage()}, EventStatus.FAILED, SeverityEnum.error);
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Task [" + monitorable.toString() + "] failed.  Error is: " + ex.getMessage()});
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR_WRAPPER, (Throwable)((Object)ex));
        }
        return reply;
    }

    private void updateSdsInstance(Monitorable monitorable) throws MonitorServiceException {
        JDBCConnection connection = null;
        try {
            connection = NCConnection.instance().getConnectionFactory().createConnection();
            EventIdStatusTable eventStatusTable = EventIdStatusTable.getInstance();
            eventStatusTable.updateSdsInstance((Connection)connection, monitorable.getId());
        }
        catch (EventIdStatusTableException ex) {
            monitorable.updateRecord(MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{ex.getLocalizedMessage()}, EventStatus.FAILED, SeverityEnum.error);
            throw new MonitorServiceException(I18NCode.EVENT_UPDATE_ERROR, (Throwable)((Object)ex));
        }
        catch (SQLException ex) {
            monitorable.updateRecord(MonitorI18NCode.MSG_MS_GENERAL_ERROR, new Object[]{ex.getLocalizedMessage()}, EventStatus.FAILED, SeverityEnum.fatal);
            throw new MonitorServiceException(I18NCode.EVENT_UPDATE_ERROR, new Object[]{ex.getLocalizedMessage()});
        }
        finally {
            if (connection != null) {
                SqlResourceCloser.releaseConnection((JDBCConnection)connection);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    @Override
    public synchronized void start() {
        if (!this.m_isEnabled && this.m_allServicesStarted) {
            this.m_isEnabled = true;
            if (m_isHistoryEnabled && WriteFinalHistoryService.useWriteFinalHistoryService) {
                TSE.trace("TSE_WFH: Starting WriteFinalHistoryService");
                this.writeFinalHistoryService.start();
                TSE.trace("TSE_WFH: WriteFinalHistoryService Started");
            }
            TSE.getInstance().start();
            this.m_resourceCapacityManager.start();
            this.enableCleanup();
            this.jmsQueue.start();
            this.jobReceiver.start();
            this.taskCleanUp.start();
            if (m_isHistoryEnabled) {
                HistoryConsistencyThread.getInstance().start();
            }
            TaskStateConsistencyCheckThread.getInstance().start();
            BulkFinishedTaskCleanerThread.getInstance().start();
            this.m_pager_contexts.start();
        }
    }

    @Override
    public synchronized void allServicesStarted() {
        if (!this.m_allServicesStarted) {
            this.m_allServicesStarted = true;
            this.start();
        }
    }

    @Override
    public synchronized void stop(boolean immediately) {
        if (this.m_isEnabled) {
            this.m_isEnabled = false;
            this.jmsQueue.stop();
            this.jobReceiver.stop();
            this.taskCleanUp.stop();
            if (m_isHistoryEnabled && WriteFinalHistoryService.useWriteFinalHistoryService) {
                TSE.trace("TSE_WFH: Stopping WriteFinalHistoryService");
                this.writeFinalHistoryService.stop(immediately);
                TSE.trace("TSE_WFH: WriteFinalHistoryService Stopped");
            }
            this.m_resourceCapacityManager.stop(immediately);
            if (m_isHistoryEnabled) {
                HistoryConsistencyThread.getInstance().stop();
            }
            TSE.getInstance().stop(immediately);
            this.m_pager_contexts.stop();
        }
    }

    @Override
    public void configure(Configuration configuration) {
        TaskQueueMetrics.getInstance().configure();
        this.m_pager_contexts.configure();
        this.m_resourceCapacityManager.configure();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialize(RequestReporter reporter) {
        TaskQueueMetrics.getInstance().initPersistedMetrics();
    }

    @Override
    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    public void compose_impl() throws PogoException {
    }

    @Override
    public synchronized void resume() {
        this.start();
    }

    public void suspend(boolean immediately) {
        this.jmsQueue.stop();
        this.jobReceiver.stop();
        this.taskCleanUp.stop();
        if (m_isHistoryEnabled) {
            HistoryConsistencyThread.getInstance().stop();
        }
        this.m_pager_contexts.stop();
    }

    @Override
    public void cancel() {
        try {
            this.m_resourceCapacityManager.cancel();
        }
        catch (LocalizableException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.EVENT_UNABLE_CANCEL);
        }
    }

    @Override
    public EventsResult cancelEvents(Event[] events, String userName) throws MonitorServiceException {
        EventsResult cer = new EventsResult();
        MonitorServiceException jse = null;
        for (int i = 0; i < events.length; ++i) {
            try {
                this.cancelSingleEvent(events[i], userName, cer);
                continue;
            }
            catch (MonitorServiceException e) {
                jse = e;
            }
        }
        if (jse != null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.EVENT_UNABLE_CANCEL);
            throw jse;
        }
        return cer;
    }

    private void cancelSingleEvent(Event event, String userName, EventsResult result) throws MonitorServiceException {
        try {
            boolean cancelled = TSE.getInstance().cancel(event.getEventId(), userName);
            if (cancelled) {
                result.addResult(EventResultType.CANCEL_SUCCEEDED, event);
            }
        }
        catch (TSEException ex) {
            this.trace("cancel error " + ex.getMessage());
            throw new MonitorServiceException(I18NCode.EVENT_UNABLE_CANCEL, ex.getCause());
        }
    }

    @Override
    public void cancelLocalEvent(String eventId, String userName, EventsResult result) throws MonitorServiceException {
        Event event = new Event(EventStatus.CANCELLED, EventId.valueOf(eventId));
        try {
            if (null != this.m_resourceCapacityManager.getTask(event.getEventId())) {
                if (this.m_resourceCapacityManager.cancel(event, userName)) {
                    result.addResult(EventResultType.CANCEL_SUCCEEDED, event);
                } else {
                    result.addResult(EventResultType.CANCEL_FAILED, event);
                }
            }
        }
        catch (MonitorServiceException ex) {
            this.trace("cancel error " + ex.getMessage());
            throw new MonitorServiceException(I18NCode.EVENT_UNABLE_CANCEL, (Throwable)((Object)ex));
        }
        catch (LocalizableException ex) {
            this.trace("cancel error " + ex.getMessage());
            throw new MonitorServiceException(I18NCode.EVENT_UNABLE_CANCEL, ex);
        }
    }

    private void validateFinishedEvent(Event event, EventStatus target) throws MonitorServiceException {
        String status;
        History history = CommonHistoryHelper.getHistoryFromCM((String)CMSearchPathGenerator.historyPath(event.getEventId()), (BiBusHeader)new BiBusHeader());
        try {
            if (history == null) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("MonitorService.validateFinishedEvent(...) Cannot update history status, history is null!");
                throw new MonitorServiceException(I18NCode.EVENT_ILLEGAL_TARGET_TRANS, new Object[]{target.statusName()});
            }
            status = history.getStatus() != null ? history.getStatus().getValue() : null;
        }
        catch (NullPointerException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)ex);
            throw new MonitorServiceException(I18NCode.EVENT_ILLEGAL_TARGET_TRANS, new Object[]{target.statusName()});
        }
        if (status != null) {
            EventStatus current = EventStatus.valueOf((String)status);
            EventTransition.validate(current, target);
        }
    }

    @Override
    public int suspendEvents(Event[] events, String user) throws MonitorServiceException {
        int held = 0;
        MonitorServiceException mse = null;
        for (int i = 0; i < events.length; ++i) {
            try {
                held += this.suspendSingleEvent(events[i], user) ? 1 : 0;
                continue;
            }
            catch (MonitorServiceException e) {
                mse = e;
            }
        }
        if (mse != null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.FATAL, I18NCode.EVENT_UNABLE_HOLD);
            throw mse;
        }
        return held;
    }

    private boolean suspendSingleEvent(Event event, String userName) throws MonitorServiceException {
        boolean cancelled = false;
        try {
            cancelled = TSE.getInstance().suspend(event.getEventId(), userName);
            if (!cancelled) {
                this.validateFinishedEvent(event, EventStatus.SUSPENDED);
            }
        }
        catch (TSEException ex) {
            this.trace("hold error " + ex.getMessage());
            throw new MonitorServiceException(I18NCode.EVENT_UNABLE_HOLD, ex.getCause());
        }
        return cancelled;
    }

    @Override
    public int releaseEvents(Event[] events, String userName) throws MonitorServiceException {
        int released = 0;
        MonitorServiceException mse = null;
        for (int i = 0; i < events.length; ++i) {
            try {
                released += this.releaseSingleEvent(events[i], userName) ? 1 : 0;
                continue;
            }
            catch (MonitorServiceException e) {
                mse = e;
            }
        }
        if (mse != null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.FATAL, I18NCode.EVENT_UNABLE_RESCHEDULE);
            throw mse;
        }
        return released;
    }

    private boolean releaseSingleEvent(Event event, String userName) throws MonitorServiceException {
        boolean released = false;
        try {
            released = TSE.getInstance().resume(event.getEventId(), userName);
        }
        catch (TSEException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Monitor release error " + ex.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.FATAL, I18NCode.EVENT_UNABLE_RESCHEDULE);
            throw new MonitorServiceException(I18NCode.EVENT_UNABLE_RESCHEDULE, ex.getCause());
        }
        if (!released) {
            this.validateFinishedEvent(event, EventStatus.PENDING);
        }
        return released;
    }

    private void enableCleanup() {
        String doCleanup = null;
        try {
            doCleanup = CRNProperties.getInstance().getProperty("autorecover.startup");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (doCleanup == null || !doCleanup.equalsIgnoreCase("false")) {
            TSE.getInstance().doCleanup();
        }
    }

    public void updateEvents(EventRecord eventRecord) throws RemoteException {
        try {
            TaskRecord task = TaskPersistLayer.getTaskFromEventId((String)eventRecord.getEventID());
            TaskPriorityChangedCmd priorityCmd = null;
            if (task != null) {
                priorityCmd = new TaskPriorityChangedCmd(task, eventRecord);
                TSEStateMapProcessor.getInstance().queueCmdAndWait(priorityCmd);
            }
        }
        catch (TaskPersistLayerException e) {
            throw AxisFault.makeFault((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notify(MonitorServiceEventID id, String status, JobBiBusHeaders headers) throws MonitorServiceException {
        boolean check;
        TaskHistoryDetailRecord detail;
        TaskStateRecord tsr;
        TaskRecord task;
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"MonitorService.notify");
        if (id == null) throw new MonitorServiceException(MonitorI18NCode.MSG_MS_EVENT_ID_INVALID);
        if (id.getEventID() == null) throw new MonitorServiceException(MonitorI18NCode.MSG_MS_EVENT_ID_INVALID);
        if (id.getStepID() <= 0) throw new MonitorServiceException(MonitorI18NCode.MSG_MS_EVENT_ID_INVALID);
        if (!TaskID.isTSEID((String)id.getEventID())) {
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_EVENT_ID_INVALID);
        }
        String idStr = id.getEventID();
        int stepId = id.getStepID();
        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify called. EventID: " + idStr + " stepId: " + stepId);
        EventStatusInfo statusInfo = new EventStatusInfo(status);
        if (statusInfo.getEventStatus() == null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify statusInfo.getEventStatus() == null for EventID: " + idStr + " stepId: " + stepId);
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_TASK_BAD_STATUS, new Object[]{id.getEventID()});
        }
        TaskStatus theStatus = TaskStatus.mapStatus((EventStatus)statusInfo.getEventStatus());
        if (!TaskStatus.isValidForNotify((TaskStatus)theStatus)) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify !TaskStatus.isValidForNotify(theStatus) for EventID: " + idStr + " stepId: " + stepId + " status: " + theStatus);
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_TASK_BAD_STATUS, new Object[]{id.getEventID()});
        }
        try {
            task = TaskPersistLayer.getTaskFromEventId((String)id.getEventID());
            if (task != null) {
                if (statusInfo.getEventStatus().equals((Object)EventStatus.TERMINATED)) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify status is terminated (cancelling) for EventID: " + idStr + " stepId: " + stepId + " status: " + theStatus);
                    UserAccountUtil uau = new UserAccountUtil(headers);
                    String userName = uau.getUserName();
                    TaskRunContext trc = TaskRunContextFactory.getRootParentTaskRunContext(task);
                    trc.getTaskRecord().getRunSpec().cancelledBy = userName;
                    Event event = new Event(EventStatus.TERMINATED, trc.getEventId());
                    this.cancelEvents(new Event[]{event}, userName);
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify status is terminated (cancel processing complete - return) for EventID: " + idStr + " stepId: " + stepId + " status: " + theStatus);
                    return;
                }
                tsr = TaskStateRecord.findRecord((TaskID)task.getTaskId());
                detail = new TaskHistoryDetailRecord(task.getTaskId());
                if (MonitorService.deleteNotifiedHistoryDetails()) {
                    detail.deleteRecord(id.getStepID());
                } else {
                    detail.setStatus(id.getStepID(), theStatus.getId());
                }
            } else {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("Notify received for unknown task. eventID [" + idStr + "]" + " stepId [" + stepId + " Status[" + status + "]");
                return;
            }
            check = true;
        }
        catch (TSEException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("TSEException MonitorService.notify. ID [" + idStr + "]" + " stepId [" + stepId + " Status[" + status + "]");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (Throwable)ex);
            new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR_WRAPPER, ex);
            return;
        }
        catch (TaskPersistLayerException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("TaskPersistLayerException MonitorService.notify. ID [" + idStr + "]" + " stepId [" + stepId + " Status[" + status + "]");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR_WRAPPER, ex);
            return;
        }
        finally {
            zipiTimer.stop();
        }
        while (check) {
            int countInactive;
            check = false;
            if (tsr.status.equals((Object)TaskStatus.INACTIVE)) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state is inactive for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status);
                countInactive = detail.countByStatus(TaskStatus.INACTIVE.getId());
                if (countInactive == 0) {
                    TaskRunContext trc = null;
                    try {
                        trc = TaskRunContextFactory.createTaskRunContext(task.getTaskId());
                    }
                    catch (TSEException e) {
                        throw new TaskPersistLayerException((Exception)e);
                    }
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state update the modcount failed (inactive block - queuing TaskRunNotifyInactiveCmd) for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status + " countInactive: " + countInactive);
                    TaskRunNotifyInactiveCmd cmd = new TaskRunNotifyInactiveCmd(statusInfo, trc, headers.getLocale());
                    TSEStateMapProcessor.getInstance().queueCmdAndWait(cmd);
                    continue;
                }
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state update the modcount failed (inactive block - inactive count > 0) for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status + " countInactive: " + countInactive);
                continue;
            }
            if (!tsr.status.isTerminatingStatus()) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state is not inactive and not terminating for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status);
                if (TaskStateRecord.updateStatus((TaskID)task.getTaskId(), (TaskStatus)tsr.status, (TaskStatus)tsr.status, (int)tsr.modCount) > 0) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state updated the modcount (do no more) for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status);
                    continue;
                }
                if (tsr.find(tsr.taskID)) {
                    countInactive = detail.countByStatus(TaskStatus.INACTIVE.getId());
                    if (countInactive == 0) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state update the modcount failed (rechecking) for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status);
                        check = true;
                        continue;
                    }
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state update the modcount failed (no recheck as inactive count > 0) for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status + " countInactive: " + countInactive);
                    continue;
                }
                SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify state update the modcount failed (no recheck) for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status);
                continue;
            }
            SDSLogger.getLogger((SDSCategory)MonitorCategory.AUDIT).debug("MonitorService.notify do nothing - state is terminating for EventID: " + idStr + " stepId: " + stepId + " status: " + tsr.status);
        }
    }

    private static boolean deleteNotifiedHistoryDetails() {
        boolean flag = false;
        try {
            String deleteNotifiedHistoryDetails = CRNProperties.getInstance().getProperty("delete.notified.history.details");
            if (deleteNotifiedHistoryDetails != null && deleteNotifiedHistoryDetails.trim().equalsIgnoreCase("true")) {
                flag = true;
            }
        }
        catch (Exception ex) {
            String msg = "Unable to load the value of the property DELETE_NOTIFIED_HISTORY_DETAILS";
            TSE.trace(msg);
        }
        return flag;
    }

    public ResourceCapacityManager getResourceCapacityManager() {
        return this.m_resourceCapacityManager;
    }

    @Override
    public MonitorContextMap getMonitorContextMap() {
        return this.m_pager_contexts;
    }

    private void trace(String msg) {
        SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug((Object)this, msg);
    }
}

