/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMessages;
import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.FaultDetail;
import com.cognos.developer.schemas.bibus._3.FaultDetailMessage;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.serverinst.InstanceUtil;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskQueueStatus;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.impl.BaseMonitorable;
import com.cognos.monitor.impl.state.IRecordable;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.BiBusRunMonitorableAdapter;
import com.cognos.monitor.tse.TSEException;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class MonitorableObject
extends BaseMonitorable
implements IRecordable {
    private AsynchRequest m_backgroundRequest = null;
    private BiBusRunMonitorableAdapter m_tseTask;
    private SearchPathSingleObject m_path;
    static ConcurrentLinkedQueue<Timestamp> retryFailureCount = new ConcurrentLinkedQueue();
    private boolean m_runImmediate = false;

    public MonitorableObject(BiBusRunMonitorableAdapter task, SearchPathSingleObject path, ParameterValue[] parameters, Option[] options, Attachment[] attachments, JobBiBusHeaders header, boolean runImmediate) throws RemoteException {
        super(task.getEventId(), parameters, MonitorableObject.optionsNeedCleanup(task, options) ? OptionUtils.cleanupRunOptionsSeparator((Option[])options) : options, attachments, header);
        this.m_path = path;
        this.m_tseTask = task;
        this.m_runImmediate = runImmediate;
    }

    private static boolean optionsNeedCleanup(BiBusRunMonitorableAdapter task, Option[] options) {
        return options == null ? null : Boolean.valueOf(!task.getServiceName().equalsIgnoreCase("agentService") && !task.getServiceName().equalsIgnoreCase("jobService") && OptionUtils.idxRunOptionsSeparator((Option[])options) < options.length);
    }

    public MonitorableObject(BiBusRunMonitorableAdapter task, AsynchRequest request, Attachment[] attachments, JobBiBusHeaders header, boolean runImmediate) throws RemoteException {
        this(task, request.getObjectPath(), request.getParameters(), request.getOptions(), attachments, header, runImmediate);
        this.m_backgroundRequest = request;
    }

    @Override
    public ServiceAPI getService() throws SDSServiceException {
        return Client.instance().getServiceAPI(this.m_header, this.getServiceName());
    }

    public SearchPathSingleObject getSearchPath() {
        return this.m_path;
    }

    public void setRoutingServerGroup() throws SDSServiceException {
        if (this.m_path != null) {
            BiBusUtilities.setRoutingServerGroup((SearchPathSingleObject)this.m_path, (JobBiBusHeaders)this.m_header);
        }
    }

    private TaskID getTaskId() {
        TaskID taskId = null;
        TaskRecord taskRecord = null;
        if (this.m_tseTask != null && (taskRecord = this.m_tseTask.getTaskRecord()) != null) {
            taskId = taskRecord.getTaskId();
        }
        return taskId;
    }

    private String generateLogMessage(String msg, String methodName) {
        String mName = "";
        if (methodName != null) {
            mName = methodName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" TASK:LOG:START: OBJECT=MonitorableObject : METHOD=");
        sb.append(mName);
        sb.append(" : EVENTID=");
        if (this.getId() != null) {
            sb.append(this.getId().getGuid());
        }
        sb.append(" : DISPATCHER=");
        String dispatcherPath = this.getDispatcherPath();
        if (dispatcherPath != null) {
            sb.append(dispatcherPath);
        }
        sb.append(" : PROCESSID=");
        if (this.getProcessId() != null) {
            sb.append(this.getProcessId());
        }
        sb.append(" : TASKID=");
        sb.append(this.getTaskId());
        sb.append(" : PATH=");
        sb.append(this.m_path);
        sb.append(" : MSG=");
        sb.append(msg);
        sb.append(" : TASK:LOG:END");
        return sb.toString();
    }

    private Object getProcessId() {
        if (this.m_tseTask != null && this.m_tseTask.getTaskRecord() != null) {
            return this.m_tseTask.getTaskRecord().getProcessId();
        }
        return null;
    }

    private String getDispatcherPath() {
        if (this.m_tseTask != null && this.m_tseTask.getTaskRecord() != null) {
            String dispatcherId = this.m_tseTask.getTaskRecord().getDispatcherId();
            if (dispatcherId == null) {
                return null;
            }
            try {
                return InstanceUtil.getDispatcherPath((ContentManagerServiceClientPort)this.getCmPort(), (String)dispatcherId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public AsynchReply run() throws MonitorServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AsynchReply resetFaultedTasktoRerun(TaskRecord record, Exception e) {
        AsynchReply targetReply = null;
        try {
            record.setTimeStamp(new Date().getTime());
            record.setProcessId(0);
            record.setDispatcherId(null);
            record.setSdsInstanceId(null);
            record.setStatus(TaskQueueStatus.READY);
            try {
                int queryServiceWaitTime = CRNProperties.getProperty((String)"ms.queryservice.wait.time", (int)10);
                this.getRTLogger().debug("wait for some time in MonitorableObject, give time to busy service :" + queryServiceWaitTime);
                TimeUnit.SECONDS.sleep(queryServiceWaitTime);
            }
            catch (InterruptedException queryServiceWaitTime) {
                // empty catch block
            }
            record.update(new String[]{"DATE_ENTERED", "HISTORY_STORE_ID", "DISPATCHER_ID", "PROCESS_ID", "STATUS", "SDS_INSTANCE_ID"});
            this.getRTLogger().debug("Task record reset done in MonitorableObject");
            targetReply = this.addAsynchDetailEventID(new AsynchReply());
            AsynchDetailMessages dei = new AsynchDetailMessages();
            FaultDetail fd = new FaultDetail();
            FaultDetailMessage fdm = new FaultDetailMessage();
            fdm.setMessage("retry will occur in a bit as we got busy signal from query service" + e.getMessage());
            fd.setMessage(new FaultDetailMessage[]{fdm});
            dei.setMessages(new FaultDetail[]{fd});
            targetReply.setDetails((AsynchDetail[])new AsynchDetailMessages[]{dei});
            targetReply.setStatus(AsynchReplyStatusEnum.complete);
            return targetReply;
        }
        catch (TaskPersistLayerException e1) {
            this.getRTLogger().debug("Task record failed the reset");
            return targetReply;
        }
    }

    private boolean hasQueryServiceBusyFaultCodeinException(SDKClientException e) {
        String[] errorMsgs = e.getMessages();
        String[] faultCodesList = this.getRecoverableErrors();
        if (faultCodesList == null) {
            faultCodesList = new String[]{"XQE-GEN-0028", "XQE-GEN-0029"};
        }
        for (int i = 0; i < errorMsgs.length; ++i) {
            String errmsg = errorMsgs[i];
            if (!this.checkErrorCode(errmsg, faultCodesList)) continue;
            return true;
        }
        this.getRTLogger().debug("Monitor service retry fault code list:" + faultCodesList);
        return false;
    }

    private boolean checkErrorCode(String errmsg, String[] errCode) {
        for (int i = 0; i < errCode.length; ++i) {
            if (!errmsg.contains(errCode[i])) continue;
            this.getRTLogger().debug("Monitor service retry fault code detected:" + errCode[i]);
            return true;
        }
        return false;
    }

    private synchronized boolean shallRetry() {
        this.removeOlderEntries();
        return retryFailureCount.size() <= this.getRetryMaximumPerPeriod();
    }

    private void removeOlderEntries() {
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        long tenMinBefore = timestamp.getTime() - (long)this.getRetryPeriod();
        Iterator<Timestamp> iter = retryFailureCount.iterator();
        while (iter.hasNext()) {
            Timestamp s = iter.next();
            if (s.getTime() >= tenMinBefore) continue;
            iter.remove();
        }
    }

    private synchronized void addFailureCount() {
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        retryFailureCount.add(timestamp);
    }

    private int getRetryMaximumPerPeriod() {
        int retryMaximumPeriod = 3;
        try {
            int newValue;
            String configValue = CRNProperties.getInstance().getProperty("retry.max.per.period.ms");
            if (configValue != null && (newValue = Integer.valueOf(configValue).intValue()) > 0) {
                retryMaximumPeriod = newValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return retryMaximumPeriod;
    }

    private int getRetryMaximum() {
        int retry = 10;
        try {
            int newValue;
            String configValue = CRNProperties.getInstance().getProperty("retry.max.ms");
            if (configValue != null && (newValue = Integer.valueOf(configValue).intValue()) > 0) {
                retry = newValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return retry;
    }

    private String[] getRecoverableErrors() {
        String[] ret = null;
        try {
            String errors = CRNProperties.getInstance().getProperty("retry.errors");
            if (errors != null) {
                ret = errors.split(",");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private int getRetryPeriod() {
        int retry = 600000;
        try {
            int newValue;
            String configValue = CRNProperties.getInstance().getProperty("retry.period.ms");
            if (configValue != null && (newValue = Integer.valueOf(configValue).intValue()) > 0) {
                retry = newValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return retry;
    }

    private AsynchReply doWorkWithRetry(ServiceAPI service, SearchPathSingleObject m_path, ParameterValue[] params, Option[] options) throws Exception {
        int maxRetryCount;
        Exception ret = null;
        AsynchReply asyncReply = null;
        int retryCount = maxRetryCount = this.getRetryMaximum();
        String exception = "";
        boolean shallRetry = this.shallRetry();
        if (this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) {
            this.getRTLogger().debug(this.generateLogMessage("JSM retry settings: shallRetryV2=" + String.valueOf(shallRetry) + ", maxRetryCount=" + String.valueOf(maxRetryCount), "doWorkWithRetry() "));
        }
        while (retryCount > 0) {
            try {
                asyncReply = service.run(m_path, params, options);
                if (retryCount == maxRetryCount || !this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) break;
                this.getRTLogger().debug(this.generateLogMessage("JSM retry is sucessful", "doWorkWithRetry()"));
                break;
            }
            catch (Exception e) {
                ret = e;
                if (!shallRetry) break;
                exception = e.getMessage();
                if (this.isRecoverableError(exception)) {
                    --retryCount;
                    this.addFailureCount();
                    if (this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) {
                        this.getRTLogger().debug(this.generateLogMessage("JSM retry count: " + String.valueOf(retryCount) + "  " + exception, "doWorkWithRetry()"));
                    }
                    try {
                        Thread.sleep(5000 * (maxRetryCount - retryCount));
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) {
                    this.getRTLogger().debug(this.generateLogMessage("JSM retry skip, no-recoverable exception: " + String.valueOf(retryCount) + "  " + exception, "doWorkWithRetry()"));
                }
                throw e;
            }
        }
        if (asyncReply == null && ret != null) {
            if (this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) {
                this.getRTLogger().debug(this.generateLogMessage("JSM retry failed when retry is set to " + String.valueOf(shallRetry), "doWorkWithRetry() "));
            }
            throw ret;
        }
        return asyncReply;
    }

    private boolean isRecoverableError(String exception) {
        boolean ret = false;
        String[] errors = this.getRecoverableErrors();
        if (errors == null || exception == null) {
            if (this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) {
                this.getRTLogger().debug(this.generateLogMessage("JSM retry both errors or exception are null", "isRecoverableError()"));
                if (errors == null) {
                    this.getRTLogger().debug(this.generateLogMessage("JSM retry errors is null ", "isRecoverableError()"));
                }
                if (exception == null) {
                    this.getRTLogger().debug(this.generateLogMessage("JSM retry exception is null ", "isRecoverableError()"));
                }
            }
            return ret;
        }
        for (String error : errors) {
            if (this.getRTLogger().isLoggingAt(SDSLevel.DEBUG)) {
                this.getRTLogger().debug(this.generateLogMessage("JSM retry isRecoverableError compare: " + error + "<-->" + exception, "isRecoverableError()"));
            }
            if (!exception.contains(error.trim())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public String getServiceName() {
        return this.m_tseTask.getServiceName();
    }

    @Override
    protected IRecordable getStateRecorder() {
        return this;
    }

    @Override
    protected void runPostConversationCommands(AsynchReply reply) throws TSEException {
        this.m_tseTask.runPostConversationCommands(reply);
    }

    public void addHistoryLocationOption() throws RemoteException {
        String historyPath = null;
        historyPath = this.m_tseTask.getHistoryPath();
        if (historyPath != null) {
            Option[] options = this.getOptions();
            AsynchOptionSearchPathSingleObject historyAsynchOption = null;
            for (int i = 0; historyAsynchOption == null && i < options.length; ++i) {
                AsynchOption asynchOption;
                if (!(options[i] instanceof AsynchOption) || !AsynchOptionEnum.historyLocation.equals((Object)(asynchOption = (AsynchOption)options[i]).getName())) continue;
                historyAsynchOption = (AsynchOptionSearchPathSingleObject)options[i];
            }
            SearchPathSingleObject historySPSO = new SearchPathSingleObject();
            historySPSO.set_value(historyPath);
            if (historyAsynchOption == null) {
                historyAsynchOption = new AsynchOptionSearchPathSingleObject();
                historyAsynchOption.setName(AsynchOptionEnum.historyLocation);
                historyAsynchOption.setValue(historySPSO);
                this.addOption((Option)historyAsynchOption);
            } else {
                historyAsynchOption.setValue(historySPSO);
            }
        }
    }

    public String toString() {
        return this.m_path != null ? this.m_path.get_value() : super.toString();
    }

    @Override
    public void update(EventStatus status) throws RecordableException {
        try {
            if (this.m_tseTask != null) {
                this.m_tseTask.updateTaskStatus(status);
            }
        }
        catch (TSEException ex) {
            this.getRTLogger().log(SDSLevel.ERROR, (Throwable)ex);
            throw new RecordableException(I18NCode.EVENT_UPDATE_ERROR);
        }
    }

    @Override
    public void update(I18NCode detail, Object[] params, EventStatus status, SeverityEnum sevEnum) throws RecordableException {
        try {
            if (this.m_tseTask != null) {
                this.m_tseTask.updateTaskStatus(status, detail, params, sevEnum);
            }
        }
        catch (TSEException ex) {
            this.getRTLogger().log(SDSLevel.ERROR, (Throwable)ex);
            throw new RecordableException(I18NCode.EVENT_UPDATE_ERROR);
        }
    }
}

