/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Attachment;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.BaseMonitorable;
import com.cognos.monitor.impl.state.IRecordable;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.sds.event.EventIdUtil;
import java.rmi.RemoteException;

public class MonitorableSpecification
extends BaseMonitorable
implements IRecordable {
    private AsynchSpecification m_specification;
    private AsynchRequest m_backgroundRequest = null;

    public MonitorableSpecification(AsynchSpecification specification, ParameterValue[] parameters, Option[] options, Attachment[] attachments, JobBiBusHeaders header) throws RemoteException, SDSServiceException {
        super(EventIdUtil.createEventId(), parameters, options, attachments, header);
        this.m_specification = specification;
    }

    public MonitorableSpecification(AsynchRequest request, Attachment[] attachments, JobBiBusHeaders header) throws RemoteException, SDSServiceException {
        this(request.getSpecification()[0], request.getParameters(), request.getOptions(), attachments, header);
        this.m_backgroundRequest = request;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AsynchReply run() throws MonitorServiceException {
        AsynchReply targetReply;
        ServiceAPI service;
        block19: {
            service = null;
            targetReply = null;
            if (!this.isCancelled()) break block19;
            this.updateRecord(MonitorI18NCode.MSG_MS_PURGED, new Object[0], EventStatus.PURGED, SeverityEnum.warn);
            targetReply = this.addAsynchDetailEventID(new AsynchReply());
            targetReply.setStatus(AsynchReplyStatusEnum.conversationComplete);
            this.getRTLogger().log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Task cancelled before execution started."});
            AsynchReply asynchReply = targetReply;
            ThreadProperties.setProperty((String)"asynchDetailEventID", (String)this.getId().toXMLString());
            if (service != null) {
                service.close();
            }
            if (this.logOffWhenDone()) {
                BiBusHeader h = this.getBiBusHeader();
                try {
                    AuthenticatorFactory.getInstance().logoff(h);
                }
                catch (EMFSecurityException e1) {
                    String passport = h.getCAM().getCAMPassport().getId();
                    this.getRTLogger().debug("Could not logoff passport " + passport);
                }
            }
            this.getRTLogger().log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Task [" + this.toString() + "] finished."});
            return asynchReply;
        }
        try {
            this.updateRecord(null, null, EventStatus.EXECUTING, SeverityEnum.info);
            JobBiBusHeaders headers = new JobBiBusHeaders(this.getBiBusHeader());
            service = Client.instance().getServiceAPI(headers, this.m_specification);
            service.setLogCategory(MonitorCategory.RUNTIME);
            service.setAttachments(this.getAttachments());
            targetReply = this.m_backgroundRequest == null ? service.runSpecification(this.m_specification, this.getParameters(), this.getOptions()) : service.wait(this.m_backgroundRequest, this.getParameters(), this.getOptions());
            targetReply = this.doConversation(service, targetReply);
            targetReply = this.addAsynchDetailEventID(targetReply);
        }
        catch (LocalizableException e) {
            try {
                this.updateRecord(e.getI18NCode(), e.getParams(), EventStatus.FAILED, e.getSeverity());
                this.getRTLogger().log(SDSLevel.ERROR, e);
                MonitorServiceException mse = new MonitorServiceException(null, e);
                throw mse;
                catch (EMFSecurityException e2) {
                    this.updateRecord(EventStatus.FAILED);
                    this.getRTLogger().debug((Throwable)e2);
                    mse = new MonitorServiceException(MonitorI18NCode.MSG_MS_ERROR_TARGET_SERVICE);
                    throw mse;
                }
                catch (Throwable e3) {
                    this.updateRecord(EventStatus.FAILED);
                    String message = this.getThrowableMessage(e3);
                    this.getRTLogger().debug(message);
                    MonitorServiceException mse2 = new MonitorServiceException(MonitorI18NCode.MSG_MS_ERROR_TARGET_SERVICE);
                    throw mse2;
                }
            }
            catch (Throwable throwable) {
                ThreadProperties.setProperty((String)"asynchDetailEventID", (String)this.getId().toXMLString());
                if (service != null) {
                    service.close();
                }
                if (this.logOffWhenDone()) {
                    BiBusHeader h = this.getBiBusHeader();
                    try {
                        AuthenticatorFactory.getInstance().logoff(h);
                    }
                    catch (EMFSecurityException e1) {
                        String passport = h.getCAM().getCAMPassport().getId();
                        this.getRTLogger().debug("Could not logoff passport " + passport);
                    }
                }
                this.getRTLogger().log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Task [" + this.toString() + "] finished."});
                throw throwable;
            }
        }
        ThreadProperties.setProperty((String)"asynchDetailEventID", (String)this.getId().toXMLString());
        if (service != null) {
            service.close();
        }
        if (this.logOffWhenDone()) {
            BiBusHeader h = this.getBiBusHeader();
            try {
                AuthenticatorFactory.getInstance().logoff(h);
            }
            catch (EMFSecurityException e1) {
                String passport = h.getCAM().getCAMPassport().getId();
                this.getRTLogger().debug("Could not logoff passport " + passport);
            }
        }
        this.getRTLogger().log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Task [" + this.toString() + "] finished."});
        return targetReply;
    }

    @Override
    protected IRecordable getStateRecorder() {
        return this;
    }

    public AsynchSpecification getSpecification() {
        return this.m_specification;
    }

    @Override
    public ServiceAPI getService() throws SDSServiceException {
        return null;
    }

    @Override
    public void update(EventStatus status) throws RecordableException {
    }

    @Override
    public void update(I18NCode detail, Object[] params, EventStatus status, SeverityEnum sevEnum) throws RecordableException {
    }

    @Override
    protected void runPostConversationCommands(AsynchReply reply) {
    }
}

