/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.monitor.MonitorCategory;

public class ReauthenticateUtil {
    private static long MAX_TIME_ON_QUEUE_BEFORE_MANDATORY_REAUTHENTICATION = 600000L;

    private ReauthenticateUtil() {
    }

    public static boolean doReauthenticate(long idleTimeInMillis, CRNProperties crnProperties) {
        boolean reauthenticate = true;
        try {
            String value = crnProperties.getProperty("ms.reauthenticate.queue.entry");
            if (null == value || value != null && Boolean.FALSE.equals(Boolean.valueOf(value))) {
                reauthenticate = false;
            }
        }
        catch (PropertiesException e1) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("PropertiesException retrieving property [ms.reauthenticate.queue.entry] will not use reauthentication");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e1);
        }
        if (!reauthenticate) {
            long maxTimeOut = MAX_TIME_ON_QUEUE_BEFORE_MANDATORY_REAUTHENTICATION;
            try {
                String value = crnProperties.getProperty("inactivityTimeout");
                if (value != null) {
                    maxTimeOut = Long.parseLong(value) * 1000L / 2L;
                }
            }
            catch (PropertiesException e1) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("PropertiesException retrieving property [ms.reauthenticate.queue.entry] will not use reauthentication");
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e1);
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Using default MAX_TIME_ON_QUEUE_BEFORE_MANDATORY_REAUTHENTICATION: " + MAX_TIME_ON_QUEUE_BEFORE_MANDATORY_REAUTHENTICATION);
            }
            if (idleTimeInMillis > maxTimeOut) {
                reauthenticate = true;
            }
        }
        return reauthenticate;
    }
}

