/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.impl.state;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRelatedHistory;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRequestArguments;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXMLProp;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.HistoryUpdateTrustedChecker;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.impl.state.RecordableException;
import com.cognos.monitor.tse.TSE;
import com.cognos.pogo.pdk.Tracking;
import com.cognos.sds.event.EventTransition;
import com.cognos.sds.event.IEventId;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class HistoryRecord
implements Serializable {
    private static final long serialVersionUID = 70009003L;
    private SearchPathSingleObject m_parentPath;
    private String m_parentID;
    private JobBiBusHeaders m_header;
    private History m_history = null;
    private boolean m_useTrusted = false;
    private BaseClass m_baseClass = null;
    private EventStatus m_currentStatus = null;
    private Account m_userAccount;
    private String m_restartID;

    public HistoryRecord(SearchPathSingleObject parentPath, String parentID, JobBiBusHeaders headers) {
        this(parentPath, parentID, headers, null);
    }

    public HistoryRecord(SearchPathSingleObject parentPath, String parentID, String restartId, JobBiBusHeaders headers, Account userAccount) {
        this.m_parentPath = parentPath;
        this.m_parentID = parentID;
        if (headers != null) {
            BiBusHeader header = BiBusUtilities.getDeepCopy((BiBusHeader)headers.getBiBusHeader());
            this.m_header = new JobBiBusHeaders(header);
        }
        this.m_userAccount = userAccount;
        this.m_restartID = restartId;
    }

    public HistoryRecord(SearchPathSingleObject parentPath, String parentID, JobBiBusHeaders headers, Account userAccount) {
        this(parentPath, parentID, null, headers, userAccount);
    }

    public HistoryRecord(History history, JobBiBusHeaders headers) {
        this.m_history = history;
        if (headers != null) {
            BiBusHeader header = BiBusUtilities.getDeepCopy((BiBusHeader)headers.getBiBusHeader());
            this.m_header = new JobBiBusHeaders(header);
        }
        this.m_parentID = history.getOwnerEventID() != null ? history.getOwnerEventID().getValue() : null;
        this.m_restartID = history.getRestartEventID() != null ? history.getRestartEventID().getValue() : null;
        String statusStr = history.getStatus().getValue();
        this.m_currentStatus = EventStatus.valueOf((String)statusStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(IEventId id, EventStatus status) throws RecordableException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryRecord.create");
        try {
            this.m_currentStatus = status;
            ContentManagerServiceClientPort cmPort = this.getCmPort();
            CAM cam = cmPort.getBiBusHeader().getCAM();
            try {
                if (!this.m_useTrusted) {
                    try {
                        HistoryUpdateTrustedChecker checker = new HistoryUpdateTrustedChecker(this.m_header.getBiBusHeader());
                        if (!this.m_useTrusted) {
                            this.m_useTrusted = checker.determineTrustedFlagState(this.m_parentPath.get_value());
                        }
                        if (this.m_useTrusted) {
                            this.signNextRequest(cmPort);
                            cmPort.getBiBusHeader().setCAM(null);
                        }
                        this.m_baseClass = ObjectModelUtil.getBaseClass((ContentManagerServiceClientPort)cmPort, (SearchPathSingleObject)this.m_parentPath, (PropEnum[])ObjectModelUtil.PERMISSSION_PROPS);
                        if (this.m_baseClass == null) {
                            String resolvedPath = this.existsInCM(this.m_parentPath.get_value());
                            if (resolvedPath != null) {
                                String userId = new UserAccountUtil(this.m_header).getUserName();
                                this.createHistory(cmPort, id, EventStatus.FAILED);
                                this.addErrorDetail(I18NCode.MSG_EXECUTE_PERMISSIONS_ERROR, new Object[]{userId, resolvedPath});
                                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to create histoty, no access to object found at [" + this.m_parentPath + "].");
                                throw new RecordableException(I18NCode.MSG_EXECUTE_PERMISSIONS_ERROR, new Object[]{userId, resolvedPath});
                            }
                            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to create histoty, no base class for object found at [" + this.m_parentPath + "].");
                            throw new RecordableException(I18NCode.MSG_JOB_RUNNABLE_MISSING);
                        }
                        if (!AuthenticatorFactory.getInstance().hasPermissions(this.m_baseClass, new String[]{"execute"})) {
                            String userId = new UserAccountUtil(this.m_header).getUserName();
                            String parentSearchPath = this.m_baseClass.getSearchPath().getValue();
                            this.createHistory(cmPort, id, EventStatus.FAILED);
                            this.addErrorDetail(I18NCode.MSG_EXECUTE_PERMISSIONS_ERROR, new Object[]{userId, parentSearchPath});
                            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to execute task, current user does not have execute permissions on object at path [" + this.m_parentPath + "].");
                            throw new RecordableException(I18NCode.MSG_EXECUTE_PERMISSIONS_ERROR, new Object[]{userId, parentSearchPath});
                        }
                    }
                    catch (SDKClientException e) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Error retrieving base class with searchPath [" + this.m_parentPath + "].");
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
                        throw new RecordableException(I18NCode.MSG_JOB_RUNNABLE_MISSING, (LocalizableException)((Object)e));
                    }
                    catch (EMFSecurityException e) {
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Error retrieving base class with searchPath [" + this.m_parentPath + "].");
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(e.getLocalizedMessage());
                        throw new RecordableException(I18NCode.MSG_JOB_RUNNABLE_MISSING);
                    }
                }
                this.createHistory(cmPort, id, status);
            }
            finally {
                if (cmPort != null) {
                    cmPort.getBiBusHeader().setCAM(cam);
                    cmPort.close();
                }
            }
        }
        finally {
            zipiTimer.stop();
        }
    }

    private void createHistory(ContentManagerServiceClientPort cmPort, IEventId id, EventStatus status) throws RecordableException {
        block10: {
            this.m_history = this.buildHistory(id, status);
            AddOptions options = new AddOptions();
            options.setDataEncoding(EncodingEnum.MIME);
            options.setUpdateAction(UpdateActionEnum.replace);
            options.setReturnProperties(new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.defaultName, PropEnum.eventID, PropEnum.restartEventID, PropEnum.requestedExecutionTime, PropEnum.status, PropEnum.actualExecutionTime});
            if (EventStatus.EXECUTING.equals((Object)status)) {
                DateTimeProp time = HistoryRecord.getDateTimeProp(new Date());
                this.m_history.setActualExecutionTime(time);
            }
            CAM cam = cmPort.getBiBusHeader().getCAM();
            if (this.m_useTrusted) {
                this.signNextRequest(cmPort);
                cmPort.getBiBusHeader().setCAM(null);
            }
            try {
                BaseClass[] objects = cmPort.add(this.m_parentPath, new BaseClass[]{this.m_history}, options);
                if (objects != null && objects.length == 1 && objects[0] instanceof History) {
                    this.m_history = (History)objects[0];
                    this.addRelatedHistory(cmPort);
                    break block10;
                }
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to create history object for base class with searchPath [" + this.m_parentPath + "].");
                this.update(EventStatus.FAILED);
                throw new RecordableException(I18NCode.MSG_UNABLE_CREATE_HISTORY);
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to create history object for base class with searchPath [" + this.m_parentPath + "].");
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
                throw new RecordableException(I18NCode.MSG_UNABLE_CREATE_HISTORY, (LocalizableException)((Object)e));
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to create history object for base class with searchPath [" + this.m_parentPath + "].");
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug(e.getLocalizedMessage());
                throw new RecordableException(I18NCode.MSG_UNABLE_CREATE_HISTORY);
            }
            finally {
                if (cmPort != null) {
                    cmPort.getBiBusHeader().setCAM(cam);
                }
            }
        }
    }

    public void addInfoDetail(I18NCode code, Object[] params) throws RecordableException {
        BaseHistoryDetail detail = HistoryRecord.makeDetail(code, params, SeverityEnum.info, this.getHeaders());
        if (detail != null) {
            this.addDetail(detail);
        }
    }

    public void addRequestArgumentsDetail(Option[] options, ParameterValue[] parameterValues) throws RecordableException {
        this.addDetail(HistoryRecord.makeDetail(options, parameterValues));
    }

    public void addErrorDetail(I18NCode code, Object[] params) throws RecordableException {
        BaseHistoryDetail detail = HistoryRecord.makeDetail(code, params, SeverityEnum.error, this.getHeaders());
        if (detail != null) {
            this.addDetail(detail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetail(BaseHistoryDetail detail) throws RecordableException {
        block8: {
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryRecord.addDetail");
            try {
                if (this.m_history == null) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to update history as no history has been created yet.");
                    throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
                }
                try {
                    this.doAddDetail(detail);
                }
                catch (SDKClientException e) {
                    if (this.existsInCM(this.m_history.getSearchPath().getValue()) != null) {
                        this.doTrustedAddDetail(detail);
                        break block8;
                    }
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to add the history detail to the history.");
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
                    throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY, (LocalizableException)((Object)e));
                }
                catch (EMFSecurityException e) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to add the history detail to the history.");
                    throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
                }
            }
            finally {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(EventStatus status) throws RecordableException {
        block9: {
            ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryRecord.update");
            try {
                if (this.m_history == null) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Unable to update history as no history has been created yet.");
                    throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
                }
                if (status == null) break block9;
                try {
                    this.doUpdateStatus(status);
                }
                catch (SDKClientException e) {
                    if (this.m_history.getSearchPath() != null && this.existsInCM(this.m_history.getSearchPath().getValue()) != null) {
                        if (this.isTerminatingStatus(status)) {
                            this.doTrustedUpdate(status);
                            break block9;
                        }
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[SDKClientException] Unable to add the history detail to the history.");
                        SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
                        throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY, (LocalizableException)((Object)e));
                    }
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[SDKClientException] Unable to add the history detail to the history." + this.m_parentID + " searchPath unavailable.");
                    throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY, (LocalizableException)((Object)e));
                }
                catch (EMFSecurityException e) {
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + e.getMessage());
                    SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[EMFSecurityException] Unable to add the history detail to the history.");
                    throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
                }
            }
            finally {
                zipiTimer.stop();
            }
        }
    }

    public JobBiBusHeaders getHeaders() {
        return this.m_header;
    }

    private void doTrustedUpdate(EventStatus status) throws RecordableException {
        this.m_useTrusted = true;
        try {
            this.doUpdateStatus(status);
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[SDKClientException] Unable to add the history detail to the history.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY, (LocalizableException)((Object)ex));
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + ex.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[EMFSecurityException] Unable to add the history detail to the history.");
            throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
        }
    }

    private void doTrustedAddDetail(BaseHistoryDetail detail) throws RecordableException {
        this.m_useTrusted = true;
        try {
            this.doAddDetail(detail);
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[SDKClientException] Unable to add the history detail to the history.");
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)ex));
            throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY, (LocalizableException)((Object)ex));
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + ex.getMessage());
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[EMFSecurityException] Unable to add the history detail to the history.");
            throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
        }
    }

    private boolean isTerminatingStatus(EventStatus status) {
        return EventStatus.CANCELLED.equals((Object)status) || EventStatus.FAILED.equals((Object)status) || EventStatus.PURGED.equals((Object)status) || EventStatus.SUCCEEDED.equals((Object)status) || EventStatus.TERMINATED.equals((Object)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doUpdateStatus(EventStatus status) throws SDKClientException, EMFSecurityException {
        if (status.equals((Object)this.m_currentStatus)) {
            return;
        }
        try {
            EventTransition.validate(this.m_currentStatus, status);
        }
        catch (MonitorServiceException ex) {
            return;
        }
        History updateHistory = new History();
        updateHistory.setSearchPath(this.m_history.getSearchPath());
        updateHistory.setStoreID(this.m_history.getStoreID());
        DateTimeProp actualExecuting = null;
        DateTimeProp actualCompletion = null;
        if (EventStatus.EXECUTING.equals((Object)status)) {
            actualExecuting = HistoryRecord.getDateTimeProp(new Date());
            updateHistory.setActualExecutionTime(actualExecuting);
        } else if (EventStatus.SUCCEEDED.equals((Object)status) || EventStatus.CANCELLED.equals((Object)status) || EventStatus.PURGED.equals((Object)status) || EventStatus.TERMINATED.equals((Object)status) || EventStatus.FAILED.equals((Object)status)) {
            actualCompletion = HistoryRecord.getDateTimeProp(new Date());
            updateHistory.setActualCompletionTime(actualCompletion);
        }
        NmtokenProp statusProp = new NmtokenProp();
        statusProp.setValue(status.statusName());
        updateHistory.setStatus(statusProp);
        ContentManagerServiceClientPort cmPort = this.getCmPort();
        CAM cam = cmPort.getBiBusHeader().getCAM();
        try {
            if (this.m_useTrusted) {
                this.signNextRequest(cmPort);
                cmPort.getBiBusHeader().setCAM(null);
            }
            cmPort.update(new BaseClass[]{updateHistory}, new UpdateOptions());
            this.m_currentStatus = status;
            this.m_history.setStatus(statusProp);
            if (actualExecuting != null) {
                this.m_history.setActualExecutionTime(actualExecuting);
            }
            if (actualCompletion != null) {
                this.m_history.setActualCompletionTime(actualCompletion);
            }
        }
        finally {
            if (cmPort != null) {
                cmPort.getBiBusHeader().setCAM(cam);
                cmPort.close();
            }
        }
    }

    public static BaseHistoryDetail makeDetail(Option[] options, ParameterValue[] parameterValues) {
        HistoryDetailRequestArguments hdra = new HistoryDetailRequestArguments();
        hdra.setDetailTime(HistoryRecord.getDateTimeProp(new Date()));
        hdra.setOptions(ObjectModelUtil.makeOptionArrayProp((Option[])options));
        hdra.setParameters(ObjectModelUtil.makeParameterArrayProp((ParameterValue[])parameterValues));
        return hdra;
    }

    public static BaseHistoryDetail makeDetail(I18NCode code, Object[] params, SeverityEnum severityEnum, JobBiBusHeaders headers) {
        if (code == null) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("HistoryRecord.addDetail - message code is null (add ignored)");
            return null;
        }
        SeverityEnumProp severity = new SeverityEnumProp();
        severity.setValue(severityEnum);
        Locale locale = headers.getProductLocale();
        String detailMessage = I18NUtil.getMessage((I18NCode)code, (Object[])params, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
        HistoryDetail detail = HistoryRecord.buildDetail(detailMessage);
        detail.setSeverity(severity);
        return detail;
    }

    public static History buildHistory(TaskRecord task, StringProp parentID) {
        History history = new History();
        IEventId eventId = null;
        String restartEventId = null;
        if (task.getRestartId() == null) {
            eventId = TSE.getInstance().getEventId(task.getTaskId());
        } else {
            eventId = TSE.getInstance().getEventId(task.getRestartId());
            restartEventId = TSE.getInstance().getEventId(task.getTaskId()).toXMLString();
        }
        history.setSearchPath(HistoryRecord.getStringProp("storeID('" + task.getTaskStoreId() + "')"));
        history.setActualCompletionTime(task.getActualCompletionTime() > 0L ? HistoryRecord.getDateTimeProp(new Date(task.getActualCompletionTime())) : null);
        history.setActualExecutionTime(task.getActualExecutionTime() > 0L ? HistoryRecord.getDateTimeProp(new Date(task.getActualExecutionTime())) : null);
        history.setDefaultName(HistoryRecord.getTokenProp(eventId.toXMLString()));
        history.setDispatcherID(HistoryRecord.getGuidProp(task.getDispatcherId()));
        if (restartEventId != null) {
            history.setRestartEventID(ObjectModelUtil.makeStringProp((String)restartEventId));
        }
        history.setEventID(HistoryRecord.getStringProp(eventId.toXMLString()));
        history.setScheduleTriggerName(HistoryRecord.getStringProp(task.getScheduleTriggerName()));
        String scheduleType = task.getScheduleType();
        if (scheduleType != null) {
            NmtokenProp typeProp = new NmtokenProp();
            typeProp.setValue(scheduleType);
            history.setScheduleType(typeProp);
        }
        Account account = new Account();
        account.setSearchPath(HistoryRecord.getStringProp(task.getAccountPath()));
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        bcap.setValue(new BaseClass[]{account});
        history.setOwner(bcap);
        history.setUser(bcap);
        history.setTenantID(HistoryRecord.getStringProp(task.getTenantId()));
        if (parentID != null) {
            history.setOwnerEventID(parentID);
        }
        history.setRequestedExecutionTime(HistoryRecord.getDateTimeProp(new Date(task.getTimeStamp())));
        try {
            NmtokenProp prop = new NmtokenProp();
            TaskStateRecord tsr = new TaskStateRecord();
            tsr.find(task.getTaskId());
            prop.setValue(TaskStatus.mapStatus((TaskStatus)tsr.status).statusName());
            history.setStatus(prop);
        }
        catch (TaskPersistLayerException taskPersistLayerException) {
            // empty catch block
        }
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddDetail(BaseHistoryDetail detail) throws SDKClientException, EMFSecurityException {
        ContentManagerServiceClientPort cmPort = this.getCmPort();
        CAM cam = cmPort.getBiBusHeader().getCAM();
        try {
            if (this.m_useTrusted) {
                this.signNextRequest(cmPort);
                cmPort.getBiBusHeader().setCAM(null);
            }
            cmPort.add(new SearchPathSingleObject(this.m_history.getSearchPath().getValue()), new BaseClass[]{detail}, new AddOptions());
        }
        finally {
            if (cmPort != null) {
                cmPort.getBiBusHeader().setCAM(cam);
                cmPort.close();
            }
        }
    }

    public History getHistory() {
        return this.m_history;
    }

    public BaseClass getBaseClass() {
        return this.m_baseClass;
    }

    public void setUseTrusted(boolean useTrusted) {
        this.m_useTrusted = useTrusted;
    }

    public EventStatus getStatus() {
        return this.m_currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryDetail[] readHistoryDetails(String storeID) throws RecordableException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryRecord.readHistoryDetails");
        try {
            ContentManagerServiceClientPort cmPort = this.getCmPort();
            CAM cam = cmPort.getBiBusHeader().getCAM();
            BaseClass[] objs = null;
            try {
                if (this.m_useTrusted) {
                    this.signNextRequest(cmPort);
                    cmPort.getBiBusHeader().setCAM(null);
                }
                SearchPathMultipleObject sp = new SearchPathMultipleObject("storeID(\"" + storeID + "\")/historyDetail");
                objs = cmPort.query(sp, new PropEnum[]{PropEnum.detail}, new Sort[0], new QueryOptions());
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + e.getMessage());
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[SDKClientException] Unable to query the history detail.");
                throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + e.getMessage());
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[EMFSecurityException] Unable to query the history detail.");
                throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
            }
            finally {
                if (cmPort != null) {
                    cmPort.getBiBusHeader().setCAM(cam);
                    cmPort.close();
                }
            }
            if (objs == null) {
                HistoryDetail[] e = null;
                return e;
            }
            HistoryDetail[] details = new HistoryDetail[objs.length];
            System.arraycopy(objs, 0, details, 0, objs.length);
            HistoryDetail[] historyDetailArray = details;
            return historyDetailArray;
        }
        finally {
            zipiTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public History readHistory(String storeID) throws RecordableException {
        History history = null;
        ZipiTimer zipiTimer = ZipiBridge.startTimer((String)"HistoryRecord.readHistory");
        try {
            ContentManagerServiceClientPort cmPort = this.getCmPort();
            CAM cam = cmPort.getBiBusHeader().getCAM();
            BaseClass[] objs = null;
            try {
                SearchPathMultipleObject sp;
                if (this.m_useTrusted) {
                    this.signNextRequest(cmPort);
                    cmPort.getBiBusHeader().setCAM(null);
                }
                if ((objs = cmPort.query(sp = new SearchPathMultipleObject("storeID(\"" + storeID + "\")"), new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.defaultName, PropEnum.eventID, PropEnum.restartEventID, PropEnum.requestedExecutionTime, PropEnum.status, PropEnum.actualExecutionTime, PropEnum.maximumDetailSeverity}, new Sort[0], new QueryOptions())) != null && objs.length == 1) {
                    history = (History)objs[0];
                }
            }
            catch (SDKClientException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + e.getMessage());
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[SDKClientException] Unable to query the history.");
                throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
            }
            catch (EMFSecurityException e) {
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Security error: " + e.getMessage());
                SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("[EMFSecurityException] Unable to query the history.");
                throw new RecordableException(I18NCode.MSG_UNABLE_UPDATE_HISTORY);
            }
            finally {
                if (cmPort != null) {
                    cmPort.getBiBusHeader().setCAM(cam);
                    cmPort.close();
                }
            }
        }
        finally {
            zipiTimer.stop();
        }
        return history;
    }

    private History buildHistory(IEventId id, EventStatus status) {
        DateTimeProp requested = HistoryRecord.getDateTimeProp(new Date());
        NmtokenProp statusProp = new NmtokenProp();
        statusProp.setValue(status.statusName());
        History history = new History();
        history.setEventID(ObjectModelUtil.makeStringProp((String)id.toXMLString()));
        history.setRestartEventID(ObjectModelUtil.makeStringProp((String)this.m_restartID));
        history.setRequestedExecutionTime(requested);
        history.setStatus(statusProp);
        String dispatcherID = Tracking.getInstance().getRequestIDBaseName();
        history.setDispatcherID(ObjectModelUtil.makeGuidProp((String)dispatcherID));
        if (this.m_parentID != null) {
            history.setOwnerEventID(ObjectModelUtil.makeStringProp((String)this.m_parentID));
        }
        if (this.m_userAccount != null) {
            BaseClass[] bc = new BaseClass[]{this.m_userAccount};
            BaseClassArrayProp bcap = new BaseClassArrayProp();
            bcap.setValue(bc);
            history.setUser(bcap);
        }
        return history;
    }

    private static TokenProp getTokenProp(String value) {
        TokenProp prop = new TokenProp();
        prop.setValue(value);
        return prop;
    }

    private static StringProp getStringProp(String value) {
        StringProp prop = new StringProp();
        prop.setValue(value);
        return prop;
    }

    private static GuidProp getGuidProp(String value) {
        GuidProp prop = new GuidProp();
        Guid guid = new Guid();
        guid.set_value(value);
        prop.setValue(guid);
        return prop;
    }

    private static DateTimeProp getDateTimeProp(Date date) {
        DateTimeProp dtp = new DateTimeProp();
        dtp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)date));
        return dtp;
    }

    private static HistoryDetail buildDetail(String detail) {
        HistoryDetail historyDetail = new HistoryDetail();
        if (detail != null) {
            StringProp stringProp = new StringProp();
            stringProp.setValue(detail);
            historyDetail.setDetail(stringProp);
        }
        Date detailTime = new Date();
        DateTimeProp detailTimeProp = new DateTimeProp();
        detailTimeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)detailTime));
        historyDetail.setDetailTime(detailTimeProp);
        return historyDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelatedHistory(ContentManagerServiceClientPort cmPort) throws SDKClientException, EMFSecurityException {
        if (this.m_parentID == null) {
            return;
        }
        HistoryDetailRelatedHistory historyDetail = this.buildRelatedHistory(null, null);
        String parentHistorySearchPath = "//history[@eventID='" + this.m_parentID + "']";
        HistoryUpdateTrustedChecker checker = new HistoryUpdateTrustedChecker(this.m_header.getBiBusHeader());
        if (!this.m_useTrusted) {
            this.m_useTrusted = checker.determineTrustedFlagState(parentHistorySearchPath);
        }
        CAM cam = cmPort.getBiBusHeader().getCAM();
        if (this.m_useTrusted) {
            this.signNextRequest(cmPort);
            cmPort.getBiBusHeader().setCAM(null);
        }
        AddOptions options = new AddOptions();
        options.setIgnoreInvalidObjectReference(true);
        try {
            cmPort.add(new SearchPathSingleObject(parentHistorySearchPath), new BaseClass[]{historyDetail}, options);
        }
        catch (SDKClientException e) {
            if (this.existsInCM(parentHistorySearchPath) != null) {
                throw e;
            }
        }
        finally {
            cmPort.getBiBusHeader().setCAM(cam);
        }
    }

    private HistoryDetailRelatedHistory buildRelatedHistory(String detail, Date detailTime) {
        HistoryDetailRelatedHistory historyDetail = new HistoryDetailRelatedHistory();
        if (detail != null) {
            XmlEncodedXML xmlEncodedDetail = new XmlEncodedXML(detail);
            XmlEncodedXMLProp xmlEncodedDetailProp = new XmlEncodedXMLProp();
            xmlEncodedDetailProp.setValue(xmlEncodedDetail);
        }
        if (detailTime == null) {
            detailTime = new Date();
        }
        DateTimeProp detailTimeProp = new DateTimeProp();
        detailTimeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)detailTime));
        historyDetail.setDetailTime(detailTimeProp);
        BaseClass[] baseClassArray = new BaseClass[]{this.m_history};
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        bcap.setValue(baseClassArray);
        historyDetail.setRelated(bcap);
        return historyDetail;
    }

    private ContentManagerServiceClientPort getCmPort() {
        ContentManagerServiceClientPort port = Client.instance().getContentManagerServiceClient(this.m_header);
        port.setLogCategory(MonitorCategory.RUNTIME);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String existsInCM(String searchPath) {
        String path = null;
        ContentManagerServiceClientPort cmPort = this.getCmPort();
        CAM cam = cmPort.getBiBusHeader().getCAM();
        try {
            PropEnum[] props = new PropEnum[]{PropEnum.searchPath};
            cmPort.getBiBusHeader().setCAM(null);
            this.signNextRequest(cmPort);
            BaseClass[] baseClasses = cmPort.query(new SearchPathMultipleObject(searchPath), props, null, new QueryOptions());
            if (baseClasses != null && baseClasses.length >= 1) {
                path = baseClasses[0].getSearchPath() != null ? baseClasses[0].getSearchPath().getValue() : null;
            }
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("HistoryRecord.existsInCM(" + searchPath + ") - CM query threw an SDKClientException: " + e.getLocalizedMessage());
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("HistoryRecord.existsInCM(" + searchPath + ") - CM query threw a EMFSecurityException: " + e.getLocalizedMessage());
        }
        finally {
            if (cmPort != null) {
                cmPort.getBiBusHeader().setCAM(cam);
                cmPort.close();
            }
        }
        return path;
    }

    private void signNextRequest(ContentManagerServiceClientPort cmPort) {
        cmPort.signNextRequest("JSM", false);
    }
}

