/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.paging;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.HistoryDetailReportService;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.NmtokenProp;
import com.cognos.developer.schemas.bibus._3.NonNegativeIntegerProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.jdbc.AbstractFactory;
import com.cognos.jsmcommon.jdbc.JDBCConnection;
import com.cognos.jsmcommon.jdbc.NCConnection;
import com.cognos.jsmcommon.jdbc.props.DatabaseType;
import com.cognos.jsmcommon.jdbc.props.JDBCConnectionProperties;
import com.cognos.jsmcommon.jdbc.util.SqlResourceCloser;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.security.UserIdentity;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskHistoryDetailRecord;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.paging.QueryStatistics;
import com.cognos.sds.util.SQL.SQLCalculatedTableItem;
import com.cognos.sds.util.SQL.SQLJoin;
import com.cognos.sds.util.SQL.SQLOrQueryFilter;
import com.cognos.sds.util.SQL.SQLQueryBuilder;
import com.cognos.sds.util.SQL.SQLQueryFilter;
import com.cognos.sds.util.SQL.SQLQueryOperatorFilter;
import com.cognos.sds.util.SQL.SQLSort;
import com.cognos.sds.util.SQL.SQLTableItem;
import com.cognos.spec.queryEvent.castor.Filters;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import com.cognos.spec.queryEvent.castor.Scope;
import com.cognos.spec.queryEvent.castor.SearchPaths;
import com.cognos.spec.queryEvent.castor.Sort;
import com.cognos.spec.queryEvent.castor.SubSort;
import com.cognos.spec.queryEvent.castor.types.DetailSeverityEnum;
import com.cognos.spec.queryEvent.castor.types.OrderEnum;
import com.cognos.spec.queryEvent.castor.types.PriorityEnum;
import com.cognos.spec.queryEvent.castor.types.ScheduleTypeEnum;
import com.cognos.spec.queryEvent.castor.types.SortEnum;
import com.cognos.spec.queryEvent.castor.types.StatusEnum;
import com.cognos.spec.queryEvent.castor.types.SubSortEnum;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MonitorQueueQuery {
    private static final int RS_IDS_ONLY = 1;
    private static final int RS_PATHSCOPE = 2;
    private static final int RS_EVENTSCOPE = 3;
    private static final int RS_CHILDSCOPE = 4;
    private static final String SELECT = "SELECT ";
    private static final String SEVERITY_ITEM = " SEVERITY.SEVERITY_MAX ";
    private static final String TASKS_DERIVED_TABLE_NAME = "TASKS";
    private static final String STATIC_SQL_PART2 = ") AS TASKS LEFT OUTER JOIN (SELECT NC_TASK_HISTORY_DETAIL.TASK_ID AS TASKID, MAX(NC_TASK_HISTORY_DETAIL.SEVERITY) AS SEVERITY_MAX FROM NC_TASK_HISTORY_DETAIL GROUP BY NC_TASK_HISTORY_DETAIL.TASK_ID ) AS SEVERITY ON TASKS.TASK_ID = SEVERITY.TASKID";
    private static final String STATIC_SQL_PART1_ORA = ") TASKS, (SELECT NC_TASK_HISTORY_DETAIL.TASK_ID AS TASKID, MAX(NC_TASK_HISTORY_DETAIL.SEVERITY) AS SEVERITY_MAX FROM NC_TASK_HISTORY_DETAIL";
    private static final String STATIC_SQL_PART2_ORA = " GROUP BY NC_TASK_HISTORY_DETAIL.TASK_ID ) SEVERITY WHERE TASKS.TASK_ID = SEVERITY.TASKID(+)";
    private int m_rsSize = 1;
    private AbstractFactory m_connectionFactory = null;
    private JDBCConnection m_connection = null;
    private PreparedStatement m_statement = null;
    private ResultSet m_rs = null;
    private QueryEventSpecification m_queryEventSpec = null;
    private SQLQueryBuilder m_builder = null;
    private SQLQueryBuilder m_Ora10gBuilder = null;
    private QueryStatistics m_queryStatistics = new QueryStatistics();
    private long m_queryTime;
    private Map m_knownAccounts = new HashMap();
    private JobBiBusHeaders m_headers = null;
    private boolean m_isOra10gDb = false;
    private boolean m_useOra10gSQL = true;
    private DatabaseType m_databaseType = null;
    private boolean m_isInactiveTaskCleanup = false;

    private String makeOracleQueryWrapperSqlPart(Map<String, Object> params) {
        Iterator<SQLQueryFilter> filterIter;
        StringBuffer oraWrapperSql = new StringBuffer(STATIC_SQL_PART1_ORA);
        if (this.useOra10gSQL() && this.m_Ora10gBuilder != null && (filterIter = this.m_Ora10gBuilder.getSelectedFilters().iterator()).hasNext()) {
            oraWrapperSql.append(" WHERE ");
            this.m_Ora10gBuilder.addFilterSql(oraWrapperSql, params);
        }
        oraWrapperSql.append(STATIC_SQL_PART2_ORA);
        return oraWrapperSql.toString();
    }

    public MonitorQueueQuery(QueryEventSpecification specification) throws SQLException {
        this(specification, NCConnection.instance().getOpenCloseFactory(), null);
    }

    public MonitorQueueQuery(QueryEventSpecification specification, AbstractFactory connectionFactory, DatabaseType type) throws SQLException {
        this.m_connectionFactory = connectionFactory;
        this.m_databaseType = type;
        this.m_queryTime = new Date().getTime();
        this.m_queryEventSpec = specification;
        this.m_connection = this.getConnection();
        this.getAdvProp();
        this.initQueryBuilder();
        this.m_queryStatistics.setCount(TaskStatus.PAUSED, 0);
        this.m_queryStatistics.setCount(TaskStatus.PENDING, 0);
        this.m_queryStatistics.setCount(TaskStatus.RUNNING, 0);
    }

    protected void initQueryBuilder() {
        this.m_builder = new SQLQueryBuilder(new String[]{NC_TASK_QUEUE.TABLE_NAME, NC_TSE_STATE_MAP.TABLE_NAME, NC_TASK_ANCESTORS.TABLE_NAME});
        this.m_builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASK_QUEUE.TASK_ID), new SQLTableItem(NC_TSE_STATE_MAP.TASK_ID)));
        this.m_builder.addSupportedJoin(new SQLJoin(new SQLTableItem(NC_TASK_QUEUE.TASK_ID), new SQLTableItem(NC_TASK_ANCESTORS.TASK_ID)));
        if (this.useOra10gSQL()) {
            this.m_Ora10gBuilder = new SQLQueryBuilder(new String[]{NC_TASK_HISTORY_DETAIL.TABLE_NAME});
        }
    }

    public void setOra10gDB(boolean isOra10g) {
        this.m_isOra10gDb = isOra10g;
    }

    private void getAdvProp() {
        try {
            String str = CRNProperties.getInstance().getProperty("oracle.extra.filters");
            if (str != null && str.trim().length() > 0) {
                this.m_useOra10gSQL = Boolean.valueOf(str);
            }
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug((Throwable)e);
        }
    }

    public boolean useOra10gSQL() {
        return this.m_isOra10gDb && this.m_useOra10gSQL;
    }

    public void executeQuery(JobBiBusHeaders headers) throws SQLException {
        this.m_headers = headers;
        this.buildStatistics();
        SqlResourceCloser.closeResources((ResultSet)this.m_rs, (Statement)this.m_statement);
        this.m_builder.reset();
        if (this.useOra10gSQL()) {
            this.m_Ora10gBuilder.reset();
        }
        this.setQuerySize();
        this.executeQuery();
    }

    public void setQuerySize() {
        if (this.m_isInactiveTaskCleanup || this.m_queryEventSpec.getScope() == null || this.m_queryEventSpec.getScope().getSearchPaths() != null) {
            this.m_rsSize = 2;
        } else if (this.m_queryEventSpec.getScope().getParentEventID() != null || this.m_queryEventSpec.getScope().getRestartParentEventID() != null) {
            this.m_rsSize = 4;
        } else if (this.m_queryEventSpec.getScope().getEventID() != null || this.m_queryEventSpec.getScope().getRestartEventID() != null) {
            this.m_rsSize = 3;
        }
    }

    public QueryStatistics getStatistics() {
        return this.m_queryStatistics;
    }

    private void buildStatistics() throws SQLException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> orderedParamKeys = new ArrayList<String>();
        String paramSql = this.buildStatisticsSql(params, orderedParamKeys);
        this.m_statement = this.m_connection.prepareStatement(paramSql, 1004, 1007);
        SQLQueryBuilder.fillPreparedStatementParameters(params, orderedParamKeys, this.m_statement);
        this.m_rs = this.m_statement.executeQuery();
        while (this.m_rs.next()) {
            int number = this.m_rs.getInt(1);
            int statusEnum = this.m_rs.getInt(2);
            int execCount = this.m_rs.getInt(3);
            TaskStatus taskStatus = TaskStatus.fromId((byte)((byte)statusEnum));
            this.m_queryStatistics.updateCount(taskStatus, number, execCount);
        }
    }

    public String buildStatisticsSql(HashMap params, ArrayList orderedParamKeys) {
        SQLCalculatedTableItem countItem = new SQLCalculatedTableItem(NC_TSE_STATE_MAP.TABLE_NAME, NC_TSE_STATE_MAP.STATUS, 1);
        this.m_builder.addSelectedItem(countItem);
        this.m_builder.addSelectedItem(new SQLTableItem(NC_TSE_STATE_MAP.STATUS));
        this.m_builder.addSelectedItem(new SQLTableItem(NC_TSE_STATE_MAP.EXECUTING));
        if (!this.m_isInactiveTaskCleanup) {
            this.setFilters(false);
        }
        this.m_builder.addGroupBy(new SQLTableItem(NC_TSE_STATE_MAP.STATUS));
        this.m_builder.addGroupBy(new SQLTableItem(NC_TSE_STATE_MAP.EXECUTING));
        String sql = this.m_builder.getSQL(params);
        return SQLQueryBuilder.buildSQLAndCollectParams(sql, params, orderedParamKeys);
    }

    protected void executeQuery() throws SQLException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> orderedParamKeys = new ArrayList<String>();
        String paramSql = this.buildExecuteSql(params, orderedParamKeys);
        this.m_statement = this.m_connection.prepareStatement(paramSql, 1004, 1007);
        SQLQueryBuilder.fillPreparedStatementParameters(params, orderedParamKeys, this.m_statement);
        this.m_rs = this.m_statement.executeQuery();
    }

    public String buildExecuteSql(HashMap params, ArrayList orderedParamKeys) {
        boolean SORT_BY_SEQ = false;
        switch (this.m_rsSize) {
            case 3: {
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TSE_STATE_MAP.PARENT_ID));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.SCHEDULE_TRIGGER_NAME));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.SCHEDULE_TYPE));
            }
            case 4: {
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.ACTUAL_EXECUTION_TIME));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.ACTUAL_COMPLETION_TIME));
            }
            case 2: {
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.PRIORITY));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TSE_STATE_MAP.EXECUTING));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TSE_STATE_MAP.STATUS));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TSE_STATE_MAP.SEQ));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.ACCOUNT_PATH));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.DATE_ENTERED));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.DISPATCHER_ID));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.PROCESS_ID));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.TENANT_ID));
                SORT_BY_SEQ = true;
            }
            case 1: {
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.TASK_ID));
                this.m_builder.addSelectedItem(new SQLTableItem(NC_TASK_QUEUE.STOREID));
            }
        }
        if (!this.m_isInactiveTaskCleanup) {
            this.setFilters(true);
        }
        this.m_builder.setDistinct(true);
        String sqlDerivedTable = this.m_builder.getSQL(params);
        StringBuffer buffer = new StringBuffer(SELECT);
        List selectedItems = this.m_builder.getSelectedItems();
        Iterator selectedItemsIter = selectedItems.iterator();
        if (selectedItemsIter.hasNext()) {
            buffer.append("TASKS.");
            buffer.append(((SQLTableItem)selectedItemsIter.next()).getColumnName() + " ");
        }
        while (selectedItemsIter.hasNext()) {
            buffer.append(", TASKS.");
            buffer.append(((SQLTableItem)selectedItemsIter.next()).getColumnName());
        }
        buffer.append(",  SEVERITY.SEVERITY_MAX ");
        buffer.append(" FROM (");
        buffer.append(sqlDerivedTable);
        DatabaseType using = this.getDBType();
        if (!DatabaseType.ORACLE.equals((Object)using)) {
            buffer.append(STATIC_SQL_PART2);
        } else {
            buffer.append(this.makeOracleQueryWrapperSqlPart(params));
        }
        if (!this.m_isInactiveTaskCleanup) {
            SQLSort sortSQL = this.getSortSQL(this.m_queryEventSpec.getSort(), TASKS_DERIVED_TABLE_NAME);
            buffer.append(" ORDER BY ");
            buffer.append(sortSQL.toString());
            if (SORT_BY_SEQ) {
                buffer.append(", TASKS.SEQ ASC");
            }
        }
        String sql = buffer.toString();
        return SQLQueryBuilder.buildSQLAndCollectParams(sql, params, orderedParamKeys);
    }

    private void setFilters(boolean filterByStatus) {
        Filters filters = this.m_queryEventSpec.getFilters();
        if (filters != null) {
            String ownerStoreID;
            SearchPaths searchPaths;
            String tenantID;
            String dispatcherID;
            PriorityEnum priorityRangeEnum;
            String scheduleTrigger;
            ScheduleTypeEnum scheduleType;
            String objectClass = filters.getObjectClass();
            if (objectClass != null && !objectClass.equalsIgnoreCase("any")) {
                this.addObjectClassFilter(objectClass);
            }
            if ((scheduleType = filters.getScheduleType()) != null && !scheduleType.toString().equalsIgnoreCase("any")) {
                this.addScheduleTypeFilter(scheduleType);
            }
            if ((scheduleTrigger = filters.getScheduleTrigger()) != null) {
                this.addScheduleTriggerFilter(scheduleTrigger);
            }
            if ((priorityRangeEnum = filters.getPriority()) != null) {
                this.addPriorityFilter(priorityRangeEnum);
            }
            if ((dispatcherID = filters.getDispatcherID()) != null) {
                this.addDispatcherIDFilter(dispatcherID);
            }
            if ((tenantID = filters.getTenantID()) != null) {
                this.addTenantIDFilters(new String[]{tenantID});
            }
            Scope scope = this.m_queryEventSpec.getScope();
            this.addEventIDScopeFilter(scope);
            StatusEnum status = filters.getStatus();
            this.addStatusFilter(status, filterByStatus);
            String user = filters.getUser();
            if (user != null) {
                this.addUserFilter(user);
            }
            SearchPaths searchPaths2 = searchPaths = scope != null ? scope.getSearchPaths() : null;
            if (searchPaths != null) {
                this.addAncestorStoreIDsFilter(searchPaths);
            }
            if ((ownerStoreID = filters.getOwner()) != null) {
                this.addOwnerFilter(ownerStoreID);
            }
            IAuthenticator authenticator = AuthenticatorFactory.getInstance();
            BiBusHeader busHeader = this.m_headers != null ? this.m_headers.getBiBusHeader() : null;
            try {
                UserIdentity userIdentity = authenticator.getUserIdentity(busHeader);
                if (userIdentity.doTenantFiltering()) {
                    this.addTenantIDFilters(userIdentity.getTenantIDsForFiltering());
                }
            }
            catch (Exception ex) {
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)ex);
            }
        }
    }

    public int numRows() throws SQLException {
        int numRows = 0;
        if (this.m_rs.last()) {
            numRows = this.m_rs.getRow();
        }
        this.m_rs.beforeFirst();
        return numRows;
    }

    public void absolute(int position) throws SQLException {
        this.m_rs.absolute(position);
    }

    public boolean next() throws SQLException {
        return this.m_rs.next();
    }

    public AsynchDetailEventRecord readRecord() throws SQLException {
        SubSortEnum sortEnum;
        AsynchDetailEventRecord record = new AsynchDetailEventRecord();
        History history = new History();
        TaskID taskID = null;
        TaskID parentID = null;
        GuidProp storeID = null;
        int rsColumn = 1;
        switch (this.m_rsSize) {
            case 3: {
                String idString = this.m_rs.getString(rsColumn);
                if (idString != null) {
                    parentID = new TaskID(idString);
                    String parentEventID = parentID.toEventId();
                    StringProp parentIDProp = new StringProp();
                    parentIDProp.setValue(parentEventID);
                    history.setOwnerEventID(parentIDProp);
                }
                String scheduleTrigger = this.m_rs.getString(++rsColumn);
                StringProp trigProp = new StringProp();
                trigProp.setValue(scheduleTrigger == null ? "" : scheduleTrigger);
                history.setScheduleTriggerName(trigProp);
                record.setScheduleTriggerName(scheduleTrigger);
                String scheduleType = this.m_rs.getString(++rsColumn);
                record.setScheduleType(scheduleType);
                if (scheduleType != null) {
                    NmtokenProp typeProp = new NmtokenProp();
                    typeProp.setValue(scheduleType);
                    history.setScheduleType(typeProp);
                }
                ++rsColumn;
            }
            case 4: {
                long compLong;
                long exLong = this.m_rs.getLong(rsColumn);
                if (exLong != 0L) {
                    Date exDate = new Date(exLong);
                    DateTimeProp exProp = new DateTimeProp();
                    exProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)exDate));
                    history.setActualExecutionTime(exProp);
                    long duration = this.m_queryTime - exDate.getTime();
                    record.setDuration(TimeUtils.getXsDuration((long)duration));
                }
                if ((compLong = this.m_rs.getLong(++rsColumn)) != 0L) {
                    Date compDate = new Date(compLong);
                    DateTimeProp compProp = new DateTimeProp();
                    compProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)compDate));
                    history.setActualCompletionTime(compProp);
                }
                ++rsColumn;
            }
            case 2: {
                int priority = this.m_rs.getInt(rsColumn);
                record.setPriority(priority);
                int executing = this.m_rs.getInt(++rsColumn);
                int status = this.m_rs.getInt(++rsColumn);
                TaskStatus taskStatus = TaskStatus.fromId((byte)((byte)status));
                taskStatus = TaskStateRecord.getActualStatus((TaskStatus)taskStatus, (int)executing);
                String eventStatusName = TaskStatus.mapStatus((TaskStatus)taskStatus).statusName();
                NmtokenProp statusProp = new NmtokenProp();
                statusProp.setValue(eventStatusName);
                history.setStatus(statusProp);
                record.setStatus(eventStatusName);
                ++rsColumn;
                String accountPath = this.m_rs.getString(++rsColumn);
                accountPath = accountPath == null ? null : accountPath.trim();
                record.setUser(new BaseClass[]{this.getAccount(accountPath)});
                Date qDate = new Date(this.m_rs.getLong(++rsColumn));
                DateTimeProp reqProp = new DateTimeProp();
                reqProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)qDate));
                record.setRequestedStartTime(TimeUtils.dateToUTCJavaCalendar((Date)qDate));
                history.setRequestedExecutionTime(reqProp);
                String dispatcherID = this.m_rs.getString(++rsColumn);
                GuidProp dispProp = new GuidProp();
                dispProp.setValue(new Guid(dispatcherID == null ? "" : dispatcherID));
                history.setDispatcherID(dispProp);
                int processID = this.m_rs.getInt(++rsColumn);
                record.setProcessID(processID);
                String tenantID = this.m_rs.getString(++rsColumn);
                record.setTenantID(tenantID);
                ++rsColumn;
            }
            case 1: {
                taskID = new TaskID(this.m_rs.getString(rsColumn));
                String eventID = taskID.toEventId();
                StringProp idProp = new StringProp();
                idProp.setValue(eventID);
                history.setEventID(idProp);
                record.setEventID(eventID);
                Guid guid = new Guid();
                guid.set_value(this.m_rs.getString(++rsColumn));
                storeID = new GuidProp();
                storeID.setValue(guid);
                ++rsColumn;
            }
        }
        int severity = this.m_rs.getInt(rsColumn);
        SeverityEnumProp sevProp1 = new SeverityEnumProp();
        sevProp1.setValue(TaskHistoryDetailRecord.getSeverityEnum((int)severity));
        history.setMaximumDetailSeverity(sevProp1);
        int position = this.m_rs.getRow();
        NonNegativeIntegerProp seqProp = new NonNegativeIntegerProp();
        seqProp.setValue(new BigInteger(new Integer(position).toString()));
        Nil runnable = new Nil();
        runnable.setStoreID(storeID);
        runnable.setPosition(seqProp);
        record.setRunnable(new BaseClass[]{runnable});
        record.setHistory((BaseClass[])new History[]{history});
        DetailSeverityEnum detailFilter = this.m_queryEventSpec.getFilters().getDetailSeverity();
        SeverityEnumProp sevProp2 = this.getSevProp(detailFilter);
        SubSort subSort = this.m_queryEventSpec.getSubSort();
        TaskHistoryDetailRecord.DetailTimeSorter detailTimeSorter = null;
        if (subSort != null && (sortEnum = subSort.getSortItem()) != null && sortEnum.equals(SubSortEnum.HISTORYDETAILS_DETAILTIME)) {
            OrderEnum orderEnum = subSort.getOrder();
            detailTimeSorter = orderEnum != null && orderEnum.equals(OrderEnum.DESCENDING) ? new TaskHistoryDetailRecord.DetailTimeSorter(false) : new TaskHistoryDetailRecord.DetailTimeSorter(true);
        }
        if (this.m_rsSize == 3) {
            try {
                TaskHistoryDetailRecord detailRetriever = new TaskHistoryDetailRecord(taskID, detailTimeSorter);
                BaseHistoryDetail[] details = detailRetriever.readAll(sevProp2);
                record.setHistoryDetails((BaseClass[])details);
            }
            catch (TaskPersistLayerException detailRetriever) {}
        } else if (this.m_rsSize == 4) {
            try {
                TaskHistoryDetailRecord detailRetriever = new TaskHistoryDetailRecord(taskID, detailTimeSorter);
                BaseHistoryDetail[] details = detailRetriever.readAll(sevProp2, HistoryDetailReportService.class);
                record.setHistoryDetails((BaseClass[])details);
            }
            catch (TaskPersistLayerException taskPersistLayerException) {
                // empty catch block
            }
        }
        return record;
    }

    private SeverityEnumProp getSevProp(DetailSeverityEnum detailFilter) {
        SeverityEnum severity = null;
        if (DetailSeverityEnum.DEBUG.equals(detailFilter)) {
            severity = SeverityEnum.debug;
        } else if (DetailSeverityEnum.INFO.equals(detailFilter)) {
            severity = SeverityEnum.info;
        } else if (DetailSeverityEnum.WARN.equals(detailFilter)) {
            severity = SeverityEnum.warn;
        } else if (DetailSeverityEnum.ERROR.equals(detailFilter)) {
            severity = SeverityEnum.error;
        } else if (DetailSeverityEnum.FATAL.equals(detailFilter)) {
            severity = SeverityEnum.fatal;
        }
        SeverityEnumProp sevProp = null;
        if (severity != null) {
            sevProp = new SeverityEnumProp();
            sevProp.setValue(severity);
        }
        return sevProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account getAccount(String accountPath) {
        Account account = (Account)this.m_knownAccounts.get(accountPath);
        if (account != null) {
            return account;
        }
        QueryRequest userDetailRequest = new QueryRequest();
        userDetailRequest.setSearch(accountPath);
        userDetailRequest.setProperties(new PropEnum[]{PropEnum.defaultName, PropEnum.userName, PropEnum.searchPath, PropEnum.storeID});
        userDetailRequest.setOptions(null);
        userDetailRequest.setSortBy(null);
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(this.m_headers);
            account = (Account)contentManager.query(userDetailRequest);
            this.m_knownAccounts.put(accountPath, account);
        }
        catch (SDKClientException sDKClientException) {
        }
        catch (EMFSecurityException eMFSecurityException) {
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        return account;
    }

    private void addObjectClassFilter(String objectClass) {
        if (objectClass.equalsIgnoreCase("any")) {
            return;
        }
        this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.OBJECT_CLASS), objectClass, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduleTypeFilter(ScheduleTypeEnum scheduleType) {
        this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.SCHEDULE_TYPE), scheduleType.toString(), SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addScheduleTriggerFilter(String scheduleTrigger) {
        this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.SCHEDULE_TRIGGER_NAME), scheduleTrigger, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addPriorityFilter(PriorityEnum priorityRangeEnum) {
        if (priorityRangeEnum == null || priorityRangeEnum.equals(PriorityEnum.ANY)) {
            return;
        }
        try {
            this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.PRIORITY), new Integer(priorityRangeEnum.toString()), SQLQueryOperatorFilter.FilterOperator.EQUALS));
        }
        catch (Exception e) {
            return;
        }
    }

    private void addDispatcherIDFilter(String dispatcherID) {
        this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.DISPATCHER_ID), dispatcherID, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addEventIDScopeFilter(Scope scope) {
        if (scope == null) {
            this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TSE_STATE_MAP.PARENT_ID), SQLQueryOperatorFilter.FilterOperator.IS_NULL));
        } else {
            String eventID;
            String parentID = scope.getParentEventID() == null ? scope.getRestartParentEventID() : scope.getParentEventID();
            String string = eventID = scope.getEventID() == null ? scope.getRestartEventID() : scope.getEventID();
            if (parentID != null) {
                this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TSE_STATE_MAP.PARENT_ID), TaskID.fromEventId((String)parentID).toString(), SQLQueryOperatorFilter.FilterOperator.EQUALS));
            } else if (eventID != null) {
                this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TSE_STATE_MAP.TASK_ID), TaskID.fromEventId((String)eventID).toString(), SQLQueryOperatorFilter.FilterOperator.EQUALS));
                if (this.useOra10gSQL()) {
                    this.m_Ora10gBuilder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_HISTORY_DETAIL.TASK_ID), TaskID.fromEventId((String)eventID).toString(), SQLQueryOperatorFilter.FilterOperator.EQUALS));
                }
            } else {
                this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TSE_STATE_MAP.PARENT_ID), SQLQueryOperatorFilter.FilterOperator.IS_NULL));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStoreIdsForSearchPaths(List<QueryRequest> pathRequests) {
        QueryReply[] pathReplies = null;
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(this.m_headers);
            pathReplies = contentManager.queryMultiple(pathRequests.toArray(new QueryRequest[pathRequests.size()]));
        }
        catch (SDKClientException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        catch (EMFSecurityException e) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug((Throwable)e);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        ArrayList<String> storeIDsList = new ArrayList<String>();
        for (int i = 0; i < pathReplies.length; ++i) {
            String storeID;
            BaseClass task;
            if (pathReplies[i].getQueryResult() == null || pathReplies[i].getQueryResult().length <= 0 || (task = pathReplies[i].getQueryResult()[0]).getStoreID() == null || task.getStoreID().getValue() == null || (storeID = task.getStoreID().getValue().get_value()) == null) continue;
            storeIDsList.add(storeID);
        }
        return storeIDsList;
    }

    private void addAncestorStoreIDsFilter(SearchPaths searchPaths) {
        ArrayList<String> searchPathsList = new ArrayList<String>();
        for (int i = 0; i < searchPaths.getSearchPath().length; ++i) {
            if (searchPaths.getSearchPath(i) == null) continue;
            searchPathsList.add(searchPaths.getSearchPath(i));
        }
        if (searchPathsList.size() == 0) {
            return;
        }
        ArrayList<QueryRequest> pathRequests = new ArrayList<QueryRequest>();
        Iterator iter = searchPathsList.iterator();
        while (iter.hasNext()) {
            QueryRequest request = new QueryRequest();
            request.setSearch((String)iter.next());
            request.setProperties(new PropEnum[]{PropEnum.storeID});
            pathRequests.add(request);
        }
        List<String> storeIDsList = this.getStoreIdsForSearchPaths(pathRequests);
        if (storeIDsList.size() == 0) {
            return;
        }
        Object[] storeIDStrings = new String[storeIDsList.size()];
        storeIDsList.toArray(storeIDStrings);
        SQLTableItem ancestorsStoreIDTableItem = new SQLTableItem(NC_TASK_ANCESTORS.ANCESTOR_STORE_ID);
        this.m_builder.addFilter(new SQLQueryOperatorFilter(ancestorsStoreIDTableItem, storeIDStrings, SQLQueryOperatorFilter.FilterOperator.IN));
    }

    private void addStatusFilter(StatusEnum status, boolean includeStatusFilter) {
        SQLTableItem tseStatusTableItem = new SQLTableItem(NC_TSE_STATE_MAP.STATUS);
        if (status == null || status.equals(StatusEnum.ALL) || !includeStatusFilter) {
            if (this.m_queryEventSpec.getScope() == null || this.m_queryEventSpec.getScope().getSearchPaths() != null) {
                this.m_builder.addFilter(new SQLQueryOperatorFilter(tseStatusTableItem, new Object[]{new Integer(TaskStatus.PENDING.getId()), new Integer(TaskStatus.READY.getId()), new Integer(TaskStatus.ALLOCATED.getId()), new Integer(TaskStatus.RUNNING.getId()), new Integer(TaskStatus.PAUSED.getId()), new Integer(TaskStatus.INACTIVE.getId())}, SQLQueryOperatorFilter.FilterOperator.IN));
            }
            if (this.m_queryEventSpec.getScope() != null && (this.m_queryEventSpec.getScope().getRestartEventID() != null || this.m_queryEventSpec.getScope().getRestartParentEventID() != null)) {
                this.m_builder.addFilter(new SQLQueryOperatorFilter(tseStatusTableItem, new Object[]{new Integer(TaskStatus.FAILED.getId()), new Integer(TaskStatus.PURGED.getId()), new Integer(TaskStatus.TERMINATED.getId())}, SQLQueryOperatorFilter.FilterOperator.IN));
            }
        } else if (status.equals(StatusEnum.PENDING)) {
            this.m_builder.addFilter(new SQLQueryOperatorFilter(tseStatusTableItem, new Object[]{new Integer(TaskStatus.RUNNING.getId()), new Integer(TaskStatus.PENDING.getId()), new Integer(TaskStatus.READY.getId())}, SQLQueryOperatorFilter.FilterOperator.IN));
            SQLTableItem tseExecTableItem = new SQLTableItem(NC_TSE_STATE_MAP.EXECUTING);
            this.m_builder.addFilter(new SQLQueryOperatorFilter(tseExecTableItem, new Object[]{new Integer(0)}, SQLQueryOperatorFilter.FilterOperator.EQUALS));
        } else if (status.equals(StatusEnum.EXECUTING)) {
            Integer id = new Integer(TaskStatus.RUNNING.getId());
            this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TSE_STATE_MAP.STATUS), id, SQLQueryOperatorFilter.FilterOperator.EQUALS));
            SQLTableItem tseExecTableItem = new SQLTableItem(NC_TSE_STATE_MAP.EXECUTING);
            this.m_builder.addFilter(new SQLQueryOperatorFilter(tseExecTableItem, new Object[]{new Integer(0)}, SQLQueryOperatorFilter.FilterOperator.GREATER_THAN));
        } else {
            Integer id = null;
            if (status.equals(StatusEnum.CANCELLED)) {
                id = new Integer(TaskStatus.CANCELLED.getId());
            } else if (status.equals(StatusEnum.FAILED)) {
                id = new Integer(TaskStatus.FAILED.getId());
            } else if (status.equals(StatusEnum.PURGED)) {
                id = new Integer(TaskStatus.PURGED.getId());
            } else if (status.equals(StatusEnum.SUCCEEDED)) {
                id = new Integer(TaskStatus.COMPLETED.getId());
            } else if (status.equals(StatusEnum.SUSPENDED)) {
                id = new Integer(TaskStatus.PAUSED.getId());
            } else if (status.equals(StatusEnum.TERMINATED)) {
                id = new Integer(TaskStatus.TERMINATED.getId());
            } else if (status.equals(StatusEnum.INACTIVE)) {
                id = new Integer(TaskStatus.INACTIVE.getId());
            }
            if (id != null) {
                this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TSE_STATE_MAP.STATUS), id, SQLQueryOperatorFilter.FilterOperator.EQUALS));
            }
        }
    }

    private void addUserFilter(String user) {
        Account account = this.getAccount("storeID('" + user + "')");
        String camID = "";
        if (account != null) {
            camID = account.getSearchPath().getValue();
        }
        this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.ACCOUNT_PATH), camID, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addOwnerFilter(String owner) {
        this.m_builder.addFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.OWNER_STOREID), owner, SQLQueryOperatorFilter.FilterOperator.EQUALS));
    }

    private void addTenantIDFilters(String[] tenantIDs) {
        SQLOrQueryFilter sqlOrQueryFilter = new SQLOrQueryFilter(new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.TENANT_ID), "", SQLQueryOperatorFilter.FilterOperator.EQUALS), new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.TENANT_ID), SQLQueryOperatorFilter.FilterOperator.IS_NULL));
        if (tenantIDs != null) {
            for (String tenantID : tenantIDs) {
                if (tenantID == null || tenantID.length() <= 0) continue;
                sqlOrQueryFilter = new SQLOrQueryFilter(sqlOrQueryFilter, new SQLQueryOperatorFilter(new SQLTableItem(NC_TASK_QUEUE.TENANT_ID), tenantID, SQLQueryOperatorFilter.FilterOperator.EQUALS));
            }
        }
        this.m_builder.addFilter(sqlOrQueryFilter);
    }

    private SQLSort getSortSQL(Sort sort, String tableAlias) {
        SQLTableItem sortColumn = null;
        SQLSort.SortDirection direction = null;
        if (sort == null) {
            sortColumn = new SQLTableItem(NC_TASK_QUEUE.DATE_ENTERED);
            direction = SQLSort.SortDirection.ASCENDING;
        } else {
            OrderEnum order = sort.getOrder();
            SortEnum sortItem = sort.getSortItem();
            if (order.toString().equals("ascending")) {
                direction = SQLSort.SortDirection.ASCENDING;
            } else if (order.toString().equals("descending")) {
                direction = SQLSort.SortDirection.DESCENDING;
            }
            if (sortItem.toString().equals("startTime")) {
                sortColumn = new SQLTableItem(NC_TASK_QUEUE.DATE_ENTERED);
            } else if (sortItem.toString().equals("status")) {
                sortColumn = new SQLTableItem(NC_TSE_STATE_MAP.STATUS);
            } else if (sortItem.toString().equals("scheduleType")) {
                sortColumn = new SQLTableItem(NC_TASK_QUEUE.SCHEDULE_TYPE);
            } else if (sortItem.toString().equals("priority")) {
                sortColumn = new SQLTableItem(NC_TASK_QUEUE.PRIORITY);
            }
        }
        sortColumn.setTableName(tableAlias);
        return new SQLSort(sortColumn, direction);
    }

    public void close() {
        SqlResourceCloser.closeResources((ResultSet)this.m_rs, (Statement)this.m_statement);
        this.closeConnection(this.m_connection);
    }

    public JDBCConnection getConnection() throws SQLException {
        JDBCConnection conn = this.m_connectionFactory.createReadOnlyConnection();
        DatabaseType using = this.getDBType();
        if (!DatabaseType.SYBASE.equals((Object)using)) {
            conn.setAutoCommit(false);
        }
        if (DatabaseType.ORACLE.equals((Object)using)) {
            this.checkAndSetOracle10G((Connection)conn);
        }
        return conn;
    }

    public void checkAndSetOracle10G(Connection conn) {
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            int dbMajorVersion = dbmd.getDatabaseMajorVersion();
            this.setOra10gDB(dbMajorVersion == 10);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void closeConnection(JDBCConnection conn) {
        if (conn == null) {
            return;
        }
        DatabaseType using = this.getDBType();
        if (!DatabaseType.SYBASE.equals((Object)using)) {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this.m_connectionFactory.releaseConnection(conn);
        }
        catch (SQLException ex) {
            SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).log(SDSLevel.WARN, I18NCode.GEN_3RD_PARTY_FAULT, (Object[])new String[]{"Unable to release connection: " + ex.getMessage()});
        }
    }

    protected DatabaseType getDBType() {
        if (this.m_databaseType != null) {
            return this.m_databaseType;
        }
        return JDBCConnectionProperties.instance((String)"SDS").getDBType();
    }

    public ResultSet getResultSet() {
        return this.m_rs;
    }

    public void setInactiveTaskCleanupFlag(boolean flag) {
        this.m_isInactiveTaskCleanup = flag;
    }

    static class MiniDataStruct {
        public TaskID m_taskID;
        public String m_storeID;

        public MiniDataStruct(TaskID taskID, String storeID) {
            this.m_taskID = taskID;
            this.m_storeID = storeID;
        }
    }

    private static class NC_TASK_HISTORY_DETAIL {
        public static String TABLE_NAME = "NC_TASK_HISTORY_DETAIL";
        public static String TASK_ID = TABLE_NAME + ".TASK_ID";

        private NC_TASK_HISTORY_DETAIL() {
        }
    }

    public static class NC_TASK_ANCESTORS {
        public static String TABLE_NAME = "NC_TASK_ANCESTOR_STOREIDS";
        public static String TASK_ID = TABLE_NAME + ".TASK_ID";
        public static String ANCESTOR_STORE_ID = TABLE_NAME + ".ANCESTOR_STORE_ID";
    }

    public static class NC_TSE_STATE_MAP {
        public static String TABLE_NAME = "NC_TSE_STATE_MAP";
        public static String TASK_ID = TABLE_NAME + ".TASK_ID";
        public static String PARENT_ID = TABLE_NAME + ".PARENT_ID";
        public static String STATUS = TABLE_NAME + ".STATUS";
        public static String EXECUTING = TABLE_NAME + ".EXECUTING";
        public static String SEQ = TABLE_NAME + ".SEQ";
    }

    public static class NC_TASK_QUEUE {
        public static String TABLE_NAME = "NC_TASK_QUEUE";
        public static String TASK_ID = TABLE_NAME + ".TASK_ID";
        public static String SERVICE_NAME = TABLE_NAME + ".SERVICE_NAME";
        public static String SERVER_GROUP = TABLE_NAME + ".SERVER_GROUP";
        public static String DATE_ENTERED = TABLE_NAME + ".DATE_ENTERED";
        public static String TASK = TABLE_NAME + ".TASK";
        public static String STATUS = TABLE_NAME + ".STATUS";
        public static String PRIORITY = TABLE_NAME + ".PRIORITY";
        public static String RESTART_ID = TABLE_NAME + ".RESTART_ID";
        public static String SDS_INSTANCE_ID = TABLE_NAME + ".SDS_INSTANCE_ID";
        public static String HISTORY_STORE_ID = TABLE_NAME + ".HISTORY_STORE_ID";
        public static String ACTUAL_EXECUTION_TIME = TABLE_NAME + ".ACTUAL_EXECUTION_TIME";
        public static String DISPATCHER_ID = TABLE_NAME + ".DISPATCHER_ID";
        public static String SCHEDULE_TRIGGER_NAME = TABLE_NAME + ".SCHEDULE_TRIGGER_NAME";
        public static String SCHEDULE_TYPE = TABLE_NAME + ".SCHEDULE_TYPE";
        public static String ACCOUNT_PATH = TABLE_NAME + ".ACCOUNT_PATH";
        public static String STOREID = TABLE_NAME + ".STOREID";
        public static String OBJECT_CLASS = TABLE_NAME + ".OBJECT_CLASS";
        public static String ACTUAL_COMPLETION_TIME = TABLE_NAME + ".ACTUAL_COMPLETION_TIME";
        public static String OWNER_STOREID = TABLE_NAME + ".OWNER_STOREID";
        public static String PROCESS_ID = TABLE_NAME + ".PROCESS_ID";
        public static String TENANT_ID = TABLE_NAME + ".TENANT_ID";
    }
}

