/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.paging;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailEventRecord;
import com.cognos.developer.schemas.bibus._3.AsynchDetailParameterValues;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSecondaryRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.JobStepDefinition;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.PagingOptionEnum;
import com.cognos.developer.schemas.bibus._3.PagingOptionInt;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.paging.IPager;
import com.cognos.monitor.paging.MonitorQueueQuery;
import com.cognos.monitor.paging.MonitorServicePagingException;
import com.cognos.spec.eventRecordState.EventRecordStateUtil;
import com.cognos.spec.eventRecordState.castor.EventRecordState;
import com.cognos.spec.queryEvent.QueryEventSpecUtil;
import com.cognos.spec.queryEvent.castor.Filters;
import com.cognos.spec.queryEvent.castor.QueryEventSpecification;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class MonitorServicePager
implements IPager {
    private JobBiBusHeaders m_headers;
    private MonitorQueueQuery m_query;
    private int m_maxObjects = 10;
    private int m_numRows = 0;
    private int m_startRow = 0;
    private int m_endRow = 0;
    private static final String NEXT = "nextPage";
    private static final String LAST = "lastPage";
    private static final String FIRST = "firstPage";
    private static final String PREVIOUS = "previousPage";
    private static final String RELEASE = "release";

    public MonitorServicePager(JobBiBusHeaders headers) {
        this.m_headers = headers;
    }

    @Override
    public void runSpecification(AsynchRequest request) throws MonitorServicePagingException {
        Object[] errorParams;
        PagingOptionInt maxObjectsOption;
        QueryEventSpecification queryEventSpec = null;
        AsynchSpecification[] specs = request.getSpecification();
        if (specs != null && specs.length == 1) {
            try {
                queryEventSpec = QueryEventSpecUtil.getQueryEventSpecification(specs[0]);
            }
            catch (ValidationException e) {
                Object[] errorParams2 = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_SPEC_VALIDATION_ERROR, errorParams2, e);
            }
            catch (MarshalException e) {
                Object[] errorParams3 = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_SPEC_UNMARSHALL_ERROR, errorParams3, e);
            }
            catch (Exception e) {
                Object[] errorParams4 = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_SPEC_VALIDATION_ERROR, errorParams4, e);
            }
        }
        if (queryEventSpec == null) {
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_NO_QUERYEVENT_SPEC);
        }
        boolean hasCapability = false;
        try {
            hasCapability = AuthenticatorFactory.getInstance().hasCapability(this.m_headers.getBiBusHeader(), UserCapabilityEnum.canUseMonitorActivityTool);
        }
        catch (Exception errorParams4) {
            // empty catch block
        }
        if (!hasCapability) {
            boolean isFilteredOnUser = false;
            UserAccountUtil userAccountUtil = new UserAccountUtil(this.m_headers);
            String userAccountStoreId = userAccountUtil.getStoreID().toString();
            if (userAccountStoreId == null) {
                throw new MonitorServicePagingException(I18NCode.SEC_NO_PRIVELEDGES);
            }
            if (queryEventSpec.getFilters() != null && queryEventSpec.getFilters().getUser() != null) {
                String userStoreId = queryEventSpec.getFilters().getUser();
                if (userAccountStoreId != null && userStoreId.equals(userAccountStoreId)) {
                    isFilteredOnUser = true;
                }
            }
            if (!isFilteredOnUser) {
                Filters filters = queryEventSpec.getFilters();
                if (filters == null) {
                    filters = new Filters();
                    queryEventSpec.setFilters(filters);
                }
                filters.setUser(userAccountStoreId);
            }
        }
        if ((maxObjectsOption = (PagingOptionInt)OptionUtils.findFirstOptionWithNameEnum((Option[])request.getOptions(), (Object)PagingOptionEnum.maximumObjects)) != null) {
            this.m_maxObjects = maxObjectsOption.getValue();
        }
        try {
            this.m_query = new MonitorQueueQuery(queryEventSpec);
            this.m_query.executeQuery(this.m_headers);
            this.m_numRows = this.m_query.numRows();
        }
        catch (SQLException e) {
            errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
        }
        if (request.getStateData() != null) {
            try {
                EventRecordState state = EventRecordStateUtil.getEventRecordState(request.getStateData());
                this.m_startRow = state.getStart();
                this.m_endRow = state.getEnd();
            }
            catch (ValidationException e) {
                errorParams = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_STATE_VALIDATION_ERROR, errorParams, e);
            }
            catch (MarshalException e) {
                errorParams = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_STATE_UNMARSHALL_ERROR, errorParams, e);
            }
        } else if (queryEventSpec.getDisplay() != null) {
            this.m_startRow = queryEventSpec.getDisplay().getStart();
            this.m_endRow = queryEventSpec.getDisplay().getEnd();
            if (this.m_startRow < 1 || this.m_endRow < 1 || this.m_startRow > this.m_endRow) {
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_SPEC_VALIDATION_ERROR);
            }
        } else {
            this.m_startRow = 1;
            this.m_endRow = this.m_maxObjects == 0 ? this.m_numRows : Math.min(this.m_numRows, this.m_startRow + this.m_maxObjects - 1);
        }
        if (this.m_startRow > this.m_numRows) {
            this.m_startRow = this.m_numRows + 1;
            this.m_endRow = this.m_numRows + 1;
        } else {
            this.m_startRow = Math.min(this.m_startRow, this.m_numRows);
            this.m_endRow = Math.min(this.m_endRow, this.m_numRows);
        }
    }

    @Override
    public void release() {
        if (this.m_query != null) {
            this.m_query.close();
            this.m_query = null;
        }
    }

    @Override
    public AsynchReply currentPage(AsynchRequest asynchRequest) throws MonitorServicePagingException {
        AsynchReply reply = null;
        try {
            reply = this.buildReply(asynchRequest);
        }
        catch (SQLException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
        }
        return reply;
    }

    @Override
    public AsynchReply firstPage(AsynchRequest asynchRequest) throws MonitorServicePagingException {
        AsynchReply reply = null;
        try {
            this.m_startRow = 1;
            this.m_endRow = Math.min(this.m_maxObjects, this.m_startRow + this.m_maxObjects - 1);
            reply = this.buildReply(asynchRequest);
        }
        catch (SQLException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
        }
        return reply;
    }

    @Override
    public AsynchReply nextPage(AsynchRequest asynchRequest) throws MonitorServicePagingException {
        AsynchReply reply = null;
        try {
            this.m_startRow = this.m_endRow + 1;
            this.m_endRow = Math.min(this.m_numRows, this.m_startRow + this.m_maxObjects - 1);
            reply = this.buildReply(asynchRequest);
        }
        catch (SQLException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
        }
        return reply;
    }

    @Override
    public AsynchReply previousPage(AsynchRequest asynchRequest) throws MonitorServicePagingException {
        AsynchReply reply = null;
        try {
            this.m_startRow = Math.max(1, this.m_startRow - this.m_maxObjects);
            this.m_endRow = this.m_startRow + this.m_maxObjects - 1;
            reply = this.buildReply(asynchRequest);
        }
        catch (SQLException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
        }
        return reply;
    }

    @Override
    public AsynchReply lastPage(AsynchRequest asynchRequest) throws MonitorServicePagingException {
        AsynchReply reply = null;
        try {
            this.m_endRow = this.m_numRows;
            this.m_startRow = Math.max(1, this.m_endRow - this.m_maxObjects + 1);
            reply = this.buildReply(asynchRequest);
        }
        catch (SQLException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
        }
        return reply;
    }

    private AsynchReply buildReply(AsynchRequest asynchRequest) throws SQLException, MonitorServicePagingException {
        AsynchDetailEventRecord[] records;
        AsynchReply reply = new AsynchReply();
        ArrayList<Object> details = new ArrayList<Object>();
        reply.setPrimaryRequest(asynchRequest);
        reply.setSecondaryRequests(this.buildSecondaryRequests());
        if (this.m_numRows > 0 && (records = this.readPage()) != null) {
            for (int i = 0; i < records.length; ++i) {
                details.add(records[i]);
            }
        }
        this.updateStateData(reply);
        details.add(this.buildStatistics());
        reply.setDetails(details.toArray(new AsynchDetail[details.size()]));
        reply.setStatus(this.buildReplyStatus());
        return reply;
    }

    private AsynchDetailParameterValues buildStatistics() {
        ArrayList<ParameterValue> statParameters = new ArrayList<ParameterValue>();
        Iterator statIterator = this.m_query.getStatistics().statisticIterator();
        HashMap<String, Integer> mergeMap = new HashMap<String, Integer>();
        while (statIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)statIterator.next();
            Integer key = (Integer)entry.getKey();
            Integer value = (Integer)entry.getValue();
            String eventStatusEnum = this.convertStatus(key);
            Integer stat = (Integer)mergeMap.get(eventStatusEnum);
            stat = stat == null ? value : new Integer(stat + value);
            mergeMap.put(eventStatusEnum, stat);
        }
        for (String statKey : mergeMap.keySet()) {
            Integer statValue = (Integer)mergeMap.get(statKey);
            statParameters.add(ObjectModelUtil.makeParameterValue((String)statKey, (String)("" + statValue)));
        }
        AsynchDetailParameterValues asynchDetailParameterValues = new AsynchDetailParameterValues();
        asynchDetailParameterValues.setParameters(statParameters.toArray(new ParameterValue[statParameters.size()]));
        return asynchDetailParameterValues;
    }

    private void updateStateData(AsynchReply reply) throws MonitorServicePagingException {
        try {
            EventRecordState state = new EventRecordState();
            state.setStart(this.m_startRow);
            state.setEnd(this.m_endRow);
            String stateAsXML = EventRecordStateUtil.getEventRecordStateAsXML(state);
            XmlEncodedXML xmlEncode = new XmlEncodedXML();
            xmlEncode.set_value(stateAsXML);
            reply.getPrimaryRequest().setStateData(xmlEncode);
        }
        catch (ValidationException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_STATE_VALIDATION_ERROR, errorParams, e);
        }
        catch (MarshalException e) {
            Object[] errorParams = new String[]{e.getLocalizedMessage()};
            throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_QUERYEVENT_STATE_UNMARSHALL_ERROR, errorParams, e);
        }
    }

    private AsynchDetailEventRecord[] readPage() throws SQLException, MonitorServicePagingException {
        AsynchDetailEventRecord[] retValue = null;
        if (this.m_startRow <= this.m_numRows) {
            ArrayList<AsynchDetailEventRecord> asynchRecords = new ArrayList<AsynchDetailEventRecord>();
            this.m_query.absolute(this.m_startRow);
            for (int i = this.m_startRow; i <= this.m_endRow; ++i) {
                AsynchDetailEventRecord record = this.m_query.readRecord();
                asynchRecords.add(record);
                this.m_query.next();
            }
            retValue = asynchRecords.toArray(new AsynchDetailEventRecord[asynchRecords.size()]);
            this.populateRunnableInfoFromCM(retValue);
        }
        return retValue;
    }

    private void populateRunnableInfoFromCM(AsynchDetailEventRecord[] records) throws MonitorServicePagingException {
        ArrayList<QueryRequest> queryRequests = new ArrayList<QueryRequest>();
        for (int i = 0; i < records.length; ++i) {
            String storeID = records[i].getRunnable()[0].getStoreID().getValue().get_value();
            QueryRequest request = new QueryRequest();
            request.setSearch("storeID(\"" + storeID.trim() + "\")");
            request.setProperties(new PropEnum[]{PropEnum.ancestors, PropEnum.owner, PropEnum.name, PropEnum.defaultName, PropEnum.objectClass, PropEnum.searchPath, PropEnum.storeID, PropEnum.hidden, PropEnum.iconURI, PropEnum.permissions});
            queryRequests.add(request);
        }
        QueryReply[] runnableReplies = null;
        if (queryRequests.size() > 0) {
            ContentManagerServiceClientPort contentManager = null;
            try {
                contentManager = Client.instance().getContentManagerServiceClient(this.m_headers);
                runnableReplies = contentManager.queryMultiple(queryRequests.toArray(new QueryRequest[queryRequests.size()]));
            }
            catch (SDKClientException e) {
                Object[] errorParams = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
            }
            catch (EMFSecurityException e) {
                Object[] errorParams = new String[]{e.getLocalizedMessage()};
                throw new MonitorServicePagingException(MonitorI18NCode.MSG_MS_PAGING_ERROR, errorParams, e);
            }
            finally {
                if (contentManager != null) {
                    contentManager.close();
                }
            }
        }
        for (int i = 0; i < runnableReplies.length; ++i) {
            boolean hasReadPermission = false;
            if (runnableReplies[i].getQueryResult() == null || runnableReplies[i].getQueryResult().length <= 0) continue;
            BaseClass baseClass = runnableReplies[i].getQueryResult()[0];
            NmtokenArrayProp permissions = baseClass.getPermissions();
            if (permissions != null && permissions.getValue() != null) {
                String[] values = permissions.getValue();
                for (int j = 0; j < values.length; ++j) {
                    if (!values[j].equals("read")) continue;
                    hasReadPermission = true;
                    break;
                }
            }
            if (hasReadPermission) continue;
            runnableReplies[i].setQueryResult(null);
        }
        BaseClass dummyRunnable = null;
        BaseClass realRunnable = null;
        for (int i = 0; i < records.length; ++i) {
            dummyRunnable = records[i].getRunnable()[0];
            if (runnableReplies[i].getQueryResult() != null && runnableReplies[i].getQueryResult().length > 0 && !(runnableReplies[i].getQueryResult()[0] instanceof JobStepDefinition)) {
                realRunnable = runnableReplies[i].getQueryResult()[0];
                realRunnable.setPosition(dummyRunnable.getPosition());
            } else {
                realRunnable = dummyRunnable;
                Locale locale = this.m_headers.getProductLocale();
                String unknown = I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, null, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
                TokenProp nameProp = new TokenProp();
                nameProp.setValue(unknown);
                realRunnable.setDefaultName(nameProp);
            }
            records[i].getRunnable()[0] = realRunnable;
        }
    }

    private AsynchReplyStatusEnum buildReplyStatus() {
        if (this.m_maxObjects == 0 || this.m_numRows <= this.m_maxObjects || this.m_startRow > this.m_numRows) {
            this.release();
            return AsynchReplyStatusEnum.conversationComplete;
        }
        return AsynchReplyStatusEnum.complete;
    }

    private AsynchSecondaryRequest[] buildSecondaryRequests() {
        String[] allowedMethods = null;
        allowedMethods = this.m_startRow > 1 && this.m_endRow < this.m_numRows ? new String[]{FIRST, PREVIOUS, NEXT, LAST, RELEASE} : (this.m_startRow == 1 && this.m_endRow < this.m_numRows ? new String[]{NEXT, LAST, RELEASE} : (this.m_startRow > 1 && this.m_endRow == this.m_numRows ? new String[]{FIRST, PREVIOUS, RELEASE} : new String[]{}));
        AsynchSecondaryRequest[] secondaryRequests = new AsynchSecondaryRequest[allowedMethods.length];
        for (int i = 0; i < allowedMethods.length; ++i) {
            AsynchSecondaryRequest secondaryRequest = new AsynchSecondaryRequest();
            secondaryRequest.setName(allowedMethods[i]);
            secondaryRequests[i] = secondaryRequest;
        }
        return secondaryRequests;
    }

    private String convertStatus(int status) {
        return TaskStatus.mapStatus((TaskStatus)TaskStatus.fromId((byte)((byte)status))).statusName();
    }
}

