/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.paging;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QueryStatistics {
    private HashMap m_statistics = new HashMap();

    public void setCount(TaskStatus status, int count) {
        if (status != null) {
            this.m_statistics.put(new Integer(status.getId()), new Integer(count));
        }
    }

    public int getCount(TaskStatus status) {
        int count = 0;
        Integer statusInt = new Integer(status.getId());
        if (this.m_statistics.containsKey(statusInt)) {
            Integer countInt = (Integer)this.m_statistics.get(statusInt);
            count = countInt;
        }
        return count;
    }

    private void updateCount(TaskStatus status, int count) {
        Integer statusInt = new Integer(status.getId());
        Integer countInt = this.m_statistics.containsKey(statusInt) ? (Integer)this.m_statistics.get(statusInt) : new Integer(0);
        countInt = new Integer(count + countInt);
        this.m_statistics.put(statusInt, countInt);
    }

    public void updateCount(TaskStatus status, int count, int executingCount) {
        status = TaskStateRecord.getActualStatus((TaskStatus)status, (int)executingCount);
        this.updateCount(status, count);
    }

    public Iterator statisticIterator() {
        return this.m_statistics.entrySet().iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.statisticIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null) continue;
            TaskStatus status = TaskStatus.fromId((byte)Byte.parseByte(entry.getKey().toString()));
            EventStatus eventStatus = TaskStatus.mapStatus((TaskStatus)status);
            if (status == null) continue;
            buf.append(eventStatus.statusName() + "->" + entry.getValue());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean empty() {
        int count = 0;
        Iterator iter = this.statisticIterator();
        while (iter.hasNext() && count == 0) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getValue() == null) continue;
            count += ((Integer)entry.getValue()).intValue();
        }
        return count == 0;
    }
}

