/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.queue;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.jsmcommon.zipi.ZipiBridge;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.api.IMonitorService;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TSEStateMapProcessor;
import com.cognos.monitor.tse.TaskRunContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;

public class JobQueueReceiver
implements Runnable {
    IMonitorService monitor;
    ArrayList receivers;
    boolean enabled;
    volatile boolean queueNotified;
    Thread runThread;
    ThreadLocal tasks;
    private static final int POLL_INTERVAL_IN_MILLISECONDS = 30000;
    private static final String BATCH_REPORT_SERVICE = "batchReportService";
    private int m_yieldCounter = 0;
    private boolean m_yield = false;

    public void start() {
        this.runThread = new Thread((Runnable)this, "JobQueueReceiver");
        this.runThread.setDaemon(true);
        this.runThread.start();
    }

    public void stop() {
        if (this.runThread != null) {
            this.runThread.interrupt();
        }
    }

    public JobQueueReceiver(IMonitorService monitor) {
        this.monitor = monitor;
        this.receivers = new ArrayList();
        this.tasks = new ThreadLocal();
    }

    public int getPollInterval() {
        return 30000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveReceivers() {
        ArrayList arrayList = this.receivers;
        synchronized (arrayList) {
            return !this.receivers.isEmpty();
        }
    }

    public synchronized void notifyNewQueueEntries() {
        this.queueNotified = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receive(String serviceName, String serverGroup, int timeout) throws InterruptedException {
        Object object;
        if (this.tasks.get() != null) {
            return this.tasks.get();
        }
        Receiver r = new Receiver(serviceName, serverGroup);
        Object obj = null;
        InterruptedException ex = null;
        ArrayList arrayList = this.receivers;
        synchronized (arrayList) {
            this.receivers.add(r);
            if (this.receivers.size() == 1) {
                this.receivers.notify();
            }
        }
        ZipiTimer zipiTimer2 = ZipiBridge.startTimer((String)"JobQueueReceiver.WaitForReceiver");
        try {
            this.notifyNewQueueEntries();
            object = r;
            synchronized (object) {
                if (r.getObject() == null) {
                    try {
                        r.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        ex = e;
                    }
                }
                obj = r.getObject();
                this.tasks.set(obj);
                r.setNotWaiting();
            }
        }
        finally {
            object = this.receivers;
            synchronized (object) {
                this.receivers.remove(r);
            }
            zipiTimer2.stop();
        }
        if (ex != null) {
            throw ex;
        }
        return obj;
    }

    public void release(Object task) {
        Validate.isTrue((task == this.tasks.get() ? 1 : 0) != 0);
        this.tasks.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object zipiTimer;
        boolean interrupted = false;
        boolean checkQueue = true;
        while (!TSEStateMapProcessor.getInstance().isIdle()) {
            zipiTimer = ZipiBridge.startTimer((String)"JobQueueReceiver.CleaningUpBeforeStarting");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e2) {
                interrupted = true;
            }
            finally {
                zipiTimer.stopAndClear();
            }
        }
        while (!interrupted) {
            try {
                Object zipiTimer10;
                zipiTimer = this.receivers;
                synchronized (zipiTimer) {
                    if (this.receivers.size() == 0) {
                        ZipiTimer zipiTimer4 = ZipiBridge.startTimer((String)"JobQueueReceiver.WaitingForReceivers");
                        try {
                            TSE.trace(this, "entering wait");
                            this.receivers.wait();
                            checkQueue = true;
                        }
                        finally {
                            zipiTimer4.stopAndClear();
                        }
                    }
                }
                while (checkQueue) {
                    Object servicesReady;
                    zipiTimer10 = ZipiBridge.startTimer((String)"JobQueueReceiver.checkQueue");
                    try {
                        servicesReady = null;
                        servicesReady = NCTaskQueueTable.getInstance().getServicesForReadyTasks();
                        if (null != servicesReady && ((String[])servicesReady).length > 0) {
                            this.processQueue((String[])servicesReady);
                        }
                        checkQueue = false;
                    }
                    finally {
                        zipiTimer10.stopAndClear();
                    }
                    servicesReady = this;
                    synchronized (servicesReady) {
                        if (!this.queueNotified) {
                            ZipiTimer zipiTimer9 = ZipiBridge.startTimer((String)"JobQueueReceiver.QueueEmptyOrCapacityReachedSmallWait");
                            try {
                                this.wait(2000L);
                            }
                            finally {
                                zipiTimer9.stopAndClear();
                            }
                        }
                        if (this.queueNotified && !this.m_yield) {
                            checkQueue = true;
                        }
                        this.queueNotified = false;
                    }
                }
                checkQueue = true;
                zipiTimer10 = this;
                synchronized (zipiTimer10) {
                    if (!this.queueNotified || this.m_yield) {
                        if (this.m_yield) {
                            TSE.trace(this, "Yielding");
                        }
                        TSE.trace(this, "entering poll wait");
                        ZipiTimer zipiTimer8 = ZipiBridge.startTimer((String)"JobQueueReceiver.QueueEmptyOrCapacityReachedWaitPollInterval");
                        try {
                            this.wait(this.getPollInterval());
                        }
                        finally {
                            this.resetYield();
                            zipiTimer8.stopAndClear();
                        }
                    }
                    this.queueNotified = false;
                }
            }
            catch (InterruptedException e) {
                this.trace(e.getMessage());
                interrupted = true;
            }
            catch (Throwable e) {
                this.trace(e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                checkQueue = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processQueue(String[] servicesReady) {
        Object[] items;
        Receiver r = null;
        boolean received = false;
        TSE.trace(this, "processQueue");
        ArrayList arrayList = this.receivers;
        synchronized (arrayList) {
            items = this.receivers.toArray();
        }
        for (int i = 0; i != items.length; ++i) {
            r = (Receiver)items[i];
            if (!this.taskReadyForService(r.service, servicesReady)) continue;
            try {
                Receiver receiver = r;
                synchronized (receiver) {
                    TaskRunContext record;
                    if (r.getObject() == null && r.isWaiting() && (record = TSE.getInstance().receiveTaskToRun(r.service, r.group)) != null) {
                        r.setObject(record);
                        TSE.trace(this, "notify " + record.toString());
                        r.notify();
                        if (r.service.equalsIgnoreCase(BATCH_REPORT_SERVICE)) {
                            this.processYield();
                        }
                        received = true;
                    }
                    continue;
                }
            }
            catch (TSEException e) {
                try {
                    TSE.trace("Job queue reciever caught exception:" + e.getStackTrace());
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                e.printStackTrace();
            }
        }
        return received;
    }

    private boolean taskReadyForService(String service, String[] servicesReady) {
        if (null == service || null == servicesReady) {
            return false;
        }
        for (String s : servicesReady) {
            if (!s.equals(service)) continue;
            return true;
        }
        return false;
    }

    private void processYield() {
        int yieldChunk = CRNProperties.getInstance().getIntProperty("ms.loadbalance.yield.chunk", 0);
        if (yieldChunk > 0) {
            ++this.m_yieldCounter;
            this.m_yield = this.m_yieldCounter >= yieldChunk;
            TSE.trace(this, "Yield counter now at : " + this.m_yieldCounter);
        }
    }

    private void resetYield() {
        this.m_yieldCounter = 0;
        this.m_yield = false;
    }

    private void trace(String msg) {
        SDSLogger.getLogger((SDSCategory)MonitorCategory.TRACE).debug((Object)this, msg);
    }

    class Receiver {
        String service;
        String group;
        Object obj;
        boolean waiting;

        Receiver(String service, String group) {
            this.service = service;
            this.group = group;
            this.obj = null;
            this.waiting = true;
        }

        Object getObject() {
            return this.obj;
        }

        boolean isWaiting() {
            return this.waiting;
        }

        void setNotWaiting() {
            this.waiting = false;
        }

        void setObject(Object obj) {
            this.obj = obj;
        }
    }
}

