/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.BiBusSpec;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskRunSpec;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.RunCommandProcessor;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContextBase;
import com.cognos.sds.event.IEventId;
import java.util.ArrayList;

public abstract class BiBusContext
extends TaskRunContextBase {
    protected HistoryWriter historyWriter;
    protected JobBiBusHeaders header;
    protected TaskID parentID;
    protected UserAccountUtil acntUtil;

    public BiBusContext(TaskRecord task, TaskID parentID, TaskStateRecord taskState) {
        super(task, parentID, taskState);
        this.header = new JobBiBusHeaders(this.getBiBusSpec().header);
    }

    @Override
    public IEventId getId() throws LocalizableException {
        return this.getEventId();
    }

    public JobBiBusHeaders getHeader() {
        return this.header;
    }

    @Override
    public boolean logOffRequired() {
        return this.getBiBusSpec().logOff;
    }

    @Override
    public void logOff() {
        BiBusHeader h = this.header.getBiBusHeader();
        try {
            AuthenticatorFactory.getInstance().logoff(h);
        }
        catch (EMFSecurityException e1) {
            String passport = h.getCAM().getCAMPassport().getId();
            SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME).debug("Could not logoff passport " + passport);
        }
    }

    @Override
    public String getFullName() {
        if (this.acntUtil == null) {
            this.acntUtil = new UserAccountUtil(new JobBiBusHeaders(this.getBiBusSpec().header));
        }
        return this.acntUtil.getFullName();
    }

    @Override
    public String getUserName() {
        if (this.acntUtil == null) {
            this.acntUtil = new UserAccountUtil(new JobBiBusHeaders(this.getBiBusSpec().header));
        }
        return this.acntUtil.getUserName();
    }

    public String getRestartID() {
        return null;
    }

    @Override
    public Object getTask() throws LocalizableException {
        return this;
    }

    @Override
    public void updateTaskStatus(EventStatus status) throws TSEException {
        this.changeTaskStatus(TaskStatus.mapStatus((EventStatus)status), null);
    }

    @Override
    public void updateTaskStatus(EventStatus status, I18NMessage message) throws TSEException {
        this.changeTaskStatus(TaskStatus.mapStatus((EventStatus)status), message);
    }

    public void updateTaskStatus(EventStatus status, I18NCode detail, Object[] params, SeverityEnum sevEnum) throws TSEException {
        this.changeTaskStatus(TaskStatus.mapStatus((EventStatus)status), detail == null ? null : new I18NMessage(detail, params, sevEnum));
    }

    @Override
    public void onTaskRunStartedCmd() throws TSEException {
        super.onTaskRunStartedCmd();
        RunCommandProcessor.getInstance().preRun(this);
    }

    @Override
    public abstract void onTaskRunFinishedCmd() throws TSEException;

    @Override
    public void onRunNewTaskCmd(ArrayList sqlUpdateFields) throws TSEException {
        BiBusSpec taskSpec = this.getBiBusSpec();
        try {
            boolean addedSpec = false;
            if (!taskSpec.authenticated) {
                if (this.task.getRunSpec().loadFault == null) {
                    TSE.getInstance().authenticateHeader(taskSpec, this.parentID == null);
                }
                sqlUpdateFields.add("TASK");
                addedSpec = true;
            }
            if (taskSpec.serviceName == null) {
                SequenceSpec spec = new SequenceSpec(SequenceSpec.SEQ_NEW, (TaskRunSpec)taskSpec);
                BiBusSpec.initialiseHeaders((SequenceSpec[])new SequenceSpec[]{spec});
                if (!addedSpec) {
                    sqlUpdateFields.add("TASK");
                }
                sqlUpdateFields.add("SERVICE_NAME");
                sqlUpdateFields.add("SERVER_GROUP");
                this.task.setServiceName(taskSpec.serviceName);
                this.task.setServerGroup(taskSpec.serverGroup);
            }
            Validate.stateIsTrue((this.getBiBusSpec().getCredentialPath() != null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TSE.throwException(e);
        }
    }

    public abstract String getFault();

    protected void trace(Object obj, String s) {
        TSE.trace(obj, s);
    }

    public BiBusSpec getBiBusSpec() {
        return (BiBusSpec)this.task.getRunSpec();
    }
}

