/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.jms.client.BiBusMonitorUtil;
import com.cognos.jsmcommon.tse.BiBusRequestSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.tse.BiBusContext;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.RunCommandProcessor;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.run.BusCaller;
import com.cognos.monitor.tse.run.BusCallerFactory;
import org.dom4j.Node;

public class BiBusRequestContext
extends BiBusContext {
    private Throwable e;
    private BusCaller caller;

    public BiBusRequestContext(TaskRecord task, TaskID parentID, TaskStateRecord taskState) {
        super(task, parentID, taskState);
    }

    @Override
    public HistoryWriter getHistoryWriter() {
        return null;
    }

    @Override
    public String getHistoryStoreID() {
        return null;
    }

    public BiBusRequestSpec getRequestSpec() {
        return (BiBusRequestSpec)this.task.getRunSpec();
    }

    @Override
    public Object run() throws LocalizableException {
        BiBusRequestSpec busSpec = this.getRequestSpec();
        this.trace(this, "running request context " + this.task.getTaskId().getID() + " on " + busSpec.soapAction);
        this.caller = BusCallerFactory.getCaller();
        Node response = null;
        try {
            try {
                this.changeTaskStatus(TaskStatus.RUNNING, null);
                response = this.caller.callServerMethod(busSpec.headers, busSpec.soapAction, busSpec.requestBody);
                if (busSpec.inactiveAfterRequest) {
                    HistoryDetail detail = BiBusMonitorUtil.createHistoryDetails((I18NCode)I18NCode.MSG_TSE_WAITING_FOR_TASK_COMPLETION, (String)this.header.getUserPreferenceProductLocale(), (SeverityEnum)SeverityEnum.info);
                    TaskPersistLayer.getInstance().addInactiveTaskDetails(this.task.getTaskId(), (BaseHistoryDetail[])new HistoryDetail[]{detail});
                } else {
                    this.changeTaskStatus(TaskStatus.COMPLETED, null);
                }
            }
            catch (TSEException e) {
                this.trace(this, "status update error " + this.task.getTaskId().getID() + e.getMessage());
                throw new MonitorServiceException(I18NCode.EVENT_UPDATE_ERROR, e);
            }
        }
        catch (Throwable e) {
            this.e = e;
            try {
                this.changeTaskStatus(TaskStatus.COMPLETED, null);
            }
            catch (TSEException e1) {
                throw new MonitorServiceException(I18NCode.EVENT_UPDATE_ERROR, e);
            }
            throw new MonitorServiceException(I18NCode.MON_OBJECT_RUN_ERROR, e);
        }
        return response;
    }

    @Override
    public boolean cancel() throws LocalizableException {
        this.caller = null;
        return true;
    }

    @Override
    public boolean cancel(Object obj, String userName) throws LocalizableException {
        return this.cancel();
    }

    @Override
    public boolean release(Object obj, String userName) throws LocalizableException {
        return false;
    }

    @Override
    public boolean suspend(Object obj, String userName) throws LocalizableException {
        return false;
    }

    @Override
    public void onTaskRunFinishedCmd() throws TSEException {
        RunCommandProcessor.getInstance().postRun(this);
    }

    @Override
    public String getFault() {
        return this.e.getMessage();
    }

    @Override
    public void useSessionAffinity(boolean useSessionAffinity) throws LocalizableException {
    }
}

