/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.sds.event.IEventId;

public final class BiBusRequestRestartContext
extends BiBusRunContext {
    private boolean run;

    BiBusRequestRestartContext(TaskRecord task, TaskID parentID, TaskStateRecord taskState, boolean run) {
        super(task, parentID, taskState);
        this.run = run;
        TSE.trace("BiBusRequestRestartContext " + task.getTaskId().getID() + " " + this.getBiBusRunSpec().hashCode());
    }

    @Override
    public IEventId getId() throws LocalizableException {
        return this.getEventId();
    }

    @Override
    public IEventId getEventId() {
        return TSE.getInstance().getEventId(this.task.getRestartId());
    }

    @Override
    public String getRestartID() {
        return super.getEventId().toXMLString();
    }

    @Override
    public Object run() throws LocalizableException {
        try {
            if (this.run) {
                return super.run();
            }
            TSE.trace(this, "restarting an already executed container task");
            this.updateTaskStatus(EventStatus.EXECUTING);
            this.updateTaskStatus(EventStatus.SUCCEEDED);
            return null;
        }
        catch (TSEException e) {
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, e);
        }
        catch (TaskPersistLayerException e) {
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, e);
        }
    }
}

