/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.i18n.MonitorI18NCode;
import com.cognos.monitor.impl.MonitorableObject;
import com.cognos.monitor.tse.BiBusRunContext;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.sds.event.IEventId;
import java.rmi.RemoteException;

public final class BiBusRestartContext
extends BiBusRunContext {
    private boolean run;

    BiBusRestartContext(TaskRecord task, TaskID parentID, TaskStateRecord taskState, boolean run) {
        super(task, parentID, taskState);
        this.run = run;
        TSE.trace("BiBusRestartContext " + task.getTaskId().getID() + " " + this.getBiBusRunSpec().hashCode());
    }

    @Override
    public IEventId getId() throws LocalizableException {
        return this.getEventId();
    }

    @Override
    public IEventId getEventId() {
        return TSE.getInstance().getEventId(this.task.getRestartId());
    }

    @Override
    public String getRestartID() {
        return super.getEventId().toXMLString();
    }

    @Override
    public Object run() throws LocalizableException {
        try {
            if (this.run) {
                return super.run();
            }
            TSE.trace(this, "restarting an already executed container task");
            this.updateTaskStatus(EventStatus.EXECUTING);
            BiBusRunSpec spec = this.getBiBusRunSpec();
            if (this.monitorable == null) {
                SearchPathSingleObject sp = new SearchPathSingleObject();
                sp.set_value(spec.searchPath);
                this.monitorable = new MonitorableObject(this, sp, spec.parameters, spec.options, spec.attachments, this.header, this.run);
            }
            this.monitorable.addEventIDToRunContextOption(this.monitorable.getOptions());
            this.monitorable.addHistoryLocationOption();
            spec.options = this.monitorable.getOptions();
            this.task.update(new String[]{"TASK"});
            this.updateTaskStatus(EventStatus.SUCCEEDED);
            AsynchReply reply = new AsynchReply();
            reply.setStatus(AsynchReplyStatusEnum.conversationComplete);
            this.monitorable.addAsynchDetailEventID(reply);
            return reply;
        }
        catch (TSEException e) {
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, e);
        }
        catch (TaskPersistLayerException e) {
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, e);
        }
        catch (RemoteException e) {
            throw new MonitorServiceException(MonitorI18NCode.MSG_MS_GENERAL_ERROR, e);
        }
    }
}

