/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.Validate;
import com.cognos.monitor.api.MonitorServiceException;
import com.cognos.monitor.bursting.BurstDistribution;
import com.cognos.monitor.impl.MonitorableObject;
import com.cognos.monitor.tse.BiBusContext;
import com.cognos.monitor.tse.BiBusRunMonitorableAdapter;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.NoopHistoryWriter;
import com.cognos.monitor.tse.RunCommandProcessor;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunHistoryWriter;
import com.cognos.monitor.util.HistoryHelper;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.IEventId;
import java.rmi.RemoteException;

public class BiBusRunContext
extends BiBusContext
implements BiBusRunMonitorableAdapter {
    static final String WRITE_HISTORY_OPTION = "http://developer.cognos.com/ceba/constants/monitorOptionEnum#writeHistory";
    private static final BurstDistribution burstDistribution = new BurstDistribution();
    MonitorableObject monitorable;
    private boolean runViaMs;

    BiBusRunContext(TaskRecord task, TaskID parentID, TaskStateRecord taskState) {
        super(task, parentID, taskState);
        Validate.isTrue((boolean)(task.getRunSpec() instanceof BiBusRunSpec));
        String credential = this.getBiBusRunSpec().getCredentialPath();
        if (credential != null) {
            this.header.setCamCredential(credential);
        }
        this.parentID = parentID;
        this.runViaMs = taskState.runViaMS;
        this.trace(this, "ctor: " + task.getTaskId().getID() + " " + this.getBiBusRunSpec().hashCode());
    }

    public BiBusRunSpec getBiBusRunSpec() {
        return (BiBusRunSpec)this.task.getRunSpec();
    }

    @Override
    public String getHistoryPath() {
        if (this.getHistoryWriter() != null && this.historyWriter.getHistory() != null && this.historyWriter.getHistory().getSearchPath() != null) {
            return this.historyWriter.getHistory().getSearchPath().getValue();
        }
        return null;
    }

    @Override
    public String getHistoryStoreID() {
        if (this.getHistoryWriter() != null && this.historyWriter.getHistory() != null) {
            return this.historyWriter.getHistory().getStoreID().getValue().get_value();
        }
        return null;
    }

    @Override
    public synchronized HistoryWriter getHistoryWriter() {
        if (this.historyWriter == null) {
            Option writeHistory = OptionUtils.findFirstOptionWithNameEnum((Option[])this.getBiBusRunSpec().options, (Object)WRITE_HISTORY_OPTION);
            this.historyWriter = writeHistory != null && !OptionUtils.isTrue((Option)writeHistory, (String)WRITE_HISTORY_OPTION) ? new NoopHistoryWriter() : new TaskRunHistoryWriter(this, this.getServiceName());
        }
        return this.historyWriter;
    }

    @Override
    public boolean cancel() throws LocalizableException {
        return this.monitorable == null ? false : this.monitorable.unconditionalCancel(this.getEventId(), null);
    }

    @Override
    public boolean cancel(Object obj, String userName) throws LocalizableException {
        return this.monitorable == null ? false : this.monitorable.cancel((Event)obj, userName);
    }

    @Override
    public boolean release(Object obj, String userName) throws LocalizableException {
        return this.monitorable == null ? false : this.monitorable.release((Event)obj, userName);
    }

    @Override
    public boolean suspend(Object obj, String userName) throws LocalizableException {
        return this.monitorable == null ? false : this.monitorable.suspend((Event)obj, userName);
    }

    @Override
    public Object run() throws LocalizableException {
        this.trace(this, "run " + this.task.getTaskId().getID());
        BiBusRunSpec spec = this.getBiBusRunSpec();
        SearchPathSingleObject sp = new SearchPathSingleObject();
        sp.set_value(spec.searchPath);
        AsynchReply result = null;
        try {
            try {
                this.changeTaskStatus(TaskStatus.RUNNING, null);
            }
            catch (TSEException e) {
                this.trace(this, "status update error " + this.task.getTaskId().getID() + e.getMessage());
                throw new MonitorServiceException(I18NCode.EVENT_UPDATE_ERROR, e);
            }
            if (!this.currentStatus.isTerminatingStatus()) {
                this.monitorable = new MonitorableObject(this, sp, spec.parameters, spec.options, spec.attachments, this.header, this.runViaMs);
                this.trace(this, this.task.getTaskId().getID() + ": Credential " + this.getBiBusRunSpec().getCredentialPath());
                if (this.monitorable.getBiBusHeader().getCAM().getCAMPassport() != null) {
                    this.trace(this, this.task.getTaskId().getID() + ": Passport " + this.monitorable.getBiBusHeader().getCAM().getCAMPassport().getId());
                }
                result = this.monitorable.run();
            }
        }
        catch (RemoteException e) {
            this.trace(this, "remote exception " + this.task.getTaskId().getID() + e.getMessage());
            MonitorServiceException mse = new MonitorServiceException(I18NCode.MON_OBJECT_RUN_ERROR, e);
            throw mse;
        }
        return result;
    }

    public static void markHistoryAsFailed(TaskID taskID, I18NCode code) throws TaskPersistLayerException {
        TSE.trace("TaskRunHistoryWriter", "Corrupt task " + taskID);
        IEventId id = TSE.getInstance().getEventId(taskID);
        HistoryHelper.markFailed(id, code);
    }

    @Override
    public String getFault() {
        return this.monitorable != null ? this.monitorable.getFirstError() : null;
    }

    @Override
    public void runPostConversationCommands(AsynchReply reply) throws TSEException {
        RunCommandProcessor.getInstance().postConversation(this, reply);
    }

    @Override
    public void onTaskRunFinishedCmd() throws TSEException {
        RunCommandProcessor.getInstance().postRun(this);
    }

    @Override
    public void useSessionAffinity(boolean useSessionAffinity) throws LocalizableException {
        this.runViaMs = useSessionAffinity;
    }

    public void addErrorDetail(BaseHistoryDetail detail) throws TaskPersistLayerException {
        TaskID taskId = this.canPropagateErrorsToParentTask() ? this.getParentTaskId() : this.getTaskId();
        TaskPersistLayer.getInstance().addTaskDetails(taskId, new BaseHistoryDetail[]{detail});
    }

    private boolean canPropagateErrorsToParentTask() {
        if (this.getParentTaskId() == null) {
            return false;
        }
        BiBusRunSpec biBusRunSpec = this.getBiBusRunSpec();
        if (biBusRunSpec.loadFailed()) {
            return true;
        }
        return burstDistribution.hasOptionToPropagateErrorsToParent(biBusRunSpec.options);
    }
}

