/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.monitor.MonitorCategory;
import com.cognos.monitor.tse.HistoryWriter;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;

public abstract class Cmd {
    boolean doNotify;
    private TaskPersistLayerException exception;
    boolean isCleanup = false;

    public final void setDoNotify(boolean value) {
        this.doNotify = value;
    }

    public final boolean getDoNotify() {
        return this.doNotify;
    }

    protected void updateHistory(TaskRunContext task, TaskID parentID, I18NMessage message) throws TSEException, TaskPersistLayerException {
        this.updateHistory(task, new I18NMessage[]{message}, parentID);
    }

    protected void updateHistory(TaskRunContext task, I18NMessage[] messages, TaskID parentID) throws TSEException, TaskPersistLayerException {
        HistoryWriter writer = task.getHistoryWriter();
        if (writer != null) {
            task.getHistoryWriter().updateHistoryStatus();
            this.addHistoryDetail(task, messages);
        }
    }

    protected void addHistoryDetail(TaskRunContext task, I18NMessage[] messages) throws TSEException, TaskPersistLayerException {
        HistoryWriter writer = task.getHistoryWriter();
        if (writer != null && messages != null) {
            for (int i = 0; i < messages.length; ++i) {
                if (messages[i] == null) continue;
                if (TaskStatus.FAILED == task.getStatus()) {
                    writer.addErrorDetail(messages[i].getCode(), messages[i].getParams());
                    continue;
                }
                writer.addInfoDetail(messages[i].getCode(), messages[i].getParams());
            }
        }
    }

    public abstract void doAction() throws TSEException, TaskPersistLayerException;

    public boolean isCleanup() {
        return this.isCleanup;
    }

    protected void setCleanup(boolean isCleanup) {
        this.isCleanup = isCleanup;
    }

    TaskPersistLayerException getException() {
        return this.exception;
    }

    void setException(TaskPersistLayerException exception) {
        this.exception = exception;
    }

    void rethrowCaughtException() throws TaskPersistLayerException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    protected boolean isLoggingAt(SDSLevel level) {
        SDSLogger logger = SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME);
        return logger.isLoggingAt(level);
    }

    protected void debug(Object object, String methodName, String eventId, String msg) {
        SDSLogger logger = SDSLogger.getLogger((SDSCategory)MonitorCategory.RUNTIME);
        if (logger.isLoggingAt(SDSLevel.DEBUG)) {
            String objectName = object.getClass().getName();
            String fullMsg = this.generateLogMessage(objectName, methodName, eventId, msg);
            TSE.trace(fullMsg);
        }
    }

    protected String generateLogMessage(String objectName, String methodName, String eventId, String msg) {
        String oName = "";
        String mName = "";
        if (objectName != null) {
            oName = objectName;
        }
        if (methodName != null) {
            mName = methodName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" TASK:LOG:START: OBJECT=");
        sb.append(oName);
        sb.append(" : METHOD=");
        sb.append(mName);
        sb.append(" : EVENTID=");
        if (eventId != null) {
            sb.append(eventId);
        }
        sb.append(" : MSG=");
        sb.append(msg);
        sb.append(" : TASK:LOG:END");
        return sb.toString();
    }
}

