/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.WriteFinalHistoryObject;
import java.util.ArrayList;

public class FinalHistoryQueue {
    private static FinalHistoryQueue parentFinalHistoryQueue = new FinalHistoryQueue();
    private static FinalHistoryQueue childFinalHistoryQueue = new FinalHistoryQueue();
    private ArrayList taskIdList = new ArrayList();

    private FinalHistoryQueue() {
    }

    public synchronized void put(WriteFinalHistoryObject wfho) throws TSEException {
        try {
            if (wfho != null && wfho.getTaskId() != null) {
                this.taskIdList.add(wfho);
                this.notifyAll();
            } else {
                TSE.trace(this, "TSE_WFH ERROR: There was an error adding the task id to the final history queue. The TaskID is null.");
            }
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error adding the task id to the final history queue. Exception: " + ex);
            throw new TSEException(ex);
        }
    }

    public synchronized WriteFinalHistoryObject get() throws TSEException {
        WriteFinalHistoryObject wfho = null;
        try {
            if (this.taskIdList != null && !this.taskIdList.isEmpty()) {
                wfho = (WriteFinalHistoryObject)this.taskIdList.remove(0);
            }
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: There was an error getting a TaskID from the final history queue. Exception: " + ex);
            throw new TSEException(ex);
        }
        return wfho;
    }

    public synchronized boolean isEmpty() {
        boolean isEmpty = false;
        try {
            if (this.taskIdList == null || this.taskIdList.isEmpty()) {
                isEmpty = true;
            }
        }
        catch (Exception ex) {
            TSE.trace(this, "TSE_WFH ERROR: Error checking queue size");
        }
        return isEmpty;
    }

    public static FinalHistoryQueue getParentQueue() {
        return parentFinalHistoryQueue;
    }

    public static FinalHistoryQueue getChildQueue() {
        return childFinalHistoryQueue;
    }
}

