/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.monitor.tse;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.monitor.impl.EventResultType;
import com.cognos.monitor.impl.EventsResult;
import com.cognos.monitor.tse.BiBusContext;
import com.cognos.monitor.tse.EventCanceler;
import com.cognos.monitor.tse.TSE;
import com.cognos.monitor.tse.TSEException;
import com.cognos.monitor.tse.TaskRunContext;
import com.cognos.sds.event.Event;
import com.cognos.sds.event.EventId;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPElement;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;

public class HTSEventCanceler
implements EventCanceler {
    private static final String HTS_PROTOCOL_NS = "http://www.example.org/WS-HT/protocol";
    private static final String HTS_NS = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1";
    private TaskRunContext m_taskRunContext = null;
    private TaskStateRecord m_state = null;

    public HTSEventCanceler(TaskRunContext context, TaskStateRecord state) {
        this.m_taskRunContext = context;
        this.m_state = state;
    }

    @Override
    public EventsResult cancel(String sdsInstanceId, String eventId, String userName, boolean background) throws TSEException {
        EventsResult result = new EventsResult();
        try {
            SOAPBodyElement body = new SOAPBodyElement(HTS_PROTOCOL_NS, "exit");
            SOAPElement idElement = body.addChildElement("eventID", "hts", HTS_NS);
            idElement.addTextNode(eventId);
            this.callHTS(new Object[]{body});
            TaskStateRecord.setStatus((TaskID)this.m_state.taskID, (TaskStatus)TaskStatus.CANCELLED);
            this.m_state.status = TaskStatus.CANCELLED;
            result.addResult(EventResultType.CANCEL_SUCCEEDED, new Event(EventStatus.CANCELLED, EventId.valueOf(eventId)));
        }
        catch (Exception e) {
            TSE.logException(e);
            result.addResult(EventResultType.CANCEL_FAILED, new Event(EventStatus.INACTIVE, EventId.valueOf(eventId)));
        }
        return result;
    }

    private Object callHTS(Object[] args) throws ServiceException, RemoteException, MalformedURLException {
        Call call = null;
        try {
            BiBusHeader header = ((BiBusContext)this.m_taskRunContext).getHeader().getBiBusHeader();
            Service service = new Service();
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(CRNProperties.getInstance().getProperty("internalDispatcher")));
            call.setUseSOAPAction(true);
            call.setSOAPActionURI(HTS_NS);
            call.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
            call.setOperationName(new QName(HTS_NS, "exit"));
            SOAPHeaderElement hdr = new SOAPHeaderElement("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)header);
            call.addHeader(hdr);
            return call.invoke(args);
        }
        catch (PropertiesException e) {
            TSE.trace("Error retrieved dispatcher url: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            TSE.trace("call Exception " + e.getLocalizedMessage());
        }
        return null;
    }
}

